/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.font.TextAttribute;
import java.util.Map;
import javax.swing.ImageIcon;

public class TextOnIcon
extends ImageIcon {
    static final int POSITION_NORMAL = 0;
    static final int OFFSET_Y = 10;
    static final int OFFSET_X = 2;
    private String text;
    private Color foreground;
    private int textposition;
    private Font font;
    private int mnemonicIndex = -1;

    public TextOnIcon(Image image) {
        super(image);
    }

    public TextOnIcon(Image image, String string, int n2, Color color, Font font) {
        this(image);
        this.setText(string);
        this.setTextPosition(n2);
        this.foreground = color;
        this.font = font;
    }

    public void setText(String string) {
        this.text = string;
    }

    public String getText() {
        return this.text;
    }

    public void setTextPosition(int n2) {
        this.textposition = n2;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
        int n4 = this.getIconWidth();
        int n5 = this.getIconHeight();
        int n6 = n2;
        int n7 = n3;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setFont(this.font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n8 = fontMetrics.stringWidth(this.text) + 2;
        int n9 = fontMetrics.getMaxDescent() + fontMetrics.getAscent();
        graphics.drawImage(this.getImage(), n2, n3, component);
        graphics.setColor(this.foreground);
        switch (this.textposition) {
            case 6: {
                n6 += 2;
                n7 += 10;
                break;
            }
            case 8: {
                n6 += n4 - n8 - 2;
                n7 += 10;
                break;
            }
            case 11: {
                n6 += 2;
                n7 += n5 - 10 + n9 / 2;
                break;
            }
            case 13: {
                n6 += n4 - n8 - 2;
                n7 += n5 - 10 + n9 / 2;
                break;
            }
            case 7: {
                n6 += n4 / 2 - n8 / 2;
                n7 += 10;
                break;
            }
            case 12: {
                n6 += n4 / 2 - n8 / 2;
                n7 += n5 - 10 + n9 / 2;
                break;
            }
            case 9: {
                n6 += 2;
                n7 += n5 / 2 + fontMetrics.getMaxDescent();
                break;
            }
            case 10: {
                n6 += n4 - 2 - n8;
                n7 += n5 / 2 + fontMetrics.getMaxDescent();
            }
        }
        if (n6 < 0) {
            n6 = 2;
        }
        if (n7 < 0) {
            n7 = 2;
        }
        if (this.mnemonicIndex >= 0 && this.mnemonicIndex < this.text.length()) {
            String string;
            Map<TextAttribute, ?> map = this.font.getAttributes();
            map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            Font font = this.font.deriveFont(map);
            if (this.mnemonicIndex > 0) {
                string = this.text.substring(0, this.mnemonicIndex);
                graphics.setFont(this.font);
                graphics.drawString(string, n6, n7);
                n6 += fontMetrics.stringWidth(string);
            }
            string = "" + this.text.charAt(this.mnemonicIndex);
            graphics.setFont(font);
            graphics.drawString(string, n6, n7);
            n6 += fontMetrics.stringWidth(string);
            if (this.mnemonicIndex < this.text.length() - 1) {
                string = this.text.substring(this.mnemonicIndex + 1);
                graphics.setFont(this.font);
                graphics.drawString(string, n6, n7);
            }
        } else {
            graphics.drawString(this.text, n6, n7);
        }
    }

    public int getMnemonicIndex() {
        return this.mnemonicIndex;
    }

    public void setMnemonicIndex(int n2) {
        this.mnemonicIndex = n2;
    }
}

