/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.VirtualKeyboard;
import com.iscobol.gui.client.ZoomLayout;
import com.iscobol.gui.client.swing.Filterable;
import com.iscobol.gui.client.swing.IsTreeViewModel;
import com.iscobol.gui.client.swing.PopupListener;
import com.iscobol.gui.client.swing.TreeTableViewModel;
import com.iscobol.gui.client.swing.TreeView;
import com.iscobol.gui.client.swing.TreeViewNode;
import com.iscobol.gui.client.swing.treetable.JTreeTable;
import com.iscobol.gui.client.swing.treetable.TreeTableModel;
import com.iscobol.gui.client.swing.treetable.TreeTableModelAdapter;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeTableView
extends JTreeTable {
    public static final int NO_SORT = 0;
    public static final int ALPHANUMERIC_CASE_SENSITIVE_SORT = 1;
    public static final int ALPHANUMERIC_CASE_INSENSITIVE_SORT = 2;
    public static final int NUMERIC_SORT = 3;
    public static final int DATE_MDY_SORT = 4;
    public static final int DATE_DMY_SORT = 5;
    public static final int DATE_YMD_SORT = 6;
    private static final boolean decPointComma = VirtualKeyboard.LOCALE_DECIMAL_SEPARATOR == ',';
    private boolean adjustableColumns;
    private float cellWidth;
    private float resizeDelta = 1.0f;
    private TreeView tree;
    private IsTreeViewModel treeModel;
    private Vector<ColumnInfo> columnInfos;
    private int hiddenColumnCount;
    private boolean lmOnColumns;
    private int[] displayColumns;
    private int virtualWidth;
    private Font headingFont;
    private Color headingBackground;
    private Color headingForeground;
    private boolean sortableColumns;
    private boolean centerHeadings;
    private boolean tiledHeadings;
    private boolean columnHeadings;
    private JTableHeader tableHeader;
    private JPopupMenu headerPopup;
    private MyRowSorter rowSorter;
    private int sortColumn = -1;
    private int lastW;
    private boolean changedRowSelection;
    private MouseListener headingMenuListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                TreeTableView.this.headerPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    };
    private PopupListener popupListener;
    private boolean headingMenuPopup;
    private Map<TreeViewNode, TreeViewNode[]> sortedChildren;

    public TreeTableView(TreeView treeView, IsTreeViewModel isTreeViewModel) {
        super(treeView, isTreeViewModel);
        this.tree = treeView;
        this.treeModel = isTreeViewModel;
        this.rowSorter = new MyRowSorter((TreeTableModelAdapter)this.getModel());
        treeView.setTreeTable(this);
        this.setAutoResizeMode(0);
        this.setAutoCreateColumnsFromModel(false);
        this.setSelectionMode(0);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.tableHeader = this.getTableHeader();
        this.headerPopup = new JPopupMenu();
        this.columnInfos = new Vector();
        this.setTableHeader(null);
        this.setDefaultRenderer(String.class, new CellRenderer());
        this.tableHeader.setDefaultRenderer(new HeaderCellRenderer());
        this.treeModel.setTreeTableModel(new TreeTableViewModel(){

            @Override
            public boolean isCellEditable(Object object, int n2) {
                return this.getColumnClass(n2) == TreeTableModel.class;
            }

            @Override
            public Object getValueAt(Object object, int n2) {
                TreeViewNode treeViewNode = (TreeViewNode)object;
                if (treeViewNode != null) {
                    return treeViewNode.getText(n2);
                }
                return null;
            }

            @Override
            public int getColumnCount() {
                return TreeTableView.this.displayColumns != null ? TreeTableView.this.displayColumns.length + 1 - TreeTableView.this.hiddenColumnCount : 1;
            }

            @Override
            public Class getColumnClass(int n2) {
                switch (n2) {
                    case 0: {
                        return TreeTableModel.class;
                    }
                }
                return String.class;
            }

            @Override
            public int[] nodesChanged(TreeNode treeNode, int[] nArray) {
                TreeViewNode[] treeViewNodeArray;
                if (TreeTableView.this.sortedChildren != null && (treeViewNodeArray = (TreeViewNode[])TreeTableView.this.sortedChildren.get(treeNode)) != null) {
                    return this.getNewIdxs(treeNode, treeViewNodeArray, nArray);
                }
                return null;
            }

            private int[] getNewIdxs(TreeNode treeNode, TreeViewNode[] treeViewNodeArray, int[] nArray) {
                int[] nArray2 = new int[nArray.length];
                block0: for (int i2 = 0; i2 < nArray.length; ++i2) {
                    TreeViewNode treeViewNode = (TreeViewNode)treeNode.getChildAt(nArray[i2]);
                    for (int i3 = 0; i3 < treeViewNodeArray.length; ++i3) {
                        if (treeViewNode != treeViewNodeArray[i3]) continue;
                        nArray2[i2] = i3;
                        continue block0;
                    }
                }
                return nArray2;
            }

            @Override
            public int[] nodesWereInserted(TreeNode treeNode, int[] nArray) {
                if (TreeTableView.this.sortedChildren != null) {
                    TreeViewNode[] treeViewNodeArray = new TreeViewNode[treeNode.getChildCount()];
                    for (int i2 = 0; i2 < treeViewNodeArray.length; ++i2) {
                        treeViewNodeArray[i2] = (TreeViewNode)treeNode.getChildAt(i2);
                    }
                    if (treeViewNodeArray.length > 1) {
                        TreeViewNode[] treeViewNodeArray2 = new TreeViewNode[treeViewNodeArray.length];
                        System.arraycopy(treeViewNodeArray, 0, treeViewNodeArray2, 0, treeViewNodeArray.length);
                        Arrays.sort(treeViewNodeArray, TreeTableView.this.rowSorter.getComparator(TreeTableView.this.sortColumn));
                        TreeTableView.this.sortedChildren.put((TreeViewNode)treeNode, treeViewNodeArray);
                        return this.getNewIdxs(treeNode, treeViewNodeArray, nArray);
                    }
                    return nArray;
                }
                return null;
            }

            @Override
            public int[] nodesWereRemoved(TreeNode treeNode, int[] nArray, Object[] objectArray) {
                TreeViewNode[] treeViewNodeArray;
                if (TreeTableView.this.sortedChildren != null && (treeViewNodeArray = (TreeViewNode[])TreeTableView.this.sortedChildren.get(treeNode)) != null) {
                    int[] nArray2 = this.getNewIdxs(treeNode, treeViewNodeArray, nArray);
                    for (int i2 = 0; i2 < nArray2.length; ++i2) {
                        treeViewNodeArray[nArray2[i2]] = null;
                    }
                    ArrayList<TreeViewNode> arrayList = new ArrayList<TreeViewNode>();
                    for (int i3 = 0; i3 < treeViewNodeArray.length; ++i3) {
                        if (treeViewNodeArray[i3] == null) continue;
                        arrayList.add(treeViewNodeArray[i3]);
                    }
                    TreeTableView.this.sortedChildren.put((TreeViewNode)treeNode, arrayList.toArray(new TreeViewNode[arrayList.size()]));
                    return nArray2;
                }
                return null;
            }

            @Override
            public int getIndexOfChild(Object object, Object object2) {
                TreeViewNode[] treeViewNodeArray;
                if (TreeTableView.this.sortedChildren != null && (treeViewNodeArray = (TreeViewNode[])TreeTableView.this.sortedChildren.get(object)) != null) {
                    for (int i2 = 0; i2 < treeViewNodeArray.length; ++i2) {
                        if (object2 != treeViewNodeArray[i2]) continue;
                        return i2;
                    }
                }
                return -1;
            }

            @Override
            public int getChildCount(Object object) {
                TreeViewNode[] treeViewNodeArray;
                if (TreeTableView.this.sortedChildren != null && (treeViewNodeArray = (TreeViewNode[])TreeTableView.this.sortedChildren.get(object)) != null) {
                    return treeViewNodeArray.length;
                }
                return -1;
            }

            @Override
            public Object getChild(Object object, int n2) {
                TreeViewNode[] treeViewNodeArray;
                if (TreeTableView.this.sortedChildren != null && (treeViewNodeArray = (TreeViewNode[])TreeTableView.this.sortedChildren.get(object)) != null && n2 < treeViewNodeArray.length) {
                    return treeViewNodeArray[n2];
                }
                return null;
            }
        });
        this.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent changeEvent) {
                JTableHeader jTableHeader = TreeTableView.this.getTableHeader();
                if (TreeTableView.this.lmOnColumns && TreeTableView.this.displayColumns != null && jTableHeader != null && jTableHeader.getResizingColumn() != null) {
                    TableColumn tableColumn = jTableHeader.getResizingColumn();
                    for (ColumnInfo columnInfo : TreeTableView.this.columnInfos) {
                        if (columnInfo.column != tableColumn) continue;
                        int n2 = columnInfo.columnIndex;
                        if (n2 >= TreeTableView.this.displayColumns.length) break;
                        float f2 = columnInfo.column.getWidth();
                        int n3 = Math.round(f2 / TreeTableView.this.cellWidth / TreeTableView.this.resizeDelta);
                        int n4 = n2 > 0 ? TreeTableView.this.displayColumns[n2 - 1] : 0;
                        int n5 = n4 + n3 - TreeTableView.this.displayColumns[n2];
                        ((TreeTableView)TreeTableView.this).displayColumns[n2] = n4 + n3;
                        int n6 = n2 + 1;
                        while (n6 < TreeTableView.this.displayColumns.length) {
                            int[] nArray = TreeTableView.this.displayColumns;
                            int n7 = n6++;
                            nArray[n7] = nArray[n7] + n5;
                        }
                        break block0;
                    }
                }
            }

            @Override
            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            }
        });
    }

    public void setReorderingColumns(boolean bl) {
        this.tableHeader.setReorderingAllowed(bl);
    }

    public void setAdjustableColumns(boolean bl) {
        this.adjustableColumns = bl;
        for (int i2 = 0; i2 < this.columnInfos.size(); ++i2) {
            this.columnInfos.elementAt((int)i2).column.setResizable(bl);
        }
    }

    public static int[] getSortType(String string) {
        string = string.trim().toUpperCase();
        int[] nArray = new int[]{0, 0};
        if (string.length() == 0) {
            return nArray;
        }
        switch (string.charAt(0)) {
            case 'X': 
            case 'x': {
                if (string.length() == 1) {
                    nArray[0] = 2;
                    break;
                }
                if (string.length() != 2 || string.charAt(1) != '^') break;
                nArray[0] = 2;
                nArray[1] = 1;
                break;
            }
            case 'L': 
            case 'U': 
            case 'l': 
            case 'u': {
                if (string.length() == 1) {
                    nArray[0] = 1;
                    break;
                }
                if (string.length() != 2 || string.charAt(1) != '^') break;
                nArray[0] = 1;
                nArray[1] = 1;
                break;
            }
            case '9': {
                if (string.length() == 1) {
                    nArray[0] = 3;
                    break;
                }
                if (string.length() != 2 || string.charAt(1) != '^') break;
                nArray[0] = 3;
                nArray[1] = 1;
                break;
            }
            case '-': {
                if (string.length() != 1) break;
                nArray[0] = 0;
                break;
            }
            case 'D': 
            case 'E': 
            case 'd': 
            case 'e': {
                if (string.length() == 1) {
                    nArray[0] = 4;
                    break;
                }
                if (string.charAt(1) == '^') {
                    nArray[1] = 1;
                    string = string.substring(2);
                } else {
                    string = string.substring(1);
                }
                if (string.length() > 0) {
                    if ("(MDY)".equals(string)) {
                        nArray[0] = 4;
                        break;
                    }
                    if ("(DMY)".equals(string)) {
                        nArray[0] = 5;
                        break;
                    }
                    if (!"(YMD)".equals(string)) break;
                    nArray[0] = 6;
                    break;
                }
                nArray[0] = 4;
            }
        }
        return nArray;
    }

    public void setSortTypes(int[] nArray, boolean[] blArray) {
        for (int i2 = 0; i2 < nArray.length && i2 < this.columnInfos.size(); ++i2) {
            ColumnInfo columnInfo = this.columnInfos.elementAt(i2);
            columnInfo.sortType = nArray[i2];
            columnInfo.initialSortState = blArray[i2] ? SortState.DESCENDING : SortState.ASCENDING;
        }
    }

    public void setAlignments(String[] stringArray) {
        for (int i2 = 0; i2 < stringArray.length && i2 < this.columnInfos.size(); ++i2) {
            ColumnInfo columnInfo = this.columnInfos.elementAt(i2);
            columnInfo.alignment = stringArray[i2];
        }
    }

    public void setDisplayColumns(int[] nArray, int[] nArray2, boolean[] blArray) {
        this.displayColumns = nArray;
        this.hiddenColumnCount = 0;
        this.columnInfos.clear();
        this.headerPopup.removeAll();
        this.createDefaultColumnsFromModel();
        int n2 = this.getColumnModel().getColumnCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            TableColumn tableColumn = this.getColumnModel().getColumn(i2);
            ColumnInfo columnInfo = new ColumnInfo(tableColumn, i2);
            if (i2 < nArray2.length) {
                columnInfo.sortType = nArray2[i2];
            }
            if (i2 < blArray.length) {
                columnInfo.initialSortState = blArray[i2] ? SortState.DESCENDING : SortState.ASCENDING;
            }
            this.columnInfos.addElement(columnInfo);
            if (i2 <= 0) continue;
            Object object = tableColumn.getHeaderValue();
            columnInfo.item = new JCheckBoxMenuItem(object != null ? object.toString() : "");
            columnInfo.item.setSelected(true);
            columnInfo.item.setActionCommand("" + i2);
            columnInfo.item.addActionListener(actionEvent -> {
                if (columnInfo.item.isSelected()) {
                    this.addColumn(Integer.parseInt(columnInfo.item.getActionCommand()));
                } else if (this.hiddenColumnCount < n2 - 1) {
                    this.removeColumn(Integer.parseInt(columnInfo.item.getActionCommand()));
                } else {
                    columnInfo.item.setSelected(true);
                }
            });
            this.headerPopup.add(columnInfo.item);
        }
        this.setupColumns();
    }

    private void setupColumns() {
        if (this.displayColumns != null && this.displayColumns.length > 0) {
            int n2;
            int n3 = 0;
            for (n2 = 0; n2 < this.displayColumns.length && n2 < this.columnInfos.size() && (this.virtualWidth == 0 || this.displayColumns[n2] < this.virtualWidth); ++n2) {
                int n4 = this.displayColumns[n2] - 1;
                this.columnInfos.elementAt((int)n2).column.setPreferredWidth(Math.round((float)(n4 - n3) * this.cellWidth * this.resizeDelta));
                n3 = n4;
            }
            this.adjustLastColumnWidth(n2);
            this.setAdjustableColumns(this.adjustableColumns);
        } else if (this.virtualWidth == 0) {
            this.adjustLastColumnWidth(0);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.tree != null) {
            this.tree.setFont(font);
            if (this.headingFont == null) {
                this.tableHeader.setFont(font);
            }
            if (!this.isZoomLayingOut()) {
                FontMetrics fontMetrics = this.getFontMetrics(font);
                this.cellWidth = fontMetrics.stringWidth("0");
                this.setupColumns();
            }
        }
    }

    public int getVirtualWidth() {
        return this.virtualWidth;
    }

    public void setVirtualWidth(int n2) {
        this.virtualWidth = n2;
        if (this.displayColumns != null && this.displayColumns.length > 0) {
            int n3;
            for (n3 = 0; n3 < this.displayColumns.length && (n2 == 0 || this.displayColumns[n3] < n2); ++n3) {
            }
            this.adjustLastColumnWidth(n3);
        }
    }

    private void adjustLastColumnWidth(int n2) {
        if (this.displayColumns == null || this.columnInfos == null || this.displayColumns.length + 1 != this.columnInfos.size()) {
            return;
        }
        if (this.virtualWidth > 0) {
            int n3 = this.virtualWidth - this.displayColumns[n2 - 1] + 1;
            if (n3 > 0) {
                this.columnInfos.elementAt((int)n2).column.setPreferredWidth(Math.round(this.cellWidth * this.resizeDelta * (float)n3));
            }
        } else if (n2 > 0) {
            int n4 = Math.round((float)(this.displayColumns[n2 - 1] - 1) * this.cellWidth * this.resizeDelta);
            if (this.lastW > n4) {
                this.columnInfos.elementAt((int)n2).column.setPreferredWidth(this.lastW - n4);
            }
        } else if (this.columnInfos.size() > 0) {
            this.columnInfos.elementAt((int)0).column.setPreferredWidth(this.lastW);
        }
    }

    public void containerWidthChanged(int n2) {
        if (n2 != this.lastW) {
            this.lastW = n2;
            if (this.virtualWidth == 0) {
                this.adjustLastColumnWidth(this.displayColumns != null ? this.displayColumns.length : 0);
            }
        }
    }

    public Font getHeadingFont() {
        return this.headingFont;
    }

    public void setHeadingFont(Font font) {
        this.headingFont = font;
        this.repaint();
    }

    protected void setResizeWidthDelta(float f2) {
        this.resizeDelta = f2;
        this.setupColumns();
    }

    public Color getHeadingBackground() {
        return this.headingBackground;
    }

    public void setHeadingBackground(Color color) {
        this.headingBackground = color;
        this.repaint();
    }

    public Color getHeadingForeground() {
        return this.headingForeground;
    }

    public void setHeadingForeground(Color color) {
        this.headingForeground = color;
        this.repaint();
    }

    public boolean isCenterHeadings() {
        return this.centerHeadings;
    }

    public void setCenterHeadings(boolean bl) {
        this.centerHeadings = bl;
        this.repaint();
    }

    public boolean isTiledHeadings() {
        return this.tiledHeadings;
    }

    public void setTiledHeadings(boolean bl) {
        this.tiledHeadings = bl;
        this.repaint();
    }

    public boolean isColumnHeadings() {
        return this.columnHeadings;
    }

    public void setColumnHeadings(boolean bl) {
        this.columnHeadings = bl;
        this.setTableHeader(bl ? this.tableHeader : null);
    }

    public void setColumnName(int n2, String string) {
        if (n2 < this.columnInfos.size()) {
            ColumnInfo columnInfo = this.columnInfos.elementAt(n2);
            columnInfo.column.setHeaderValue(string);
            if (columnInfo.item != null) {
                columnInfo.item.setText(string);
            }
        }
    }

    @Override
    protected void processEvent(AWTEvent aWTEvent) {
        switch (aWTEvent.getID()) {
            case 400: 
            case 401: 
            case 402: {
                aWTEvent.setSource(this.tree);
                this.tree.processEvent(aWTEvent);
                break;
            }
            default: {
                super.processEvent(aWTEvent);
            }
        }
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        super.addMouseListener(mouseListener);
        if (this.tree != null) {
            this.tree.addMouseListener(mouseListener);
        }
        if (mouseListener instanceof PopupListener) {
            this.popupListener = (PopupListener)mouseListener;
        }
        if (this.tableHeader != null) {
            this.tableHeader.addMouseListener(mouseListener);
        }
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        super.removeMouseListener(mouseListener);
        if (this.tree != null) {
            this.tree.removeMouseListener(mouseListener);
        }
        if (this.tableHeader != null) {
            this.tableHeader.removeMouseListener(mouseListener);
        }
    }

    @Override
    public void clearSelection() {
    }

    public TreeView getTree() {
        return this.tree;
    }

    public void addColumn(int n2) {
        if (n2 > 0 && n2 < this.columnInfos.size()) {
            ColumnInfo columnInfo = this.columnInfos.elementAt(n2);
            if (columnInfo.hidden) {
                TableColumnModel tableColumnModel = this.getColumnModel();
                --this.hiddenColumnCount;
                tableColumnModel.addColumn(columnInfo.column);
                if (columnInfo.insertionIndex < tableColumnModel.getColumnCount() - 1) {
                    tableColumnModel.moveColumn(tableColumnModel.getColumnCount() - 1, columnInfo.insertionIndex);
                }
                columnInfo.hidden = false;
                if (columnInfo.item != null) {
                    columnInfo.item.setSelected(true);
                }
                this.doLayout();
            }
        }
    }

    public void removeColumn(int n2) {
        if (n2 > 0 && n2 < this.columnInfos.size()) {
            ColumnInfo columnInfo = this.columnInfos.elementAt(n2);
            if (!columnInfo.hidden) {
                columnInfo.insertionIndex = this.convertColumnIndexToView(n2);
                TableColumnModel tableColumnModel = this.getColumnModel();
                ++this.hiddenColumnCount;
                tableColumnModel.removeColumn(columnInfo.column);
                columnInfo.hidden = true;
                if (columnInfo.item != null) {
                    columnInfo.item.setSelected(false);
                }
                this.doLayout();
            }
        }
    }

    public boolean isHeadingMenuPopup() {
        return this.headingMenuPopup;
    }

    public void setHeadingMenuPopup(boolean bl) {
        if (this.headingMenuPopup != bl) {
            this.headingMenuPopup = bl;
            if (this.tableHeader != null) {
                if (this.headingMenuPopup) {
                    if (this.popupListener != null) {
                        this.tableHeader.removeMouseListener(this.popupListener);
                    }
                    this.tableHeader.addMouseListener(this.headingMenuListener);
                } else {
                    if (this.popupListener != null) {
                        this.tableHeader.addMouseListener(this.popupListener);
                    }
                    this.tableHeader.removeMouseListener(this.headingMenuListener);
                }
            }
        }
    }

    public JPopupMenu getHeaderPopup() {
        return this.headerPopup;
    }

    private boolean isZoomLayingOut() {
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container.getLayout() instanceof ZoomLayout)) continue;
            return ((ZoomLayout)container.getLayout()).isLayingOut();
        }
        return false;
    }

    public boolean isSortableColumns() {
        return this.sortableColumns;
    }

    public void setSortableColumns(boolean bl) {
        if (this.sortableColumns != bl) {
            this.sortableColumns = bl;
            this.setRowSorter(this.sortableColumns ? this.rowSorter : null);
        }
    }

    @Override
    protected boolean shouldFireMouseEventsInEditor() {
        return !this.tree.isProcessingEvent();
    }

    @Override
    protected TableColumnModel createDefaultColumnModel() {
        return new DefaultTableColumnModel(){

            @Override
            public void moveColumn(int n2, int n3) {
                if (n2 > 0 && n3 > 0) {
                    super.moveColumn(n2, n3);
                } else {
                    TreeTableView.this.getTableHeader().repaint();
                }
            }
        };
    }

    @Override
    public void changeSelection(int n2, int n3, boolean bl, boolean bl2) {
        this.changedRowSelection = this.getSelectedRow() != n2;
        super.changeSelection(n2, n3, bl, bl2);
    }

    boolean isChangedRowSelection() {
        return this.changedRowSelection;
    }

    void setChangedRowSelection(boolean bl) {
        this.changedRowSelection = bl;
    }

    public boolean isLmOnColumns() {
        return this.lmOnColumns;
    }

    public void setLmOnColumns(boolean bl) {
        this.lmOnColumns = bl;
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() != 506) {
            super.processMouseMotionEvent(mouseEvent);
        }
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        TreeViewNode treeViewNode;
        String string;
        String string2 = super.getToolTipText();
        int n2 = this.rowAtPoint(mouseEvent.getPoint());
        int n3 = this.columnAtPoint(mouseEvent.getPoint());
        TreePath treePath = this.tree.getPathForRow(n2);
        if (treePath != null && (string = (treeViewNode = (TreeViewNode)treePath.getLastPathComponent()).getHint(n3)) != null) {
            string2 = string;
        }
        return string2;
    }

    private class CellRenderer
    extends DefaultTableCellRenderer {
        private CellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n2, int n3) {
            ColumnInfo columnInfo;
            int n4 = TreeTableView.this.convertColumnIndexToModel(n3);
            ColumnInfo columnInfo2 = columnInfo = n4 < TreeTableView.this.columnInfos.size() ? (ColumnInfo)TreeTableView.this.columnInfos.elementAt(n4) : null;
            if (columnInfo != null && columnInfo.alignment != null && !"U".equalsIgnoreCase(columnInfo.alignment) && object instanceof String) {
                object = object.toString().trim();
            }
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n2, n3);
            JLabel jLabel = (JLabel)component;
            TreeViewNode treeViewNode = null;
            TreePath treePath = TreeTableView.this.tree.getPathForRow(n2);
            if (treePath != null) {
                treeViewNode = (TreeViewNode)treePath.getLastPathComponent();
            }
            if (object != null && treeViewNode != null && treeViewNode.getRoot() instanceof Filterable) {
                String string;
                int n5;
                int n6 = Integer.MIN_VALUE;
                String string2 = ((Filterable)((Object)treeViewNode.getRoot())).getFilterString();
                boolean bl3 = ((Filterable)((Object)treeViewNode.getRoot())).isFilterCaseSensitive();
                if (string2 != null && (n5 = string2.length()) > 0) {
                    if (!bl3) {
                        string2 = string2.toLowerCase();
                    }
                    if (treeViewNode == TreeTableView.this.tree.getCurrentMatchNode()) {
                        n6 = 0;
                        for (int i2 = 0; i2 < n3; ++i2) {
                            String string3 = treeViewNode.getText(i2);
                            if (!bl3) {
                                string3 = string3.toLowerCase();
                            }
                            int n7 = 0;
                            while ((n7 = string3.indexOf(string2, n7)) >= 0) {
                                ++n6;
                                n7 += n5;
                            }
                        }
                    }
                }
                if ((string = TreeTableView.this.tree.getTextWithHighlight(object.toString(), n6, string2, bl3)) != null) {
                    jLabel.setText(string);
                }
            }
            if (columnInfo != null) {
                if ("C".equalsIgnoreCase(columnInfo.alignment)) {
                    jLabel.setHorizontalAlignment(0);
                } else if ("R".equalsIgnoreCase(columnInfo.alignment)) {
                    jLabel.setHorizontalAlignment(4);
                } else {
                    jLabel.setHorizontalAlignment(2);
                }
            }
            jLabel.setOpaque(bl);
            if (treeViewNode != null) {
                if (!bl) {
                    if (treeViewNode.getForeground() != null) {
                        component.setForeground(treeViewNode.getForeground());
                    }
                    if (treeViewNode.getBackground() != null) {
                        jLabel.setOpaque(true);
                        component.setBackground(treeViewNode.getBackground());
                    }
                }
                jLabel.setIcon(treeViewNode.getIcon(n3));
                if (treeViewNode.getImgTrailing(n3) != 0) {
                    jLabel.setHorizontalTextPosition(2);
                } else {
                    jLabel.setHorizontalTextPosition(4);
                }
            }
            return component;
        }
    }

    private class HeaderCellRenderer
    extends JPanel
    implements TableCellRenderer {
        private Color defBackground = UIManager.getColor("TableHeader.background");
        private Color defForeground = UIManager.getColor("TableHeader.foreground");
        private Border defBorder = UIManager.getBorder("TableHeader.cellBorder");
        private JLabel label;
        private Icon descIcon = UIManager.getIcon("Table.descendingSortIcon");
        private Icon ascIcon;
        private Icon unsortedIcon;
        private Icon sortIcon;

        HeaderCellRenderer() {
            if (this.descIcon != null) {
                this.ascIcon = UIManager.getIcon("Table.ascendingSortIcon");
                final int n2 = this.descIcon.getIconWidth();
                final int n3 = this.descIcon.getIconHeight();
                this.unsortedIcon = new Icon(){

                    @Override
                    public void paintIcon(Component component, Graphics graphics, int n22, int n32) {
                    }

                    @Override
                    public int getIconWidth() {
                        return n2;
                    }

                    @Override
                    public int getIconHeight() {
                        return n3;
                    }
                };
            }
            this.setLayout(new BorderLayout(2, 2));
            this.label = new JLabel(){

                @Override
                public void paintComponent(Graphics graphics) {
                    super.paintComponent(graphics);
                    if (HeaderCellRenderer.this.sortIcon != null) {
                        HeaderCellRenderer.this.sortIcon.paintIcon(this, graphics, this.getWidth() - HeaderCellRenderer.this.sortIcon.getIconWidth() - 5, (this.getHeight() - HeaderCellRenderer.this.sortIcon.getIconHeight()) / 2);
                    }
                }
            };
            this.label.setVerticalTextPosition(0);
            this.add((Component)this.label, "Center");
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n2, int n3) {
            Object object2;
            String string;
            if (TreeTableView.this.centerHeadings) {
                string = "C";
            } else {
                string = "U";
                if (n3 < TreeTableView.this.columnInfos.size() && (object2 = (ColumnInfo)TreeTableView.this.columnInfos.get(n3)) != null && ((ColumnInfo)object2).alignment != null) {
                    string = ((ColumnInfo)object2).alignment;
                }
            }
            object2 = !"U".equalsIgnoreCase(string) && object instanceof String ? object.toString().trim() : (object != null ? object.toString() : "");
            this.label.setText((String)object2);
            if ("C".equalsIgnoreCase(string)) {
                this.label.setHorizontalAlignment(0);
            } else if ("R".equalsIgnoreCase(string)) {
                this.label.setHorizontalAlignment(4);
            } else {
                this.label.setHorizontalAlignment(2);
            }
            if (TreeTableView.this.headingFont != null) {
                this.label.setFont(TreeTableView.this.headingFont);
            } else {
                this.label.setFont(TreeTableView.this.getFont());
            }
            if (TreeTableView.this.headingBackground != null) {
                this.setBackground(TreeTableView.this.headingBackground);
            } else if (this.defBackground != null) {
                this.setBackground(this.defBackground);
            } else {
                this.setBackground(Color.gray);
            }
            if (TreeTableView.this.headingForeground != null) {
                this.label.setForeground(TreeTableView.this.headingForeground);
            } else if (this.defForeground != null) {
                this.label.setForeground(this.defForeground);
            } else {
                this.label.setForeground(Color.black);
            }
            if (TreeTableView.this.tiledHeadings) {
                this.setBorder(BorderFactory.createRaisedBevelBorder());
            } else if (this.defBorder != null) {
                this.setBorder(this.defBorder);
            }
            if (TreeTableView.this.sortableColumns) {
                int n4 = TreeTableView.this.convertColumnIndexToModel(n3);
                if (n4 == TreeTableView.this.sortColumn && ((ColumnInfo)((TreeTableView)TreeTableView.this).columnInfos.elementAt((int)n4)).sortType != 0) {
                    switch (((ColumnInfo)((TreeTableView)TreeTableView.this).columnInfos.elementAt((int)n4)).sortState) {
                        case ASCENDING: {
                            this.sortIcon = this.ascIcon;
                            break;
                        }
                        case DESCENDING: {
                            this.sortIcon = this.descIcon;
                            break;
                        }
                        default: {
                            this.sortIcon = this.unsortedIcon;
                            break;
                        }
                    }
                } else {
                    this.sortIcon = this.unsortedIcon;
                }
                TreeTableView.this.tableHeader.repaint();
            } else {
                this.sortIcon = null;
            }
            return this;
        }
    }

    private class MyRowSorter
    extends TableRowSorter<TreeTableModelAdapter> {
        MyRowSorter(TreeTableModelAdapter treeTableModelAdapter) {
            super(treeTableModelAdapter);
        }

        @Override
        public void sort() {
        }

        @Override
        public int convertRowIndexToModel(int n2) {
            return n2;
        }

        @Override
        public int convertRowIndexToView(int n2) {
            return n2;
        }

        @Override
        public boolean isSortable(int n2) {
            return ((ColumnInfo)((TreeTableView)TreeTableView.this).columnInfos.elementAt((int)n2)).sortType != 0;
        }

        @Override
        public Comparator<TreeViewNode> getComparator(int n2) {
            return ((ColumnInfo)TreeTableView.this.columnInfos.elementAt(n2)).getComparator();
        }

        private void sortChildren(TreeViewNode treeViewNode) {
            TreeViewNode[] treeViewNodeArray = new TreeViewNode[treeViewNode.getChildCount()];
            for (int i2 = 0; i2 < treeViewNodeArray.length; ++i2) {
                treeViewNodeArray[i2] = (TreeViewNode)treeViewNode.getChildAt(i2);
                this.sortChildren(treeViewNodeArray[i2]);
            }
            if (treeViewNodeArray.length > 1) {
                TreeViewNode[] treeViewNodeArray2 = new TreeViewNode[treeViewNodeArray.length];
                System.arraycopy(treeViewNodeArray, 0, treeViewNodeArray2, 0, treeViewNodeArray.length);
                Arrays.sort(treeViewNodeArray, this.getComparator(TreeTableView.this.sortColumn));
                TreeTableView.this.sortedChildren.put(treeViewNode, treeViewNodeArray);
            }
        }

        @Override
        public void toggleSortOrder(int n2) {
            if (!this.isSortable(n2)) {
                return;
            }
            for (int i2 = 0; i2 < TreeTableView.this.columnInfos.size(); ++i2) {
                if (i2 == n2) continue;
                ((ColumnInfo)((TreeTableView)TreeTableView.this).columnInfos.elementAt((int)i2)).sortState = SortState.UNSORTED;
            }
            TreeTableView.this.sortColumn = n2;
            ColumnInfo columnInfo = (ColumnInfo)TreeTableView.this.columnInfos.elementAt(TreeTableView.this.sortColumn);
            switch (columnInfo.sortState) {
                case UNSORTED: {
                    columnInfo.sortState = columnInfo.initialSortState;
                    break;
                }
                case ASCENDING: {
                    if (columnInfo.initialSortState == SortState.ASCENDING) {
                        columnInfo.sortState = SortState.DESCENDING;
                        break;
                    }
                    columnInfo.sortState = SortState.UNSORTED;
                    break;
                }
                case DESCENDING: {
                    columnInfo.sortState = columnInfo.initialSortState == SortState.DESCENDING ? SortState.ASCENDING : SortState.UNSORTED;
                }
            }
            if (columnInfo.sortState == SortState.UNSORTED) {
                if (TreeTableView.this.sortedChildren != null) {
                    TreeTableView.this.sortedChildren.clear();
                }
                TreeTableView.this.sortedChildren = null;
            } else {
                TreeTableView.this.sortedChildren = new HashMap();
                TreeViewNode treeViewNode = (TreeViewNode)TreeTableView.this.treeModel.getRoot();
                this.sortChildren(treeViewNode);
            }
            TreeTableView.this.tree.tableSorted();
        }
    }

    private static class ColumnInfo {
        TableColumn column;
        int columnIndex;
        int insertionIndex;
        boolean hidden;
        SortState sortState = SortState.UNSORTED;
        SortState initialSortState = SortState.ASCENDING;
        int sortType = 2;
        Comparator<TreeViewNode> comparator;
        JCheckBoxMenuItem item;
        String alignment = "U";

        ColumnInfo(TableColumn tableColumn, int n2) {
            this.column = tableColumn;
            this.columnIndex = n2;
            this.insertionIndex = n2;
        }

        Comparator<TreeViewNode> getComparator() {
            if (this.comparator == null && this.sortType != 0) {
                Comparator<TreeViewNode> comparator;
                switch (this.sortType) {
                    default: {
                        comparator = new Comparator<TreeViewNode>(){

                            @Override
                            public int compare(TreeViewNode treeViewNode, TreeViewNode treeViewNode2) {
                                return treeViewNode.getText(columnIndex).compareTo(treeViewNode2.getText(columnIndex));
                            }
                        };
                        break;
                    }
                    case 2: {
                        comparator = new Comparator<TreeViewNode>(){

                            @Override
                            public int compare(TreeViewNode treeViewNode, TreeViewNode treeViewNode2) {
                                return treeViewNode.getText(columnIndex).compareToIgnoreCase(treeViewNode2.getText(columnIndex));
                            }
                        };
                        break;
                    }
                    case 3: {
                        comparator = new Comparator<TreeViewNode>(){

                            @Override
                            public int compare(TreeViewNode treeViewNode, TreeViewNode treeViewNode2) {
                                String[] stringArray = new String[]{treeViewNode.getText(columnIndex), treeViewNode2.getText(columnIndex)};
                                double[] dArray = new double[2];
                                for (int i2 = 0; i2 < dArray.length; ++i2) {
                                    try {
                                        char[] cArray = stringArray[i2].toCharArray();
                                        StringBuilder stringBuilder = new StringBuilder();
                                        boolean bl = false;
                                        boolean bl2 = false;
                                        block9: for (int i3 = 0; i3 < cArray.length; ++i3) {
                                            switch (cArray[i3]) {
                                                case '0': 
                                                case '1': 
                                                case '2': 
                                                case '3': 
                                                case '4': 
                                                case '5': 
                                                case '6': 
                                                case '7': 
                                                case '8': 
                                                case '9': {
                                                    stringBuilder.append(cArray[i3]);
                                                    bl2 = true;
                                                    continue block9;
                                                }
                                                case '.': {
                                                    if (decPointComma || bl) continue block9;
                                                    stringBuilder.append(cArray[i3]);
                                                    bl = true;
                                                    continue block9;
                                                }
                                                case ',': {
                                                    if (!decPointComma || bl) continue block9;
                                                    stringBuilder.append('.');
                                                    bl = true;
                                                    continue block9;
                                                }
                                                case '+': 
                                                case '-': {
                                                    if (bl2) continue block9;
                                                    stringBuilder.append(cArray[i3]);
                                                }
                                            }
                                        }
                                        dArray[i2] = Double.parseDouble(stringBuilder.toString());
                                        continue;
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                }
                                if (dArray[0] > dArray[1]) {
                                    return 1;
                                }
                                if (dArray[1] > dArray[0]) {
                                    return -1;
                                }
                                return 0;
                            }
                        };
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        comparator = new Comparator<TreeViewNode>(){

                            @Override
                            public int compare(TreeViewNode treeViewNode, TreeViewNode treeViewNode2) {
                                int[] nArray;
                                Object object;
                                Object object2;
                                Object[] objectArray;
                                String[] stringArray = new String[]{treeViewNode.getText(columnIndex), treeViewNode2.getText(columnIndex)};
                                int[] nArray2 = new int[2];
                                int[] nArray3 = new int[2];
                                int[] nArray4 = new int[2];
                                Vector<Object> vector = new Vector<Object>();
                                for (int i2 = 0; i2 < nArray2.length; ++i2) {
                                    objectArray = stringArray[i2].toCharArray();
                                    object2 = new StringBuilder();
                                    block14: for (object = 0; object < objectArray.length; ++object) {
                                        switch (objectArray[object]) {
                                            case '0': 
                                            case '1': 
                                            case '2': 
                                            case '3': 
                                            case '4': 
                                            case '5': 
                                            case '6': 
                                            case '7': 
                                            case '8': 
                                            case '9': {
                                                ((StringBuilder)object2).append(objectArray[object]);
                                                continue block14;
                                            }
                                            default: {
                                                if (((StringBuilder)object2).length() <= 0) continue block14;
                                                vector.addElement(object2);
                                                object2 = new StringBuilder();
                                            }
                                        }
                                    }
                                    if (((StringBuilder)object2).length() > 0) {
                                        vector.addElement(object2);
                                    }
                                    if (vector.size() > 0) {
                                        try {
                                            nArray2[i2] = Integer.parseInt(((StringBuilder)vector.elementAt(0)).toString());
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            // empty catch block
                                        }
                                    }
                                    if (vector.size() > 1) {
                                        try {
                                            nArray3[i2] = Integer.parseInt(((StringBuilder)vector.elementAt(1)).toString());
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            // empty catch block
                                        }
                                    }
                                    if (vector.size() <= 2) continue;
                                    try {
                                        nArray4[i2] = Integer.parseInt(((StringBuilder)vector.elementAt(2)).toString());
                                        continue;
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                }
                                switch (sortType) {
                                    case 5: {
                                        nArray = nArray2;
                                        objectArray = nArray3;
                                        object2 = nArray4;
                                        break;
                                    }
                                    default: {
                                        nArray = nArray3;
                                        objectArray = nArray2;
                                        object2 = nArray4;
                                        break;
                                    }
                                    case 6: {
                                        nArray = nArray4;
                                        objectArray = nArray3;
                                        object2 = nArray2;
                                    }
                                }
                                for (object = 0; object < ((Object)object2).length; ++object) {
                                    if (object2[object] < 30) {
                                        Object object3 = object2;
                                        int n2 = object;
                                        object3[n2] = object3[n2] + 2000;
                                        continue;
                                    }
                                    if (object2[object] >= 100) continue;
                                    Object object4 = object2;
                                    Object object5 = object;
                                    object4[object5] = object4[object5] + 1900;
                                }
                                object = object2[0] - object2[1];
                                if (object == 0) {
                                    object = objectArray[0] - objectArray[1];
                                }
                                if (object == 0) {
                                    object = nArray[0] - nArray[1];
                                }
                                return object;
                            }
                        };
                    }
                }
                this.comparator = new Comparator<TreeViewNode>(){

                    @Override
                    public int compare(TreeViewNode treeViewNode, TreeViewNode treeViewNode2) {
                        switch (sortState) {
                            default: {
                                return comparator.compare(treeViewNode, treeViewNode2);
                            }
                            case DESCENDING: 
                        }
                        return -comparator.compare(treeViewNode, treeViewNode2);
                    }
                };
            }
            return this.comparator;
        }
    }

    private static enum SortState {
        UNSORTED,
        ASCENDING,
        DESCENDING;

    }
}

