/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.client.swing.Filterable;
import com.iscobol.gui.client.swing.FlatStyleUI;
import com.iscobol.gui.client.swing.GradientManager;
import com.iscobol.gui.client.swing.IsTreeViewModel;
import com.iscobol.gui.client.swing.TreeTableView;
import com.iscobol.gui.client.swing.TreeViewEvent;
import com.iscobol.gui.client.swing.TreeViewListener;
import com.iscobol.gui.client.swing.TreeViewNode;
import com.iscobol.gui.client.swing.treetable.JTreeTable;
import com.iscobol.gui.client.swing.treetable.TreeTableCellRenderer;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeView
extends TreeTableCellRenderer {
    private short changeSelectionCause = (short)-1;
    private final MyTreeCellRenderer renderer;
    private Vector<TreeViewListener> treeViewListeners = new Vector();
    private MyTreeCellEditor editor;
    private String toolTipText;
    private TreePath[] selectingPath;
    private TreePath lastMouseSelectedPath;
    private DefaultTreeSelectionModel virtualModel;
    private boolean flat;
    private boolean showRootHandles;
    private FlatStyleUI fsui;
    private boolean processingEvent;
    private int vpadding = 20;
    private Color matchingTextColorBackground = new Color(-10446);
    private Color matchingTextColorForeground = new Color(-13487566);
    private Color matchingTextColor2Background = new Color(-16711936);
    private Color matchingTextColor2Foreground = new Color(-13487566);
    private TreeViewNode currMatchNode;
    private int currMatchNodeIdx;

    public TreeView(IsTreeViewModel isTreeViewModel, GradientManager gradientManager) {
        super(isTreeViewModel, null);
        this.renderer = new MyTreeCellRenderer();
        this.setCellRenderer(this.renderer);
        this.setCellEditor(null);
        super.setToolTipText("");
        this.virtualModel = new DefaultTreeSelectionModel();
        this.virtualModel.setRowMapper(this.getSelectionModel().getRowMapper());
        this.setSelectionMode(1);
    }

    void setPaintGradient(boolean bl) {
        this.renderer.showBackground = !bl;
        this.setOpaque(!bl);
    }

    public TreePath[] getSelectingPaths() {
        return this.selectingPath;
    }

    @Override
    public void clearSelection() {
        super.clearSelection();
        if (this.getTreeTable() != null) {
            super.setLeadSelectionPath(null);
        }
        this.selectingPath = null;
    }

    @Override
    public void setEditable(boolean bl) {
        super.setEditable(bl);
        if (bl && this.editor == null) {
            JTextField jTextField = new JTextField();
            this.editor = new MyTreeCellEditor(jTextField);
            this.setCellEditor(this.editor);
            this.setInvokesStopCellEditing(true);
        }
    }

    @Override
    public void addFocusListener(FocusListener focusListener) {
        super.addFocusListener(focusListener);
        if (this.editor != null) {
            this.editor.textField.addFocusListener(focusListener);
        }
    }

    @Override
    public void removeFocusListener(FocusListener focusListener) {
        super.removeFocusListener(focusListener);
        if (this.editor != null) {
            this.editor.textField.removeFocusListener(focusListener);
        }
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        super.addKeyListener(keyListener);
        if (this.editor != null) {
            this.editor.textField.addKeyListener(keyListener);
        }
    }

    @Override
    public void removeKeyListener(KeyListener keyListener) {
        super.removeKeyListener(keyListener);
        if (this.editor != null) {
            this.editor.textField.removeKeyListener(keyListener);
        }
    }

    @Override
    public void setFocusable(boolean bl) {
        super.setFocusable(bl);
        if (this.editor != null) {
            this.editor.textField.setFocusable(bl);
        }
    }

    public void addTreeViewListener(TreeViewListener treeViewListener) {
        this.treeViewListeners.addElement(treeViewListener);
    }

    public void removeTreeViewListener(TreeViewListener treeViewListener) {
        this.treeViewListeners.remove(treeViewListener);
    }

    @Override
    public void scrollPathToVisible(TreePath treePath) {
        if (treePath != null) {
            this.makeVisible(treePath);
            Rectangle rectangle = this.getPathBounds(treePath);
            if (rectangle != null) {
                super.scrollRectToVisible(rectangle);
                if (this.accessibleContext != null) {
                    ((JTree.AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
                }
            }
        }
    }

    @Override
    public void scrollRectToVisible(Rectangle rectangle) {
    }

    void superScrollRectToVisible(Rectangle rectangle) {
        super.scrollRectToVisible(rectangle);
    }

    @Override
    public void addSelectionInterval(int n2, int n3) {
        this.addSelectionPaths(this.getPathBetweenRows(n2, n3));
    }

    @Override
    public void addSelectionPath(TreePath treePath) {
        this.addSelectionPaths(new TreePath[]{treePath});
    }

    @Override
    public void addSelectionPaths(TreePath[] treePathArray) {
        this.changeVirtualSelection(treePathArray, true);
    }

    @Override
    public void removeSelectionInterval(int n2, int n3) {
        this.removeSelectionPaths(this.getPathBetweenRows(n2, n3));
    }

    @Override
    public void removeSelectionPath(TreePath treePath) {
        this.removeSelectionPaths(new TreePath[]{treePath});
    }

    @Override
    public void removeSelectionPaths(TreePath[] treePathArray) {
        this.changeVirtualSelection(treePathArray, false);
    }

    private void changeVirtualSelection(TreePath[] treePathArray, boolean bl) {
        TreePath[] treePathArray2 = this.getSelectionPaths();
        if (treePathArray2 != null) {
            this.virtualModel.setSelectionPaths(treePathArray2);
        } else {
            this.virtualModel.clearSelection();
        }
        if (bl) {
            this.virtualModel.addSelectionPaths(treePathArray);
        } else {
            this.virtualModel.removeSelectionPaths(treePathArray);
        }
        treePathArray2 = this.virtualModel.getSelectionPaths();
        this.setSelectionPaths(treePathArray2, false);
    }

    @Override
    public void setSelectionInterval(int n2, int n3) {
        this.setSelectionPaths(this.getPathBetweenRows(n2, n3), false);
    }

    @Override
    public void setSelectionPath(TreePath treePath) {
        this.setSelectionPaths(new TreePath[]{treePath}, false);
    }

    @Override
    public void setSelectionPaths(TreePath[] treePathArray) {
        this.setSelectionPaths(treePathArray, false);
    }

    void setSelectionPaths(TreePath[] treePathArray, boolean bl) {
        if (this.isEditing() || treePathArray == null || treePathArray.length == 0) {
            return;
        }
        if (this.getSelectionModel().getSelectionMode() == 1) {
            TreePath[] treePathArray2 = this.getSelectionPaths();
            if (bl || treePathArray2 == null || treePathArray2.length != 1 || !treePathArray2[0].equals(treePathArray[0])) {
                this.selectingPath = treePathArray;
                this.fireValueWillChange(treePathArray[0]);
            }
        } else {
            TreePath[] treePathArray3 = this.getSelectionPaths();
            boolean bl2 = false;
            if (treePathArray3 == null || treePathArray3.length != treePathArray.length) {
                bl2 = true;
            } else {
                for (int i2 = 0; i2 < treePathArray3.length; ++i2) {
                    if (treePathArray3[i2].equals(treePathArray[i2])) continue;
                    bl2 = true;
                    break;
                }
            }
            if (bl2) {
                super.setSelectionPaths(treePathArray);
                this.fireMultipleSelectionChanged(treePathArray);
            }
        }
    }

    public void selectPaths(TreePath[] treePathArray) {
        this.selectPaths(treePathArray, true);
    }

    public void selectPaths(TreePath[] treePathArray, boolean bl) {
        super.setSelectionPaths(treePathArray);
        TreeTableView treeTableView = (TreeTableView)this.getTreeTable();
        if (treeTableView != null) {
            super.setLeadSelectionPath(treePathArray[0]);
        }
        this.selectingPath = null;
        if (bl) {
            if (treeTableView != null) {
                int n2 = this.getRowForPath(treePathArray[0]);
                Rectangle rectangle = treeTableView.getCellRect(n2, 0, true);
                if (rectangle != null) {
                    treeTableView.scrollRectToVisible(rectangle);
                }
            } else {
                Rectangle rectangle = this.getPathBounds(treePathArray[0]);
                if (rectangle != null) {
                    rectangle.x = 0;
                    rectangle.width = 1;
                    super.scrollRectToVisible(rectangle);
                }
            }
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.renderer != null) {
            this.renderer.setBackgroundNonSelectionColor(color);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.renderer != null) {
            this.renderer.setTextNonSelectionColor(color);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.renderer != null) {
            this.renderer.setFont(font);
        }
        if (this.editor != null) {
            this.editor.setFont(font);
        }
        this.updateRowHeight();
    }

    protected void updateRowHeight() {
        TreeModel treeModel = this.getModel();
        if (treeModel != null) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            float f2 = fontMetrics.getHeight();
            float f3 = (100.0f + (float)this.vpadding) / 100.0f;
            this.setRowHeight(Math.round(f2 * f3) + 1);
        }
    }

    public short getChangeSelectionCause() {
        return this.changeSelectionCause;
    }

    public void setChangeSelectionCause(short s2) {
        this.changeSelectionCause = s2;
    }

    @Override
    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this.toolTipText = string;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath != null) {
            TreeViewNode treeViewNode = (TreeViewNode)treePath.getLastPathComponent();
            String string = treeViewNode.getHint(0);
            if (string != null) {
                return string;
            }
            if (this.toolTipText != null) {
                return this.toolTipText;
            }
            if (this.getParent() != null) {
                Rectangle rectangle = this.getPathBounds(treePath);
                int n2 = this.getParent().getSize().width;
                if (rectangle.x + rectangle.width > n2) {
                    return treeViewNode.getText(0);
                }
            }
        } else if (this.toolTipText != null) {
            return this.toolTipText;
        }
        return null;
    }

    @Override
    public void requestFocus() {
        if (this.isEditing()) {
            this.editor.textField.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.isEditing()) {
            return this.editor.textField.requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    @Override
    public void startEditingAtPath(TreePath treePath) {
    }

    public void actionEntry(TreePath treePath) {
        this.fireStartEditing();
    }

    public void editPath(TreePath treePath) {
        if (this.editor != null) {
            super.startEditingAtPath(treePath);
            this.repaint();
        }
    }

    public void exitEditor() {
        if (this.editor != null) {
            this.editor.setFireEvents(false);
            super.stopEditing();
            this.editor.setFireEvents(true);
        }
    }

    Component getEditorComponent() {
        if (this.editor != null) {
            return this.editor.textField;
        }
        return null;
    }

    @Override
    public void setLeadSelectionPath(TreePath treePath) {
        if (this.getTreeTable() == null) {
            super.setLeadSelectionPath(treePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processEvent(AWTEvent aWTEvent) {
        this.processingEvent = true;
        try {
            switch (aWTEvent.getID()) {
                case 501: {
                    MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                    this.lastMouseSelectedPath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    this.changeSelectionCause = 1;
                    break;
                }
                case 401: {
                    Enumeration<TreePath> enumeration;
                    KeyEvent keyEvent = (KeyEvent)aWTEvent;
                    this.changeSelectionCause = (short)2;
                    TreeViewNode treeViewNode = (TreeViewNode)this.getLastSelectedPathComponent();
                    if (keyEvent.getKeyCode() == 39) {
                        if (treeViewNode == null || !treeViewNode.isLeaf()) break;
                        this.fireRightArrowPressedOnLeaf(this.getLeadSelectionPath(), keyEvent);
                        return;
                    }
                    if (treeViewNode == null || treeViewNode.isLeaf() || keyEvent.getKeyChar() != '*' || keyEvent.getKeyLocation() != 4 || keyEvent.getModifiersEx() != 0 || !(enumeration = this.getPathsToExpand(treeViewNode)).hasMoreElements()) break;
                    this.fireExpandAllEvent(enumeration);
                }
            }
            super.processEvent(aWTEvent);
        }
        finally {
            this.processingEvent = false;
        }
    }

    public Enumeration<TreePath> getPathsToExpand(TreeViewNode treeViewNode) {
        Vector<TreePath> vector = new Vector<TreePath>();
        this.getPathsToExpand(treeViewNode, vector);
        return vector.elements();
    }

    private void getPathsToExpand(TreeViewNode treeViewNode, Vector<TreePath> vector) {
        int n2 = treeViewNode.getChildCount();
        if (n2 > 0) {
            TreePath treePath = new TreePath(treeViewNode.getPath());
            if (!this.isExpanded(treePath)) {
                vector.addElement(treePath);
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                this.getPathsToExpand((TreeViewNode)treeViewNode.getChildAt(i2), vector);
            }
        }
    }

    public boolean isProcessingEvent() {
        return this.processingEvent;
    }

    void tableSorted() {
        ArrayList<Enumeration<TreePath>> arrayList = new ArrayList<Enumeration<TreePath>>();
        this.getExpandedPaths(arrayList);
        ((IsTreeViewModel)this.getModel()).reload();
        TreeViewEvent treeViewEvent = new TreeViewEvent(this, arrayList);
        for (TreeViewListener treeViewListener : this.treeViewListeners) {
            treeViewListener.tableSorted(treeViewEvent);
        }
    }

    private void fireCancelEditing() {
        TreeViewEvent treeViewEvent = new TreeViewEvent(this, (String)null);
        for (TreeViewListener treeViewListener : this.treeViewListeners) {
            treeViewListener.cancelEditing(treeViewEvent);
        }
    }

    private void fireStopEditing(TreePath treePath) {
        TreeViewEvent treeViewEvent = new TreeViewEvent(this, ((TreeViewNode)treePath.getLastPathComponent()).getText(0));
        for (TreeViewListener treeViewListener : this.treeViewListeners) {
            treeViewListener.stopEditing(treeViewEvent);
        }
    }

    private void fireMultipleSelectionChanged(TreePath[] treePathArray) {
        TreeViewEvent treeViewEvent = new TreeViewEvent(this, treePathArray);
        for (TreeViewListener treeViewListener : this.treeViewListeners) {
            treeViewListener.multipleSelectionChanged(treeViewEvent);
        }
    }

    private void fireValueWillChange(TreePath treePath) {
        TreeViewEvent treeViewEvent = new TreeViewEvent(this, new TreePath[]{treePath});
        for (TreeViewListener treeViewListener : this.treeViewListeners) {
            treeViewListener.valueWillChange(treeViewEvent);
        }
    }

    private void fireStartEditing() {
        TreeViewEvent treeViewEvent = new TreeViewEvent(this, (String)null);
        for (TreeViewListener treeViewListener : this.treeViewListeners) {
            treeViewListener.startEditing(treeViewEvent);
        }
    }

    private void fireExpandAllEvent(Enumeration<TreePath> enumeration) {
        ArrayList<Enumeration<TreePath>> arrayList = new ArrayList<Enumeration<TreePath>>();
        arrayList.add(enumeration);
        TreeViewEvent treeViewEvent = new TreeViewEvent(this, arrayList);
        for (TreeViewListener treeViewListener : this.treeViewListeners) {
            treeViewListener.expandAll(treeViewEvent);
        }
    }

    private void fireRightArrowPressedOnLeaf(TreePath treePath, KeyEvent keyEvent) {
        TreeViewEvent treeViewEvent = new TreeViewEvent(this, treePath, keyEvent);
        for (TreeViewListener treeViewListener : this.treeViewListeners) {
            treeViewListener.rightArrowPressedOnLeaf(treeViewEvent);
        }
    }

    public void setSelectionBackground(Color color) {
        this.renderer.setBackgroundSelectionColor(color);
    }

    public Color getSelectionBackground() {
        return this.renderer.getBackgroundSelectionColor();
    }

    public void setSelectionForeground(Color color) {
        this.renderer.setTextSelectionColor(color);
    }

    public Color getSelectionForeground() {
        return this.renderer.getTextSelectionColor();
    }

    protected void getAllExpandedPaths(TreePath treePath, TreePath treePath2, Vector<TreePath> vector) {
        TreeNode treeNode;
        if (!this.isExpanded(treePath)) {
            return;
        }
        if (treePath != treePath2) {
            vector.add(treePath);
        }
        if ((treeNode = (TreeNode)treePath.getLastPathComponent()) != null && treeNode.getChildCount() > 0) {
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode2 = enumeration.nextElement();
                TreePath treePath3 = treePath.pathByAddingChild(treeNode2);
                this.getAllExpandedPaths(treePath3, treePath2, vector);
            }
        }
    }

    protected void setExpandedPaths(Vector<TreePath> vector) {
        for (TreePath treePath : vector) {
            if (this.isExpanded(treePath)) continue;
            this.expandPath(treePath);
        }
    }

    private void getExpandedPaths(List<Enumeration<TreePath>> list) {
        TreeModel treeModel = this.getModel();
        if (treeModel != null) {
            TreeViewNode treeViewNode = (TreeViewNode)treeModel.getRoot();
            for (int i2 = 0; i2 < treeViewNode.getChildCount(); ++i2) {
                TreeViewNode treeViewNode2 = (TreeViewNode)treeViewNode.getChildAt(i2);
                TreePath treePath = new TreePath(treeViewNode2.getPath());
                if (!this.isExpanded(treePath)) continue;
                list.add(this.getExpandedDescendants(treePath));
            }
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n2, int n3) {
        if (bl) {
            this.setBackground(jTable.getSelectionBackground());
        } else {
            Color color;
            TreePath treePath = this.getPathForRow(n2);
            if (treePath != null && (color = ((TreeViewNode)treePath.getLastPathComponent()).getBackground()) != null) {
                this.setBackground(color);
            } else {
                this.setBackground(jTable.getBackground());
            }
        }
        this.visibleRow = n2;
        return this;
    }

    public void setSelectionMode(int n2) {
        this.getSelectionModel().setSelectionMode(n2);
        this.virtualModel.setSelectionMode(n2);
    }

    public TreePath getLastMouseSelectedPath() {
        return this.lastMouseSelectedPath;
    }

    private static boolean isWindowsLaf() {
        return "com.sun.java.swing.plaf.windows.WindowsLookAndFeel".equals(UIManager.getLookAndFeel().getClass().getName());
    }

    public boolean isFlat() {
        return this.flat && TreeView.isWindowsLaf();
    }

    public void setFlat(boolean bl) {
        if (this.flat != bl) {
            this.flat = bl;
            if (TreeView.isWindowsLaf()) {
                if (this.flat) {
                    if (this.fsui == null) {
                        this.fsui = new FlatStyleUI("chevron_down2.png", "chevron_right2.png");
                    }
                    super.setShowsRootHandles(true);
                } else {
                    super.setShowsRootHandles(this.showRootHandles);
                }
                Color color = this.renderer.getBackgroundSelectionColor();
                Color color2 = this.renderer.getTextSelectionColor();
                Color color3 = this.renderer.getBackgroundNonSelectionColor();
                Color color4 = this.renderer.getTextNonSelectionColor();
                super.updateUI();
                this.renderer.setBackgroundSelectionColor(color);
                this.renderer.setTextSelectionColor(color2);
                this.renderer.setBackgroundNonSelectionColor(color3);
                this.renderer.setTextNonSelectionColor(color4);
            }
        }
    }

    @Override
    public void setUI(TreeUI treeUI) {
        super.setUI(this.isFlat() && this.fsui != null ? this.fsui : treeUI);
    }

    @Override
    public void setShowsRootHandles(boolean bl) {
        this.showRootHandles = bl;
        if (!this.isFlat()) {
            super.setShowsRootHandles(bl);
        }
    }

    public boolean isLocationInExpandControl(TreePath treePath, int n2, int n3) {
        if (this.isFlat()) {
            return this.fsui.isLocationInExpandControl(treePath, n2, n3);
        }
        return false;
    }

    @Override
    public void setTreeTable(JTreeTable jTreeTable) {
        super.setTreeTable(jTreeTable);
        this.renderer.isInTreeTable = jTreeTable != null;
    }

    public int getVPadding() {
        return this.vpadding;
    }

    public void setVPadding(int n2) {
        if (this.vpadding != n2) {
            this.vpadding = n2;
            this.updateRowHeight();
        }
    }

    @Override
    public Rectangle getVisibleRect() {
        if (this.getTreeTable() != null) {
            return this.getTreeTable().getVisibleRect();
        }
        return super.getVisibleRect();
    }

    private static String getRgbString(Color color) {
        String string = "#";
        String string2 = Integer.toHexString(color.getRed());
        if (string2.length() == 1) {
            string = string + "0";
        }
        string = string + string2;
        string2 = Integer.toHexString(color.getGreen());
        if (string2.length() == 1) {
            string = string + "0";
        }
        string = string + string2;
        string2 = Integer.toHexString(color.getBlue());
        if (string2.length() == 1) {
            string = string + "0";
        }
        string = string + string2;
        return string;
    }

    String getTextWithHighlight(String string, int n2, String string2, boolean bl) {
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            return null;
        }
        String string3 = bl ? string : string.toLowerCase();
        String string4 = bl ? string2 : string2.toLowerCase();
        int n3 = string2.length();
        int n4 = string3.indexOf(string4);
        if (n4 >= 0) {
            String string5;
            int n5 = n2;
            StringBuffer stringBuffer = new StringBuffer();
            if (!string3.startsWith("<html>")) {
                stringBuffer.append("<html>");
                string5 = "</html>";
            } else {
                string5 = null;
            }
            int n6 = 0;
            while (n4 >= 0) {
                Color color;
                Color color2;
                stringBuffer.append(string.substring(n6, n4));
                if (n5 == this.currMatchNodeIdx) {
                    color2 = this.matchingTextColor2Background;
                    color = this.matchingTextColor2Foreground;
                } else {
                    color2 = this.matchingTextColorBackground;
                    color = this.matchingTextColorForeground;
                }
                stringBuffer.append("<span bgcolor=" + TreeView.getRgbString(color2) + " color=" + TreeView.getRgbString(color) + ">");
                stringBuffer.append(string.substring(n4, n4 + n3));
                stringBuffer.append("</span>");
                n6 = n4 + n3;
                n4 = string3.indexOf(string4, n6);
                ++n5;
            }
            if (n6 < string3.length()) {
                stringBuffer.append(string.substring(n6));
            }
            if (string5 != null) {
                stringBuffer.append(string5);
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public Color getMatchingTextColorBackground() {
        return this.matchingTextColorBackground;
    }

    public void setMatchingTextColorBackground(Color color) {
        this.matchingTextColorBackground = color;
    }

    public Color getMatchingTextColorForeground() {
        return this.matchingTextColorForeground;
    }

    public void setMatchingTextColorForeground(Color color) {
        this.matchingTextColorForeground = color;
    }

    public Color getMatchingTextColor2Background() {
        return this.matchingTextColor2Background;
    }

    public void setMatchingTextColor2Background(Color color) {
        this.matchingTextColor2Background = color;
    }

    public Color getMatchingTextColor2Foreground() {
        return this.matchingTextColor2Foreground;
    }

    public void setMatchingTextColor2Foreground(Color color) {
        this.matchingTextColor2Foreground = color;
    }

    void setCurrentMatch(TreeViewNode treeViewNode, int n2) {
        this.currMatchNode = treeViewNode;
        this.currMatchNodeIdx = n2;
    }

    TreeViewNode getCurrentMatchNode() {
        return this.currMatchNode;
    }

    int getCurrentMatchNodeIndex() {
        return this.currMatchNodeIdx;
    }

    private class MyTreeCellEditor
    extends DefaultCellEditor
    implements DocumentListener {
        private JTextField textField;
        private FontMetrics fm;
        private boolean fireEvents;
        private final int MIN_SIZE = 20;
        private final int TEXT_PAD = 5;
        private int height;

        public MyTreeCellEditor(JTextField jTextField) {
            super(jTextField);
            this.fireEvents = true;
            this.MIN_SIZE = 20;
            this.TEXT_PAD = 5;
            this.textField = jTextField;
            this.setFont(TreeView.this.getFont());
            this.textField.getDocument().addDocumentListener(this);
            this.textField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (!focusEvent.isTemporary()) {
                        TreeView.this.stopEditing();
                    }
                }
            });
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void setFont(Font font) {
            this.textField.setFont(font);
            this.fm = this.textField.getFontMetrics(font);
            this.height = this.fm.getHeight();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            int n2 = this.fm.stringWidth(this.textField.getText()) + 5;
            this.textField.setSize(new Dimension(Math.max(20, n2), this.textField.getHeight()));
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            int n2 = this.fm.stringWidth(this.textField.getText()) + 5;
            this.textField.setSize(new Dimension(Math.max(20, n2), this.textField.getHeight()));
        }

        void setFireEvents(boolean bl) {
            this.fireEvents = bl;
        }

        @Override
        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n2) {
            int n3 = this.fm.stringWidth(object.toString()) + 5;
            this.textField.setPreferredSize(new Dimension(Math.max(20, n3), this.height));
            this.textField.selectAll();
            return super.getTreeCellEditorComponent(jTree, object, bl, bl2, bl3, n2);
        }

        @Override
        public void cancelCellEditing() {
            TreeView.this.fireCancelEditing();
            super.cancelCellEditing();
        }

        @Override
        public boolean stopCellEditing() {
            if (!this.fireEvents) {
                return super.stopCellEditing();
            }
            TreePath treePath = TreeView.this.getEditingPath();
            TreeView.this.fireStopEditing(treePath);
            TreeViewNode treeViewNode = (TreeViewNode)treePath.getLastPathComponent();
            if (treeViewNode != null) {
                treeViewNode.setText(0, this.getCellEditorValue().toString());
            }
            return false;
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            return !(eventObject instanceof MouseEvent);
        }
    }

    private class MyTreeCellRenderer
    extends DefaultTreeCellRenderer
    implements TreeCellRenderer {
        private boolean showBackground;
        private boolean isInTreeTable;

        private MyTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n2, boolean bl4) {
            String string;
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n2, bl4);
            TreeViewNode treeViewNode = (TreeViewNode)object;
            if (treeViewNode != null && treeViewNode.getRoot() instanceof Filterable && (string = TreeView.this.getTextWithHighlight(treeViewNode.toString(), treeViewNode == TreeView.this.currMatchNode ? 0 : Integer.MIN_VALUE, ((Filterable)((Object)treeViewNode.getRoot())).getFilterString(), ((Filterable)((Object)treeViewNode.getRoot())).isFilterCaseSensitive())) != null) {
                this.setText(string);
            }
            this.setOpaque(false);
            if (!bl) {
                if (treeViewNode.getForeground() != null) {
                    this.setForeground(treeViewNode.getForeground());
                }
                if (treeViewNode.getBackground() != null) {
                    this.setOpaque(true);
                    this.setBackground(treeViewNode.getBackground());
                }
            }
            ImageIcon imageIcon = treeViewNode.getIcon(0);
            this.setIcon(imageIcon);
            this.setDisabledIcon(imageIcon);
            if (this.isInTreeTable) {
                if (treeViewNode.getImgTrailing(0) != 0) {
                    this.setHorizontalTextPosition(2);
                } else {
                    this.setHorizontalTextPosition(4);
                }
            }
            this.doLayout();
            return this;
        }

        @Override
        public Color getBackgroundNonSelectionColor() {
            return this.isOpaque() || this.showBackground ? super.getBackgroundNonSelectionColor() : null;
        }

        @Override
        public Color getBackground() {
            return this.isOpaque() || this.showBackground ? super.getBackground() : null;
        }
    }
}

