/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import com.iscobol.gui.client.PicobolWidget;
import com.iscobol.gui.client.swing.GradientManager;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.ScrollPane;
import com.iscobol.gui.client.swing.SearchPanel;
import com.iscobol.gui.client.swing.TreeTableView;
import com.iscobol.gui.client.swing.TreeView;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import javax.swing.border.Border;

public class TreeViewPanel
extends JPanel
implements PicobolWidget {
    private final PicobolWidget pw;
    private final JComponent mainComponent;
    private SearchPanel searchPanel;
    private MyScrollPane scrollPane;
    private boolean searchPanelVisible;
    private SearchPanelVisibility spVisibility = SearchPanelVisibility.ON_DEMAND;
    private GradientManager gradientMgr;

    public TreeViewPanel(JComponent jComponent, GuiFactoryImpl guiFactoryImpl, boolean bl) {
        this(jComponent, null, guiFactoryImpl, bl, false, true, false, false, false, false, false);
    }

    public TreeViewPanel(JComponent jComponent, GradientManager gradientManager, final GuiFactoryImpl guiFactoryImpl, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8) {
        TreeTableView treeTableView;
        this.mainComponent = jComponent;
        this.searchPanel = new SearchPanel(bl2, bl3, bl4, bl5, bl6, bl7, bl8);
        this.searchPanel.addSearchPanelNotifier(new SearchPanel.Notifier(){

            @Override
            public void escapeKeyPressed() {
                if (TreeViewPanel.this.spVisibility == SearchPanelVisibility.ON_DEMAND) {
                    TreeViewPanel.this.hideSearchPanel();
                }
            }

            @Override
            public void closeButtonPressed() {
                TreeViewPanel.this.hideSearchPanel();
            }
        });
        this.pw = this.mainComponent instanceof PicobolWidget ? (PicobolWidget)((Object)this.mainComponent) : null;
        this.setLayout(new BorderLayout());
        this.gradientMgr = gradientManager;
        if (bl) {
            this.scrollPane = new MyScrollPane(this.mainComponent);
            this.scrollPane.getVerticalScrollBar().addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent componentEvent) {
                    TreeViewPanel.this.notifyWidthChanged(TreeViewPanel.this.getSize().width);
                }

                @Override
                public void componentHidden(ComponentEvent componentEvent) {
                    TreeViewPanel.this.notifyWidthChanged(TreeViewPanel.this.getSize().width);
                }
            });
            this.add((Component)this.scrollPane, "Center");
        } else {
            this.add((Component)this.mainComponent, "Center");
        }
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (SearchPanelVisibility.isSearchKey(keyEvent, TreeViewPanel.this.spVisibility, guiFactoryImpl)) {
                    TreeViewPanel.this.showSearchPanel();
                }
            }
        };
        this.mainComponent.addKeyListener(keyAdapter);
        if (this.mainComponent instanceof TreeTableView && (treeTableView = (TreeTableView)this.mainComponent).getTree() != null) {
            treeTableView.getTree().addKeyListener(keyAdapter);
        }
        if (this.gradientMgr != null && this.scrollPane != null) {
            this.gradientMgr.addPropertyChangeListener(propertyChangeEvent -> {
                this.setOpaque();
                this.scrollPane.getViewport().repaint();
            });
            this.setOpaque();
        }
    }

    private void setOpaque() {
        boolean bl;
        boolean bl2 = bl = this.gradientMgr != null && this.gradientMgr.isPaintGradient();
        if (this.pw instanceof TreeView) {
            ((TreeView)((Object)this.pw)).setPaintGradient(bl);
        }
        if (this.scrollPane != null) {
            this.scrollPane.getViewport().setOpaque(!bl);
        }
    }

    public void showSearchPanel() {
        if (!this.searchPanelVisible) {
            this.searchPanel.setShowCloseButton(this.spVisibility == SearchPanelVisibility.ON_DEMAND);
            this.add((Component)this.searchPanel, "North");
            this.validate();
            this.searchPanelVisible = true;
            this.searchPanel.setFocus();
        } else if (this.searchPanel.isShowCloseButton() && this.spVisibility == SearchPanelVisibility.ALWAYS) {
            this.searchPanel.setShowCloseButton(false);
            this.validate();
        }
    }

    public void hideSearchPanel() {
        if (this.searchPanelVisible) {
            this.remove(this.searchPanel);
            this.validate();
            this.searchPanelVisible = false;
            this.searchPanel.resetSearchText();
        }
    }

    public boolean isSearchPanelVisible() {
        return this.searchPanelVisible;
    }

    public ScrollPane getScrollPane() {
        return this.scrollPane;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        if (this.searchPanel != null) {
            this.searchPanel.addPropertyChangeListener(propertyChangeListener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        if (this.searchPanel != null) {
            this.searchPanel.removePropertyChangeListener(propertyChangeListener);
        }
    }

    @Override
    public void setBackground(Color color) {
        if (this.scrollPane == null) {
            super.setBackground(color);
        } else {
            this.scrollPane.setBackground(color);
        }
    }

    @Override
    public Color getBackground() {
        if (this.scrollPane == null) {
            return super.getBackground();
        }
        return this.scrollPane.getBackground();
    }

    @Override
    public void setForeground(Color color) {
        if (this.scrollPane == null) {
            super.setForeground(color);
        } else {
            this.scrollPane.setForeground(color);
        }
    }

    @Override
    public Color getForeground() {
        if (this.scrollPane == null) {
            return super.getForeground();
        }
        return this.scrollPane.getForeground();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.scrollPane != null) {
            this.scrollPane.setEnabled(bl);
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.scrollPane == null) {
            return super.isEnabled();
        }
        return this.scrollPane.isEnabled();
    }

    @Override
    public void setFont(Font font) {
        if (this.scrollPane == null) {
            super.setFont(font);
        } else {
            this.scrollPane.setFont(font);
            if (this.searchPanel != null) {
                this.searchPanel.getSearchText().setFont(font);
            }
        }
    }

    @Override
    public Font getFont() {
        if (this.scrollPane == null) {
            return super.getFont();
        }
        return this.scrollPane.getFont();
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        if (this.scrollPane == null) {
            super.addKeyListener(keyListener);
        } else {
            this.scrollPane.addKeyListener(keyListener);
        }
    }

    @Override
    public void removeKeyListener(KeyListener keyListener) {
        if (this.scrollPane == null) {
            super.removeKeyListener(keyListener);
        } else {
            this.scrollPane.removeKeyListener(keyListener);
        }
    }

    @Override
    public void addFocusListener(FocusListener focusListener) {
        if (this.scrollPane == null) {
            super.addFocusListener(focusListener);
        } else {
            this.scrollPane.addFocusListener(focusListener);
        }
    }

    @Override
    public void removeFocusListener(FocusListener focusListener) {
        if (this.scrollPane == null) {
            super.removeFocusListener(focusListener);
        } else {
            this.scrollPane.removeFocusListener(focusListener);
        }
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        if (this.scrollPane == null) {
            super.addMouseListener(mouseListener);
        } else {
            this.scrollPane.addMouseListener(mouseListener);
        }
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        if (this.scrollPane == null) {
            super.removeMouseListener(mouseListener);
        } else {
            this.scrollPane.removeMouseListener(mouseListener);
        }
    }

    @Override
    public void setFocusable(boolean bl) {
        if (this.scrollPane == null) {
            super.setFocusable(bl);
        } else {
            this.scrollPane.setFocusable(bl);
        }
    }

    @Override
    public void requestFocus() {
        if (this.scrollPane == null) {
            super.requestFocus();
        } else {
            this.scrollPane.requestFocus();
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.scrollPane == null) {
            return super.requestFocusInWindow();
        }
        return this.scrollPane.requestFocusInWindow();
    }

    @Override
    public void setToolTipText(String string) {
        if (this.scrollPane != null && this.scrollPane instanceof JComponent) {
            ((JComponent)this.scrollPane).setToolTipText(string);
        }
    }

    @Override
    public void setActiveAccept(boolean bl) {
        if (this.pw != null) {
            this.pw.setActiveAccept(bl);
        }
    }

    @Override
    public boolean getActiveAccept() {
        return this.pw != null && this.pw.getActiveAccept();
    }

    @Override
    public void setSelfAct(boolean bl) {
    }

    @Override
    public boolean getSelfAct() {
        return false;
    }

    @Override
    public void asyncProcessEvent(AWTEvent aWTEvent) {
    }

    public SearchPanelVisibility getSearchPanelVisibility() {
        return this.spVisibility;
    }

    public SearchPanel getSearchPanel() {
        return this.searchPanel;
    }

    public void setSearchPanelVisibility(SearchPanelVisibility searchPanelVisibility) {
        if (searchPanelVisibility != null && this.spVisibility != searchPanelVisibility) {
            this.spVisibility = searchPanelVisibility;
            switch (this.spVisibility) {
                case NEVER: 
                case ON_DEMAND: {
                    this.hideSearchPanel();
                    break;
                }
                case ALWAYS: {
                    this.showSearchPanel();
                }
            }
        }
    }

    public void setScrollBarPolicies(int n2, int n3) {
        if (this.scrollPane != null) {
            this.scrollPane.setVerticalScrollBarPolicy(n2);
            this.scrollPane.setHorizontalScrollBarPolicy(n3);
        }
    }

    @Override
    public void setBounds(int n2, int n3, int n4, int n5) {
        super.setBounds(n2, n3, n4, n5);
        if (this.mainComponent instanceof TreeTableView) {
            this.notifyWidthChanged(n4);
        }
    }

    private void notifyWidthChanged(int n2) {
        TreeTableView treeTableView;
        Insets insets = this.mainComponent.getInsets();
        n2 -= insets.left;
        n2 -= insets.right;
        TreeTableView treeTableView2 = treeTableView = this.mainComponent instanceof TreeTableView ? (TreeTableView)this.mainComponent : null;
        if (treeTableView != null && treeTableView.getColumnCount() > 1) {
            n2 -= treeTableView.getColumnCount() - 1;
        }
        if (this.scrollPane != null) {
            insets = this.scrollPane.getInsets();
            n2 -= insets.left;
            n2 -= insets.right;
            if (this.scrollPane.getVerticalScrollBar().isVisible()) {
                n2 -= this.scrollPane.getVerticalScrollBar().getPreferredSize().width;
            }
        }
        if (treeTableView != null) {
            treeTableView.containerWidthChanged(n2);
        }
    }

    private class MyScrollPane
    extends ScrollPane {
        MyScrollPane(Component component) {
            super(component);
            super.setBorder(null);
        }

        @Override
        public void setBorder(Border border) {
        }

        @Override
        protected JViewport createViewport() {
            return new MyViewport();
        }
    }

    private class MyViewport
    extends JViewport {
        private MyViewport() {
        }

        @Override
        public void paintComponent(Graphics graphics) {
            if (TreeViewPanel.this.gradientMgr != null && TreeViewPanel.this.gradientMgr.isPaintGradient()) {
                JScrollBar jScrollBar;
                Dimension dimension = this.getSize();
                JScrollBar jScrollBar2 = TreeViewPanel.this.scrollPane.getVerticalScrollBar();
                if (jScrollBar2.isVisible()) {
                    dimension.width += jScrollBar2.getSize().width;
                }
                if ((jScrollBar = TreeViewPanel.this.scrollPane.getHorizontalScrollBar()).isVisible()) {
                    dimension.height += jScrollBar.getSize().height;
                }
                TreeViewPanel.this.gradientMgr.paint((Graphics2D)graphics, new Rectangle(new Point(0, 0), dimension));
            }
            super.paintComponent(graphics);
        }
    }

    public static enum SearchPanelVisibility {
        NEVER,
        ON_DEMAND,
        ALWAYS;


        public static boolean isSearchKey(KeyEvent keyEvent, SearchPanelVisibility searchPanelVisibility, AbstractGuiFactoryImpl abstractGuiFactoryImpl) {
            return searchPanelVisibility != NEVER && abstractGuiFactoryImpl.getRemoteVirtualKeyboard().isSearchKey(keyEvent.getKeyCode(), keyEvent.isShiftDown(), keyEvent.isControlDown(), keyEvent.isAltDown(), "tree-view");
        }
    }
}

