/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.swing.DockablePanel;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.JDialog;
import javax.swing.WindowConstants;

public class UndockedDialog
extends JDialog
implements WindowConstants {
    private DockablePanel dockPanel;
    private String port;
    private Dimension paneSize;
    private boolean firstTime = true;

    public UndockedDialog(DockablePanel dockablePanel, Point point) {
        super(dockablePanel.getRootWindow());
        this.dockPanel = dockablePanel;
        this.setRootPane(dockablePanel.getRootPane());
        this.paneSize = dockablePanel.getRootPane().getSize();
        this.setTitle(this.dockPanel.getTitle());
        this.setDefaultCloseOperation(0);
        ScreenUtility.disableFocusTraversalKeys(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                UndockedDialog.this.dockPanel.add(UndockedDialog.this.getRootPane());
                UndockedDialog.this.dockPanel.dock();
                UndockedDialog.this.dockPanel.setVisible(true);
                UndockedDialog.this.dispose();
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
            }
        });
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
                UndockedDialog.this.dockPanel.setFocused(true);
            }

            @Override
            public void windowLostFocus(WindowEvent windowEvent) {
            }
        });
        if (point != null) {
            this.setLocation(point.x, point.y);
        }
        this.setVisible(true);
    }

    @Override
    public void doLayout() {
        if (this.firstTime) {
            Insets insets = this.getInsets();
            this.setSize(insets.left + insets.right + this.paneSize.width, insets.top + insets.bottom + this.paneSize.height);
            this.firstTime = false;
        }
        super.doLayout();
    }
}

