/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.client.swing.WebClientEvent;
import com.iscobol.gui.client.swing.WebClientListener;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.JPanel;

public class WebClientUtility {
    private static final Character char_0 = new Character('\u0000');
    private static final Byte byte_0 = new Byte(0);
    private static final boolean initSucceeded;
    private static final Class webActionListenerCls;
    private static final Object webSwingApi;
    private static final Method sendActionEventMth;
    private static final Method sendActionEventWWMth;
    private static final Method createHtmlPanelMth;
    private static final Class webWindowActionListenerCls;
    private static final Method addWebWindowActionListenerMth;
    private static final Method removeWebWindowActionListenerMth;
    private static final Method getActionNameMth;
    private static final Method getDataMth;
    private static final Method getBinaryDataMth;
    private static int communicationStatusValue;
    private final ArrayList<WebClientListener> listeners = new ArrayList();
    private final LinkedList<WebClientEvent> events = new LinkedList();
    private final Object webActionListener;

    public WebClientUtility() throws Throwable {
        MyInvocationHandler myInvocationHandler = new MyInvocationHandler(){

            @Override
            public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                if ("actionPerformed".equals(method.getName())) {
                    return WebClientUtility.this.fireWebActionEvent(objectArray[0]);
                }
                return super.invoke(object, method, objectArray);
            }
        };
        this.webActionListener = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{webActionListenerCls}, (InvocationHandler)myInvocationHandler);
        webSwingApi.getClass().getMethod("addBrowserActionListener", webActionListenerCls).invoke(webSwingApi, this.webActionListener);
    }

    private static Integer proxyHashCode(Object object) {
        return new Integer(System.identityHashCode(object));
    }

    private static Boolean proxyEquals(Object object, Object object2) {
        return object == object2 ? Boolean.TRUE : Boolean.FALSE;
    }

    private static String proxyToString(Object object) {
        return object.getClass().getName() + '@' + Integer.toHexString(object.hashCode());
    }

    private static Object nullValueOf(Class clazz) {
        if (!clazz.isPrimitive()) {
            return null;
        }
        if (clazz == Void.TYPE) {
            return null;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (clazz == Character.TYPE) {
            return char_0;
        }
        return byte_0;
    }

    private Object fireWebActionEvent(Object object) {
        if (WebClientUtility.getCommunicationStatusValue() > 0) {
            try {
                this.fireWebActionEvent(new WebClientEvent((String)getActionNameMth.invoke(object, new Object[0]), (String)getDataMth.invoke(object, new Object[0]), (byte[])getBinaryDataMth.invoke(object, new Object[0])));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireWebActionEvent(WebClientEvent webClientEvent) {
        AbstractList abstractList = this.events;
        synchronized (abstractList) {
            this.events.addLast(webClientEvent);
            this.events.notify();
        }
        abstractList = this.listeners;
        synchronized (abstractList) {
            for (WebClientListener webClientListener : this.listeners) {
                webClientListener.messageReceived(webClientEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWebClientListener(WebClientListener webClientListener) {
        ArrayList<WebClientListener> arrayList = this.listeners;
        synchronized (arrayList) {
            if (!this.listeners.contains(webClientListener)) {
                this.listeners.add(webClientListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWebClientListener(WebClientListener webClientListener) {
        ArrayList<WebClientListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(webClientListener);
        }
    }

    public static boolean sendActionEvent(String string, String string2, byte[] byArray) {
        if (communicationStatusValue > 0) {
            try {
                sendActionEventMth.invoke(webSwingApi, string, string2, byArray);
                return true;
            }
            catch (Throwable throwable) {
                return false;
            }
        }
        return false;
    }

    public static boolean sendActionEvent(Object object, String string, String string2, byte[] byArray) {
        try {
            sendActionEventWWMth.invoke(webSwingApi, object, string, string2, byArray);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebClientEvent getActionEvent(int n2, String[] stringArray) {
        if (communicationStatusValue <= 0) {
            stringArray[0] = "-1";
            return null;
        }
        LinkedList<WebClientEvent> linkedList = this.events;
        synchronized (linkedList) {
            if (this.events.isEmpty()) {
                if (n2 > 0) {
                    stringArray[0] = "99";
                    try {
                        this.events.wait(n2);
                    }
                    catch (InterruptedException interruptedException) {
                        stringArray[0] = "-1";
                    }
                } else {
                    stringArray[0] = "-1";
                    try {
                        this.events.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.events.isEmpty()) {
                    return null;
                }
                return this.events.removeFirst();
            }
            return this.events.removeFirst();
        }
    }

    public static int getCommunicationStatusValue() {
        return communicationStatusValue;
    }

    public static void setCommunicationStatusValue(int n2) {
        communicationStatusValue = n2;
    }

    public static JPanel createHtmlPanel() {
        try {
            return (JPanel)createHtmlPanelMth.invoke(webSwingApi, new Object[0]);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Object addWebClientListener(JPanel jPanel, final WebClientListener webClientListener) {
        try {
            MyInvocationHandler myInvocationHandler = new MyInvocationHandler(){

                @Override
                public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                    if ("actionPerformed".equals(method.getName())) {
                        try {
                            WebClientEvent webClientEvent = new WebClientEvent((String)getActionNameMth.invoke(objectArray[0], new Object[0]), (String)getDataMth.invoke(objectArray[0], new Object[0]), (byte[])getBinaryDataMth.invoke(objectArray[0], new Object[0]));
                            webClientListener.messageReceived(webClientEvent);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        return null;
                    }
                    if ("windowInitialized".equals(method.getName())) {
                        return null;
                    }
                    return super.invoke(object, method, objectArray);
                }
            };
            Object object = Proxy.newProxyInstance(WebClientUtility.class.getClassLoader(), new Class[]{webWindowActionListenerCls}, (InvocationHandler)myInvocationHandler);
            addWebWindowActionListenerMth.invoke((Object)jPanel, object);
            return object;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static void removeWebWindowActionListener(JPanel jPanel, Object object) {
        try {
            removeWebWindowActionListenerMth.invoke((Object)jPanel, object);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static WebClientUtility getInstance() {
        if (initSucceeded) {
            try {
                return new WebClientUtility();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public void dispose() {
        try {
            webSwingApi.getClass().getMethod("removeBrowserActionListener", webActionListenerCls).invoke(webSwingApi, this.webActionListener);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        Class<?> clazz = null;
        Object object = null;
        Method method = null;
        Method method2 = null;
        Method method3 = null;
        Class<?> clazz2 = null;
        Class<?> clazz3 = null;
        Method method4 = null;
        Method method5 = null;
        Method method6 = null;
        Method method7 = null;
        Method method8 = null;
        boolean bl = false;
        try {
            clazz = Class.forName("org.webswing.toolkit.api.action.WebActionListener");
            Class<?> clazz4 = Class.forName("org.webswing.toolkit.api.WebswingUtil");
            object = clazz4.getMethod("getWebswingApi", new Class[0]).invoke(null, new Object[0]);
            method = object.getClass().getMethod("sendActionEvent", String.class, String.class, byte[].class);
            Class<?> clazz5 = Class.forName("org.webswing.toolkit.api.action.WebWindow");
            method2 = object.getClass().getMethod("sendActionEvent", clazz5, String.class, String.class, byte[].class);
            method3 = object.getClass().getMethod("createHtmlPanel", new Class[0]);
            clazz2 = Class.forName("org.webswing.toolkit.api.action.WebWindowActionListener");
            clazz3 = Class.forName("org.webswing.toolkit.api.component.HtmlPanel");
            method4 = clazz3.getMethod("addWebWindowActionListener", clazz2);
            method5 = clazz3.getMethod("removeWebWindowActionListener", clazz2);
            Class<?> clazz6 = Class.forName("org.webswing.toolkit.api.action.WebActionEvent");
            method6 = clazz6.getMethod("getActionName", new Class[0]);
            method7 = clazz6.getMethod("getData", new Class[0]);
            method8 = clazz6.getMethod("getBinaryData", new Class[0]);
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        webSwingApi = object;
        sendActionEventMth = method;
        sendActionEventWWMth = method2;
        createHtmlPanelMth = method3;
        webWindowActionListenerCls = clazz2;
        addWebWindowActionListenerMth = method4;
        removeWebWindowActionListenerMth = method5;
        getActionNameMth = method6;
        getDataMth = method7;
        getBinaryDataMth = method8;
        webActionListenerCls = clazz;
        initSucceeded = bl;
    }

    private static abstract class MyInvocationHandler
    implements InvocationHandler {
        private MyInvocationHandler() {
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if ("hashCode".equals(method.getName())) {
                return WebClientUtility.proxyHashCode(object);
            }
            if ("equals".equals(method.getName())) {
                return WebClientUtility.proxyEquals(object, objectArray[0]);
            }
            if ("toString".equals(method.getName())) {
                return WebClientUtility.proxyToString(object);
            }
            return WebClientUtility.nullValueOf(method.getReturnType());
        }
    }
}

