/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing.treetable;

import com.iscobol.gui.client.swing.treetable.AbstractCellEditor;
import com.iscobol.gui.client.swing.treetable.TreeTableCellRenderer;
import com.iscobol.gui.client.swing.treetable.TreeTableModel;
import com.iscobol.gui.client.swing.treetable.TreeTableModelAdapter;
import com.iscobol.gui.client.swing.treetable.TreeTableModelExt;
import com.iscobol.gui.client.swing.treetable.TreeTableMouseEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JTreeTable
extends JTable {
    protected TreeTableCellRenderer tree;

    public JTreeTable(TreeTableModel treeTableModel) {
        this(null, treeTableModel);
    }

    public JTreeTable(TreeTableCellRenderer treeTableCellRenderer, TreeTableModel treeTableModel) {
        if (treeTableCellRenderer == null) {
            treeTableCellRenderer = new TreeTableCellRenderer(treeTableModel, this);
        }
        this.tree = treeTableCellRenderer;
        super.setModel(new TreeTableModelAdapter(treeTableModel, treeTableCellRenderer));
        ListToTreeSelectionModelWrapper listToTreeSelectionModelWrapper = new ListToTreeSelectionModelWrapper();
        treeTableCellRenderer.setSelectionModel(listToTreeSelectionModelWrapper);
        this.setSelectionModel(listToTreeSelectionModelWrapper.getListSelectionModel());
        this.setDefaultRenderer(TreeTableModel.class, treeTableCellRenderer);
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        if (treeTableCellRenderer.getRowHeight() < 1) {
            this.setRowHeight(18);
        }
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.tree.addTreeSelectionListener(treeSelectionListener);
    }

    public void removeTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.tree.removeTreeSelectionListener(treeSelectionListener);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    @Override
    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == TreeTableModel.class ? -1 : this.editingRow;
    }

    @Override
    public void setRowHeight(int n2) {
        super.setRowHeight(n2);
        if (this.tree != null && this.tree.getRowHeight() != n2) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    public void setRootVisible(boolean bl) {
        this.tree.setRootVisible(bl);
    }

    public boolean isRootVisible() {
        return this.tree.isRootVisible();
    }

    public void reload() {
        TreeModel treeModel = this.tree.getModel();
        if (treeModel instanceof TreeTableModelExt) {
            TreeTableModelExt treeTableModelExt = (TreeTableModelExt)treeModel;
            treeTableModelExt.fireTreeStructureChanged(treeTableModelExt, new Object[]{treeTableModelExt.getRoot()}, null, null);
            TreeTableModelAdapter treeTableModelAdapter = (TreeTableModelAdapter)this.getModel();
            treeTableModelAdapter.fireTableChanged(new TableModelEvent(treeTableModelAdapter));
        }
    }

    public TreeTableModel getTreeTableModel() {
        return (TreeTableModel)this.tree.getModel();
    }

    public JTree getTreeTableCellRenderer() {
        return this.tree;
    }

    protected boolean shouldFireMouseEventsInEditor() {
        return true;
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        @Override
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int n2 = this.listSelectionModel.getMinSelectionIndex();
                    int n3 = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (n2 != -1 && n3 != -1) {
                        for (int i2 = n2; i2 <= n3; ++i2) {
                            TreePath treePath;
                            if (!this.listSelectionModel.isSelectedIndex(i2) || (treePath = JTreeTable.this.tree.getPathForRow(i2)) == null) continue;
                            this.addSelectionPath(treePath);
                        }
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    public class TreeTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n2, int n3) {
            return JTreeTable.this.tree;
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent && JTreeTable.this.shouldFireMouseEventsInEditor()) {
                for (int i2 = JTreeTable.this.getColumnCount() - 1; i2 >= 0; --i2) {
                    if (JTreeTable.this.getColumnClass(i2) != TreeTableModel.class) continue;
                    MouseEvent mouseEvent = (MouseEvent)eventObject;
                    TreeTableMouseEvent treeTableMouseEvent = new TreeTableMouseEvent(JTreeTable.this.tree, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - JTreeTable.this.getCellRect((int)0, (int)i2, (boolean)true).x, mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                    JTreeTable.this.tree.dispatchEvent(treeTableMouseEvent);
                    break;
                }
            }
            return false;
        }
    }
}

