/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing.treetable;

import com.iscobol.gui.client.swing.OutDragListener;
import com.iscobol.gui.client.swing.treetable.JTreeTable;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;

public class TreeTableCellRenderer
extends JTree
implements TableCellRenderer {
    protected int visibleRow;
    private JTreeTable treeTable;
    private OutDragListener odlistener;

    public TreeTableCellRenderer(TreeModel treeModel, JTreeTable jTreeTable) {
        super(treeModel);
        this.treeTable = jTreeTable;
    }

    public JTreeTable getTreeTable() {
        return this.treeTable;
    }

    public void setTreeTable(JTreeTable jTreeTable) {
        this.treeTable = jTreeTable;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        TreeCellRenderer treeCellRenderer = this.getCellRenderer();
        if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
            DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
            defaultTreeCellRenderer.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
            defaultTreeCellRenderer.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
        }
    }

    @Override
    public void setRowHeight(int n2) {
        if (n2 > 0) {
            super.setRowHeight(n2);
            if (this.treeTable != null && this.treeTable.getRowHeight() != n2) {
                this.treeTable.setRowHeight(this.getRowHeight());
            }
        }
    }

    @Override
    public void setBounds(int n2, int n3, int n4, int n5) {
        if (this.treeTable != null) {
            super.setBounds(n2, 0, n4, this.treeTable.getHeight());
        } else {
            super.setBounds(n2, n3, n4, n5);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.treeTable != null) {
            graphics.translate(0, -this.visibleRow * this.getRowHeight());
        }
        try {
            super.paint(graphics);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n2, int n3) {
        if (bl) {
            this.setBackground(jTable.getSelectionBackground());
        } else {
            this.setBackground(jTable.getBackground());
        }
        this.visibleRow = n2;
        return this;
    }

    public void removeOutDragListener() {
        this.odlistener = null;
    }

    public void setDragComponent(OutDragListener outDragListener) {
        this.odlistener = outDragListener;
    }

    public JComponent getDragDropComponent() {
        return this;
    }

    public int getDropRow(Point point) {
        return this.getRowForLocation(point.x, point.y) + 1;
    }
}

