/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing.treetable;

import com.iscobol.gui.client.swing.treetable.TreeTableModel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreePath;

public class TreeTableModelAdapter
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    JTree tree;
    TreeTableModel treeTableModel;

    public TreeTableModelAdapter(TreeTableModel treeTableModel, JTree jTree) {
        this.tree = jTree;
        this.treeTableModel = treeTableModel;
        jTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }
        });
        treeTableModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }
        });
    }

    @Override
    public int getColumnCount() {
        return this.treeTableModel.getColumnCount();
    }

    @Override
    public String getColumnName(int n2) {
        return this.treeTableModel.getColumnName(n2);
    }

    public Class getColumnClass(int n2) {
        return this.treeTableModel.getColumnClass(n2);
    }

    @Override
    public int getRowCount() {
        return this.tree.getRowCount();
    }

    protected Object nodeForRow(int n2) {
        TreePath treePath = this.tree.getPathForRow(n2);
        return treePath != null ? treePath.getLastPathComponent() : null;
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        return this.treeTableModel.getValueAt(this.nodeForRow(n2), n3);
    }

    @Override
    public boolean isCellEditable(int n2, int n3) {
        return this.treeTableModel.isCellEditable(this.nodeForRow(n2), n3);
    }

    @Override
    public void setValueAt(Object object, int n2, int n3) {
        this.treeTableModel.setValueAt(object, this.nodeForRow(n2), n3);
    }

    protected void delayedFireTableDataChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }
        });
    }
}

