/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.server;

import com.iscobol.gui.ColorCmp;
import com.iscobol.gui.ParamElementInt;
import com.iscobol.gui.ParamVector;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.server.BaseGUIControl;
import com.iscobol.gui.server.CobolGUIEnvironment;
import com.iscobol.gui.server.CobolGUILabel;
import com.iscobol.gui.server.DisplayToolBar;
import com.iscobol.gui.server.DisplayWindow;
import com.iscobol.gui.server.TerminalEmulation;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.INumericVar;
import com.iscobol.rts.IPicG;
import com.iscobol.rts.IPicN;
import com.iscobol.rts.IscobolSystem;
import java.io.IOException;

public class CobolGUITerminalDisplay
extends CobolGUILabel
implements TerminalEmulation {
    int colAdjust;
    private boolean isclone;

    @Override
    protected void clear() {
        this.baseclear();
        this.isclone = false;
        this.setSizes(this.getSizes() + (float)this.colAdjust);
        this.colAdjust = 0;
    }

    public CobolGUITerminalDisplay(String string, ICobolVar iCobolVar, CobolGUIEnvironment cobolGUIEnvironment) {
        super(string, iCobolVar, cobolGUIEnvironment);
        this.color = new ColorCmp(false);
        this.controlPeerType = 20;
        this.setAtLineInCell(true);
        this.setAtColumnInCell(true);
        this.setLinesInCell(true);
        this.setSizesInCell(true);
        this.setFont("FIXED-FONT");
    }

    @Override
    protected boolean initialize(DisplayWindow displayWindow) {
        boolean bl = true;
        super.initialize(displayWindow);
        this.controlPeerServerIdTerminalDisplay = this.controlPeerServerId;
        if (displayWindow.getTerminalDisplayGateId() == 0) {
            displayWindow.setTerminalDisplayGateId(this.controlPeerServerId);
        } else {
            bl = false;
            this.controlPeerServerId = displayWindow.getTerminalDisplayGateId();
        }
        this.controlPeerType = 20;
        return bl;
    }

    @Override
    protected void initialize() {
        super.initialize();
    }

    @Override
    public int getLenInChar() {
        return (int)this.getSizes();
    }

    @Override
    public float getAtColumn() {
        return super.getAtColumn() + (float)this.colAdjust;
    }

    @Override
    public Object clone(DisplayWindow displayWindow) {
        CobolGUITerminalDisplay cobolGUITerminalDisplay = null;
        try {
            cobolGUITerminalDisplay = (CobolGUITerminalDisplay)super.clone(displayWindow);
            cobolGUITerminalDisplay.remoteClone(displayWindow);
            cobolGUITerminalDisplay.controlPeerinitialize();
        }
        catch (IOException iOException) {
            ScreenUtility.handleIOException(iOException);
        }
        return cobolGUITerminalDisplay;
    }

    @Override
    public void reclone(DisplayWindow displayWindow, ParamVector paramVector) {
        super.reclone();
        this.getClone(displayWindow);
        this.controlpeersetParentControl(-1, displayWindow.getParamCSWindow());
        this.clearChange();
    }

    @Override
    public BaseGUIControl getClone(DisplayWindow displayWindow) {
        if (this.paramCS == null) {
            this.paramCS = new ParamVector(IscobolSystem.isAS());
        }
        try {
            this.buildRemoteObject(this, displayWindow);
        }
        catch (IOException iOException) {
            ScreenUtility.handleIOException(iOException);
        }
        this.setVisible(true);
        this.isclone = true;
        this.destroyed = false;
        if (displayWindow != null && !(displayWindow instanceof DisplayToolBar)) {
            this.addToParamCS(new ParamElementInt(1024, displayWindow.getTheObjectId()));
        }
        return this;
    }

    @Override
    public boolean isClone() {
        return this.isclone;
    }

    @Override
    public BaseGUIControl getLastClone() {
        if (this.isclone) {
            return this;
        }
        return null;
    }

    @Override
    public BaseGUIControl setNoecho(boolean bl) {
        super.setNoecho(bl);
        if (bl) {
            this.styleoneset |= 0x80L;
        }
        return this;
    }

    @Override
    public BaseGUIControl setUnderline(boolean bl) {
        super.setUnderline(bl);
        if (bl) {
            this.styleoneset |= 0x1000L;
        }
        return this;
    }

    @Override
    public void setUnderlineColor(boolean bl) {
        super.setUnderlineColor(bl);
        if (bl) {
            this.styleoneset |= 0x1000L;
        }
    }

    @Override
    public BaseGUIControl setBlink(boolean bl) {
        super.setBlink(bl);
        if (bl) {
            this.styleoneset |= 8L;
        }
        return this;
    }

    @Override
    public void setBlinkColor(boolean bl) {
        super.setBlinkColor(bl);
        if (bl) {
            this.styleoneset |= 8L;
        }
    }

    @Override
    public BaseGUIControl setReverse(boolean bl) {
        super.setReverse(bl);
        if (bl) {
            this.styleoneset |= 0x400000L;
        }
        return this;
    }

    @Override
    public BaseGUIControl setAll(boolean bl) {
        super.setAll(bl);
        if (bl) {
            this.styleoneset |= 0x80000L;
        }
        return this;
    }

    @Override
    public BaseGUIControl setBeep(boolean bl) {
        super.setBeep(bl);
        if (bl) {
            this.styleoneset |= 2L;
        }
        return this;
    }

    @Override
    public BaseGUIControl setHighlight(boolean bl) {
        super.setHighlight(bl);
        if (bl) {
            this.styleoneset |= 0x8000L;
        }
        return this;
    }

    @Override
    protected long getStyleNumber(String string) {
        if (string.equalsIgnoreCase("RIGHT")) {
            return 1024L;
        }
        if (string.equalsIgnoreCase("LEFT")) {
            return 32L;
        }
        if (string.equalsIgnoreCase("CENTER") || string.equalsIgnoreCase("CENTERED")) {
            return 16L;
        }
        if (string.equalsIgnoreCase("NUMERIC")) {
            return 256L;
        }
        if (string.equalsIgnoreCase("NO-ECHO")) {
            return 128L;
        }
        if (string.equalsIgnoreCase("UNDERLINE")) {
            return 4096L;
        }
        if (string.equalsIgnoreCase("BLINK")) {
            return 8L;
        }
        if (string.equalsIgnoreCase("UPDATE")) {
            return 8192L;
        }
        if (string.equalsIgnoreCase("PROMPT")) {
            return 512L;
        }
        if (string.equalsIgnoreCase("UPPER")) {
            return 16384L;
        }
        if (string.equalsIgnoreCase("LOWER")) {
            return 64L;
        }
        if (string.equalsIgnoreCase("AUTO") || string.equalsIgnoreCase("AUTO-SKIP") || string.equalsIgnoreCase("AUTO-TERMINATION")) {
            return 1L;
        }
        if (string.equalsIgnoreCase("GRAPHICS")) {
            return 2048L;
        }
        return super.getStyleNumber(string);
    }

    @Override
    public float getWidthDimensionInCell() {
        ICobolVar iCobolVar = this.getCobolComponentPicture();
        ICobolVar iCobolVar2 = this.getCobolComponentO();
        if (this.getSizes() > 0.0f) {
            return this.sizes;
        }
        if (this.titleupdated != null) {
            return this.titleupdated.length();
        }
        String string = this.displaysetTitle(iCobolVar);
        if (string != null) {
            return string.length();
        }
        if (iCobolVar2 != null) {
            int n2 = Math.max(iCobolVar2.ieval().getLength(), iCobolVar != null ? iCobolVar.getLength() : 0);
            return n2;
        }
        return 0.0f;
    }

    @Override
    public BaseGUIControl setTitle(String string) {
        this.title = string;
        return this;
    }

    @Override
    public void displaysetValue(ICobolVar iCobolVar) throws IOException {
        if (this.title != null && this instanceof CobolGUITerminalDisplay) {
            return;
        }
        super.displaysetValue(iCobolVar);
    }

    @Override
    void controlPeersetValue(String string) throws IOException {
        super.controlPeersetValue(string);
        this.strValue = string;
    }

    @Override
    public void displaysetStyle() {
        try {
            if (this.color != null && this.colorCV != null && this.colorCV.ieval() instanceof INumericVar) {
                if (this.underlinecolor && !this.underline) {
                    this.styleoneset &= 0xFFFFFFFFFFFFEFFFL;
                }
                if (this.blinkcolor && !this.blink) {
                    this.styleoneset &= 0xFFFFFFFFFFFFFFF7L;
                }
                this.styleoneset &= 0xFFFFFFFFFFFF7FFFL;
                this.color = new ColorCmp(false);
            }
            this.checkColorVars();
            if (this.color != null && this.colorCV != null && this.colorCV.ieval() instanceof INumericVar) {
                if (this.getReverseValue()) {
                    this.color.setReverse(this.getReverseValue());
                }
                if (this.highlight) {
                    this.setHighlight(this.highlight);
                }
                if (this.lowlight) {
                    this.color.setForeHighIntensity(!this.lowlight);
                }
                if (this.backhigh) {
                    this.color.setBackHighIntensity(this.backhigh);
                }
                if (this.backlow) {
                    this.color.setBackHighIntensity(!this.backlow);
                }
            }
            this.setUnderlineColor(this.color.getUnderline());
            this.setBlinkColor(this.color.getBlink());
            super.displaysetStyle();
        }
        catch (IOException iOException) {
            ScreenUtility.handleIOException(iOException);
        }
    }

    @Override
    public final boolean isTerminalEmulation() {
        return true;
    }

    @Override
    public boolean getContainsChildTE() {
        return true;
    }

    @Override
    public void putControlInfo() {
        if (this.isValidRemoteControl() && (this.getCobolComponentO() instanceof IPicN || this.getCobolComponentO() instanceof IPicG)) {
            int n2 = 2048;
            if (this.paramCS != null && this.clsentINFO != n2) {
                this.clsentINFO = n2;
                this.paramCS.addFirst(new ParamElementInt(1067, n2));
            }
        }
    }
}

