/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.server;

import com.iscobol.gui.Constants;
import com.iscobol.gui.FontAttribute;
import com.iscobol.gui.GuiFactory;
import com.iscobol.gui.IsguiUtility;
import com.iscobol.gui.RemoteFontComponent;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.interfaces.runtime.IFontCmp;
import com.iscobol.rts.Config;
import com.iscobol.rts.Handle;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.UserHandles;
import com.iscobol.types.CobolVar;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class FontCmp
implements Constants,
IFontCmp,
Handle {
    private static final long serialVersionUID = 1L;
    private int style;
    private float size;
    private int cellWidth;
    private int cellHeight;
    private String name;
    private final Hashtable attrs;
    RemoteFontComponent fontPeer;
    int fontPeerId;

    private FontCmp(String string, int n2, float f2) {
        this.name = string;
        this.style = n2;
        this.size = f2;
        this.attrs = new Hashtable();
        this.attrs.put(FontAttribute.FAMILY, string);
        this.attrs.put(FontAttribute.SIZE, new Float(f2));
        if ((n2 & 1) != 0) {
            this.attrs.put(FontAttribute.WEIGHT, FontAttribute.WEIGHT_BOLD);
        }
        if ((n2 & 2) != 0) {
            this.attrs.put(FontAttribute.POSTURE, FontAttribute.POSTURE_OBLIQUE);
        }
    }

    public FontCmp(RemoteFontComponent remoteFontComponent, Hashtable hashtable) {
        this.fontPeer = remoteFontComponent;
        this.attrs = hashtable;
        if (this.fontPeer != null) {
            try {
                this.fontPeerId = this.fontPeer.getTheObjectId();
            }
            catch (IOException iOException) {
                ScreenUtility.handleIOException(iOException);
            }
        }
    }

    public void setFont(RemoteFontComponent remoteFontComponent) {
        this.fontPeer = remoteFontComponent;
        if (this.fontPeer != null) {
            try {
                this.fontPeerId = this.fontPeer.getTheObjectId();
            }
            catch (IOException iOException) {
                ScreenUtility.handleIOException(iOException);
            }
        }
    }

    public FontCmp(RemoteFontComponent remoteFontComponent, int n2, Hashtable hashtable) {
        this.setFontPeer(remoteFontComponent, n2);
        this.attrs = hashtable;
    }

    private static int[] getCellSize(String string) {
        int[] nArray = new int[2];
        String string2 = Config.a("iscobol.font." + string + ".cell", null);
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            try {
                nArray[0] = Integer.parseInt(stringTokenizer.nextToken());
                nArray[1] = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (Exception exception) {
                nArray[0] = 0;
                nArray[1] = 0;
            }
        } else {
            nArray[0] = 0;
            nArray[1] = 0;
        }
        return nArray;
    }

    public static FontCmp getStdFont(int n2) {
        return FontCmp.getStdFont(n2, "iscobol.font.");
    }

    public static FontCmp getStdFont(int n2, String string) {
        FontCmp fontCmp = null;
        String string2 = null;
        String string3 = null;
        float f2 = 9.0f;
        int n3 = 0;
        int[] nArray = new int[]{0, 0};
        if (n2 == 5) {
            string3 = Config.a(string + "default", null);
            if (string3 != null) {
                string2 = "SansSerif";
                n3 = 1;
            } else {
                n2 = 4;
            }
            nArray = FontCmp.getCellSize("default");
        }
        switch (n2) {
            case 0: {
                string2 = "Monospaced";
                n3 = 1;
                string3 = Config.a(string + "traditional", null);
                nArray = FontCmp.getCellSize("traditional");
                break;
            }
            case 1: {
                string2 = "Monospaced";
                n3 = 1;
                string3 = Config.a(string + "fixed", null);
                nArray = FontCmp.getCellSize("fixed");
                break;
            }
            case 2: {
                string2 = "SansSerif";
                n3 = 1;
                f2 = 10.0f;
                string3 = Config.a(string + "large", null);
                nArray = FontCmp.getCellSize("large");
                break;
            }
            case 3: {
                string2 = "SansSerif";
                f2 = 8.0f;
                string3 = Config.a(string + "small", null);
                nArray = FontCmp.getCellSize("small");
                break;
            }
            default: {
                if (n2 == 5) break;
                string2 = "SansSerif";
                n3 = 1;
                string3 = Config.a(string + "medium", null);
                nArray = FontCmp.getCellSize("medium");
            }
        }
        if (string3 != null) {
            Object[] objectArray = IsguiUtility.parseFontString(string3);
            fontCmp = new FontCmp((String)objectArray[0], (int)((Integer)objectArray[1]), ((Float)objectArray[2]).floatValue());
        } else {
            fontCmp = new FontCmp(string2, n3, f2);
        }
        fontCmp.cellWidth = nArray[0];
        fontCmp.cellHeight = nArray[1];
        return fontCmp;
    }

    public static FontCmp[] getStdFonts() {
        return FontCmp.getStdFonts("iscobol.font.");
    }

    public static FontCmp[] getStdFonts(String string) {
        FontCmp[] fontCmpArray = new FontCmp[6];
        for (int i2 = 0; i2 < 6; ++i2) {
            fontCmpArray[i2] = FontCmp.getStdFont(i2, string);
        }
        return fontCmpArray;
    }

    private static FontCmp[] intGetStdFonts() {
        FontCmp[] fontCmpArray = (FontCmp[])IscobolSystem.get(FontCmp[].class);
        if (fontCmpArray == null) {
            fontCmpArray = FontCmp.getStdFonts();
            IscobolSystem.set(FontCmp[].class, fontCmpArray);
        }
        return fontCmpArray;
    }

    public static FontCmp getFont(int n2) {
        return FontCmp.intGetStdFonts()[n2];
    }

    public static FontCmp getFont(CobolVar cobolVar) {
        return FontCmp.getFont((ICobolVar)cobolVar);
    }

    public static FontCmp getFont(ICobolVar iCobolVar) {
        Object object = UserHandles.getId(iCobolVar.toint());
        if (object instanceof FontCmp) {
            return (FontCmp)object;
        }
        return FontCmp.getFont(iCobolVar.toString());
    }

    private static int getFontIndex(String string) {
        int n2 = -1;
        if (string.equalsIgnoreCase("DEFAULT-FONT")) {
            n2 = 5;
        } else if (string.equalsIgnoreCase("FIXED-FONT")) {
            n2 = 1;
        } else if (string.equalsIgnoreCase("TRADITIONAL-FONT")) {
            n2 = 0;
        } else if (string.equalsIgnoreCase("SMALL-FONT")) {
            n2 = 3;
        } else if (string.equalsIgnoreCase("MEDIUM-FONT")) {
            n2 = 4;
        } else if (string.equalsIgnoreCase("LARGE-FONT")) {
            n2 = 2;
        }
        return n2;
    }

    public static FontCmp getStdFont(String string) {
        return FontCmp.getStdFont(string, "iscobol.font.");
    }

    public static FontCmp getStdFont(String string, String string2) {
        int n2 = FontCmp.getFontIndex(string);
        if (n2 >= 0) {
            return FontCmp.getStdFont(n2, string2);
        }
        return FontCmp.getStdFont(5, string2);
    }

    public static FontCmp getFont(String string) {
        int n2 = FontCmp.getFontIndex(string);
        if (n2 >= 0) {
            return FontCmp.intGetStdFonts()[n2];
        }
        return FontCmp.intGetStdFonts()[5];
    }

    public static FontCmp getFontIfExists(String string) {
        int n2 = FontCmp.getFontIndex(string);
        if (n2 >= 0) {
            return FontCmp.intGetStdFonts()[n2];
        }
        return null;
    }

    public static FontCmp getDefaultFont() {
        return FontCmp.intGetStdFonts()[5];
    }

    public static FontCmp getDefaultWindowFont() {
        return FontCmp.intGetStdFonts()[1];
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public float getSize() {
        return this.size;
    }

    @Override
    public int getStyle() {
        return this.style;
    }

    @Override
    public int getCellWidth() {
        return this.cellWidth;
    }

    @Override
    public int getCellHeight() {
        return this.cellHeight;
    }

    public int getFontId(boolean bl) {
        if (this.fontPeer == null) {
            this.getFont(bl);
        }
        int n2 = this.fontPeerId;
        return n2;
    }

    public RemoteFontComponent getFont(boolean bl) {
        RemoteFontComponent remoteFontComponent = null;
        if (this.fontPeer != null) {
            remoteFontComponent = this.fontPeer;
        } else if (this.name != null) {
            GuiFactory guiFactory = ScreenUtility.getGuiFactory();
            try {
                remoteFontComponent = this.fontPeer = guiFactory.getFont(this.name, this.style, this.size, this.cellWidth, this.cellHeight, bl);
                this.fontPeerId = this.fontPeer.getTheObjectId();
            }
            catch (IOException iOException) {
                ScreenUtility.handleIOException(iOException);
            }
        }
        return remoteFontComponent;
    }

    @Override
    public int type() {
        return 3;
    }

    public String toString() {
        return "FontCmp name=[" + this.name + "], size=[" + this.size + "],style=[" + this.style + "]";
    }

    @Override
    public boolean isStandardFont() {
        int n2 = FontCmp.intGetStdFonts().length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (FontCmp.getFont(i2) != this) continue;
            return true;
        }
        return false;
    }

    public void destroy() {
        if (this.fontPeer == null || this.isStandardFont()) {
            return;
        }
        try {
            this.fontPeer.destroy();
        }
        catch (IOException iOException) {
            ScreenUtility.handleIOException(iOException);
        }
        this.fontPeer = null;
        this.fontPeerId = 0;
    }

    public Hashtable getAttrs() {
        return this.attrs;
    }

    public boolean isInitialized() {
        return this.fontPeer != null;
    }

    public void setFontPeer(RemoteFontComponent remoteFontComponent, int n2) {
        this.fontPeer = remoteFontComponent;
        if (remoteFontComponent != null) {
            this.fontPeerId = n2;
        }
    }
}

