/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.htmlexporter;

import com.iscobol.gui.RemoteIO;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.io.RemoteIOImpl;
import com.iscobol.gui.server.CobolGUIJavaBean;
import com.iscobol.htmlexporter.RptExporter;
import com.iscobol.htmlexporter.ss.SSExporter;
import com.iscobol.htmlexporter.xls.XLSExporter;
import com.iscobol.htmlexporter.xlsx.XLSXExporter;
import com.iscobol.htmlrenderer.Drawer;
import com.iscobol.htmlrenderer.HTMLRenderer;
import com.iscobol.preview.PreviewEventsHandler;
import com.iscobol.preview.PreviewEventsImpl;
import com.iscobol.rts.CallOverflowException;
import com.iscobol.rts.Factory;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.types.CobolVar;
import com.iscobol.types.NumericVar;
import com.iscobol.types.PicX;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;

public class ExtendedHTMLRenderer
extends HTMLRenderer {
    public static final int XLS_EXPORT = 1;
    public static final int XLSX_EXPORT = 2;
    private static final String CLIENT_PREFIX = "@[display]:";
    private NumericVar RETURN_CODE = Factory.getVarBinary(Factory.getMem(8), 0, 8, false, Factory.getNumLiteral(0L, 1, 0, false), null, null, "RETURN-CODE", false, 18, 0, true, false, false);
    private PicX FILENAME = Factory.getVarAlphanum(Factory.getMem(256), 0, 256, false, null, null, null, "FILENAME", false, false);
    private PicX TMPFILENAME = Factory.getVarAlphanum(Factory.getMem(256), 0, 256, false, null, null, null, "TMPFILENAME", false, false);
    private Thread thread;
    private String header;
    private String footer;
    private double leftMargin;
    private double rightMargin;
    private double topMargin;
    private double bottomMargin;
    private boolean landscape;
    private String paperSize;
    private Properties exportProperties = new Properties();
    private Drawer serverDrawer;

    public ExtendedHTMLRenderer() {
        this.thread = Thread.currentThread();
    }

    private Drawer getServerDrawer() throws IOException {
        if (this.serverDrawer == null) {
            this.serverDrawer = new Drawer(new PreviewEventsImpl(), true);
        }
        return this.serverDrawer;
    }

    private RptExporter createExporter(int n2, String string, String string2, String string3) {
        SSExporter sSExporter;
        switch (n2) {
            default: {
                sSExporter = new XLSExporter(string, string2, string3);
                break;
            }
            case 2: {
                sSExporter = new XLSXExporter(string, string2, string3);
            }
        }
        sSExporter.setupPage(this.paperSize, this.topMargin, this.leftMargin, this.bottomMargin, this.rightMargin, this.landscape);
        return sSExporter;
    }

    private void runInBackground(final Runnable runnable) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                finally {
                    IscobolSystem.destroyEnv(this);
                }
            }
        };
        IscobolSystem.duplicateEnv(this.thread, thread);
        thread.start();
    }

    public static boolean checkLock(String string) {
        try {
            return ExtendedHTMLRenderer.checkLock0(string);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static boolean checkLock0(String string) throws IOException {
        RemoteIO remoteIO;
        if (string.toLowerCase().startsWith(CLIENT_PREFIX)) {
            remoteIO = ScreenUtility.getGuiFactory().getRemoteIO();
            string = string.substring(CLIENT_PREFIX.length());
        } else {
            remoteIO = new RemoteIOImpl();
        }
        return remoteIO.checkLock(string, true);
    }

    private void export(int n2, String string, String string2, boolean bl) {
        RptExporter rptExporter;
        block17: {
            boolean bl2 = this.getPaperUrl().toLowerCase().startsWith(CLIENT_PREFIX);
            String string3 = this.getOutputFilename(string, string2, bl);
            if (string3 == null) {
                return;
            }
            if (!ExtendedHTMLRenderer.checkLock(bl2 ? CLIENT_PREFIX + string3 : string3)) {
                return;
            }
            rptExporter = null;
            if (IscobolSystem.isAS() && (bl || bl2)) {
                block16: {
                    try {
                        Factory.call("c$create_tmp_file", null, new Object[]{this.TMPFILENAME.byRef(), Factory.getStrLiteral("rpt").byVal(), Factory.getStrLiteral("." + string2).byVal()});
                    }
                    catch (CallOverflowException callOverflowException) {
                        if (!bl) break block16;
                        ExtendedHTMLRenderer.showMessageDialog(callOverflowException.getMessage(), callOverflowException.getClass().getName(), 0);
                    }
                }
                rptExporter = this.createExporter(n2, this.getBasename(), this.getPaperUrl(), this.TMPFILENAME.toString().trim());
                try {
                    rptExporter.export();
                    this.FILENAME.set("@[DISPLAY]:" + string3);
                    try {
                        this.RETURN_CODE.set(Factory.call("c$copy", null, new CobolVar[]{this.TMPFILENAME.byRef(), this.FILENAME.byRef()}));
                        if (bl) {
                            ExtendedHTMLRenderer.showMessageDialog("Created file '" + string3 + "'");
                        }
                        break block17;
                    }
                    catch (CallOverflowException callOverflowException) {
                        if (bl) {
                            ExtendedHTMLRenderer.showMessageDialog(callOverflowException.getMessage(), callOverflowException.getClass().getName(), 0);
                        }
                        break block17;
                    }
                }
                catch (IOException iOException) {
                    if (bl) {
                        ExtendedHTMLRenderer.showMessageDialog(iOException.getMessage(), iOException.getClass().getName(), 0);
                    }
                    break block17;
                }
            }
            rptExporter = this.createExporter(n2, this.getBasename(), this.getPaperUrl(), string3);
            try {
                rptExporter.export();
                if (bl) {
                    ExtendedHTMLRenderer.showMessageDialog("Created file '" + string3 + "'");
                }
            }
            catch (IOException iOException) {
                if (!bl) break block17;
                ExtendedHTMLRenderer.showMessageDialog(iOException.getMessage(), iOException.getClass().getName(), 0);
            }
        }
        if (rptExporter != null) {
            rptExporter.dispose();
        }
    }

    private static void showMessageDialog(String string) {
        CobolGUIJavaBean.callStaticMethod("javax.swing.JOptionPane", "showMessageDialog", null, string);
    }

    private static void showMessageDialog(String string, String string2, int n2) {
        CobolGUIJavaBean.callStaticMethod("javax.swing.JOptionPane", "showMessageDialog", null, string, string2, new Integer(n2));
    }

    private String getBasename() {
        String string;
        int n2;
        String string2 = this.getPaperUrl();
        if (string2.toLowerCase().startsWith(CLIENT_PREFIX)) {
            string2 = string2.substring(CLIENT_PREFIX.length());
        }
        if ((n2 = (string = new File(string2.replace('\\', '/')).getName()).lastIndexOf(46)) >= 0) {
            string = string.substring(0, n2);
        }
        return string;
    }

    @Override
    public int open() {
        this.addMenu("export", "Export", null, 0, null);
        this.addMenu("export/xls", "Export to XLS", null, 1, new PreviewEventsHandler(){

            @Override
            public void handleEvent() {
                ExtendedHTMLRenderer.this.runInBackground(new Runnable(){

                    @Override
                    public void run() {
                        ExtendedHTMLRenderer.this.intExportXLS(true);
                    }
                });
            }
        });
        this.addMenu("export/xlsx", "Export to XLSx", null, 2, new PreviewEventsHandler(){

            @Override
            public void handleEvent() {
                ExtendedHTMLRenderer.this.runInBackground(new Runnable(){

                    @Override
                    public void run() {
                        ExtendedHTMLRenderer.this.intExportXLSX(true);
                    }
                });
            }
        });
        int n2 = super.open();
        this.removeMenu("export");
        return n2;
    }

    public void exportXLS() {
        this.intExportXLS(false);
    }

    private void intExportXLS(boolean bl) {
        this.export(1, "XLS files (*.xls)|*.xls", "xls", bl);
    }

    private void intExportXLSX(boolean bl) {
        this.export(2, "XLSX files (*.xlsx)|*.xlsx", "xlsx", bl);
    }

    public void exportXLSX() {
        this.intExportXLSX(false);
    }

    public void exportPDF() {
        boolean bl = this.getPaperUrl().toLowerCase().startsWith(CLIENT_PREFIX);
        String string = this.getOutputFilename(null, "pdf", false);
        if (!ExtendedHTMLRenderer.checkLock(bl ? CLIENT_PREFIX + string : string)) {
            return;
        }
        Drawer drawer = this.drawer;
        try {
            if (IscobolSystem.isAS() && !bl) {
                this.drawer = this.getServerDrawer();
                this.drawer.setUrl(this.getPaperUrl());
                this.drawer.setPaperSize(this.paperSize);
                this.drawer.setLandscape(this.landscape);
                this.drawer.setMargins(this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin);
                this.drawer.setHeaderFooter(this.header, this.footer);
            }
            this.setPDF(true);
            this.setJobName(string, "P");
            super.open();
        }
        catch (IOException iOException) {
            throw new IscobolRuntimeException(iOException);
        }
        finally {
            this.drawer = drawer;
        }
    }

    private String getOutputFilename(String string, String string2, boolean bl) {
        String string3 = null;
        if (bl) {
            string3 = (String)CobolGUIJavaBean.callStaticMethod("com.iscobol.rts.print.SpoolPrinter", "getSaveDefaultFilename");
        }
        if (string3 == null) {
            string3 = this.getPaperUrl();
        }
        if (string3.toLowerCase().startsWith(CLIENT_PREFIX)) {
            string3 = string3.substring(CLIENT_PREFIX.length());
        } else if (IscobolSystem.isAS() && bl) {
            File file = new File(string3);
            string3 = file.getName();
        }
        int n2 = string3.lastIndexOf(46);
        if (n2 >= 0) {
            string3 = string3.substring(0, n2);
        }
        string3 = string3 + "." + string2;
        if (bl) {
            String string4 = (String)CobolGUIJavaBean.callStaticMethod("com.iscobol.preview.Preview", "openSaveDialog", new Object[]{null, string2, string, string3});
            if (string4 != null && !string4.toUpperCase().endsWith(string2.toUpperCase())) {
                string4 = string4 + "." + string2;
            }
            return string4;
        }
        String string5 = string3;
        return string5;
    }

    @Override
    public void setLandscape(boolean bl) {
        super.setLandscape(bl);
        this.landscape = bl;
    }

    @Override
    public void setHeaderFooter(String string, String string2) {
        super.setHeaderFooter(string, string2);
        this.header = string;
        this.footer = string2;
    }

    @Override
    public void setMargins(double d2, double d3, double d4, double d5) {
        super.setMargins(d2, d3, d4, d5);
        this.leftMargin = d2;
        this.rightMargin = d3;
        this.topMargin = d4;
        this.bottomMargin = d5;
    }

    @Override
    public void setPaperSize(String string) {
        super.setPaperSize(string);
        this.paperSize = string;
    }

    @Override
    public void setCustomPaperSize(float f2, float f3) {
        super.setCustomPaperSize(f2, f3);
        this.paperSize = "Custom";
    }

    public void setExportProperty(String string, String string2) {
        this.exportProperties.setProperty(string, string2);
    }

    public String getExportProperty(String string) {
        return this.exportProperties.getProperty(string);
    }

    public static void main(String[] stringArray) throws Exception {
        ExtendedHTMLRenderer extendedHTMLRenderer = new ExtendedHTMLRenderer();
        int n2 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        float f2 = 0.0f;
        float f3 = 0.0f;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if ("-rm".equals(stringArray[n2])) {
                try {
                    d3 = Double.parseDouble(stringArray[++n2]);
                }
                catch (Exception exception) {}
                continue;
            }
            if ("-lm".equals(stringArray[n2])) {
                try {
                    d2 = Double.parseDouble(stringArray[++n2]);
                }
                catch (Exception exception) {}
                continue;
            }
            if ("-tm".equals(stringArray[n2])) {
                try {
                    d4 = Double.parseDouble(stringArray[++n2]);
                }
                catch (Exception exception) {}
                continue;
            }
            if ("-bm".equals(stringArray[n2])) {
                try {
                    d5 = Double.parseDouble(stringArray[++n2]);
                }
                catch (Exception exception) {}
                continue;
            }
            if ("-cps".equals(stringArray[n2])) {
                String string = stringArray[++n2];
                try {
                    String[] stringArray2 = string.split("\\,");
                    f2 = Float.parseFloat(stringArray2[0]);
                    f3 = Float.parseFloat(stringArray2[1]);
                }
                catch (Exception exception) {}
                continue;
            }
            arrayList.add(stringArray[n2]);
        }
        extendedHTMLRenderer.setMargins(d2, d3, d4, d5);
        if (f2 > 0.0f && f3 > 0.0f) {
            extendedHTMLRenderer.setCustomPaperSize(f2, f3);
        }
        ExtendedHTMLRenderer.run(arrayList.toArray(new String[arrayList.size()]), extendedHTMLRenderer);
    }
}

