/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.htmlexporter;

import com.iscobol.htmlexporter.HTMLNode;
import com.iscobol.htmlexporter.RptBorder;
import com.iscobol.htmlexporter.RptComponent;
import com.iscobol.htmlexporter.RptExporter;
import com.iscobol.htmlexporter.RptStyle;
import com.iscobol.htmlrenderer.CSSStyle;
import com.iscobol.htmlrenderer.SAHParser;
import com.iscobol.rts.IscobolRuntimeException;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HTMLParser {
    private final Map<String, CSSStyle> styles = new HashMap<String, CSSStyle>();
    private final Stack<HTMLNode> nodeStack = new Stack();

    public void addStyle(CSSStyle cSSStyle, RptExporter rptExporter) {
        this.styles.put(cSSStyle.getName(), cSSStyle);
        if (rptExporter != null) {
            RptStyle rptStyle = new RptStyle(cSSStyle.getName());
            this.addStyleAttributes(cSSStyle, rptStyle);
            rptExporter.addStyle(rptStyle);
        }
    }

    public CSSStyle getStyle(String string) {
        return this.styles.get(string);
    }

    public int parseStream(InputStream inputStream, final RptExporter rptExporter) {
        try {
            new SAHParser(inputStream, null).parse(new DefaultHandler(){
                String text;

                @Override
                public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                    HTMLNode hTMLNode;
                    HTMLNode hTMLNode2;
                    HTMLNode hTMLNode3 = hTMLNode2 = string2.equals("style") ? new HTMLNodeStyle() : new HTMLNode();
                    if (HTMLParser.this.nodeStack.isEmpty()) {
                        hTMLNode = null;
                    } else {
                        hTMLNode = (HTMLNode)HTMLParser.this.nodeStack.peek();
                        hTMLNode.incChildCount();
                    }
                    hTMLNode2.init(HTMLParser.this, string2, hTMLNode, attributes);
                    HTMLParser.this.nodeStack.push(hTMLNode2);
                }

                @Override
                public void endElement(String string, String string2, String string3) throws SAXException {
                    if (HTMLParser.this.nodeStack.size() > 1) {
                        HTMLNode hTMLNode = (HTMLNode)HTMLParser.this.nodeStack.pop();
                        if (hTMLNode instanceof HTMLNodeStyle) {
                            String string4 = this.text;
                            int n2 = string4.length();
                            for (int i2 = 0; i2 < n2; ++i2) {
                                char c2 = string4.charAt(i2);
                                if (c2 <= ' ') continue;
                                CSSStyle cSSStyle = new CSSStyle(string4, i2);
                                try {
                                    i2 = cSSStyle.parse();
                                    HTMLParser.this.addStyle(cSSStyle, rptExporter);
                                    continue;
                                }
                                catch (CSSStyle.BadFormatException badFormatException) {
                                    badFormatException.printStackTrace();
                                }
                            }
                        } else if (hTMLNode.getChildCount() == 0) {
                            for (int i3 = 1; i3 < HTMLParser.this.nodeStack.size(); ++i3) {
                                HTMLNode hTMLNode2 = (HTMLNode)HTMLParser.this.nodeStack.elementAt(i3);
                                if (hTMLNode2.getComponent() != null) continue;
                                hTMLNode2.cmp = i3 > 1 ? new RptComponent(((HTMLNode)HTMLParser.this.nodeStack.get(i3 - 1)).getComponent(), hTMLNode2.getName(), hTMLNode2.getChildCount()) : new RptComponent();
                                HTMLParser.this.analyze(hTMLNode2, hTMLNode2.getComponent());
                                if (i3 == 2 && hTMLNode2.getName().equals("div")) {
                                    if (rptExporter == null) continue;
                                    rptExporter.newPage();
                                    continue;
                                }
                                if (i3 == 3 && hTMLNode2.getName().equals("div")) {
                                    if (rptExporter == null) continue;
                                    hTMLNode2.getComponent().rptType = "sec";
                                    continue;
                                }
                                if (rptExporter == null) continue;
                                rptExporter.addGroupComponent(hTMLNode2.getComponent());
                            }
                            HTMLNode hTMLNode3 = (HTMLNode)HTMLParser.this.nodeStack.elementAt(HTMLParser.this.nodeStack.size() - 1);
                            hTMLNode.cmp = new RptComponent(hTMLNode3.getComponent(), hTMLNode.getName(), hTMLNode3.getChildCount());
                            HTMLParser.this.analyze(hTMLNode, hTMLNode.getComponent());
                            if (this.text != null) {
                                hTMLNode.cmp.text = this.text;
                            }
                            if (rptExporter != null) {
                                rptExporter.addComponent(hTMLNode.getComponent());
                            }
                        }
                        this.text = null;
                    } else if (HTMLParser.this.nodeStack.isEmpty()) {
                        throw new SAXException("Empty stack! " + string2);
                    }
                }

                @Override
                public void characters(char[] cArray, int n2, int n3) throws SAXException {
                    String string = new String(cArray, n2, n3).trim();
                    this.text = this.text != null ? this.text + string : string;
                }
            });
        }
        catch (IOException iOException) {
            throw new IscobolRuntimeException(iOException);
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() != null) {
                throw new IscobolRuntimeException(sAXException.getException());
            }
            throw new IscobolRuntimeException(sAXException);
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            throw new IscobolRuntimeException(iOException);
        }
        return 0;
    }

    protected void analyze(HTMLNode hTMLNode, RptComponent rptComponent) {
        CSSStyle cSSStyle;
        String string;
        Attributes attributes = hTMLNode.getAttributes();
        if (attributes != null && (string = attributes.getValue("class")) != null) {
            cSSStyle = this.getStyle(string);
            rptComponent.cssClass = string;
            String[] stringArray = rptComponent.cssClass.split("\\-");
            if (stringArray.length > 1) {
                rptComponent.rptType = stringArray[1];
            }
        }
        if (hTMLNode.getStyle() != null) {
            cSSStyle = hTMLNode.getStyle();
            this.addStyleAttributes(cSSStyle, rptComponent);
        }
        if (hTMLNode.getName().equals("a")) {
            string = attributes.getValue("href");
            if (string != null) {
                rptComponent.hyperlink = string;
            }
        } else if (hTMLNode.getName().equals("img")) {
            string = attributes.getValue("src");
            if (string != null) {
                rptComponent.imageFile = string;
            }
        } else if (hTMLNode.getName().equals("strong")) {
            rptComponent.font.bold = true;
        } else if (hTMLNode.getName().equals("em")) {
            rptComponent.font.italic = true;
        } else if (hTMLNode.getName().equals("u")) {
            rptComponent.font.underline = true;
        } else if (hTMLNode.getName().equals("input")) {
            string = attributes.getValue("type");
            if (string.equals("checkbox")) {
                rptComponent.inputType = attributes.getValue("checked") != null ? "$CheckedCheckBox$" : "$UncheckedCheckBox$";
            } else {
                string = attributes.getValue("type");
                if (string.equals("radio")) {
                    rptComponent.inputType = attributes.getValue("checked") != null ? "$CheckedRadioButton$" : "$UncheckedRadioButton$";
                }
            }
        }
    }

    private void addStyleAttributes(CSSStyle cSSStyle, RptComponent rptComponent) {
        int n2;
        Object object = cSSStyle.get("top");
        if (object != null) {
            n2 = (Integer)object;
            rptComponent.y = rptComponent.name.equals("img") ? n2 : (rptComponent.y += n2);
        }
        if ((object = cSSStyle.get("left")) != null) {
            n2 = (Integer)object;
            rptComponent.x = rptComponent.name.equals("img") ? n2 : (rptComponent.x += n2);
        }
        if ((object = cSSStyle.get("width")) != null) {
            rptComponent.width = (Integer)object;
        }
        if ((object = cSSStyle.get("height")) != null) {
            rptComponent.height = (Integer)object;
        }
        if ((object = cSSStyle.get("color")) != null) {
            rptComponent.foreground = (Color)object;
        }
        if ((object = cSSStyle.get("background-color")) != null && object != CSSStyle.TRANSPARENT_COLOR) {
            rptComponent.background = (Color)object;
        }
        if ((object = cSSStyle.get("text-align")) != null) {
            rptComponent.align = (String)object;
        }
        if ((object = cSSStyle.get("letter-spacing")) != null) {
            rptComponent.letterSpacing = (String)object;
        }
        if ((object = cSSStyle.get("position")) != null) {
            rptComponent.position = (String)object;
        }
        if ((object = cSSStyle.get("font-size")) != null) {
            rptComponent.font.size = ((CSSStyle.FontSizePt)object).getValue().floatValue();
        }
        if ((object = cSSStyle.get("font-family")) != null) {
            rptComponent.font.family = (String)object;
        }
    }

    private RptBorder getRptBorder(CSSStyle cSSStyle) {
        CSSStyle.Border border;
        RptBorder rptBorder = null;
        Object object = cSSStyle.get("border");
        if (object != null) {
            border = (CSSStyle.Border)object;
            if (rptBorder == null) {
                rptBorder = new RptBorder();
            }
            rptBorder.color = border.getColor();
            rptBorder.width = border.getDepth();
        }
        if ((object = cSSStyle.get("border-top")) != null) {
            border = (CSSStyle.Border)object;
            if (rptBorder == null) {
                rptBorder = new RptBorder();
            }
            rptBorder.color = border.getColor();
            rptBorder.width = border.getDepth();
            rptBorder.top = true;
        }
        if ((object = cSSStyle.get("border-left")) != null) {
            border = (CSSStyle.Border)object;
            if (rptBorder == null) {
                rptBorder = new RptBorder();
            }
            rptBorder.color = border.getColor();
            rptBorder.width = border.getDepth();
            rptBorder.left = true;
        }
        if ((object = cSSStyle.get("border-style")) != null) {
            object = cSSStyle.get("border-color");
            if (object != null) {
                if (rptBorder == null) {
                    rptBorder = new RptBorder(true, true, true, true);
                }
                rptBorder.color = (Color)object;
            }
            if ((object = cSSStyle.get("border-width")) != null) {
                if (rptBorder == null) {
                    rptBorder = new RptBorder(true, true, true, true);
                }
                rptBorder.width = (Integer)object;
            }
        }
        return rptBorder;
    }

    private void addStyleAttributes(CSSStyle cSSStyle, RptStyle rptStyle) {
        Object object = cSSStyle.get("top");
        if (object != null) {
            rptStyle.y = (Integer)object;
        }
        if ((object = cSSStyle.get("left")) != null) {
            rptStyle.x = (Integer)object;
        }
        if ((object = cSSStyle.get("width")) != null) {
            rptStyle.width = (Integer)object;
        }
        if ((object = cSSStyle.get("height")) != null) {
            rptStyle.height = (Integer)object;
        }
        rptStyle.border = this.getRptBorder(cSSStyle);
    }

    public Collection getStyles() {
        return this.styles.values();
    }

    private static class HTMLNodeStyle
    extends HTMLNode {
        private HTMLNodeStyle() {
        }
    }
}

