/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.htmlexporter;

import com.iscobol.htmlexporter.RptFont;
import java.awt.Color;

public class RptComponent {
    public static final int INPUT_IMG_WIDTH = 17;
    public static final int INPUT_IMG_HEIGHT = 17;
    public static final String CHECKED_CHECK_BOX = "$CheckedCheckBox$";
    public static final String CHECKED_RADIO_BUTTON = "$CheckedRadioButton$";
    public static final String UNCHECKED_CHECK_BOX = "$UncheckedCheckBox$";
    public static final String UNCHECKED_RADIO_BUTTON = "$UncheckedRadioButton$";
    public int x;
    public int y;
    public Color background;
    public Color foreground;
    public int width;
    public int height;
    public String text;
    public String imageFile;
    public String hyperlink;
    public String align;
    public String letterSpacing;
    public String position;
    public String cssClass;
    public String rptType;
    public RptFont font = new RptFont();
    public String name;
    public RptComponent parent;
    public RptComponent image;
    public String inputType;

    public RptComponent() {
    }

    public RptComponent(RptComponent rptComponent, String string, int n2) {
        this.name = string;
        this.parent = rptComponent;
        this.x = rptComponent.x;
        this.y = rptComponent.y;
        this.width = rptComponent.width;
        this.height = rptComponent.height;
        this.background = rptComponent.background;
        this.foreground = rptComponent.foreground;
        this.text = rptComponent.text;
        this.imageFile = rptComponent.imageFile;
        this.image = rptComponent.image;
        this.hyperlink = rptComponent.hyperlink;
        this.align = rptComponent.align;
        this.letterSpacing = rptComponent.letterSpacing;
        this.position = rptComponent.position;
        this.inputType = rptComponent.inputType;
        this.cssClass = rptComponent.cssClass;
        this.rptType = rptComponent.rptType;
        if (rptComponent.font != null) {
            this.font = new RptFont(rptComponent.font);
        }
    }

    public boolean isSection() {
        return this.rptType != null && this.rptType.equals("sec");
    }

    public boolean isTableComponent() {
        return this.rptType != null && this.rptType.equals("tb");
    }

    public boolean isTableCellComponent() {
        return this.rptType != null && this.rptType.startsWith("tc");
    }

    public boolean isLineComponent() {
        return this.rptType != null && this.rptType.equals("ln");
    }

    public boolean isBoxComponent() {
        return this.rptType != null && this.rptType.equals("bx");
    }

    public boolean isImageComponent() {
        return this.rptType != null && this.rptType.startsWith("im");
    }

    public boolean equalTo(RptComponent rptComponent) {
        return RptComponent.equal(this.cssClass, rptComponent.cssClass) && RptComponent.equal(this.text, rptComponent.text) && RptComponent.equal(this.background, rptComponent.background) && RptComponent.equal(this.foreground, rptComponent.foreground) && RptComponent.equal(this.imageFile, rptComponent.imageFile) && RptComponent.equal(this.hyperlink, rptComponent.hyperlink);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<" + this.name + " class='" + this.cssClass + "',rptType='" + this.rptType + "',x='" + this.x + "',y='" + this.y + "',width='" + this.width + "',height='" + this.height + "'");
        stringBuilder.append(",fontFamily='" + this.font.family + "'");
        stringBuilder.append(",fontSize='" + this.font.size + "'");
        stringBuilder.append(",fontBold='" + this.font.bold + "'");
        stringBuilder.append(",fontItalic='" + this.font.italic + "'");
        stringBuilder.append(",fontUnderline='" + this.font.underline + "'");
        if (this.background != null) {
            stringBuilder.append(",background='" + Integer.toHexString(this.background.getRGB()) + "'");
        }
        if (this.foreground != null) {
            stringBuilder.append(",foreground='" + Integer.toHexString(this.foreground.getRGB()) + "'");
        }
        if (this.align != null) {
            stringBuilder.append(",align='" + this.align + "'");
        }
        if (this.hyperlink != null) {
            stringBuilder.append(",hyperlink='" + this.hyperlink + "'");
        }
        if (this.image != null) {
            stringBuilder.append(",image='" + this.image + "'");
        }
        if (this.inputType != null) {
            stringBuilder.append(",input='" + this.inputType + "'");
        }
        if (this.text != null) {
            stringBuilder.append(",text='" + this.text + "'");
        }
        stringBuilder.append("/>");
        return stringBuilder.toString();
    }

    private static boolean equal(Object object, Object object2) {
        if (object != null) {
            if (object2 != null) {
                return object.equals(object2);
            }
            return false;
        }
        return object2 == null;
    }
}

