/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.htmlexporter;

import com.iscobol.htmlexporter.RptBorder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RptStyle {
    private static final Pattern RPT_STYLE_PTN = Pattern.compile("(([a-z]+)\\d+)\\-([a-z]+)\\-(.+)");
    private String name;
    private String baseName;
    private String sectionId;
    private String sectionType;
    private String type;
    private String parentName;
    public int x;
    public int y;
    public int width;
    public int height;
    public RptBorder border;
    public Object customData;

    public RptStyle(RptStyle rptStyle) {
        this.name = rptStyle.name;
        this.baseName = rptStyle.baseName;
        this.sectionId = rptStyle.sectionId;
        this.sectionType = rptStyle.sectionType;
        this.type = rptStyle.type;
        this.parentName = rptStyle.parentName;
        this.x = rptStyle.x;
        this.y = rptStyle.y;
        this.width = rptStyle.width;
        this.height = rptStyle.height;
        if (rptStyle.border != null) {
            this.border = new RptBorder(rptStyle.border);
        }
    }

    public RptStyle(String string) {
        this.name = string;
        Matcher matcher = RPT_STYLE_PTN.matcher(string);
        if (matcher.find()) {
            this.sectionType = matcher.group(2);
            this.sectionId = matcher.group(1);
            this.type = matcher.group(3);
            this.baseName = matcher.group(4);
            if (this.type.startsWith("tc") || this.type.equals("imc")) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.sectionId);
                stringBuilder.append("-");
                if (this.type.equals("tc")) {
                    stringBuilder.append("tb");
                } else if (this.type.startsWith("tc")) {
                    stringBuilder.append(this.type.substring(0, this.type.length() - 1));
                } else {
                    stringBuilder.append("im");
                }
                stringBuilder.append("-");
                stringBuilder.append(this.baseName.substring(0, this.baseName.lastIndexOf(45)));
                this.parentName = stringBuilder.toString();
            }
        }
    }

    public boolean isTableComponent() {
        return this.type != null && this.type.equals("tb");
    }

    public boolean isTableCellComponent() {
        return this.type != null && this.type.startsWith("tc");
    }

    public boolean isBoxComponent() {
        return this.type != null && this.type.equals("bx");
    }

    public boolean isLineComponent() {
        return this.type != null && this.type.equals("ln");
    }

    public boolean isImageComponent() {
        return this.type != null && this.type.equals("im");
    }

    public String getName() {
        return this.name;
    }

    public String getParentName() {
        return this.parentName;
    }

    public void setParentName(String string) {
        this.parentName = string;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getSectionId() {
        return this.sectionId;
    }

    public String getSectionType() {
        return this.sectionType;
    }

    public String toString() {
        return this.name;
    }

    public String getBaseName() {
        return this.baseName;
    }
}

