/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.htmlexporter.ss;

import com.iscobol.htmlexporter.HTMLParser;
import com.iscobol.htmlexporter.RptBorder;
import com.iscobol.htmlexporter.RptComponent;
import com.iscobol.htmlexporter.RptExporter;
import com.iscobol.htmlexporter.RptFont;
import com.iscobol.htmlexporter.RptStyle;
import com.iscobol.htmlrenderer.CheckBoxImage;
import com.iscobol.htmlrenderer.HTMLRenderer;
import com.iscobol.htmlrenderer.RadioButtonImage;
import com.iscobol.htmlrenderer.UncheckBoxImage;
import com.iscobol.htmlrenderer.UnradioButtonImage;
import com.iscobol.misc.export.UnitConverter;
import com.iscobol.misc.export.ss.SSExportHelper;
import com.iscobol.rts.Config;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;

public abstract class SSExporter
implements RptExporter {
    private static final String PROP_PREFIX = "iscobol.export.";
    private static final int MAX_ROW_BREAKS_PER_SHEET = 1024;
    private static final byte EMPTY = 0;
    private static final byte OCCUPIED_BY_COMPONENT = 1;
    private static final byte COLLAPSABLE = 2;
    private static final byte OCCUPIED_BY_BOX = 3;
    private static final int NONE = 0;
    private static final int COLLAPSE_BOX = 1;
    private static final int COLLAPSE_ALL = 2;
    private final Map<String, Integer> IMAGES = new HashMap<String, Integer>();
    private final Map<String, CellStyle> CELL_STYLES = new TreeMap<String, CellStyle>();
    private double topMargin;
    private double leftMargin;
    private double rightMargin;
    private double bottomMargin;
    private String paperSize;
    private boolean landscape;
    private List<Integer> columnOffsets = new ArrayList<Integer>();
    private Map<String, RptSection> sections = new LinkedHashMap<String, RptSection>();
    private Map<String, RptStyle> allStyles = new LinkedHashMap<String, RptStyle>();
    protected int pageCount;
    private HTMLParser hr;
    private String inputFile;
    protected String outputFile;
    private String reportName;
    protected CreationHelper creationHelper;
    protected List<Drawing> patriarchs = new ArrayList<Drawing>();
    private CellStyle defaultCellStyle;
    protected int currentRowIndex;
    protected Properties properties = new Properties();
    protected boolean cellWrap;
    protected boolean cellLock;
    protected boolean detectCellType;
    protected boolean ignoreCellBackground;
    protected boolean ignoreCellBorder;
    protected boolean ignoreImages;
    protected boolean collapseRowSpan;
    protected int removeRowsSpace;
    protected int removeColumnsSpace;
    protected boolean whitePageBackground;
    protected boolean freezePageHeader;
    protected boolean addPageBreaks;
    protected String cellNumericFormat;
    private boolean pageHeaderFound;
    private RptSection lastSection;
    private RptSection lastPageHeaderSection;
    private int currTopOffset;
    private StringBuilder visibleComponents;
    protected SSExportHelper exportHelper;
    protected List<Integer> sheetLastRowIndexes = new ArrayList<Integer>();

    public SSExporter(String string, String string2, String string3) {
        this.reportName = string;
        this.inputFile = string2;
        this.outputFile = string3;
    }

    @Override
    public double getTopMargin() {
        return this.topMargin;
    }

    @Override
    public double getLeftMargin() {
        return this.leftMargin;
    }

    @Override
    public double getBottomMargin() {
        return 0.0;
    }

    @Override
    public double getRightMargin() {
        return 0.0;
    }

    @Override
    public boolean isLandscape() {
        return false;
    }

    @Override
    public String getPaperSize() {
        return this.paperSize;
    }

    public int getSheetLineCount() {
        int n2 = 0;
        Workbook workbook = this.exportHelper.getWorkbook();
        for (int i2 = 0; i2 < workbook.getNumberOfSheets(); ++i2) {
            n2 += workbook.getSheetAt(i2).getLastRowNum() + 1;
        }
        return n2;
    }

    public int getSheetColumnCount() {
        int n2 = this.columnOffsets.size();
        if (n2 > 0 && this.columnOffsets.get(0) == 0) {
            --n2;
        }
        return n2;
    }

    public int getSheetImageCount() {
        return this.IMAGES.size();
    }

    public int getSheetFontCount() {
        return this.exportHelper.getFontCount();
    }

    public int getSheetCellStyleCount() {
        return this.CELL_STYLES.size();
    }

    public String getInputFile() {
        return this.inputFile;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public int getSheetColorCount() {
        return this.exportHelper.getSheetColorCount();
    }

    protected void log() {
        System.out.println("image count = " + this.getSheetImageCount() + ", font count = " + this.getSheetFontCount() + ", color count = " + this.getSheetColorCount() + ", cell style count = " + this.getSheetCellStyleCount() + ", column count = " + this.getSheetColumnCount() + ", line count = " + this.getSheetLineCount());
    }

    protected long log(String string, long l2) {
        long l3 = System.currentTimeMillis();
        System.out.println(string + " time = " + (l3 - l2));
        return l3;
    }

    protected abstract SSExportHelper createExportHelper();

    private void initializeReport() {
        this.currentRowIndex = 0;
        this.pageHeaderFound = false;
        this.lastSection = null;
        this.cellWrap = this.getExportProperty("excel.cell_wrap_text", true);
        this.cellLock = this.getExportProperty("excel.cell_locked", true);
        this.detectCellType = this.getExportProperty("excel.detect_cell_type", true);
        this.cellNumericFormat = this.getExportProperty("excel.cell_numeric_format", null);
        this.ignoreCellBackground = this.getExportProperty("excel.cell_ignore_background", false);
        this.ignoreCellBorder = this.getExportProperty("excel.cell_ignore_border", false);
        this.ignoreImages = this.getExportProperty("excel.ignore_images", false);
        this.collapseRowSpan = this.getExportProperty("excel.collapse_row_span", false);
        this.removeRowsSpace = this.getExportProperty("excel.remove_rows_space", 0);
        this.removeRowsSpace = Math.min(1, this.removeRowsSpace);
        this.removeColumnsSpace = this.getExportProperty("excel.remove_columns_space", 0);
        this.whitePageBackground = this.getExportProperty("excel.whitepage_background", true);
        this.freezePageHeader = this.getExportProperty("excel.freeze_page_header", false);
        this.addPageBreaks = this.getExportProperty("excel.force_page_breaks", true);
        this.exportHelper = this.createExportHelper();
        this.creationHelper = this.exportHelper.getWorkbook().getCreationHelper();
        this.defaultCellStyle = this.exportHelper.getWorkbook().createCellStyle();
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (RptSection object : this.sections.values()) {
            TreeSet<Integer> treeSet2 = new TreeSet<Integer>();
            this.initTables(object.styles.values(), treeSet, treeSet2, false);
            object.lineOffsets = new ArrayList<Integer>(treeSet2);
        }
        this.columnOffsets = new ArrayList<Integer>(treeSet);
        int n2 = this.columnOffsets.size();
        if (this.columnOffsets.size() > 0 && this.columnOffsets.get(0) == 0) {
            --n2;
        }
        for (RptSection rptSection : this.sections.values()) {
            int n3 = rptSection.lineOffsets.size();
            if (rptSection.lineOffsets.size() > 0 && rptSection.lineOffsets.get(0) == 0) {
                --n3;
            }
            rptSection.occupiedCells = new byte[n3][n2];
            if (!this.collapseRowSpan && this.removeRowsSpace == 0 && this.removeColumnsSpace == 0 && !this.whitePageBackground) continue;
            for (RptStyle rptStyle : rptSection.styles.values()) {
                this.draw(null, true, rptStyle, rptSection, this.columnOffsets, null);
            }
        }
        if (this.removeColumnsSpace != 0) {
            this.removeUnusedColumns(n2);
        }
        this.createSheet(this.reportName);
    }

    protected Sheet createSheet(String string) {
        Sheet sheet = this.exportHelper.createSheet(string);
        if (this.sheetLastRowIndexes.size() == 0) {
            this.sheetLastRowIndexes.add(new Integer(this.exportHelper.getMaxRowsPerSheet() - 1));
        } else {
            this.sheetLastRowIndexes.add(new Integer(this.sheetLastRowIndexes.get(this.sheetLastRowIndexes.size() - 1) + this.exportHelper.getMaxRowsPerSheet()));
        }
        PrintSetup printSetup = sheet.getPrintSetup();
        this.setPaperSize(printSetup);
        printSetup.setLandscape(this.landscape);
        sheet.setMargin((short)1, this.rightMargin);
        sheet.setMargin((short)0, this.leftMargin);
        sheet.setMargin((short)2, this.topMargin);
        sheet.setMargin((short)3, this.bottomMargin);
        printSetup.setScale((short)75);
        Drawing drawing = sheet.createDrawingPatriarch();
        this.patriarchs.add(drawing);
        int n2 = 0;
        int n3 = 0;
        int n4 = this.columnOffsets.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = this.columnOffsets.get(i2);
            if (n5 > n3) {
                sheet.setColumnWidth(n2, UnitConverter.pixel2ExcelWidthUnits(n5 - n3));
                ++n2;
            }
            n3 = n5;
        }
        return sheet;
    }

    private void initSection(RptSection rptSection, int n2) {
        rptSection.topOffset = n2;
        rptSection.pageIndex = this.pageCount;
        rptSection.rowOffset = this.currentRowIndex;
        rptSection.components = new ArrayList<RptComponent>();
    }

    @Override
    public void export() throws IOException {
        this.hr = new HTMLParser();
        InputStream inputStream = HTMLRenderer.getInputStream(this.inputFile);
        this.hr.parseStream(inputStream, this);
        if (this.lastSection != null) {
            this.drawSection(this.lastSection);
        }
        this.exportHelper.write(this.outputFile);
    }

    protected void setPaperSize(PrintSetup printSetup) {
        String string = this.getPaperSize();
        int n2 = string == null ? 0 : (string.equals("Letter") ? 1 : (string.equals("Letter small") ? 2 : (string.equals("Tabloid") ? 3 : (string.equals("Ledger") ? 4 : (string.equals("Legal") ? 5 : (string.equals("Statement") ? 6 : (string.equals("Executive") ? 7 : (string.equals("A3") ? 8 : (string.equals("A4") ? 9 : (string.equals("A4 small") ? 10 : (string.equals("A5") ? 11 : (string.equals("B4") ? 12 : (string.equals("B5") ? 13 : (string.equals("Folio") ? 14 : (string.equals("Quarto") ? 15 : (string.equals("10x14") ? 16 : (string.equals("11x17") ? 17 : (string.equals("Note") ? 18 : (string.equals("Envelope #9") ? 19 : (string.equals("Envelope #10") ? 20 : (string.equals("Envelope C3") ? 29 : (string.equals("Envelope C4") ? 30 : (string.equals("Envelope C5") ? 28 : (string.equals("Envelope C6") ? 31 : (string.equals("Envelope C65") ? 28 : (string.equals("Envelope Dl") ? 27 : (string.equals("Envelope Monarch") ? 37 : 0)))))))))))))))))))))))))));
        printSetup.setPaperSize((short)n2);
    }

    @Override
    public void dispose() {
        this.IMAGES.clear();
        this.CELL_STYLES.clear();
        this.sections.clear();
        this.topMargin = 0.0;
        this.leftMargin = 0.0;
        this.columnOffsets = new ArrayList<Integer>();
        this.hr = null;
        this.exportHelper.dispose();
        this.exportHelper = null;
        this.patriarchs.clear();
        this.defaultCellStyle = null;
        this.creationHelper = null;
        this.sheetLastRowIndexes = new ArrayList<Integer>();
        this.lastSection = null;
        this.lastPageHeaderSection = null;
    }

    private void setWhitePageBackground(RptSection rptSection) {
        if (this.whitePageBackground) {
            for (int i2 = 0; i2 < rptSection.occupiedCells.length; ++i2) {
                for (int i3 = 0; i3 < rptSection.occupiedCells[i2].length; ++i3) {
                    if (rptSection.occupiedCells[i2][i3] != 0) continue;
                    this.setBorderedCellStyle(i2 + rptSection.rowOffset, i3, false, false, false, false, 0, null, Color.white);
                }
            }
        }
    }

    private void adjustRowsHeights(RptSection rptSection, TreeMap<Integer, Integer> treeMap) {
        for (Integer n2 : treeMap.keySet()) {
            int n3 = rptSection.lineOffsets.get(n2);
            int n4 = rptSection.lineOffsets.get(n2 + 1) - n3;
            int n5 = treeMap.get(n2);
            int n6 = n5 - n4;
            for (RptStyle rptStyle : rptSection.currStyles.values()) {
                if (rptStyle.y < n3) {
                    if (rptStyle.y + rptStyle.height <= n3) continue;
                    rptStyle.height += n6;
                    continue;
                }
                if (rptStyle.y == n3) {
                    rptStyle.height = n5;
                    continue;
                }
                rptStyle.y += n6;
            }
            for (int i2 = n2 + 1; i2 < rptSection.lineOffsets.size(); ++i2) {
                rptSection.lineOffsets.set(i2, new Integer(rptSection.lineOffsets.get(i2) + n6));
            }
        }
    }

    private void removeUnusedColumns(int n2) {
        int n3;
        byte[] byArray = new byte[n2];
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            for (RptSection rptSection : this.sections.values()) {
                block12: for (n3 = 0; n3 < rptSection.occupiedCells.length && byArray[i2] != 1; ++n3) {
                    switch (rptSection.occupiedCells[n3][i2]) {
                        case 0: {
                            continue block12;
                        }
                        case 2: {
                            if (byArray[i2] != 0) continue block12;
                            byArray[i2] = 2;
                            continue block12;
                        }
                        case 1: {
                            byArray[i2] = 1;
                        }
                    }
                }
            }
            if (byArray[i2] == 1) continue;
            ++n4;
        }
        if (n4 > 0) {
            HashMap<RptSection, byte[][]> hashMap = new HashMap<RptSection, byte[][]>();
            for (RptSection rptSection : this.sections.values()) {
                hashMap.put(rptSection, rptSection.occupiedCells);
                rptSection.occupiedCells = new byte[rptSection.occupiedCells.length][n2 - n4];
            }
            if (this.columnOffsets.get(0) == 0) {
                this.columnOffsets.remove(0);
            }
            int n5 = 0;
            int n6 = 0;
            n3 = 0;
            boolean bl = false;
            for (int i3 = 0; i3 < n2; ++i3) {
                int n7 = i3 - n5;
                int n8 = this.columnOffsets.get(n7);
                this.columnOffsets.set(n7, n8 - n3);
                switch (byArray[i3]) {
                    case 0: {
                        Object object;
                        this.columnOffsets.remove(n7);
                        for (RptSection rptSection : this.sections.values()) {
                            object = rptSection.styles.values().iterator();
                            while (object.hasNext()) {
                                RptStyle rptStyle = (RptStyle)object.next();
                                if (rptStyle.x + n3 >= n8) {
                                    rptStyle.x -= n8 - n6;
                                }
                                if (rptStyle.x == 0) {
                                    bl = true;
                                }
                                RptStyleInfo rptStyleInfo = (RptStyleInfo)rptStyle.customData;
                                if (!rptStyleInfo.isFrameOrLine || rptStyleInfo.excelRC == null || i3 < rptStyleInfo.excelRC.x || i3 > rptStyleInfo.excelRC.width) continue;
                                rptStyle.width -= n8 - n6;
                            }
                        }
                        ++n5;
                        n3 += n8 - n6;
                        break;
                    }
                    case 2: {
                        Object object;
                        this.columnOffsets.remove(n7);
                        for (RptSection rptSection : this.sections.values()) {
                            object = rptSection.styles.values().iterator();
                            while (object.hasNext()) {
                                RptStyle rptStyle = (RptStyle)object.next();
                                if (rptStyle.x + n3 == n8) {
                                    if (rptStyle.width > 0) {
                                        if (n7 > 0) {
                                            int n9 = rptStyle.x;
                                            rptStyle.x = this.columnOffsets.get(n7 - 1);
                                            rptStyle.width += n9 - rptStyle.x;
                                        }
                                    } else if (n7 < this.columnOffsets.size()) {
                                        rptStyle.x = this.columnOffsets.get(n7) - n3;
                                    }
                                }
                                if (rptStyle.x != 0) continue;
                                bl = true;
                            }
                        }
                        ++n5;
                        break;
                    }
                    case 1: {
                        Object object;
                        for (RptSection rptSection : this.sections.values()) {
                            object = (byte[][])hashMap.get(rptSection);
                            for (int i4 = 0; i4 < ((byte[][])object).length; ++i4) {
                                rptSection.occupiedCells[i4][n7] = (byte)object[i4][i3];
                            }
                        }
                        break;
                    }
                }
                n6 = n8;
            }
            if (bl) {
                this.columnOffsets.add(0, 0);
            }
        }
    }

    private void removeUnusedRows(RptSection rptSection) {
        int n2;
        byte[] byArray = new byte[rptSection.occupiedCells.length];
        int n3 = 0;
        for (int i2 = 0; i2 < rptSection.occupiedCells.length; ++i2) {
            block10: for (n2 = 0; n2 < rptSection.occupiedCells[i2].length && byArray[i2] != 1; ++n2) {
                switch (rptSection.occupiedCells[i2][n2]) {
                    case 0: {
                        continue block10;
                    }
                    case 1: 
                    case 2: {
                        byArray[i2] = 1;
                    }
                }
            }
            if (byArray[i2] != 0) continue;
            ++n3;
        }
        if (n3 > 0) {
            if (rptSection.lineOffsets.get(0) == 0) {
                rptSection.lineOffsets.remove(0);
            }
            byte[][] byArray2 = rptSection.occupiedCells;
            n2 = byArray2[0].length;
            rptSection.occupiedCells = new byte[byArray2.length - n3][n2];
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            boolean bl = false;
            int n7 = rptSection.lineOffsets.size();
            for (int i3 = 0; i3 < n7; ++i3) {
                int n8 = i3 - n4;
                int n9 = rptSection.lineOffsets.get(n8);
                rptSection.lineOffsets.set(n8, n9 - n6);
                switch (byArray[i3]) {
                    case 0: {
                        rptSection.lineOffsets.remove(n8);
                        for (RptStyle rptStyle : rptSection.currStyles.values()) {
                            if (rptStyle.y + n6 >= n9) {
                                rptStyle.y -= n9 - n5;
                            }
                            if (rptStyle.y == 0) {
                                bl = true;
                            }
                            RptStyleInfo rptStyleInfo = (RptStyleInfo)rptStyle.customData;
                            if (!rptStyleInfo.isFrameOrLine || rptStyleInfo.excelRC == null || i3 < rptStyleInfo.excelRC.y || i3 > rptStyleInfo.excelRC.height) continue;
                            rptStyle.height -= n9 - n5;
                        }
                        ++n4;
                        n6 += n9 - n5;
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 1: {
                        for (int i4 = 0; i4 < n2; ++i4) {
                            rptSection.occupiedCells[n8][i4] = byArray2[i3][i4];
                        }
                        break;
                    }
                }
                n5 = n9;
            }
            if (bl) {
                rptSection.lineOffsets.add(0, 0);
            }
        }
    }

    private boolean addMergedRegion(int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = this.getSheetIndex(n2);
        if (n7 < (n6 = this.getSheetIndex(n3)) && n2 == (n3 = this.sheetLastRowIndexes.get(n7).intValue()) && n4 == n5) {
            return false;
        }
        this.exportHelper.addMergedRegion(this.getSheet(n2), this.getSheetRelativeRowIndex(n2, n7), this.getSheetRelativeRowIndex(n3, n7), n4, n5);
        return true;
    }

    private void initTables(Collection<RptStyle> collection, TreeSet<Integer> treeSet, TreeSet<Integer> treeSet2, boolean bl) {
        for (RptStyle rptStyle : collection) {
            if (treeSet != null) {
                treeSet.add(rptStyle.x);
                treeSet.add(rptStyle.x + rptStyle.width);
            }
            if (treeSet2 == null) continue;
            RptStyleInfo rptStyleInfo = (RptStyleInfo)rptStyle.customData;
            if (bl && rptStyleInfo != null) {
                if (rptStyleInfo.discarded) continue;
                if (!rptStyleInfo.isFrame) {
                    rptStyle.x += rptStyleInfo.adjustBounds.x;
                    rptStyle.y += rptStyleInfo.adjustBounds.y;
                    rptStyle.width += rptStyleInfo.adjustBounds.width;
                    rptStyle.height += rptStyleInfo.adjustBounds.height;
                    if (!(rptStyle.width > 0 && rptStyle.height > 0 || rptStyle.isLineComponent())) {
                        rptStyleInfo.discarded = true;
                        continue;
                    }
                }
            }
            treeSet2.add(rptStyle.y);
            treeSet2.add(rptStyle.y + rptStyle.height);
        }
    }

    private void checkComponentIntersections(RptStyle[] rptStyleArray) {
        for (int i2 = 0; i2 < rptStyleArray.length; ++i2) {
            RptStyle rptStyle = rptStyleArray[i2];
            RptStyleInfo rptStyleInfo = (RptStyleInfo)rptStyle.customData;
            if (rptStyleInfo.isFrameOrLine) continue;
            Rectangle rectangle = new Rectangle(rptStyle.x, rptStyle.y, rptStyle.width, rptStyle.height);
            for (int i3 = i2 + 1; i3 < rptStyleArray.length; ++i3) {
                Rectangle rectangle2;
                RptStyle rptStyle2 = rptStyleArray[i3];
                RptStyleInfo rptStyleInfo2 = (RptStyleInfo)rptStyle2.customData;
                if (rptStyleInfo2.isFrameOrLine || rectangle.intersection(rectangle2 = new Rectangle(rptStyle2.x, rptStyle2.y, rptStyle2.width, rptStyle2.height)).isEmpty()) continue;
                Rectangle rectangle3 = new Rectangle();
                if (rectangle.x <= rectangle2.x) {
                    if (rectangle.x + rectangle.width - rectangle2.x - rectangle2.width > rectangle2.x + rectangle2.width - rectangle.x) {
                        rectangle3.x = rectangle3.width = rectangle2.x + rectangle2.width - rectangle.x;
                    } else {
                        rectangle3.width = rectangle.x + rectangle.width - rectangle2.x;
                    }
                } else {
                    rectangle3.x = rectangle3.width = rectangle2.x + rectangle2.width - rectangle.x;
                }
                if (rectangle.y <= rectangle2.y) {
                    if (rectangle.y + rectangle.height - rectangle2.y - rectangle2.height > rectangle2.y + rectangle2.height - rectangle.y) {
                        rectangle3.y = rectangle3.height = rectangle2.y + rectangle2.height - rectangle.y;
                    } else {
                        rectangle3.height = rectangle.y + rectangle.height - rectangle2.y;
                    }
                } else {
                    rectangle3.y = rectangle3.height = rectangle2.y + rectangle2.height - rectangle.y;
                }
                if (rectangle3.width >= rectangle.width || rectangle3.width * rectangle.height > rectangle3.height * rectangle.width) {
                    rptStyleInfo.adjustBounds.height = Math.min(rptStyleInfo.adjustBounds.height, -rectangle3.height);
                    rptStyleInfo.adjustBounds.y = Math.max(rptStyleInfo.adjustBounds.y, rectangle3.y);
                    continue;
                }
                rptStyleInfo.adjustBounds.width = Math.min(rptStyleInfo.adjustBounds.width, -rectangle3.width);
                rptStyleInfo.adjustBounds.x = Math.max(rptStyleInfo.adjustBounds.x, rectangle3.x);
            }
        }
    }

    protected Cell getCell(int n2, int n3) {
        return this.getRow(n2).getCell(n3);
    }

    protected Row getRow(int n2) {
        int[] nArray = new int[1];
        Sheet sheet = this.getSheet(n2, nArray);
        return sheet.getRow(this.getSheetRelativeRowIndex(n2, nArray[0]));
    }

    private void draw(RptComponent rptComponent, boolean bl, RptStyle rptStyle, RptSection rptSection, List<Integer> list, Map<Integer, Integer> map) {
        int n2;
        int n3;
        int n4;
        int n5 = rptSection.rowOffset;
        RptStyleInfo rptStyleInfo = (RptStyleInfo)rptStyle.customData;
        if (rptStyleInfo.discarded || bl && rptStyleInfo.discarded2 || map != null && rptStyleInfo.isFrameOrLine) {
            return;
        }
        int n6 = -1;
        int n7 = -1;
        int n8 = rptSection.lineOffsets.get(0) > 0 ? 1 : 0;
        int n9 = rptSection.lineOffsets.size();
        for (n4 = 0; n4 < n9; ++n4) {
            n3 = rptSection.lineOffsets.get(n4);
            if (n3 == rptStyle.y) {
                n6 = n4 + n8 + n5;
                if (!rptStyle.isLineComponent() || rptStyle.width <= rptStyle.height) continue;
                break;
            }
            if (n3 != rptStyle.y + rptStyle.height) continue;
            n7 = n4 - 1 + n8 + n5;
            break;
        }
        if (map != null) {
            Integer n10;
            Integer n11;
            if (n7 > n6 && ((n11 = map.get(n10 = Integer.valueOf(n6 - n8))) == null || n11 < rptStyle.height)) {
                map.put(n10, rptStyle.height);
            }
            return;
        }
        n4 = -1;
        int n12 = -1;
        int n13 = list.get(0) > 0 ? 1 : 0;
        int n14 = list.size();
        for (n2 = 0; n2 < n14; ++n2) {
            n3 = list.get(n2);
            if (n3 == rptStyle.x) {
                n4 = n2 + n13;
                if (!rptStyle.isLineComponent() || rptStyle.height <= rptStyle.width) continue;
                break;
            }
            if (n3 != rptStyle.x + rptStyle.width) continue;
            n12 = n2 - 1 + n13;
            break;
        }
        if (rptStyleInfo != null && rptStyleInfo.isFrameOrLine) {
            if (bl) {
                rptStyleInfo.excelRC = new Rectangle(n4, n6, n12, n7);
            } else if (rptStyle.isLineComponent()) {
                if (rptStyle.border != null && !this.ignoreCellBorder) {
                    Color color;
                    n2 = rptStyle.border.width;
                    Color color2 = color = rptStyle.border.color != null ? rptStyle.border.color : rptComponent.foreground;
                    if (rptStyle.height > rptStyle.width) {
                        boolean bl2 = true;
                        int n15 = n4;
                        if (n15 > 0) {
                            --n15;
                        } else {
                            bl2 = false;
                        }
                        block14: for (int i2 = n6; i2 <= n7; ++i2) {
                            switch (rptSection.occupiedCells[i2 - n5][n15]) {
                                case 0: {
                                    Color color3 = this.whitePageBackground ? Color.white : null;
                                    this.setBorderedCellStyle(i2, n15, false, false, !bl2, bl2, n2, color, color3);
                                    rptSection.occupiedCells[i2 - n5][n15] = 3;
                                    continue block14;
                                }
                                case 3: {
                                    Color color3;
                                    Cell cell = this.getCell(i2, n15);
                                    CellStyle cellStyle = cell.getCellStyle();
                                    if (this.ignoreCellBackground) {
                                        color3 = this.whitePageBackground ? Color.white : null;
                                    } else {
                                        color3 = this.exportHelper.getBackgroundColor(cellStyle);
                                        if (color3 == null && this.whitePageBackground) {
                                            color3 = Color.white;
                                        }
                                    }
                                    this.setBorderedCellStyle(i2, n15, cellStyle.getBorderTopEnum() != BorderStyle.NONE, cellStyle.getBorderBottomEnum() != BorderStyle.NONE, !bl2 || cellStyle.getBorderLeftEnum() != BorderStyle.NONE, bl2 || cellStyle.getBorderRightEnum() != BorderStyle.NONE, n2, color, color3);
                                }
                            }
                        }
                    } else {
                        boolean bl3 = true;
                        int n16 = n6;
                        if (n16 - n5 > 0) {
                            --n16;
                        } else {
                            bl3 = false;
                        }
                        block15: for (int i3 = n4; i3 <= n12; ++i3) {
                            switch (rptSection.occupiedCells[n16 - n5][i3]) {
                                case 0: {
                                    Color color4 = this.whitePageBackground ? Color.white : null;
                                    this.setBorderedCellStyle(n16, i3, !bl3, bl3, false, false, n2, color, color4);
                                    rptSection.occupiedCells[n16 - n5][i3] = 3;
                                    continue block15;
                                }
                                case 3: {
                                    Color color4;
                                    Cell cell = this.getCell(n16, i3);
                                    CellStyle cellStyle = cell.getCellStyle();
                                    if (this.ignoreCellBackground) {
                                        color4 = this.whitePageBackground ? Color.white : null;
                                    } else {
                                        color4 = this.exportHelper.getBackgroundColor(cellStyle);
                                        if (color4 == null && this.whitePageBackground) {
                                            color4 = Color.white;
                                        }
                                    }
                                    this.setBorderedCellStyle(n16, i3, !bl3 || cellStyle.getBorderTopEnum() != BorderStyle.NONE, bl3 || cellStyle.getBorderBottomEnum() != BorderStyle.NONE, cellStyle.getBorderLeftEnum() != BorderStyle.NONE, cellStyle.getBorderRightEnum() != BorderStyle.NONE, n2, color, color4);
                                }
                            }
                        }
                    }
                }
            } else {
                Color color;
                if (rptStyle.border != null && !this.ignoreCellBorder) {
                    n2 = rptStyle.border.width;
                    color = rptStyle.border.color != null ? rptStyle.border.color : rptComponent.foreground;
                } else {
                    n2 = 0;
                    color = null;
                }
                Color color5 = this.ignoreCellBackground ? (this.whitePageBackground ? Color.white : null) : (rptComponent.background != null ? rptComponent.background : (this.whitePageBackground ? Color.white : null));
                if (color != null || color5 != null) {
                    for (int i4 = n6; i4 <= n7; ++i4) {
                        block17: for (int i5 = n4; i5 <= n12; ++i5) {
                            switch (rptSection.occupiedCells[i4 - n5][i5]) {
                                case 0: {
                                    this.setBorderedCellStyle(i4, i5, i4 == n6, i4 == n7, i5 == n4, i5 == n12, n2, color, color5);
                                    rptSection.occupiedCells[i4 - n5][i5] = 3;
                                    continue block17;
                                }
                                case 3: {
                                    Cell cell = this.getCell(i4, i5);
                                    CellStyle cellStyle = cell.getCellStyle();
                                    this.setBorderedCellStyle(i4, i5, cellStyle.getBorderTopEnum() != BorderStyle.NONE || i4 == n6, cellStyle.getBorderBottomEnum() != BorderStyle.NONE || i4 == n7, cellStyle.getBorderLeftEnum() != BorderStyle.NONE || i5 == n4, cellStyle.getBorderRightEnum() != BorderStyle.NONE || i5 == n12, n2, color, color5);
                                }
                            }
                        }
                    }
                }
            }
        } else {
            if (bl && (this.removeRowsSpace == 2 || this.removeColumnsSpace == 2)) {
                rptStyleInfo.excelRC = new Rectangle(n4, n6, n12, n7);
            }
            if (bl) {
                n2 = this.removeColumnsSpace == 2 ? 1 : 0;
                for (int i6 = n6; i6 <= n7; ++i6) {
                    for (int i7 = n4; i7 <= n12; ++i7) {
                        rptSection.occupiedCells[i6 - n5][i7] = i7 > n4 && i7 < n12 && n2 != 0 ? 2 : 1;
                    }
                }
            } else {
                for (n2 = n6; n2 <= n7; ++n2) {
                    for (int i8 = n4; i8 <= n12; ++i8) {
                        rptSection.occupiedCells[n2 - n5][i8] = 1;
                    }
                }
                int n17 = n2 = n7 > n6 || n12 > n4 ? 1 : 0;
                if (n2 != 0) {
                    n2 = this.addMergedRegion(n6, n7, n4, n12) ? 1 : 0;
                }
                Row row = this.getRow(n6);
                Cell cell = row.createCell(n4);
                int n18 = 0;
                Double d2 = null;
                if (rptComponent.text != null && this.detectCellType && (d2 = this.exportHelper.getNumericValue(rptComponent.text)) != null) {
                    n18 = this.exportHelper.getNumericType(rptComponent.text);
                }
                CellStyle cellStyle = this.getCellStyle(rptComponent, rptStyle, n18);
                cell.setCellStyle(cellStyle);
                if (rptStyle.border != null && !this.ignoreCellBorder && n2 != 0) {
                    int n19 = rptStyle.border.width;
                    Color color = rptStyle.border.color != null ? rptStyle.border.color : rptComponent.foreground;
                    for (int i9 = n6; i9 <= n7; ++i9) {
                        for (int i10 = n4; i10 <= n12; ++i10) {
                            if (i9 <= n6 && i10 <= n4) continue;
                            this.setBorderedCellStyle(i9, i10, rptStyle.border.top && i9 == n6, rptStyle.border.bottom && i9 == n7, rptStyle.border.left && i10 == n4, rptStyle.border.right && i10 == n12, n19, color, null);
                        }
                    }
                }
                if (!(rptComponent.image == null || this.ignoreImages && rptComponent.inputType == null)) {
                    this.drawBitmap(rptComponent, rptSection, n4, n6, n13, n8);
                }
                if (rptComponent.text != null) {
                    if (d2 != null) {
                        cell.setCellValue(d2.doubleValue());
                    } else {
                        cell.setCellValue(rptComponent.text);
                    }
                }
                if (rptComponent.hyperlink != null) {
                    cell.setHyperlink(this.getHyperlink(rptComponent.hyperlink));
                }
            }
        }
        if (bl) {
            rptStyleInfo.discarded2 = true;
        } else if (n7 > this.currentRowIndex) {
            this.currentRowIndex = n7;
        }
    }

    private void drawBitmap(RptComponent rptComponent, RptSection rptSection, int n2, int n3, int n4, int n5) {
        int n6 = this.getImage(rptComponent.image.imageFile);
        if (n6 >= 0) {
            int n7;
            int n8 = -1;
            int n9 = -1;
            int n10 = -1;
            int n11 = -1;
            int n12 = -1;
            int n13 = -1;
            int n14 = -1;
            int n15 = -1;
            int n16 = 0;
            int n17 = n2 - n4;
            int n18 = this.columnOffsets.get(n17++);
            int n19 = this.columnOffsets.size();
            while (n17 < n19) {
                n7 = this.columnOffsets.get(n17) - n18;
                if (rptComponent.image.x + rptComponent.image.width <= n7 || n17 == n19 - 1) {
                    n10 = n17;
                    n14 = this.exportHelper.computeAnchorX(n7 - n16, rptComponent.image.x + rptComponent.image.width - n16);
                    if (n15 >= 0) break;
                    n11 = n17;
                    n15 = this.exportHelper.computeAnchorX(n7 - n16, rptComponent.image.x - n16);
                    break;
                }
                if (n15 < 0 && rptComponent.image.x <= n7) {
                    n11 = n17;
                    n15 = this.exportHelper.computeAnchorX(n7 - n16, rptComponent.image.x - n16);
                }
                n16 = n7;
                ++n17;
            }
            n16 = 0;
            n7 = this.getSheetIndex(n3);
            int n20 = this.sheetLastRowIndexes.get(n7) - rptSection.rowOffset;
            n17 = n3 - n5 - rptSection.rowOffset;
            int n21 = rptSection.lineOffsets.get(n17++);
            int n22 = rptSection.lineOffsets.size();
            while (n17 < n22) {
                int n23 = rptSection.lineOffsets.get(n17) - n21;
                if (rptComponent.image.y + rptComponent.image.height <= n23 || n17 == n22 - 1 || n17 == n20) {
                    n8 = n17 + rptSection.rowOffset;
                    n12 = this.exportHelper.computeAnchorY(n23 - n16, rptComponent.image.y + rptComponent.image.height - n16);
                    if (n13 >= 0) break;
                    n9 = n17 + rptSection.rowOffset;
                    n13 = this.exportHelper.computeAnchorY(n23 - n16, rptComponent.image.y - n16);
                    break;
                }
                if (n13 < 0 && rptComponent.image.y <= n23) {
                    n9 = n17 + rptSection.rowOffset;
                    n13 = this.exportHelper.computeAnchorY(n23 - n16, rptComponent.image.y - n16);
                }
                n16 = n23;
                ++n17;
            }
            ClientAnchor clientAnchor = this.createClientAnchor(n15, n13, n14, n12, n11 - 1 + n4, n9 - 1 + n5, n10 - 1 + n4, n8 - 1 + n5);
            clientAnchor.setAnchorType(ClientAnchor.AnchorType.DONT_MOVE_AND_RESIZE);
            this.patriarchs.get(this.getSheetIndex(n9)).createPicture(clientAnchor, n6);
        }
    }

    protected ClientAnchor createClientAnchor(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10 = this.getSheetIndex(n7);
        return this.patriarchs.get(n10).createAnchor(n2, n3, n4, n5, n6, this.getSheetRelativeRowIndex(n7, n10), n8, this.getSheetRelativeRowIndex(n9, n10));
    }

    protected Sheet getSheet(int n2) {
        return this.getSheet(n2, null);
    }

    private Sheet newSheet() {
        Sheet sheet = this.createSheet(this.reportName + " " + String.valueOf(this.exportHelper.getSheetCount() + 1));
        return sheet;
    }

    protected Sheet getSheet(int n2, int[] nArray) {
        int n3 = this.getSheetIndex(n2);
        if (n3 >= this.exportHelper.getSheetCount()) {
            this.newSheet();
        }
        if (nArray != null) {
            nArray[0] = n3;
        }
        return this.exportHelper.getSheetAt(n3);
    }

    protected int getSheetIndex(int n2) {
        for (int i2 = this.sheetLastRowIndexes.size() - 1; i2 >= 0; --i2) {
            if (n2 <= this.sheetLastRowIndexes.get(i2)) continue;
            return i2 + 1;
        }
        return 0;
    }

    protected int getSheetRelativeRowIndex(int n2, int n3) {
        if (n3 == 0) {
            return n2;
        }
        return n2 - this.sheetLastRowIndexes.get(n3 - 1) - 1;
    }

    private void setBorderedCellStyle(int n2, int n3, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n4, Color color, Color color2) {
        Cell cell;
        int[] nArray = new int[1];
        Sheet sheet = this.getSheet(n2, nArray);
        Row row = sheet.getRow(n2 = this.getSheetRelativeRowIndex(n2, nArray[0]));
        if (row == null) {
            row = sheet.createRow(n2);
        }
        if ((cell = row.getCell(n3)) == null) {
            cell = row.createCell(n3);
        }
        StringBuilder stringBuilder = new StringBuilder("brd[");
        if (color != null) {
            stringBuilder.append(n4);
            stringBuilder.append(",");
            stringBuilder.append(color.getRGB());
            if (bl) {
                stringBuilder.append(",t");
            }
            if (bl2) {
                stringBuilder.append(",b");
            }
            if (bl3) {
                stringBuilder.append(",l");
            }
            if (bl4) {
                stringBuilder.append(",r");
            }
            if (color2 != null) {
                stringBuilder.append(",u").append(color2.getRGB());
            }
        } else if (color2 != null) {
            stringBuilder.append("u").append(color2.getRGB());
        }
        stringBuilder.append("]");
        CellStyle cellStyle = this.CELL_STYLES.get(stringBuilder.toString());
        if (cellStyle == null) {
            try {
                cellStyle = this.exportHelper.getWorkbook().createCellStyle();
            }
            catch (Exception exception) {
                return;
            }
            if (color != null) {
                this.exportHelper.setBorderedCellStyleAttrs(cellStyle, bl, bl2, bl3, bl4, n4, color);
            }
            if (color2 != null) {
                this.exportHelper.setBackgroundAttrs(cellStyle, color2);
            }
            this.CELL_STYLES.put(stringBuilder.toString(), cellStyle);
        }
        cell.setCellStyle(cellStyle);
    }

    protected abstract void setCellStyleAttrs(CellStyle var1, RptComponent var2, RptStyle var3, String var4);

    private CellStyle getCellStyle(RptComponent rptComponent, RptStyle rptStyle, int n2) {
        CellStyle cellStyle;
        String string = rptComponent.cssClass;
        if (n2 != 0) {
            string = string + "-" + n2;
        }
        if ((cellStyle = this.CELL_STYLES.get(string)) == null) {
            String string2;
            try {
                cellStyle = this.exportHelper.getWorkbook().createCellStyle();
            }
            catch (Exception exception) {
                return this.defaultCellStyle;
            }
            if (n2 != 0) {
                if (this.cellNumericFormat != null) {
                    string2 = this.cellNumericFormat;
                } else {
                    switch (n2) {
                        case 2: {
                            string2 = "#,###.##########";
                            break;
                        }
                        default: {
                            string2 = "#,###";
                            break;
                        }
                    }
                }
            } else {
                string2 = null;
            }
            this.setCellStyleAttrs(cellStyle, rptComponent, rptStyle, string2);
            this.CELL_STYLES.put(string, cellStyle);
        }
        return cellStyle;
    }

    private Hyperlink getHyperlink(String string) {
        HyperlinkType hyperlinkType = HyperlinkType.URL;
        try {
            new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            hyperlinkType = HyperlinkType.DOCUMENT;
        }
        Hyperlink hyperlink = this.createHyperlink(hyperlinkType);
        hyperlink.setAddress(string);
        return hyperlink;
    }

    protected Hyperlink createHyperlink(HyperlinkType hyperlinkType) {
        return this.creationHelper.createHyperlink(hyperlinkType);
    }

    protected Font getFont(RptFont rptFont, Color color) {
        return this.exportHelper.getFont(rptFont.family, rptFont.size, rptFont.bold, rptFont.italic, rptFont.underline, color);
    }

    private InputStream getStaticImage(String string) {
        byte[] byArray = null;
        if (string.equals("$CheckedCheckBox$")) {
            byArray = CheckBoxImage.getByteStream();
        } else if (string.equals("$CheckedRadioButton$")) {
            byArray = RadioButtonImage.getByteStream();
        } else if (string.equals("$UncheckedCheckBox$")) {
            byArray = UncheckBoxImage.getByteStream();
        } else if (string.equals("$UncheckedRadioButton$")) {
            byArray = UnradioButtonImage.getByteStream();
        }
        return byArray != null ? new ByteArrayInputStream(byArray) : null;
    }

    private int getImage(String string) {
        Integer n2 = this.IMAGES.get(string);
        InputStream inputStream = null;
        if (n2 == null) {
            Object object;
            inputStream = this.getStaticImage(string);
            if (inputStream == null) {
                try {
                    object = new URL(string);
                    inputStream = ((URL)object).openStream();
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (inputStream == null) {
                try {
                    inputStream = new FileInputStream(string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            if (inputStream != null) {
                try {
                    object = new byte[inputStream.available()];
                    inputStream.read((byte[])object);
                    inputStream.close();
                    n2 = this.exportHelper.getWorkbook().addPicture((byte[])object, 6);
                    this.IMAGES.put(string, n2);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return n2 != null ? n2 : -1;
    }

    @Override
    public void addGroupComponent(RptComponent rptComponent) {
        if (rptComponent.isTableComponent()) {
            this.intAddComponent(rptComponent);
        } else if (rptComponent.parent != null && rptComponent.parent.isTableComponent()) {
            this.intAddComponent(rptComponent);
        }
    }

    @Override
    public void addComponent(RptComponent rptComponent) {
        if (rptComponent.name.equals("title") || rptComponent.name.equals("style") || rptComponent.position != null && !rptComponent.position.equals("absolute")) {
            return;
        }
        if (rptComponent.name.equals("img")) {
            RptComponent rptComponent2 = rptComponent.parent;
            while (rptComponent2 != null) {
                if (rptComponent2.name.equals("div")) {
                    rptComponent2.image = rptComponent;
                    rptComponent2.hyperlink = rptComponent.hyperlink;
                    rptComponent = rptComponent2;
                    break;
                }
                rptComponent2 = rptComponent2.parent;
            }
        }
        this.intAddComponent(rptComponent);
    }

    @Override
    public void addStyle(RptStyle rptStyle) {
        String string;
        if (rptStyle.getType().equals("imc") || rptStyle.getType().equals("tccc")) {
            return;
        }
        RptSection rptSection = this.sections.get(rptStyle.getSectionId());
        if (rptStyle.getParentName() != null) {
            string = rptStyle.getParentName().toLowerCase();
            RptStyle rptStyle2 = this.allStyles.get(string);
            rptStyle.x += rptStyle2.x;
            rptStyle.y += rptStyle2.y;
            if (rptStyle.width == 0) {
                rptStyle.width = rptStyle2.width;
            }
            if (rptStyle.height == 0) {
                rptStyle.height = rptStyle2.height;
            }
        }
        if (rptStyle.isTableComponent() || rptStyle.isTableCellComponent()) {
            rptStyle.border = null;
        } else if (rptStyle.isLineComponent()) {
            if (rptStyle.width > rptStyle.height) {
                rptStyle.height = 0;
            } else {
                rptStyle.width = 0;
            }
        }
        string = rptStyle.getName().toLowerCase();
        if (rptSection == null) {
            rptSection = new RptSection(rptStyle.getSectionType());
            this.sections.put(rptStyle.getSectionId(), rptSection);
        }
        rptStyle.customData = new RptStyleInfo(rptStyle);
        rptSection.styles.put(string, rptStyle);
        this.allStyles.put(string, rptStyle);
    }

    @Override
    public void newPage() {
        if (this.pageCount == 0) {
            this.initializeReport();
        } else {
            int[] nArray;
            Sheet sheet;
            if (this.lastSection != null) {
                this.drawSection(this.lastSection);
                this.lastSection = null;
            }
            if (this.addPageBreaks && (sheet = this.getSheet(this.currentRowIndex - 1, nArray = new int[1])).getRowBreaks().length < 1024) {
                sheet.setRowBreak(this.getSheetRelativeRowIndex(this.currentRowIndex - 1, nArray[0]));
            }
        }
        ++this.pageCount;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    private void intAddComponent(RptComponent rptComponent) {
        RptStyle rptStyle = this.allStyles.get(rptComponent.cssClass.toLowerCase());
        if (rptStyle == null) {
            return;
        }
        RptSection rptSection = this.sections.get(rptStyle.getSectionId());
        if (rptComponent.inputType != null) {
            rptComponent.image = new RptComponent();
            rptComponent.image.imageFile = rptComponent.inputType;
            rptComponent.image.width = 17;
            rptComponent.image.height = 17;
            rptComponent.image.x = 2;
            rptComponent.image.y = Math.max(2, (rptComponent.height - 17) / 2);
        }
        int n2 = 0;
        RptComponent rptComponent2 = rptComponent.parent;
        while (rptComponent2 != null) {
            if (rptComponent2.isSection()) {
                n2 = rptComponent2.y;
                break;
            }
            rptComponent2 = rptComponent2.parent;
        }
        if (rptSection != this.lastSection || n2 != rptSection.topOffset) {
            if (this.lastSection != null) {
                this.drawSection(this.lastSection);
            }
            this.initSection(rptSection, n2);
            this.lastSection = rptSection;
            this.visibleComponents = new StringBuilder();
        }
        rptSection.components.add(rptComponent);
        this.visibleComponents.append(" ").append(rptStyle.getBaseName());
    }

    private void drawSection(RptSection rptSection) {
        RptStyle rptStyle;
        int n2;
        Object object2;
        int n3;
        boolean bl = false;
        if (this.freezePageHeader && rptSection.isPageHeader()) {
            if (this.lastPageHeaderSection != null && !rptSection.equalTo(this.lastPageHeaderSection)) {
                this.sheetLastRowIndexes.set(this.sheetLastRowIndexes.size() - 1, new Integer(this.currentRowIndex - 1));
                this.newSheet();
                this.pageHeaderFound = false;
                bl = true;
            } else if (this.pageHeaderFound) {
                return;
            }
        }
        if (rptSection.isPageHeader()) {
            this.lastPageHeaderSection = new RptSection(rptSection.typeName);
            this.lastPageHeaderSection.components = rptSection.components;
        }
        int n4 = this.getSheetColumnCount();
        String string = this.visibleComponents.toString();
        if (!rptSection.visComponents.equals(string)) {
            Iterator<RptStyle> iterator;
            rptSection.currStyles = new LinkedHashMap<String, RptStyle>();
            for (RptComponent rptComponent : rptSection.components) {
                iterator = rptComponent.cssClass.toLowerCase();
                RptStyle object22 = new RptStyle(rptSection.styles.get(iterator));
                object22.customData = new RptStyleInfo(object22);
                rptSection.currStyles.put((String)((Object)iterator), object22);
            }
            this.checkComponentIntersections(rptSection.currStyles.values().toArray(new RptStyle[rptSection.currStyles.size()]));
            TreeSet treeSet = new TreeSet();
            this.initTables(rptSection.currStyles.values(), null, treeSet, true);
            rptSection.lineOffsets = new ArrayList<Integer>(treeSet);
            n3 = rptSection.lineOffsets.size();
            if (rptSection.lineOffsets.size() > 0 && rptSection.lineOffsets.get(0) == 0) {
                --n3;
            }
            if (this.collapseRowSpan) {
                iterator = new TreeMap();
                for (Object object2 : rptSection.currStyles.values()) {
                    this.draw(null, false, (RptStyle)object2, rptSection, this.columnOffsets, (Map<Integer, Integer>)((Object)iterator));
                }
                this.adjustRowsHeights(rptSection, (TreeMap<Integer, Integer>)((Object)iterator));
            }
            rptSection.occupiedCells = new byte[n3][n4];
            if (this.collapseRowSpan || this.removeRowsSpace != 0 || this.removeColumnsSpace != 0 || this.whitePageBackground) {
                for (RptStyle rptStyle2 : rptSection.currStyles.values()) {
                    this.draw(null, true, rptStyle2, rptSection, this.columnOffsets, null);
                }
            }
            if (this.collapseRowSpan || this.removeRowsSpace != 0) {
                this.removeUnusedRows(rptSection);
            }
            rptSection.visComponents = string;
        }
        int n5 = rptSection.lineOffsets.size();
        n3 = 0;
        int n6 = 0;
        int[] nArray = new int[1];
        if (!bl && rptSection.topOffset > this.currTopOffset && this.removeRowsSpace == 0) {
            object2 = this.getSheet(this.currentRowIndex, nArray);
            Row row = object2.createRow(this.getSheetRelativeRowIndex(this.currentRowIndex, nArray[0]));
            n2 = rptSection.topOffset - this.currTopOffset;
            if (n5 > 0 && (n6 = rptSection.lineOffsets.get(0).intValue()) > 0) {
                n2 += n6;
                ++n3;
            } else {
                ++rptSection.rowOffset;
            }
            row.setHeightInPoints((float)UnitConverter.pixel2ExcelHeightPoints(n2));
            if (this.whitePageBackground) {
                for (int i2 = 0; i2 < n4; ++i2) {
                    this.setBorderedCellStyle(this.currentRowIndex, i2, false, false, false, false, 0, null, Color.white);
                }
            }
            ++this.currentRowIndex;
        }
        n2 = this.currentRowIndex;
        while (n3 < n5) {
            int n7 = rptSection.lineOffsets.get(n3);
            if (n7 > n6) {
                object2 = this.getSheet(n2, nArray);
                Row row = object2.createRow(this.getSheetRelativeRowIndex(n2, nArray[0]));
                row.setHeightInPoints((float)UnitConverter.pixel2ExcelHeightPoints(n7 - n6));
                ++n2;
            }
            n6 = n7;
            ++n3;
        }
        rptSection.occupiedCells = new byte[rptSection.occupiedCells.length][n4];
        Stack<RptComponent> stack = new Stack<RptComponent>();
        for (RptComponent rptComponent : rptSection.components) {
            rptStyle = rptSection.currStyles.get(rptComponent.cssClass.toLowerCase());
            RptStyleInfo rptStyleInfo = (RptStyleInfo)rptStyle.customData;
            if (rptStyleInfo.isFrameOrLine) {
                if (rptStyle.border != null && !this.ignoreCellBorder) {
                    RptStyleInfo rptStyleInfo2;
                    RptStyle rptStyle3;
                    if (rptStyleInfo.isFrame) {
                        for (RptComponent rptComponent2 : rptSection.components) {
                            if (rptComponent2 == rptComponent) continue;
                            rptStyle3 = rptSection.currStyles.get(rptComponent2.cssClass.toLowerCase());
                            rptStyleInfo2 = (RptStyleInfo)rptStyle3.customData;
                            if (rptStyleInfo2.isFrameOrLine) continue;
                            this.checkFrameBorder(rptStyle, rptStyle3);
                        }
                    } else {
                        for (RptComponent rptComponent2 : rptSection.components) {
                            if (rptComponent2 == rptComponent) continue;
                            rptStyle3 = rptSection.currStyles.get(rptComponent2.cssClass.toLowerCase());
                            rptStyleInfo2 = (RptStyleInfo)rptStyle3.customData;
                            if (rptStyleInfo2.isFrameOrLine) continue;
                            if (rptStyle.height > rptStyle.width) {
                                this.checkVLineBorder(rptStyle, rptComponent.foreground, rptStyle3);
                                continue;
                            }
                            this.checkHLineBorder(rptStyle, rptComponent.foreground, rptStyle3);
                        }
                    }
                }
                stack.push(rptComponent);
                continue;
            }
            this.draw(rptComponent, false, rptStyle, rptSection, this.columnOffsets, null);
        }
        while (!stack.isEmpty()) {
            RptComponent rptComponent = (RptComponent)stack.pop();
            rptStyle = rptSection.currStyles.get(rptComponent.cssClass.toLowerCase());
            this.draw(rptComponent, false, rptStyle, rptSection, this.columnOffsets, null);
        }
        this.setWhitePageBackground(rptSection);
        if (rptSection.isPageHeader() && !this.pageHeaderFound) {
            this.pageHeaderFound = true;
            if (this.freezePageHeader) {
                object2 = this.getSheet(this.currentRowIndex, nArray);
                int n8 = this.getSheetRelativeRowIndex(rptSection.rowOffset, nArray[0]);
                int n9 = this.getSheetRelativeRowIndex(this.currentRowIndex, nArray[0]);
                if (n8 >= 0) {
                    if (n9 <= this.sheetLastRowIndexes.get(nArray[0])) {
                        object2.createFreezePane(0, n9 + 1);
                    }
                    object2.setRepeatingRows(new CellRangeAddress(n8, n9, -1, -1));
                }
            }
        }
        if (rptSection.pageIndex < this.pageCount && this.pageCount % 10 == 0) {
            this.flushRows();
        }
        ++this.currentRowIndex;
        this.currTopOffset = rptSection.topOffset + rptSection.lineOffsets.get(rptSection.lineOffsets.size() - 1);
    }

    protected void flushRows() {
    }

    private void checkFrameBorder(RptStyle rptStyle, RptStyle rptStyle2) {
        if (rptStyle2.y >= rptStyle.y && rptStyle2.y + rptStyle2.height <= rptStyle.y + rptStyle.height) {
            if (rptStyle2.x == rptStyle.x || rptStyle2.x == rptStyle.x + rptStyle.width) {
                if (rptStyle2.border == null) {
                    rptStyle2.border = new RptBorder(rptStyle.border.width, rptStyle.border.color, false, true, false, false);
                } else {
                    rptStyle2.border.left = true;
                }
            }
            if (rptStyle2.x + rptStyle2.width == rptStyle.x + rptStyle.width || rptStyle2.x + rptStyle2.width == rptStyle.x) {
                if (rptStyle2.border == null) {
                    rptStyle2.border = new RptBorder(rptStyle.border.width, rptStyle.border.color, false, false, false, true);
                } else {
                    rptStyle2.border.right = true;
                }
            }
        }
        if (rptStyle2.x >= rptStyle.x && rptStyle2.x + rptStyle2.width <= rptStyle.x + rptStyle.width) {
            if (rptStyle2.y == rptStyle.y || rptStyle2.y == rptStyle.y + rptStyle.height) {
                if (rptStyle2.border == null) {
                    rptStyle2.border = new RptBorder(rptStyle.border.width, rptStyle.border.color, true, false, false, false);
                } else {
                    rptStyle2.border.top = true;
                }
            }
            if (rptStyle2.y + rptStyle2.height == rptStyle.y + rptStyle.height || rptStyle2.y + rptStyle2.height == rptStyle.y) {
                if (rptStyle2.border == null) {
                    rptStyle2.border = new RptBorder(rptStyle.border.width, rptStyle.border.color, false, false, true, false);
                } else {
                    rptStyle2.border.bottom = true;
                }
            }
        }
    }

    private void checkVLineBorder(RptStyle rptStyle, Color color, RptStyle rptStyle2) {
        if (rptStyle2.y >= rptStyle.y && rptStyle2.y + rptStyle2.height <= rptStyle.y + rptStyle.height) {
            if (rptStyle2.x == rptStyle.x) {
                if (rptStyle2.border == null) {
                    rptStyle2.border = new RptBorder(rptStyle.border.width, color, false, true, false, false);
                } else {
                    rptStyle2.border.left = true;
                }
            }
            if (rptStyle2.x + rptStyle2.width == rptStyle.x) {
                if (rptStyle2.border == null) {
                    rptStyle2.border = new RptBorder(rptStyle.border.width, color, false, false, false, true);
                } else {
                    rptStyle2.border.right = true;
                }
            }
        }
    }

    private void checkHLineBorder(RptStyle rptStyle, Color color, RptStyle rptStyle2) {
        if (rptStyle2.x >= rptStyle.x && rptStyle2.x + rptStyle2.width <= rptStyle.x + rptStyle.width) {
            if (rptStyle2.y == rptStyle.y) {
                if (rptStyle2.border == null) {
                    rptStyle2.border = new RptBorder(rptStyle.border.width, color, true, false, false, false);
                } else {
                    rptStyle2.border.top = true;
                }
            }
            if (rptStyle2.y + rptStyle2.height == rptStyle.y) {
                if (rptStyle2.border == null) {
                    rptStyle2.border = new RptBorder(rptStyle.border.width, color, false, false, true, false);
                } else {
                    rptStyle2.border.bottom = true;
                }
            }
        }
    }

    @Override
    public void setupPage(String string, double d2, double d3, double d4, double d5, boolean bl) {
        this.topMargin = d2;
        this.leftMargin = d3;
        this.rightMargin = d5;
        this.bottomMargin = d4;
        this.paperSize = string;
        this.landscape = bl;
    }

    protected void setupPage(String[] stringArray) {
        int n2 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        String string = "A4";
        boolean bl = false;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if ("-rm".equals(stringArray[n2])) {
                try {
                    d3 = Double.parseDouble(stringArray[++n2]);
                }
                catch (Exception exception) {}
                continue;
            }
            if ("-lm".equals(stringArray[n2])) {
                try {
                    d2 = Double.parseDouble(stringArray[++n2]);
                }
                catch (Exception exception) {}
                continue;
            }
            if ("-tm".equals(stringArray[n2])) {
                try {
                    d4 = Double.parseDouble(stringArray[++n2]);
                }
                catch (Exception exception) {}
                continue;
            }
            if ("-bm".equals(stringArray[n2])) {
                try {
                    d5 = Double.parseDouble(stringArray[++n2]);
                }
                catch (Exception exception) {}
                continue;
            }
            if ("-l".equals(stringArray[n2])) {
                bl = true;
                continue;
            }
            if (!"-p".equals(stringArray[n2])) continue;
            string = stringArray[++n2];
        }
        this.setupPage(string, d4, d2, d5, d3, bl);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    protected String getExportProperty(String string, String string2) {
        return this.properties.getProperty(string, Config.a(PROP_PREFIX + string, string2));
    }

    protected int getExportProperty(String string, int n2) {
        String string2 = this.properties.getProperty(string);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return Boolean.parseBoolean(string2) ? 1 : 0;
            }
        }
        return Config.a(PROP_PREFIX + string, Config.b(PROP_PREFIX + string, false) ? 1 : 0);
    }

    protected boolean getExportProperty(String string, boolean bl) {
        String string2 = this.properties.getProperty(string);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2) != 0;
            }
            catch (NumberFormatException numberFormatException) {
                return Boolean.parseBoolean(string2);
            }
        }
        return Config.b(PROP_PREFIX + string, bl);
    }

    private static class RptStyleInfo {
        Rectangle adjustBounds = new Rectangle();
        boolean discarded;
        boolean discarded2;
        boolean isFrame;
        boolean isFrameOrLine;
        Rectangle excelRC;

        RptStyleInfo(RptStyle rptStyle) {
            this.isFrame = rptStyle.isBoxComponent() || rptStyle.isTableComponent() || rptStyle.getType().equals("tc");
            this.isFrameOrLine = this.isFrame || rptStyle.isLineComponent();
        }
    }

    private static class RptSection {
        String typeName;
        Map<String, RptStyle> styles = new LinkedHashMap<String, RptStyle>();
        Map<String, RptStyle> currStyles;
        List<RptComponent> components;
        List<Integer> lineOffsets = new ArrayList<Integer>();
        byte[][] occupiedCells;
        int rowOffset;
        int topOffset;
        int pageIndex;
        String visComponents = "";

        RptSection(String string) {
            this.typeName = string;
        }

        boolean isPageHeader() {
            return "ph".equals(this.typeName);
        }

        boolean equalTo(RptSection rptSection) {
            int n2 = this.components.size();
            if (n2 != rptSection.components.size()) {
                return false;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.components.get(i2).equalTo(rptSection.components.get(i2))) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "Section: name='" + this.typeName + "', componentCount=" + this.styles.size();
        }
    }
}

