/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.htmlexporter.xls;

import com.iscobol.htmlexporter.RptComponent;
import com.iscobol.htmlexporter.RptStyle;
import com.iscobol.htmlexporter.ss.SSExporter;
import com.iscobol.misc.export.ss.SSExportHelper;
import com.iscobol.misc.export.xls.XLSExportHelper;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;

public class XLSExporter
extends SSExporter {
    public XLSExporter(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    @Override
    protected void setCellStyleAttrs(CellStyle cellStyle, RptComponent rptComponent, RptStyle rptStyle, String string) {
        VerticalAlignment verticalAlignment = VerticalAlignment.TOP;
        HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
        Font font = this.getFont(rptComponent.font, rptComponent.foreground);
        XLSExportHelper xLSExportHelper = (XLSExportHelper)this.exportHelper;
        cellStyle.setFont(font);
        if (!this.ignoreCellBackground) {
            cellStyle.setFillForegroundColor(xLSExportHelper.getColor(rptComponent.background, HSSFColor.HSSFColorPredefined.WHITE.getIndex()));
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        if (rptComponent.inputType != null) {
            cellStyle.setIndention((short)2);
            verticalAlignment = VerticalAlignment.CENTER;
        }
        if (rptComponent.align != null) {
            if (rptComponent.align.equals("left")) {
                horizontalAlignment = HorizontalAlignment.LEFT;
            } else if (rptComponent.align.equals("right")) {
                horizontalAlignment = HorizontalAlignment.RIGHT;
            } else if (rptComponent.align.equals("center")) {
                horizontalAlignment = HorizontalAlignment.CENTER;
            }
        }
        cellStyle.setAlignment(horizontalAlignment);
        cellStyle.setVerticalAlignment(verticalAlignment);
        if (rptStyle.border != null && !this.ignoreCellBorder) {
            BorderStyle borderStyle = xLSExportHelper.getBorder(rptStyle.border.width);
            if (rptStyle.border.color == null) {
                rptStyle.border.color = rptComponent.foreground;
            }
            short s2 = xLSExportHelper.getColor(rptStyle.border.color, HSSFColor.HSSFColorPredefined.BLACK.getIndex());
            if (rptStyle.border.top) {
                cellStyle.setBorderTop(borderStyle);
                cellStyle.setTopBorderColor(s2);
            }
            if (rptStyle.border.left) {
                cellStyle.setBorderLeft(borderStyle);
                cellStyle.setLeftBorderColor(s2);
            }
            if (rptStyle.border.right) {
                cellStyle.setRightBorderColor(s2);
                cellStyle.setBorderRight(borderStyle);
            }
            if (rptStyle.border.bottom) {
                cellStyle.setBottomBorderColor(s2);
                cellStyle.setBorderBottom(borderStyle);
            }
        }
        cellStyle.setWrapText(this.cellWrap);
        cellStyle.setLocked(this.cellLock);
        if (string != null) {
            cellStyle.setDataFormat(this.exportHelper.getFormat(string));
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 3) {
            System.err.println("Usage: java com.iscobol.htmlexporter.xls.XLSExporter reportName inputFile outputFile [options]");
            System.exit(1);
        }
        XLSExporter xLSExporter = new XLSExporter(stringArray[0], stringArray[1], stringArray[2]);
        xLSExporter.setupPage(stringArray);
        xLSExporter.export();
        xLSExporter.log();
        xLSExporter.dispose();
        System.out.println("Created file '" + xLSExporter.getOutputFile() + "'");
        System.exit(0);
    }

    @Override
    protected SSExportHelper createExportHelper() {
        return new XLSExportHelper();
    }
}

