/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.htmlexporter.xlsx;

import com.iscobol.htmlexporter.RptComponent;
import com.iscobol.htmlexporter.RptStyle;
import com.iscobol.htmlexporter.ss.SSExporter;
import com.iscobol.misc.export.ss.SSExportHelper;
import com.iscobol.misc.export.xlsx.XLSXExportHelper;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;

public class XLSXExporter
extends SSExporter {
    public XLSXExporter(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    @Override
    protected void setCellStyleAttrs(CellStyle cellStyle, RptComponent rptComponent, RptStyle rptStyle, String string) {
        VerticalAlignment verticalAlignment = VerticalAlignment.TOP;
        HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
        XSSFCellStyle xSSFCellStyle = (XSSFCellStyle)cellStyle;
        Font font = this.getFont(rptComponent.font, rptComponent.foreground);
        xSSFCellStyle.setFont(font);
        XLSXExportHelper xLSXExportHelper = (XLSXExportHelper)this.exportHelper;
        if (!this.ignoreCellBackground) {
            xSSFCellStyle.setFillForegroundColor(xLSXExportHelper.getColor(rptComponent.background.getRGB()));
            xSSFCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        if (rptComponent.inputType != null) {
            xSSFCellStyle.setIndention((short)2);
            verticalAlignment = VerticalAlignment.CENTER;
        }
        if (rptComponent.align != null) {
            if (rptComponent.align.equals("left")) {
                horizontalAlignment = HorizontalAlignment.LEFT;
            } else if (rptComponent.align.equals("right")) {
                horizontalAlignment = HorizontalAlignment.RIGHT;
            } else if (rptComponent.align.equals("center")) {
                horizontalAlignment = HorizontalAlignment.CENTER;
            }
        }
        xSSFCellStyle.setAlignment(horizontalAlignment);
        xSSFCellStyle.setVerticalAlignment(verticalAlignment);
        if (rptStyle.border != null && !this.ignoreCellBorder) {
            BorderStyle borderStyle = xLSXExportHelper.getBorder(rptStyle.border.width);
            if (rptStyle.border.color == null) {
                rptStyle.border.color = rptComponent.foreground;
            }
            XSSFColor xSSFColor = xLSXExportHelper.getColor(rptStyle.border.color.getRGB());
            if (rptStyle.border.top) {
                xSSFCellStyle.setBorderTop(borderStyle);
                xSSFCellStyle.setTopBorderColor(xSSFColor);
            }
            if (rptStyle.border.left) {
                xSSFCellStyle.setBorderLeft(borderStyle);
                xSSFCellStyle.setLeftBorderColor(xSSFColor);
            }
            if (rptStyle.border.right) {
                xSSFCellStyle.setRightBorderColor(xSSFColor);
                xSSFCellStyle.setBorderRight(borderStyle);
            }
            if (rptStyle.border.bottom) {
                xSSFCellStyle.setBottomBorderColor(xSSFColor);
                xSSFCellStyle.setBorderBottom(borderStyle);
            }
        }
        xSSFCellStyle.setWrapText(true);
        if (string != null) {
            xSSFCellStyle.setDataFormat(this.exportHelper.getFormat(string));
        }
        xSSFCellStyle.setWrapText(this.cellWrap);
        xSSFCellStyle.setLocked(this.cellLock);
    }

    @Override
    protected void flushRows() {
        SXSSFSheet sXSSFSheet = (SXSSFSheet)this.getSheet(this.currentRowIndex);
        this.exportHelper.flushRows((Sheet)sXSSFSheet);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 3) {
            System.err.println("Usage: java com.iscobol.htmlexporter.xlsx.XLSXExporter reportName inputFile outputFile [options]");
            System.exit(1);
        }
        XLSXExporter xLSXExporter = new XLSXExporter(stringArray[0], stringArray[1], stringArray[2]);
        xLSXExporter.setupPage(stringArray);
        xLSXExporter.export();
        xLSXExporter.log();
        xLSXExporter.dispose();
        System.out.println("Created file '" + xLSXExporter.getOutputFile() + "'");
        System.exit(0);
    }

    @Override
    protected SSExportHelper createExportHelper() {
        return new XLSXExportHelper();
    }
}

