/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.htmlrenderer;

import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

public class CSSStyle {
    public static final String BACKGROUND = "background";
    public static final String BACKGROUND_COLOR = "background-color";
    public static final String BORDER = "border";
    public static final String BORDER_BOTTOM = "border-bottom";
    public static final String BORDER_LEFT = "border-left";
    public static final String BORDER_RIGHT = "border-right";
    public static final String BORDER_TOP = "border-top";
    public static final String BORDER_STYLE = "border-style";
    public static final String BORDER_WIDTH = "border-width";
    public static final String BORDER_COLOR = "border-color";
    public static final String COLOR = "color";
    public static final String FONT_FAMILY = "font-family";
    public static final String FONT_SIZE = "font-size";
    public static final String HEIGHT = "height";
    public static final String LEFT = "left";
    public static final String LETTER_SPACING = "letter-spacing";
    public static final String OVERFLOW = "overflow";
    public static final String POSITION = "position";
    public static final String SOLID = "solid";
    public static final String TEXT_ALIGN = "text-align";
    public static final String TOP = "top";
    public static final String WIDTH = "width";
    public static final Color TRANSPARENT_COLOR = new Color(255, 255, 255, 0);
    static final int POSITION_RELATIVE = 1;
    static final int POSITION_ABSOLUTE = 2;
    static final int OVERFLOW_HIDDEN = 1;
    private static final HashMap properties = new HashMap();
    private final String name;
    private final CharSequence text;
    private final int csLen;
    private int currIdx;
    private final HashMap attributes;
    private boolean isClass;

    public CSSStyle(String string) {
        this.name = "Anonymous";
        this.attributes = new HashMap();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        stringBuffer.append(string);
        stringBuffer.append('}');
        this.text = stringBuffer;
        this.csLen = this.text.length();
    }

    public CSSStyle(CharSequence charSequence, int n2) {
        char c2;
        this.text = charSequence;
        this.csLen = this.text.length();
        this.currIdx = n2;
        this.attributes = new HashMap();
        if (this.text.charAt(this.currIdx) == '.') {
            ++this.currIdx;
            this.isClass = true;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (this.currIdx < this.csLen && (c2 = this.text.charAt(this.currIdx)) > ' ' && c2 != '{') {
            stringBuffer.append(Character.toLowerCase(c2));
            ++this.currIdx;
        }
        this.name = stringBuffer.toString();
        while (this.currIdx < this.csLen && (c2 = this.text.charAt(this.currIdx)) <= ' ' && c2 != '{') {
            ++this.currIdx;
        }
    }

    public CSSStyle(CSSStyle cSSStyle) {
        this.name = "$copy";
        this.attributes = new HashMap(cSSStyle.attributes);
        this.text = new StringBuffer(cSSStyle.text.toString());
        this.csLen = cSSStyle.csLen;
    }

    public String getName() {
        return this.name;
    }

    public int parse() throws BadFormatException {
        char c2 = this.text.charAt(this.currIdx);
        if (c2 != '{') {
            throw new BadFormatException("Expected '{', found '" + c2 + "'");
        }
        ++this.currIdx;
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        String string2 = null;
        boolean bl = false;
        block5: while (this.currIdx < this.csLen) {
            c2 = Character.toLowerCase(this.text.charAt(this.currIdx));
            switch (c2) {
                case ';': {
                    string2 = stringBuffer.toString();
                    stringBuffer.delete(0, stringBuffer.length());
                    this.set(string, string2);
                    string2 = null;
                    string = null;
                    bl = false;
                    break;
                }
                case '}': {
                    if (string == null) break block5;
                    string2 = stringBuffer.toString();
                    this.set(string, string2);
                    break block5;
                }
                case ':': 
                case '=': {
                    if (!bl) {
                        string = stringBuffer.toString();
                        bl = BACKGROUND.equals(string);
                        stringBuffer.delete(0, stringBuffer.length());
                        break;
                    }
                }
                default: {
                    if (c2 > ' ') {
                        stringBuffer.append(c2);
                        break;
                    }
                    if (string == null || stringBuffer.length() <= 0 || stringBuffer.charAt(stringBuffer.length() - 1) == ' ') break;
                    stringBuffer.append(' ');
                }
            }
            ++this.currIdx;
        }
        return this.currIdx;
    }

    private void set(String string, String string2) throws BadFormatException {
        GetObject getObject = (GetObject)properties.get(string);
        if (getObject == null) {
            throw new BadFormatException("Unhandled attribute: " + string);
        }
        this.attributes.put(string, getObject.get(string2));
    }

    public Object get(String string) {
        return this.attributes.get(string);
    }

    public void mixUp(CSSStyle cSSStyle) {
        if (cSSStyle != null) {
            Set set = cSSStyle.attributes.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                if (this.attributes.get(string) != null) continue;
                this.attributes.put(string, cSSStyle.attributes.get(string));
            }
        }
    }

    private static String attrToString(Object object) {
        String string;
        if (object instanceof Color) {
            StringBuffer stringBuffer = new StringBuffer();
            Color color = (Color)object;
            int n2 = color.getAlpha();
            if (n2 == 0) {
                stringBuffer.append("transparent");
            } else {
                stringBuffer.append("#");
                n2 = color.getRed();
                if (n2 < 16) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(Integer.toHexString(n2));
                n2 = color.getGreen();
                if (n2 < 16) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(Integer.toHexString(n2));
                n2 = color.getBlue();
                if (n2 < 16) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(Integer.toHexString(n2));
            }
            string = stringBuffer.toString();
        } else {
            string = object != null ? object.toString() : "null";
        }
        return string;
    }

    public String getContent() {
        StringBuffer stringBuffer = new StringBuffer();
        Set set = this.attributes.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            stringBuffer.append(string);
            stringBuffer.append(":");
            stringBuffer.append(CSSStyle.attrToString(this.attributes.get(string)));
            stringBuffer.append("; ");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isClass) {
            stringBuffer.append('.');
        }
        stringBuffer.append(this.name);
        stringBuffer.append(" {");
        stringBuffer.append(this.getContent());
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    static {
        properties.put(BACKGROUND, new GetImage());
        properties.put(BACKGROUND_COLOR, new GetColor());
        properties.put(BORDER, new Border());
        properties.put(BORDER_BOTTOM, new Border());
        properties.put(BORDER_LEFT, new Border());
        properties.put(BORDER_RIGHT, new Border());
        properties.put(BORDER_TOP, new Border());
        properties.put(BORDER_STYLE, new Border());
        properties.put(BORDER_WIDTH, new GetInteger());
        properties.put(BORDER_COLOR, new GetColor());
        properties.put(COLOR, new GetColor());
        properties.put(FONT_FAMILY, new GetString());
        properties.put(FONT_SIZE, new GetFontSizePt());
        properties.put(HEIGHT, new GetInteger());
        properties.put(LEFT, new GetInteger());
        properties.put(LETTER_SPACING, new GetString());
        properties.put(OVERFLOW, new GetString());
        properties.put(POSITION, new GetString());
        properties.put(SOLID, new GetColor());
        properties.put(TEXT_ALIGN, new GetString());
        properties.put(TOP, new GetInteger());
        properties.put(WIDTH, new GetInteger());
    }

    private static class GetFontSizePt
    extends GetObject {
        private GetFontSizePt() {
        }

        @Override
        public Object get(String string) {
            return new FontSizePt(this.getFloat(string));
        }
    }

    private static class GetImage
    extends GetObject {
        private GetImage() {
        }

        @Override
        public Object get(String string) {
            return string;
        }
    }

    private static class GetString
    extends GetObject {
        private GetString() {
        }

        @Override
        public Object get(String string) {
            return string;
        }
    }

    private static class GetColor
    extends GetObject {
        private GetColor() {
        }

        @Override
        public Object get(String string) {
            return this.getColor(string);
        }
    }

    private static class GetFloat
    extends GetObject {
        private GetFloat() {
        }

        @Override
        public Object get(String string) {
            return this.getFloat(string);
        }
    }

    private static class GetInteger
    extends GetObject {
        private GetInteger() {
        }

        @Override
        public Object get(String string) {
            return this.getInteger(string);
        }
    }

    public static class Border
    extends GetObject {
        private Integer depth;
        private String style;
        private Color color;

        @Override
        public Object get(String string) {
            Border border = new Border();
            Integer n2 = null;
            String string2 = null;
            Color color = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.hasMoreElements()) {
                n2 = this.getInteger(stringTokenizer.nextToken());
                if (stringTokenizer.hasMoreElements()) {
                    string2 = stringTokenizer.nextToken();
                    if (stringTokenizer.hasMoreElements()) {
                        color = this.getColor(stringTokenizer.nextToken());
                    }
                }
            }
            border.depth = n2;
            border.style = string2;
            border.color = color;
            return border;
        }

        public int getDepth() {
            if (this.depth != null) {
                return this.depth;
            }
            return -1;
        }

        public String getStyle() {
            return this.style;
        }

        public Color getColor() {
            return this.color;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.depth);
            if (this.style != null) {
                stringBuffer.append(' ');
                stringBuffer.append(this.style);
                if (this.color != null) {
                    stringBuffer.append(' ');
                    stringBuffer.append(CSSStyle.attrToString(this.color));
                }
            }
            return stringBuffer.toString();
        }
    }

    private static abstract class GetObject {
        private GetObject() {
        }

        abstract Object get(String var1);

        private final int getInt(String string) {
            int n2 = 0;
            char[] cArray = string.toCharArray();
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                if (cArray[i2] < '0' || cArray[i2] > '9') continue;
                n2 *= 10;
                n2 += cArray[i2] - 48;
            }
            return n2;
        }

        public Integer getInteger(String string) {
            return new Integer(this.getInt(string));
        }

        public Float getFloat(String string) {
            return new Float(this.getInt(string));
        }

        public Color getColor(String string) {
            Color color;
            if (string.length() == 0) {
                color = null;
            } else if (string.charAt(0) == '#' && string.length() >= 7) {
                try {
                    color = new Color(Integer.valueOf(string.substring(1, 7), 16));
                }
                catch (Exception exception) {
                    color = null;
                }
            } else {
                color = "transparent".equals(string) ? TRANSPARENT_COLOR : ("red".equals(string) ? Color.red : ("green".equals(string) ? Color.green : ("blue".equals(string) ? Color.blue : ("yellow".equals(string) ? Color.yellow : ("cyan".equals(string) ? Color.cyan : ("magenta".equals(string) ? Color.magenta : ("white".equals(string) ? Color.white : ("black".equals(string) ? Color.black : null))))))));
            }
            return color;
        }
    }

    public static class FontSizePt {
        final Float value;

        FontSizePt(Float f2) {
            this.value = f2;
        }

        public Float getValue() {
            return this.value;
        }

        public String toString() {
            return "" + this.value + "pt";
        }
    }

    public static class BadFormatException
    extends Exception {
        BadFormatException(String string) {
            super(string);
        }
    }
}

