/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.htmlrenderer;

import com.iscobol.gui.Events;
import com.iscobol.gui.IsguiUtility;
import com.iscobol.htmlrenderer.CSSStyle;
import com.iscobol.htmlrenderer.CheckBoxImage;
import com.iscobol.htmlrenderer.RadioButtonImage;
import com.iscobol.htmlrenderer.UncheckBoxImage;
import com.iscobol.htmlrenderer.UnradioButtonImage;
import com.iscobol.rts.BitmapNotFoundException;
import com.iscobol.rts.Config;
import com.iscobol.rts.FileImage;
import com.iscobol.rts.UserHandles;
import com.iscobol.rts.print.LocalSpoolPrinter;
import com.iscobol.rts.print.SpoolPrinterList;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.print.attribute.Size2DSyntax;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import org.xml.sax.Attributes;

public class Drawer {
    public static final float PIX2PT = 0.75f;
    public static final int CUSTOM_PAPER = 9999;
    public static final String CUSTOM_PAPER_NAME = "custom";
    public static final int DEFAULT_PAPER = 9;
    public static final Map defaultFont = new Font("default", 0, 12).getAttributes();
    public static final Color defaultColor = Color.black;
    public static final Color defaultBrush = new Color(255, 255, 255, 0);
    public static FileImage checkBox;
    public static FileImage uncheckBox;
    public static FileImage radioButton;
    public static FileImage unradioButton;
    private static final Size2DSyntax customPaperSize;
    static final String[] media;
    final LocalSpoolPrinter thePrinter;
    private final HashMap<String, FileImage> images = new HashMap();
    private final Stack contexts = new Stack();
    private Map currFont;
    private Color currColor;
    private Color currBrush;
    private boolean inBody;
    private boolean landscape;
    private int currPaper;
    private int divDepth = -1;
    private ArrayList<int[]> divSizes = new ArrayList();
    private float _topMargin = 54.0f;
    private float _leftMargin = 54.0f;
    private float _bottomMargin = 54.0f;
    private float _rightMargin = 54.0f;
    private boolean lightGrayIsTransparent = Config.b("iscobol.gui.light_gray_is_transparent", true);
    private HashSet<Integer> handlesToFree = new HashSet();

    public static boolean areEqual(Map map, Map map2) {
        if (map != null) {
            if (map2 != null) {
                if (map.size() == map2.size()) {
                    Set set = map.keySet();
                    for (Object k2 : set) {
                        if (map.get(k2) != null) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        return map2 == null;
    }

    public Drawer(Events events) throws IOException {
        this(events, false);
    }

    public Drawer(Events events, boolean bl) throws IOException {
        if (bl) {
            boolean bl2 = SpoolPrinterList.get().isServerSide();
            SpoolPrinterList.get().setServerSide(true);
            this.thePrinter = SpoolPrinterList.get().newSpoolPrinter(false, false, true, "-p preview", false, events);
            SpoolPrinterList.get().setServerSide(bl2);
        } else {
            this.thePrinter = SpoolPrinterList.get().newSpoolPrinter(false, false, false, "-p preview", false, events);
        }
        this.currPaper = 9;
        this.thePrinter.setMediaSize(this.currPaper);
    }

    private FileImage getImage(String string) {
        FileImage fileImage = this.images.get(string);
        if (fileImage == null) {
            try {
                URL uRL = new URL(string);
                fileImage = new FileImage(uRL.openStream(), string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (fileImage == null) {
                try {
                    fileImage = new FileImage(string);
                }
                catch (BitmapNotFoundException bitmapNotFoundException) {
                    fileImage = FileImage.getBroken();
                }
            }
            this.images.put(string, fileImage);
        }
        return fileImage;
    }

    public void setLandscape(boolean bl) {
        this.landscape = bl;
        try {
            if (this.landscape) {
                this.thePrinter.setOrientation(2);
            } else {
                this.thePrinter.setOrientation(1);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isLandscape() {
        return this.landscape;
    }

    public String getPaperName() {
        if (this.currPaper == 9999) {
            return CUSTOM_PAPER_NAME;
        }
        if (this.currPaper > 0 && this.currPaper < media.length) {
            return media[this.currPaper];
        }
        return "unset";
    }

    public float[] getPaperSize(int n2) {
        try {
            Size2DSyntax size2DSyntax = this.thePrinter.getCurrMediaSize2D();
            if (size2DSyntax != null) {
                return size2DSyntax.getSize(25400);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new float[]{0.0f, 0.0f};
    }

    public int[] getMargins() {
        int[] nArray = new int[4];
        try {
            double[] dArray = this.thePrinter.getMargins(2);
            nArray[0] = (int)Math.round(dArray[2] * 100.0);
            nArray[1] = (int)Math.round(dArray[3] * 100.0);
            nArray[2] = (int)Math.round(dArray[0] * 100.0);
            nArray[3] = (int)Math.round(dArray[1] * 100.0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return nArray;
    }

    public void setMargins(double d2, double d3, double d4, double d5) {
        this._topMargin = (float)d4 * 72.0f;
        this._leftMargin = (float)d2 * 72.0f;
        this._rightMargin = (float)d3 * 72.0f;
        this._bottomMargin = (float)d5 * 72.0f;
        try {
            this.thePrinter.setMargins(d4, d5, d2, d3, 2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean setCustomPaperSize(float f2, float f3) {
        boolean bl;
        try {
            bl = this.thePrinter.setCustomMediaSize(f2, f3, 2);
            this.currPaper = 9999;
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    public boolean setPaperSize(String string) {
        if (CUSTOM_PAPER_NAME.equals(string = string.trim().toLowerCase())) {
            boolean bl;
            try {
                bl = this.thePrinter.setCustomMediaSize(customPaperSize.getX(25400), customPaperSize.getY(25400), 2);
                this.currPaper = 9999;
            }
            catch (IOException iOException) {
                bl = false;
            }
            return bl;
        }
        for (int i2 = 1; i2 < media.length; ++i2) {
            if (!media[i2].equalsIgnoreCase(string)) continue;
            try {
                this.thePrinter.setMediaSize(i2);
                this.currPaper = i2;
            }
            catch (IOException iOException) {
                return false;
            }
            return true;
        }
        return false;
    }

    public void setup() {
        try {
            if (this.thePrinter.setup()) {
                this.currPaper = this.thePrinter.getCurrMediaSize();
                int n2 = this.thePrinter.getOrientation();
                this.landscape = n2 != 1 && n2 != 3;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public double[] setupPrint() {
        double[] dArray = new double[]{};
        try {
            dArray = this.thePrinter.setup(this._topMargin / 72.0f, this._bottomMargin / 72.0f, this._leftMargin / 72.0f, this._rightMargin / 72.0f);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return dArray;
    }

    private Context startTag(String string) throws IOException {
        Context context;
        int n2 = this.contexts.size();
        Context context2 = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            context2 = (Context)this.contexts.get(i2);
            context2.printText();
        }
        if (context2 == null) {
            context = new Context(string);
            this.contexts.push(context);
        } else {
            context = context2.deepClone(string);
            this.contexts.push(context);
        }
        return context;
    }

    private void printPageHeader(int n2) throws IOException {
    }

    private void printPageFooter(float f2, float f3) throws IOException {
    }

    public void startTag(String string, Attributes attributes, CSSStyle cSSStyle) throws IOException {
        Context context = this.startTag(string);
        boolean bl = false;
        if (this.inBody || (this.inBody = "body".equals(string))) {
            Object object;
            int n2 = 0;
            int n3 = 0;
            if ("div".equals(string)) {
                ++this.divDepth;
                if (this.divDepth == 1) {
                    this.thePrinter.newPage();
                    context.newPage();
                    bl = true;
                    this.printPageHeader(n2);
                } else if (this.divDepth == 0) {
                    this.divDepth = 1;
                    this.printPageHeader(n2);
                }
                this.divSizes.add(new int[2]);
            }
            if (cSSStyle != null) {
                Object object2;
                int n4;
                Object object3;
                int n5;
                object = cSSStyle.get("top");
                if (object != null) {
                    n5 = (Integer)object;
                    if (bl) {
                        n5 = 0;
                    }
                } else {
                    n5 = -1;
                }
                int n6 = (object = cSSStyle.get("left")) != null ? (Integer)object : -1;
                object = cSSStyle.get("width");
                n2 = object != null ? (Integer)object : -1;
                object = cSSStyle.get("height");
                n3 = object != null ? (Integer)object : -1;
                if (this.divDepth > 0) {
                    object3 = this.divSizes.get(this.divDepth - 1);
                    object3[0] = n2;
                    object3[1] = n3;
                }
                if ((object = cSSStyle.get("color")) != null) {
                    context.color = (Color)object;
                }
                if ((object = cSSStyle.get("background-color")) != null) {
                    context.setBrush((Color)object);
                }
                if (this.currBrush != null) {
                    if (context.brush == null) {
                        this.currBrush = defaultBrush;
                        this.thePrinter.setGraphBrush(0, this.currBrush.getRed(), this.currBrush.getGreen(), this.currBrush.getBlue(), this.currBrush.getAlpha());
                    } else if (!this.currBrush.equals(context.brush)) {
                        this.currBrush = context.brush;
                        this.thePrinter.setGraphBrush(0, this.currBrush.getRed(), this.currBrush.getGreen(), this.currBrush.getBlue(), this.currBrush.getAlpha());
                    }
                } else if (context.brush != null) {
                    this.currBrush = context.brush;
                    this.thePrinter.setGraphBrush(0, this.currBrush.getRed(), this.currBrush.getGreen(), this.currBrush.getBlue(), this.currBrush.getAlpha());
                }
                object = cSSStyle.get("text-align");
                if (object != null) {
                    context.textAlign = object.toString();
                }
                if ((object = cSSStyle.get("overflow")) != null) {
                    context.overflow = object.toString();
                }
                if ((object = cSSStyle.get("border")) != null) {
                    object3 = (CSSStyle.Border)object;
                    n4 = ((CSSStyle.Border)object3).getDepth();
                    Color color = ((CSSStyle.Border)object3).getColor();
                    if (color == null) {
                        color = context.color;
                    }
                    if (n5 >= 0 && n6 >= 0 && n2 > 0 && n3 > 0) {
                        this.drawBox(n6, n5, n2, n3, color, n4);
                    }
                } else {
                    object = cSSStyle.get("border-style");
                    if (object != null) {
                        Integer n7;
                        object3 = (Color)cSSStyle.get("border-color");
                        if (object3 == null) {
                            object3 = context.color;
                        }
                        if ((n7 = (Integer)cSSStyle.get("border-width")) == null) {
                            n7 = new Integer(3);
                        }
                        if (n5 >= 0 && n6 >= 0 && n2 > 0 && n3 > 0) {
                            this.drawBox(n6, n5, n2, n3, (Color)object3, n7.intValue());
                        }
                    } else {
                        object = cSSStyle.get("border-top");
                        if (object != null) {
                            object3 = (CSSStyle.Border)object;
                            n4 = ((CSSStyle.Border)object3).getDepth();
                            Color color = ((CSSStyle.Border)object3).getColor();
                            if (color == null) {
                                color = context.color;
                            }
                            if (n5 >= 0 && n6 >= 0 && n2 > 0 && n3 > 0) {
                                this.drawBox(n6, n5, n2, n3, color, n4);
                            }
                        } else {
                            object = cSSStyle.get("border-left");
                            if (object != null) {
                                object3 = (CSSStyle.Border)object;
                                n4 = ((CSSStyle.Border)object3).getDepth();
                                Color color = ((CSSStyle.Border)object3).getColor();
                                if (color == null) {
                                    color = context.color;
                                }
                                if (n5 >= 0 && n6 >= 0 && n2 > 0 && n3 > 0) {
                                    this.drawBox(n6, n5, n2, n3, color, n4);
                                }
                            } else if (context.brush != null) {
                                int n8 = n2;
                                n4 = n3;
                                if (this.divDepth > 1) {
                                    int n9;
                                    object2 = this.divSizes.get(this.divDepth - 2);
                                    if (n8 <= 0) {
                                        n8 = object2[0] - n6;
                                    } else if (object2[0] > 0 && (n9 = n8 + n6 - object2[0]) > 0) {
                                        n8 -= n9;
                                    }
                                    if (n4 <= 0) {
                                        n4 = object2[1] - n5;
                                    } else if (object2[1] > 0 && (n9 = n4 + n5 - object2[1]) > 0) {
                                        n4 -= n9;
                                    }
                                }
                                this.fillBox(n6, n5, n8, n4);
                            }
                        }
                    }
                }
                context.setPrintArea(n6, n5, n2, n3);
                object = cSSStyle.get("font-size");
                if (object != null) {
                    context.font.put(TextAttribute.SIZE, ((CSSStyle.FontSizePt)object).getValue());
                }
                if ((object = cSSStyle.get("font-family")) != null) {
                    context.font.put(TextAttribute.FAMILY, object);
                }
                if ((object = cSSStyle.get("background")) != null && n2 > 0 && n3 > 0) {
                    String string2 = (String)object;
                    n4 = string2.indexOf(40);
                    int n10 = string2.indexOf(41);
                    if (n4 >= 0 && n10 > n4) {
                        object2 = string2.substring(n4 + 1, n10);
                        boolean bl2 = string2.indexOf("no-repeat", n10 + 1) < 0;
                        InputStream inputStream = null;
                        try {
                            inputStream = new URL((String)object2).openStream();
                        }
                        catch (Exception exception) {
                            try {
                                inputStream = new FileInputStream((String)object2);
                            }
                            catch (Exception exception2) {
                                // empty catch block
                            }
                        }
                        if (inputStream != null) {
                            byte[] byArray = new byte[4096];
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            int n11 = inputStream.read(byArray);
                            while (n11 >= 0) {
                                byteArrayOutputStream.write(byArray, 0, n11);
                                n11 = inputStream.read(byArray);
                            }
                            byteArrayOutputStream.close();
                            byte[] byArray2 = byteArrayOutputStream.toByteArray();
                            inputStream.close();
                            Image image = IsguiUtility.createImage(byArray2, new int[]{0}, true, this.lightGrayIsTransparent, Config.a("iscobol.wbitmap.load_method", 1));
                            BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
                            Graphics2D graphics2D = bufferedImage.createGraphics();
                            if (bl2) {
                                int n12 = image.getWidth(null);
                                int n13 = image.getHeight(null);
                                BufferedImage bufferedImage2 = new BufferedImage(n12, n13, 2);
                                Graphics2D graphics2D2 = bufferedImage2.createGraphics();
                                graphics2D2.drawImage(image, 0, 0, null);
                                graphics2D2.dispose();
                                Rectangle rectangle = new Rectangle(0, 0, n12, n13);
                                graphics2D.setPaint(new TexturePaint(bufferedImage2, rectangle));
                                graphics2D.fillRect(0, 0, n2, n3);
                            } else {
                                graphics2D.drawImage(image, (n2 - image.getWidth(null)) / 2, (n3 - image.getHeight(null)) / 2, null);
                            }
                            graphics2D.dispose();
                            byteArrayOutputStream = new ByteArrayOutputStream();
                            ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
                            byteArrayOutputStream.close();
                            this.drawBitmap(new FileImage(byteArrayOutputStream.toByteArray()), n2, n3);
                        }
                    }
                }
            }
            if ("strong".equals(string)) {
                context.font.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            } else if ("em".equals(string)) {
                context.font.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            } else if ("u".equals(string)) {
                context.font.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            } else if (!"p".equals(string) && !"table".equals(string)) {
                if ("input".equals(string)) {
                    boolean bl3 = "checkbox".equalsIgnoreCase(attributes.getValue("type"));
                    if (bl3 || "radio".equalsIgnoreCase(attributes.getValue("type"))) {
                        FileImage fileImage = attributes.getValue("checked") != null ? (bl3 ? (checkBox == null ? (checkBox = new CheckBoxImage()) : checkBox) : (radioButton == null ? (radioButton = new RadioButtonImage()) : radioButton)) : (bl3 ? (uncheckBox == null ? (uncheckBox = new UncheckBoxImage()) : uncheckBox) : (unradioButton == null ? (unradioButton = new UnradioButtonImage()) : unradioButton));
                        this.drawBitmap(fileImage, fileImage.getWidth(), fileImage.getHeight());
                        context.moveRight(fileImage.getWidth());
                        context.setBaselineDown(fileImage.getHeight() - 5);
                    }
                } else if ("img".equals(string)) {
                    object = attributes.getValue("src");
                    String string3 = attributes.getValue("width");
                    if (string3 != null) {
                        try {
                            n2 = Integer.parseInt(string3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            n2 = 0;
                        }
                    }
                    if ((string3 = attributes.getValue("height")) != null) {
                        try {
                            n3 = Integer.parseInt(string3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            n3 = 0;
                        }
                    }
                    if (object != null) {
                        this.drawBitmap(this.getImage((String)object), n2, n3);
                    }
                }
            }
        }
    }

    public void characters(char[] cArray, int n2, int n3) {
        if (this.inBody && this.contexts.size() > 0) {
            ((Context)this.contexts.peek()).appendText(cArray, n2, n3);
        }
    }

    public void characters(char[] cArray) {
        this.characters(cArray, 0, cArray.length);
    }

    public void characters(String string) {
        this.characters(string.toCharArray());
    }

    public void endTag() throws IOException {
        if (this.contexts.size() > 0) {
            Context context = (Context)this.contexts.pop();
            if (this.inBody) {
                context.printText();
                if ("div".equals(context.tagName)) {
                    this.divSizes.remove(this.divSizes.size() - 1);
                    --this.divDepth;
                    if (this.divDepth == 0) {
                        this.printPageFooter(context.getPageWidth(), context.getPageHeight());
                    }
                } else if ("body".equals(context.tagName)) {
                    this.inBody = false;
                }
            }
        }
    }

    public void drawBitmap(FileImage fileImage, int n2, int n3) throws IOException {
        if (fileImage.getImage() != null) {
            Context context = (Context)this.contexts.peek();
            double d2 = context.getPageTop();
            double d3 = context.getPageLeft();
            if (this.thePrinter.isServerSide()) {
                int n4 = UserHandles.ssetId(fileImage);
                this.thePrinter.printBitmap(n4, d2, d3, 4, (float)n3 * 0.75f, (float)n2 * 0.75f, 4);
                this.handlesToFree.add(n4);
            } else {
                int n5 = fileImage.getImage().getTheObjectId();
                this.thePrinter.printBitmap(n5, d2, d3, 4, (float)n3 * 0.75f, (float)n2 * 0.75f, 4);
            }
        }
    }

    public void drawBox(int n2, int n3, int n4, int n5, Color color, double d2) throws IOException {
        Context context = (Context)this.contexts.peek();
        if (color == null) {
            color = context.color;
        }
        d2 = d2 >= 1.0 ? d2 : 0.0;
        this.thePrinter.setGraphPenPt(0, d2 *= 0.75, color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        double d3 = context.getPageTop();
        double d4 = context.getPageLeft();
        double d5 = (d3 += (double)((float)n3 * 0.75f)) + (double)((float)(n5 - 1) * 0.75f);
        double d6 = (d4 += (double)((float)n2 * 0.75f)) + (double)((float)(n4 - 1) * 0.75f);
        this.thePrinter.drawGraph(1, d4, d3, d6, d5, 4, null);
    }

    public void fillBox(int n2, int n3, int n4, int n5) throws IOException {
        if (n2 >= 0 && n3 >= 0 && n4 > 0 & n5 > 0) {
            Context context = (Context)this.contexts.peek();
            double d2 = context.getPageTop();
            double d3 = context.getPageLeft();
            double d4 = (d2 += (double)((float)n3 * 0.75f)) + (double)((float)(n5 - 1) * 0.75f);
            double d5 = (d3 += (double)((float)n2 * 0.75f)) + (double)((float)(n4 - 1) * 0.75f);
            this.thePrinter.drawGraph(17, d3, d2, d5, d4, 4, null);
        }
    }

    public void setFont(Map map) throws Exception {
        Context context = (Context)this.contexts.peek();
        context.setFont(map);
    }

    public void setColor(int n2, int n3, int n4) throws Exception {
        Context context = (Context)this.contexts.peek();
        context.setColor(new Color(n2, n3, n4));
    }

    public void setPosition(float f2, float f3) throws Exception {
        Context context = (Context)this.contexts.peek();
        context.setPrintArea(f2, f3, -1.0f, -1.0f);
    }

    public void setHeaderFooter(String string, String string2) throws IOException {
        this.thePrinter.setHeaderFooter(string, string2, 0);
    }

    public void setTitle(String string) {
    }

    public void setUrl(String string) throws IOException {
        this.thePrinter.setReportName(string);
    }

    public void write(char[] cArray, int n2, int n3) throws Exception {
        this.thePrinter.write(cArray, n2, n3);
    }

    public void close() throws IOException {
        this.thePrinter.close();
        if (checkBox != null) {
            checkBox.destroy();
            checkBox = null;
        }
        if (uncheckBox != null) {
            uncheckBox.destroy();
            uncheckBox = null;
        }
        for (FileImage serializable : this.images.values()) {
            serializable.destroy();
        }
        for (Integer n2 : this.handlesToFree) {
            UserHandles.free(n2);
        }
    }

    public static List getPaperSizeNames() {
        return Arrays.asList(media);
    }

    static {
        media = new String[]{null, "letter", "letter small", "tabloid", "ledger", "legal", "statement", "executive", "a3", "a4", "a4 small", "a5", "b4", "b5", "folio", "quarto", "10x14", "11x17", "note", "envelope #9", "envelope #10", "envelope #11", "envelope #12", "envelope #14", "c", "d", "e", "envelope dl", "envelope c5", "envelope c3", "envelope c4", "envelope c6", "envelope c65", "envelope b4", "envelope b5", "envelope b6", "envelope italy", "envelope monarch", "envelope personal", "us std fanfold", "german std fanfold", "german legal fanfold", "b4", "japanese postcard", "9x11", "10x11", "15x11", "envelope invite"};
        String string = Config.a(".printer.custompaper", null);
        if (string == null) {
            customPaperSize = MediaSize.getMediaSizeForName(MediaSizeName.ISO_A4);
        } else if ((string = string.trim().toLowerCase()).endsWith("mm")) {
            int n2 = -1;
            int n3 = -1;
            StringTokenizer stringTokenizer = new StringTokenizer(string = string.substring(0, string.length() - 2), "x ");
            if (stringTokenizer.hasMoreTokens()) {
                try {
                    n2 = Integer.parseInt(stringTokenizer.nextToken());
                    if (stringTokenizer.hasMoreTokens()) {
                        try {
                            n3 = Integer.parseInt(stringTokenizer.nextToken());
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            customPaperSize = n2 > 0 && n3 > 0 ? new MySize2DSyntax(n2, n3, 1000) : MediaSize.getMediaSizeForName(MediaSizeName.ISO_A4);
        } else {
            StringTokenizer stringTokenizer;
            float f2 = -1.0f;
            float f3 = -1.0f;
            if (string.endsWith("in")) {
                string = string.substring(0, string.length() - 2);
            }
            if ((stringTokenizer = new StringTokenizer(string, "x ")).hasMoreTokens()) {
                try {
                    f2 = Float.parseFloat(stringTokenizer.nextToken());
                    if (stringTokenizer.hasMoreTokens()) {
                        try {
                            f3 = Float.parseFloat(stringTokenizer.nextToken());
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            customPaperSize = f2 > 0.0f && f3 > 0.0f ? new MySize2DSyntax(f2, f3, 25400) : MediaSize.getMediaSizeForName(MediaSizeName.ISO_A4);
        }
    }

    private class Context
    implements Cloneable {
        private Map font = defaultFont;
        private Color color = defaultColor;
        private Color brush = defaultBrush;
        private float _pageTop;
        private float _pageLeft;
        private float _pageWidth;
        private float _pageHeight;
        private String textAlign;
        private String overflow;
        private StringBuffer text = new StringBuffer();
        private CSSStyle style;
        private final String tagName;

        public Context(String string) {
            this.tagName = string;
        }

        public final void setPageTop(float f2) {
            this._pageTop = f2;
        }

        public final float getPageTop() {
            return this._pageTop;
        }

        public final void addPageTop(float f2) {
            this._pageTop += f2;
        }

        public final void setPageLeft(float f2) {
            this._pageLeft = f2;
        }

        public final float getPageLeft() {
            return this._pageLeft;
        }

        public final void addPageLeft(float f2) {
            this._pageLeft += f2;
        }

        public final void setPageHeight(float f2) {
            this._pageHeight = f2;
        }

        public final void setPageWidth(float f2) {
            this._pageWidth = f2;
        }

        public final float getPageWidth() {
            return this._pageWidth;
        }

        public final float getPageHeight() {
            return Drawer.this._topMargin + this._pageHeight;
        }

        Context deepClone(String string) {
            Context context = new Context(string);
            context.font = new HashMap(this.font);
            context.color = this.color;
            context.brush = this.brush;
            context._pageTop = this._pageTop;
            context._pageLeft = this._pageLeft;
            context._pageWidth = this._pageWidth;
            context._pageHeight = this._pageHeight;
            context.textAlign = this.textAlign;
            context.overflow = this.overflow;
            if (this.style != null) {
                context.style = new CSSStyle(this.style);
            }
            return context;
        }

        void setFont(Map map) {
            this.font = map;
        }

        void setColor(Color color) {
            this.color = color;
        }

        void setBrush(Color color) {
            this.brush = color;
        }

        void moveRight(float f2) {
            this.addPageLeft(f2 * 0.75f);
        }

        void setBaselineDown(float f2) {
            Object v2 = this.font.get(TextAttribute.SIZE);
            float f3 = v2 instanceof Float ? ((Float)v2).floatValue() : 12.0f;
            this.addPageTop(f2 * 0.75f - f3);
        }

        void setPrintArea(float f2, float f3, float f4, float f5) {
            if (f2 >= 0.0f) {
                this.addPageLeft(f2 * 0.75f);
            }
            if (f3 >= 0.0f) {
                this.addPageTop(f3 * 0.75f);
            }
            if (f4 > 0.0f) {
                this.setPageWidth(f4 * 0.75f);
            }
            if (f5 > 0.0f) {
                this.setPageHeight(f5 * 0.75f);
            }
        }

        void newPage() {
            this.setPageTop(0.0f);
            this.setPageLeft(0.0f);
        }

        void appendText(char[] cArray, int n2, int n3) {
            this.text.append(cArray, n2, n3);
        }

        void printText() throws IOException {
            int n2 = this.text.length();
            if (n2 > 0) {
                if (this.font != null && !Drawer.areEqual(Drawer.this.currFont, this.font)) {
                    Drawer.this.thePrinter.setFont(this.font);
                    Drawer.this.currFont = this.font;
                }
                if (this.color != null && !this.color.equals(Drawer.this.currColor)) {
                    Drawer.this.thePrinter.setColor(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha());
                    Drawer.this.currColor = this.color;
                }
                char c2 = "right".equals(this.textAlign) ? (char)'R' : ("center".equals(this.textAlign) ? (char)'C' : 'L');
                Drawer.this.thePrinter.printAt(this.text.toString(), this.getPageLeft(), this.getPageTop(), this.getPageWidth(), false, c2, (byte)2, false);
                this.text.delete(0, n2);
            }
        }
    }

    private static class MySize2DSyntax
    extends Size2DSyntax {
        private static final long serialVersionUID = 1L;

        protected MySize2DSyntax(int n2, int n3, int n4) {
            super(n2, n3, n4);
        }

        protected MySize2DSyntax(float f2, float f3, int n2) {
            super(f2, f3, n2);
        }
    }
}

