/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.htmlrenderer;

import com.iscobol.gui.GuiFactory;
import com.iscobol.gui.RemoteIO;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.server.CobolGUIJavaBean;
import com.iscobol.gui.server.FontCmp;
import com.iscobol.htmlrenderer.CSSStyle;
import com.iscobol.htmlrenderer.Drawer;
import com.iscobol.htmlrenderer.SAHParser;
import com.iscobol.preview.PreviewEventsHandler;
import com.iscobol.preview.PreviewEventsImpl;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.print.SpoolPrinter;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HTMLRenderer
extends DefaultHandler {
    public static final int OR_PORTRAIT = 1;
    public static final int OR_LANDSCAPE = 2;
    private static final HashMap nodeTypes = new HashMap();
    private final HashMap styles = new HashMap();
    private final Stack nodeStack = new Stack();
    protected Drawer drawer;
    private String fileName;
    private PreviewEventsImpl events = new PreviewEventsImpl();
    static final String[] usage;

    public HTMLRenderer() {
        try {
            this.drawer = new Drawer(this.events);
        }
        catch (IOException iOException) {
            throw new IscobolRuntimeException(iOException);
        }
    }

    public static InputStream getInputStream(String string) throws IOException {
        if (string.toUpperCase().startsWith("@[DISPLAY]:")) {
            RemoteIO remoteIO = ScreenUtility.getGuiFactory().getRemoteIO();
            remoteIO.openInputFile(string.substring(11));
            int n2 = 8192;
            byte[] byArray = new byte[8192];
            int n3 = 0;
            Object[] objectArray = remoteIO.readFromInputFile(8192);
            while (true) {
                if (objectArray == null) {
                    throw new FileNotFoundException(string);
                }
                if (!(objectArray[0] instanceof byte[])) {
                    throw new IOException(objectArray[0].toString());
                }
                int n4 = Integer.parseInt(objectArray[1].toString());
                if (n4 < 0) break;
                byte[] byArray2 = (byte[])objectArray[0];
                if (n3 + n4 > byArray.length) {
                    byte[] byArray3 = byArray;
                    byArray = new byte[byArray3.length * 2];
                    System.arraycopy(byArray3, 0, byArray, 0, n3);
                }
                System.arraycopy(byArray2, 0, byArray, n3, n4);
                n3 += n4;
                objectArray = remoteIO.readFromInputFile(8192);
            }
            remoteIO.closeFiles();
            return new ByteArrayInputStream(byArray, 0, n3);
        }
        return new FileInputStream(string);
    }

    public int open() {
        try {
            InputStream inputStream = this.fileName != null ? HTMLRenderer.getInputStream(this.fileName) : System.in;
            return this.readFromStream(inputStream);
        }
        catch (IOException iOException) {
            throw new IscobolRuntimeException(iOException);
        }
    }

    public int readFromStream(InputStream inputStream) {
        try {
            new SAHParser(inputStream, null).parse(this);
        }
        catch (IOException iOException) {
            throw new IscobolRuntimeException(iOException);
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() != null) {
                throw new IscobolRuntimeException(sAXException.getException());
            }
            throw new IscobolRuntimeException(sAXException);
        }
        try {
            if (this.drawer != null) {
                this.drawer.close();
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            throw new IscobolRuntimeException(iOException);
        }
        return 0;
    }

    private void drawStartTag(Node node) throws SAXException {
        try {
            this.drawer.startTag(node.name, node.attrs, node.style);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    private void drawEndTag(Node node) throws SAXException {
        try {
            this.drawer.endTag();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Node node;
        Node node2 = (Node)nodeTypes.get(string2);
        node2 = node2 == null ? new Node() : (Node)node2.clone();
        if (this.nodeStack.isEmpty()) {
            node = null;
        } else {
            node = (Node)this.nodeStack.peek();
            node.print(false);
            node.add(node2);
        }
        node2.init(this, string2, node, this.nodeStack.size(), attributes);
        this.nodeStack.push(node2);
        this.drawStartTag(node2);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (!this.nodeStack.isEmpty()) {
            Node node = (Node)this.nodeStack.pop();
            if (!string2.equals(node.getName())) {
                int n2;
                for (n2 = this.nodeStack.size() - 1; n2 >= 0 && !string2.equals(((Node)this.nodeStack.get(n2)).getName()); --n2) {
                }
                if (n2 >= 0) {
                    while (!string2.equals(node.getName())) {
                        node.print(true);
                        this.drawEndTag(node);
                        node = (Node)this.nodeStack.pop();
                    }
                    node.print(true);
                    this.drawEndTag(node);
                } else {
                    this.nodeStack.push(node);
                }
            } else {
                node.print(true);
                this.drawEndTag(node);
            }
        } else {
            throw new SAXException("Empty stack! " + string2);
        }
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        Node node = (Node)this.nodeStack.peek();
        node.add(cArray, n2, n3);
        this.drawer.characters(cArray, n2, n3);
    }

    private void printString(StringBuffer stringBuffer) {
    }

    public boolean setup() {
        try {
            return this.drawer.thePrinter.setup();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void setPrinter(String string) {
        try {
            this.drawer.thePrinter.setPrinter(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setPDF(boolean bl) {
        try {
            this.drawer.thePrinter.setPDF(bl);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setJobName(String string, String string2) {
        try {
            this.drawer.thePrinter.setJobName(string, string2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setPreview(boolean bl) {
        try {
            this.drawer.thePrinter.setPreview(bl);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setCopies(int n2) {
        try {
            this.drawer.thePrinter.setCurrCopies(n2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getCopies() {
        try {
            return this.drawer.thePrinter.getCurrCopies();
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    public void setQuality(int n2) {
        try {
            this.drawer.thePrinter.setQuality(n2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getQuality() {
        try {
            return this.drawer.thePrinter.getQuality();
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    public void setChromacity(int n2) {
        try {
            this.drawer.thePrinter.setChromaticity(n2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getChromacity() {
        try {
            return this.drawer.thePrinter.getChromaticity();
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    public void setCollate(int n2) {
        try {
            this.drawer.thePrinter.setCollate(n2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getCollate() {
        try {
            return this.drawer.thePrinter.getCollate();
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    public void setDuplexPrinting(int n2) {
        try {
            this.drawer.thePrinter.setDuplexPrinting(n2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getDuplexPrinting() {
        try {
            return this.drawer.thePrinter.getDuplexPrinting();
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    public String getPrinterName() {
        try {
            return this.drawer.thePrinter.getPrinterName(this.drawer.thePrinter.getCurrPrinter());
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public void setBrowserParaOrientation(String string, int n2) {
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        if (stringTokenizer.hasMoreTokens()) {
            try {
                n3 = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (stringTokenizer.hasMoreTokens()) {
                try {
                    n4 = Integer.parseInt(stringTokenizer.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    n4 = 0;
                }
                if (stringTokenizer.hasMoreTokens()) {
                    try {
                        n5 = Integer.parseInt(stringTokenizer.nextToken());
                    }
                    catch (NumberFormatException numberFormatException) {
                        n5 = 0;
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        try {
                            n6 = Integer.parseInt(stringTokenizer.nextToken());
                        }
                        catch (NumberFormatException numberFormatException) {
                            n6 = 0;
                        }
                    }
                }
            }
        }
        switch (n2) {
            case 1: {
                this.drawer.setLandscape(false);
                break;
            }
            case 2: {
                int n7 = n5;
                n5 = n4;
                n4 = n6;
                n6 = n3;
                n3 = n7;
                this.drawer.setLandscape(true);
                break;
            }
        }
        if (n6 >= 0 && n3 >= 0) {
            this.drawer.setMargins((double)n3 / 100.0, (double)n4 / 100.0, (double)n5 / 100.0, (double)n6 / 100.0);
        }
    }

    public void setHeaderFooter(String string, String string2) {
        try {
            this.drawer.setHeaderFooter(string, string2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setPaperTitle(String string) {
        this.drawer.setTitle(string);
    }

    public void setPaperUrl(String string) {
        this.fileName = string;
        try {
            this.drawer.setUrl(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getPaperUrl() {
        return this.fileName;
    }

    public void setMargins(double d2, double d3, double d4, double d5) {
        this.drawer.setMargins(d2, d3, d4, d5);
    }

    public void setLandscape(boolean bl) {
        this.drawer.setLandscape(bl);
    }

    public void setCustomPaperSize(float f2, float f3) {
        this.drawer.setCustomPaperSize(f2, f3);
    }

    public void setPaperSize(String string) {
        this.drawer.setPaperSize(string);
    }

    public int getOrientation() {
        if (this.drawer.isLandscape()) {
            return 2;
        }
        return 1;
    }

    public void setPrinterName(String string) {
        try {
            this.drawer.thePrinter.setPrinter(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getPaperName() {
        return this.drawer.getPaperName();
    }

    public String getPaperSize(int n2) {
        return HTMLRenderer.getPaperSize(this.drawer.getPaperSize(n2));
    }

    private static String getPaperSize(float[] fArray) {
        String string = "";
        string = string + HTMLRenderer.fillZero(Math.round(fArray[0] * 100.0f));
        string = string + "|";
        string = string + HTMLRenderer.fillZero(Math.round(fArray[1] * 100.0f));
        return string;
    }

    private static String fillZero(int n2) {
        if (n2 <= 9) {
            return "00000" + n2;
        }
        if (n2 <= 99) {
            return "0000" + n2;
        }
        if (n2 <= 999) {
            return "000" + n2;
        }
        if (n2 <= 9999) {
            return "00" + n2;
        }
        if (n2 <= 99999) {
            return "0" + n2;
        }
        return "" + n2;
    }

    public String getMargins(int n2) {
        return HTMLRenderer.getMargins(this.drawer.getMargins(), this.getOrientation());
    }

    private static String getMargins(int[] nArray, int n2) {
        if (n2 == 1) {
            return HTMLRenderer.fillZero(nArray[0]) + "|" + HTMLRenderer.fillZero(nArray[1]) + "|" + HTMLRenderer.fillZero(nArray[2]) + "|" + HTMLRenderer.fillZero(nArray[3]);
        }
        return HTMLRenderer.fillZero(nArray[3]) + "|" + HTMLRenderer.fillZero(nArray[2]) + "|" + HTMLRenderer.fillZero(nArray[0]) + "|" + HTMLRenderer.fillZero(nArray[1]);
    }

    private static void showHelp() {
        System.out.println("usage: java " + HTMLRenderer.class.getName() + usage[0]);
        for (int i2 = 1; i2 < usage.length; ++i2) {
            System.out.println(usage[i2]);
        }
        System.exit(2);
    }

    private static void invOpt(String string) {
        System.out.println("invalid option: " + string);
        HTMLRenderer.showHelp();
    }

    private static void invPaper(String string) {
        String string2 = "                          ";
        System.out.println("unsupported paper: " + string + ". Supported papers are:");
        for (int i2 = 1; i2 < Drawer.media.length; ++i2) {
            if (i2 % 3 == 0) {
                System.out.println((Drawer.media[i2] + "                          ").substring(0, 26));
                continue;
            }
            System.out.print((Drawer.media[i2] + "                          ").substring(0, 26));
        }
        System.out.println("custom");
        System.exit(3);
    }

    public static void main(String[] stringArray) throws Exception {
        HTMLRenderer.run(stringArray, new HTMLRenderer());
    }

    public static void run(String[] stringArray, HTMLRenderer hTMLRenderer) throws Exception {
        String string = "&w&bPage &p of &P";
        String string2 = "&u&b&d";
        hTMLRenderer.setPreview(true);
        int n2 = 0;
        for (n2 = 0; n2 < stringArray.length && stringArray[n2].startsWith("-"); ++n2) {
            String string3;
            if ("-h".equals(stringArray[n2])) {
                HTMLRenderer.showHelp();
                continue;
            }
            if ("-q".equals(stringArray[n2])) {
                hTMLRenderer.setPreview(false);
                continue;
            }
            if ("-l".equals(stringArray[n2])) {
                hTMLRenderer.drawer.setLandscape(true);
                continue;
            }
            if (stringArray[n2].startsWith("-p")) {
                string3 = null;
                if (stringArray[n2].length() > 2) {
                    string3 = stringArray[n2].substring(2);
                } else if (++n2 < stringArray.length) {
                    string3 = stringArray[n2];
                } else {
                    HTMLRenderer.invPaper("");
                }
                if (!hTMLRenderer.drawer.setPaperSize(string3)) {
                    HTMLRenderer.invPaper(string3);
                    continue;
                }
                System.out.println("paper size=" + hTMLRenderer.getPaperSize(0));
                continue;
            }
            if (stringArray[n2].startsWith("-H")) {
                if (stringArray[n2].length() > 2) {
                    string = stringArray[n2].substring(2);
                    continue;
                }
                if (++n2 < stringArray.length) {
                    string = stringArray[n2];
                    continue;
                }
                HTMLRenderer.invOpt("-H");
                continue;
            }
            if (stringArray[n2].startsWith("-F")) {
                if (stringArray[n2].length() > 2) {
                    string2 = stringArray[n2].substring(2);
                    continue;
                }
                if (++n2 < stringArray.length) {
                    string2 = stringArray[n2];
                    continue;
                }
                HTMLRenderer.invOpt("-F");
                continue;
            }
            if (stringArray[n2].startsWith("-w")) {
                string3 = null;
                if (stringArray[n2].length() > 2) {
                    string3 = stringArray[n2].substring(2);
                } else if (++n2 < stringArray.length) {
                    string3 = stringArray[n2];
                } else {
                    HTMLRenderer.invOpt("-F");
                }
                hTMLRenderer.setPaperTitle(string3);
                continue;
            }
            HTMLRenderer.invOpt(stringArray[n2]);
        }
        if (n2 < stringArray.length) {
            String string4 = stringArray[n2];
            hTMLRenderer.setPaperUrl(string4);
        } else {
            Object var2_7 = null;
            hTMLRenderer.setPaperUrl("(stdin)");
        }
        hTMLRenderer.setHeaderFooter(string, string2);
        hTMLRenderer.open();
        System.exit(0);
    }

    public boolean setup(ICobolVar iCobolVar, ICobolVar iCobolVar2) {
        double[] dArray = this.drawer.setupPrint();
        if (dArray != null && dArray.length == 7) {
            float[] fArray = new float[]{(float)dArray[1], (float)dArray[2]};
            iCobolVar.set(HTMLRenderer.getPaperSize(fArray));
            int[] nArray = new int[]{(int)Math.round(dArray[5] * 100.0), (int)Math.round(dArray[6] * 100.0), (int)Math.round(dArray[3] * 100.0), (int)Math.round(dArray[4] * 100.0)};
            boolean bl = (int)dArray[0] != 1;
            iCobolVar2.set(HTMLRenderer.getMargins(nArray, bl ? 2 : 1));
            if (bl) {
                this.setMargins(dArray[4], dArray[3], dArray[5], dArray[6]);
            } else {
                this.setMargins(dArray[5], dArray[6], dArray[3], dArray[4]);
            }
            this.setLandscape(bl);
            return true;
        }
        return false;
    }

    public static void getFontValue(String string, ICobolVar iCobolVar) {
        FontCmp fontCmp = FontCmp.getStdFont(string, "iscobol.report.font.");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("font-size:");
        stringBuffer.append(Math.round(fontCmp.getSize()));
        stringBuffer.append("pt; font-family:");
        stringBuffer.append(fontCmp.getName());
        stringBuffer.append(";");
        iCobolVar.set(stringBuffer.toString());
    }

    public static void escapeText(ICobolVar iCobolVar, ICobolVar iCobolVar2) {
        HTMLRenderer.escapeText(iCobolVar, iCobolVar2, false);
    }

    public static void escapeText(ICobolVar iCobolVar, ICobolVar iCobolVar2, boolean bl) {
        iCobolVar2.set(HTMLRenderer.escapeText(iCobolVar.toString(), bl));
    }

    private static String escapeText(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        block9: for (int i2 = 0; i2 < cArray.length; ++i2) {
            switch (cArray[i2]) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block9;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block9;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block9;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block9;
                }
                case '\u20ac': {
                    stringBuffer.append("&euro;");
                    continue block9;
                }
                case '\u00a0': {
                    stringBuffer.append("&nbsp;");
                    continue block9;
                }
                case ' ': {
                    if (bl) {
                        stringBuffer.append("&nbsp;");
                        continue block9;
                    }
                    stringBuffer.append(cArray[i2]);
                    continue block9;
                }
                default: {
                    stringBuffer.append(cArray[i2]);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static void getFontFlags(String string, ICobolVar iCobolVar) {
        FontCmp fontCmp = FontCmp.getStdFont(string, "iscobol.report.font.");
        String string2 = "";
        string2 = (fontCmp.getStyle() & 1) == 1 ? string2 + "y" : string2 + "n";
        string2 = (fontCmp.getStyle() & 2) == 2 ? string2 + "y" : string2 + "n";
        iCobolVar.set(string2);
    }

    public static void getRGBValues(ICobolVar iCobolVar, ICobolVar iCobolVar2, ICobolVar iCobolVar3, ICobolVar iCobolVar4, ICobolVar iCobolVar5) {
        int n2;
        GuiFactory guiFactory = ScreenUtility.getGuiFactory();
        if (iCobolVar2 != null) {
            n2 = iCobolVar2.toint();
            if (n2 < 0) {
                iCobolVar5.set(HTMLRenderer.getRgbString(-n2));
            } else {
                HTMLRenderer.getRGBValue(n2, guiFactory, iCobolVar5);
            }
        } else if (iCobolVar != null) {
            HTMLRenderer.getRGBValue(iCobolVar.toint() / 32 - 1, guiFactory, iCobolVar5);
        } else {
            iCobolVar5.setSpace();
        }
        if (iCobolVar3 != null) {
            n2 = iCobolVar3.toint();
            if (n2 < 0) {
                iCobolVar4.set(HTMLRenderer.getRgbString(-n2));
            } else {
                HTMLRenderer.getRGBValue(n2, guiFactory, iCobolVar4);
            }
        } else if (iCobolVar != null) {
            HTMLRenderer.getRGBValue(iCobolVar.toint() % 32 - 1, guiFactory, iCobolVar4);
        } else {
            iCobolVar4.setSpace();
        }
    }

    public static void getRGBValues(ICobolVar iCobolVar, ICobolVar iCobolVar2, ICobolVar iCobolVar3) {
        GuiFactory guiFactory = ScreenUtility.getGuiFactory();
        int n2 = iCobolVar.toint();
        HTMLRenderer.getRGBValue(n2 / 32 - 1, guiFactory, iCobolVar3);
        HTMLRenderer.getRGBValue(n2 % 32 - 1, guiFactory, iCobolVar2);
    }

    private static void getRGBValue(int n2, GuiFactory guiFactory, ICobolVar iCobolVar) {
        Color color = null;
        if (n2 >= 0) {
            try {
                color = guiFactory.getColor(n2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (color != null) {
            iCobolVar.set(HTMLRenderer.getRgbString(color.getRGB()));
        } else {
            iCobolVar.setSpace();
        }
    }

    private static String getRgbString(int n2) {
        String string = Integer.toHexString(n2 & 0xFFFFFF);
        StringBuffer stringBuffer = new StringBuffer("#");
        int n3 = 6 - string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static void getCurrentDate(String string, ICobolVar iCobolVar) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        iCobolVar.set(simpleDateFormat.format(Calendar.getInstance().getTime()));
    }

    public static int inchToPixel(float f2) {
        return Math.round(f2 * 96.0f);
    }

    public void addMenu(String string, String string2, ImageIcon imageIcon, int n2, PreviewEventsHandler previewEventsHandler) {
        CobolGUIJavaBean.callStaticMethod(SpoolPrinter.class.getName(), "addMenu", new Object[]{string, string2, imageIcon, new Integer(n2)});
        this.events.addEventHandler(n2, previewEventsHandler);
    }

    public void removeMenu(String string) {
        CobolGUIJavaBean.callStaticMethod(SpoolPrinter.class.getName(), "removeMenu", new Object[]{string});
    }

    static {
        nodeTypes.put("style", new NodeStyle());
        usage = new String[]{" [-h|-l|-q|-p papername] [filename]", "        -h   prints this help", "        -l   set the orientation landscape (default=portrait)", "        -p   set the paper sheet size (default=a4)", "        -q   prints directly without preview", "        -w   set the title", "        -H   set the header", "        -F   set the footer"};
    }

    private static class NodeStyle
    extends Node {
        private NodeStyle() {
        }

        @Override
        protected void print(boolean bl) {
            int n2;
            this.printStart();
            int n3 = this.content.size();
            StringBuffer stringBuffer = new StringBuffer();
            for (n2 = 0; n2 < n3; ++n2) {
                Object e2 = this.content.get(n2);
                if (e2 instanceof Node) continue;
                stringBuffer.append(e2.toString());
            }
            int n4 = stringBuffer.length();
            for (int i2 = 0; i2 < n4; ++i2) {
                n2 = stringBuffer.charAt(i2);
                if (n2 <= 32) continue;
                CSSStyle cSSStyle = new CSSStyle(stringBuffer, i2);
                try {
                    i2 = cSSStyle.parse();
                    this.main.styles.put(cSSStyle.getName(), cSSStyle);
                    continue;
                }
                catch (CSSStyle.BadFormatException badFormatException) {
                    badFormatException.printStackTrace();
                }
            }
            this.content.clear();
            if (!this.ended) {
                StringBuffer stringBuffer2 = new StringBuffer("<!--debug-->");
                Iterator iterator = this.main.styles.keySet().iterator();
                while (iterator.hasNext()) {
                    stringBuffer2.append(this.main.styles.get(iterator.next()).toString());
                    stringBuffer2.append("\n");
                }
                this.main.printString(stringBuffer2);
                this.printEnd(bl);
            }
        }
    }

    private static class Node
    implements Cloneable {
        protected HTMLRenderer main;
        protected String name;
        protected int level;
        protected Attributes attrs;
        protected boolean started;
        protected boolean ended;
        protected boolean containsNode;
        protected ArrayList content;
        protected CSSStyle style;

        private Node() {
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public String getName() {
            return this.name;
        }

        void init(HTMLRenderer hTMLRenderer, String string, Node node, int n2, Attributes attributes) {
            int n3;
            this.content = new ArrayList();
            this.name = string;
            this.main = hTMLRenderer;
            this.level = n2;
            this.attrs = attributes;
            if (this.attrs != null && (n3 = this.attrs.getLength()) > 0) {
                Object object;
                String string2;
                int n4;
                for (n4 = 0; n4 < n3; ++n4) {
                    string2 = this.attrs.getLocalName(n4);
                    if (!"style".equals(string2)) continue;
                    object = this.attrs.getValue(n4);
                    this.style = new CSSStyle((String)object);
                    try {
                        this.style.parse();
                    }
                    catch (CSSStyle.BadFormatException badFormatException) {
                        badFormatException.printStackTrace();
                    }
                    break;
                }
                for (n4 = 0; n4 < n3; ++n4) {
                    string2 = this.attrs.getLocalName(n4);
                    if (!"class".equals(string2)) continue;
                    if (this.style == null) {
                        this.style = new CSSStyle("");
                    }
                    object = new StringTokenizer(this.attrs.getValue(n4));
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        this.style.mixUp((CSSStyle)this.main.styles.get(((StringTokenizer)object).nextToken().toLowerCase()));
                    }
                    break;
                }
            }
        }

        final void add(Node node) {
            this.content.add(node);
            this.containsNode = true;
        }

        final void add(char[] cArray, int n2, int n3) {
            Object e2;
            int n4 = this.content.size();
            if (n4 > 0 && (e2 = this.content.get(n4 - 1)) instanceof StringBuffer) {
                ((StringBuffer)e2).append(cArray, n2, n3);
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(cArray, n2, n3);
                this.content.add(stringBuffer);
            }
        }

        protected void printIndent(StringBuffer stringBuffer) {
            for (int i2 = 0; i2 < this.level; ++i2) {
                stringBuffer.append(' ');
            }
        }

        protected void printStart() {
            if (!this.started) {
                int n2;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append('\n');
                this.printIndent(stringBuffer);
                stringBuffer.append('<');
                stringBuffer.append(this.name);
                if (this.style != null) {
                    stringBuffer.append(' ');
                    stringBuffer.append("style=\"");
                    stringBuffer.append(this.style.getContent());
                    stringBuffer.append('\"');
                }
                if (this.attrs != null && (n2 = this.attrs.getLength()) > 0) {
                    for (int i2 = 0; i2 < n2; ++i2) {
                        String string = this.attrs.getLocalName(i2);
                        if ("class".equals(string) || "style".equals(string)) continue;
                        stringBuffer.append(' ');
                        stringBuffer.append(this.attrs.getLocalName(i2));
                        stringBuffer.append('=');
                        stringBuffer.append('\"');
                        stringBuffer.append(this.attrs.getValue(i2));
                        stringBuffer.append('\"');
                    }
                }
                stringBuffer.append('>');
                this.main.printString(stringBuffer);
                this.started = true;
            }
        }

        protected final void printEnd(boolean bl) {
            if (bl && !this.ended) {
                StringBuffer stringBuffer = new StringBuffer();
                if (this.containsNode) {
                    stringBuffer.append('\n');
                    this.printIndent(stringBuffer);
                }
                stringBuffer.append('<');
                stringBuffer.append('/');
                stringBuffer.append(this.name);
                stringBuffer.append('>');
                stringBuffer.append('\n');
                this.main.printString(stringBuffer);
                this.ended = true;
            }
        }

        protected void print(boolean bl) {
            this.printStart();
            int n2 = this.content.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Object e2 = this.content.get(i2);
                if (e2 instanceof Node) {
                    ((Node)e2).print(true);
                    continue;
                }
                this.main.printString((StringBuffer)e2);
            }
            this.printEnd(bl);
            this.content.clear();
        }

        public String toString() {
            return "<" + this.name + ">";
        }
    }
}

