/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.htmlrenderer;

import com.iscobol.htmlrenderer.Source;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SAHParser {
    private static final char[][] escapeAmpSequences = new char[][]{{'e', 'u', 'r', 'o', '\u20ac'}, {'g', 't', '>'}, {'l', 't', '<'}, {'a', 'm', 'p', '&'}, {'q', 'u', 'o', 't', '\"'}, {'n', 'b', 's', 'p', '\u00a0'}, {'?'}};
    private final Source input;

    private static char getEscapedChar(char[] cArray, int n2) {
        for (int i2 = 0; i2 < escapeAmpSequences.length; ++i2) {
            int n3;
            if (n2 != escapeAmpSequences[i2].length - 1) continue;
            for (n3 = 0; n3 < n2 && escapeAmpSequences[i2][n3] == cArray[n3]; ++n3) {
            }
            if (n3 != n2) continue;
            return escapeAmpSequences[i2][n3];
        }
        return escapeAmpSequences[escapeAmpSequences.length - 1][0];
    }

    public SAHParser(InputStream inputStream, String string) {
        this.input = new Source(inputStream);
    }

    void skipSpaces() throws IOException {
        int n2;
        while ((n2 = this.input.getChar()) <= 32 && n2 >= 0) {
        }
        this.input.ungetChar((char)n2);
    }

    private int flushBuffer(DefaultHandler defaultHandler, char[] cArray, int n2) throws SAXException {
        int n3;
        if (n2 > 0) {
            if (cArray[n2 - 1] <= ' ') {
                if (n2 > 1) {
                    defaultHandler.characters(cArray, 0, n2 - 1);
                }
                cArray[0] = 32;
                n3 = 1;
            } else {
                if (n2 > 1 || n2 == 1 && cArray[0] > ' ') {
                    defaultHandler.characters(cArray, 0, n2);
                }
                n3 = 0;
            }
        } else {
            n3 = 0;
        }
        return n3;
    }

    public void parse(DefaultHandler defaultHandler) throws SAXException, IOException {
        int n2;
        char[] cArray = new char[10];
        char[] cArray2 = new char[1024];
        int n3 = 0;
        this.skipSpaces();
        block4: while ((n2 = this.input.getChar()) >= 0) {
            if (n3 == cArray2.length) {
                n3 = this.flushBuffer(defaultHandler, cArray2, n3);
            }
            switch (n2) {
                case 60: {
                    Tag tag = new Tag();
                    if (!tag.isValid() || defaultHandler == null) continue block4;
                    if (tag.isOpen()) {
                        defaultHandler.startElement("", tag.name.toString(), tag.name.toString(), tag.attrs);
                    }
                    if (n3 > 0) {
                        n3 = this.flushBuffer(defaultHandler, cArray2, n3);
                    }
                    if (tag.isClosed()) {
                        defaultHandler.endElement("", tag.name.toString(), tag.name.toString());
                    }
                    if (!tag.isOpen()) continue block4;
                    n3 = 0;
                    continue block4;
                }
                case 38: {
                    n2 = this.input.getChar();
                    if (n2 > 32) {
                        int n4;
                        cArray[0] = (char)n2;
                        for (n4 = 1; (n2 = this.input.getChar()) != 59 && n2 > 32 && n4 < cArray.length; ++n4) {
                            cArray[n4] = (char)n2;
                        }
                        cArray2[n3++] = SAHParser.getEscapedChar(cArray, n4);
                        continue block4;
                    }
                    this.input.ungetChar(n2);
                    n2 = 38;
                }
            }
            if (n2 <= 32) {
                if (n3 == 0 || cArray2[n3 - 1] > ' ') {
                    cArray2[n3++] = 32;
                }
                this.skipSpaces();
                continue;
            }
            cArray2[n3++] = (char)n2;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        InputStream inputStream = stringArray.length > 0 ? new FileInputStream(stringArray[0]) : System.in;
        new SAHParser(inputStream, null).parse(new DefaultHandler(){

            @Override
            public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                System.out.println("Tag=" + string2);
                int n2 = attributes.getLength();
                for (int i2 = 0; i2 < n2; ++i2) {
                    System.out.println("localName=" + attributes.getLocalName(i2) + ", value=\"" + attributes.getValue(i2) + '\"');
                }
            }

            @Override
            public void characters(char[] cArray, int n2, int n3) throws SAXException {
                System.out.println("[" + new String(cArray, n2, n3) + "]");
            }

            @Override
            public void endElement(String string, String string2, String string3) {
                System.out.println("/" + string2);
            }
        });
    }

    class Tag {
        private StringBuffer name = new StringBuffer();
        AttributesImpl attrs = new AttributesImpl();
        private boolean valid;
        private boolean open;
        private boolean closed;

        Tag() throws IOException {
            int n2 = SAHParser.this.input.getChar();
            if (n2 == 33) {
                this.name.append((char)n2);
                n2 = SAHParser.this.input.getChar();
                if (n2 == 45) {
                    this.name.append((char)n2);
                    n2 = SAHParser.this.input.getChar();
                    if (n2 == 45) {
                        this.name.append((char)n2);
                        while ((n2 = SAHParser.this.input.getChar()) >= 0) {
                            if (n2 == 45) {
                                this.name.append((char)n2);
                                int n3 = 1;
                                while ((n2 = SAHParser.this.input.getChar()) == 45) {
                                    this.name.append((char)n2);
                                    ++n3;
                                }
                                if (n3 > 1 && n2 == 62) {
                                    this.name.append((char)n2);
                                    break;
                                }
                                SAHParser.this.input.ungetChar(n2);
                                continue;
                            }
                            this.name.append((char)n2);
                        }
                    } else {
                        SAHParser.this.input.ungetChar(n2);
                        this.skipToAngular(this.name);
                    }
                } else {
                    SAHParser.this.input.ungetChar(n2);
                    this.skipToAngular(this.name);
                }
            } else {
                this.valid = true;
                if (n2 == 47) {
                    this.open = false;
                    this.closed = true;
                } else {
                    this.open = true;
                    this.closed = false;
                    SAHParser.this.input.ungetChar(n2);
                }
                this.fillTag();
            }
        }

        private void skipToAngular(StringBuffer stringBuffer) throws IOException {
            int n2;
            while ((n2 = SAHParser.this.input.getChar()) >= 0 && n2 != 62) {
                stringBuffer.append((char)n2);
            }
        }

        private void getKey(StringBuffer stringBuffer) throws IOException {
            int n2 = SAHParser.this.input.getChar();
            if (n2 > 32 && n2 != 61 && n2 != 62) {
                stringBuffer.append(Character.toLowerCase((char)n2));
                while ((n2 = SAHParser.this.input.getChar()) > 32 && n2 != 61 && n2 != 62) {
                    stringBuffer.append(Character.toLowerCase((char)n2));
                }
                SAHParser.this.input.ungetChar(n2);
            }
        }

        private void getValue(StringBuffer stringBuffer) throws IOException {
            int n2 = SAHParser.this.input.getChar();
            if (n2 > 32 && n2 != 62) {
                if (n2 == 39 || n2 == 34) {
                    int n3 = n2;
                    while ((n2 = SAHParser.this.input.getChar()) >= 0 && n2 != n3) {
                        stringBuffer.append((char)n2);
                    }
                } else {
                    stringBuffer.append(Character.toLowerCase((char)n2));
                    while ((n2 = SAHParser.this.input.getChar()) > 32 && n2 != 62) {
                        stringBuffer.append(Character.toLowerCase((char)n2));
                    }
                    SAHParser.this.input.ungetChar(n2);
                }
            }
        }

        private void fillTag() throws IOException {
            this.getKey(this.name);
            if (this.closed) {
                int n2;
                while ((n2 = SAHParser.this.input.getChar()) >= 0 && n2 != 62) {
                }
            } else {
                SAHParser.this.skipSpaces();
                int n3 = SAHParser.this.input.getChar();
                while (n3 >= 0 && n3 != 62) {
                    this.closed = false;
                    SAHParser.this.input.ungetChar(n3);
                    StringBuffer stringBuffer = new StringBuffer();
                    this.getKey(stringBuffer);
                    n3 = SAHParser.this.input.getChar();
                    if (n3 == 61) {
                        StringBuffer stringBuffer2 = new StringBuffer();
                        this.getValue(stringBuffer2);
                        if (stringBuffer2.length() > 0) {
                            this.attrs.add("", stringBuffer.toString(), null, "CDATA", stringBuffer2.toString());
                        } else {
                            this.attrs.add("", stringBuffer.toString(), null, "CDATA", null);
                        }
                    } else if (n3 == 62) {
                        if ("/".equals(stringBuffer.toString())) {
                            this.closed = true;
                        } else {
                            this.attrs.add("", stringBuffer.toString(), null, "CDATA", null);
                        }
                        SAHParser.this.input.ungetChar(n3);
                    } else {
                        this.attrs.add("", stringBuffer.toString(), null, "CDATA", null);
                        SAHParser.this.input.ungetChar(n3);
                    }
                    SAHParser.this.skipSpaces();
                    n3 = SAHParser.this.input.getChar();
                }
            }
        }

        boolean isValid() {
            return this.valid;
        }

        boolean isOpen() {
            return this.open;
        }

        boolean isClosed() {
            return this.closed;
        }

        public String toString() {
            if (this.closed) {
                if (this.open) {
                    return "<" + this.name + "/>";
                }
                return "</" + this.name + ">";
            }
            return "<" + this.name + ">";
        }
    }

    private static class AttributesImpl
    implements Attributes {
        ArrayList content = new ArrayList();

        private AttributesImpl() {
        }

        void add(String string, String string2, String string3, String string4, String string5) {
            if (string3 == null) {
                string3 = string2;
            }
            if (string5 == null) {
                string5 = string2;
            }
            this.content.add(new Attrs(string, string2, string3, string4, string5));
        }

        @Override
        public int getLength() {
            return this.content.size();
        }

        @Override
        public String getURI(int n2) {
            return "";
        }

        @Override
        public String getLocalName(int n2) {
            return ((Attrs)this.content.get((int)n2)).localName;
        }

        @Override
        public String getQName(int n2) {
            return ((Attrs)this.content.get((int)n2)).qName;
        }

        @Override
        public String getType(int n2) {
            return ((Attrs)this.content.get((int)n2)).type;
        }

        @Override
        public String getValue(int n2) {
            return ((Attrs)this.content.get((int)n2)).value;
        }

        @Override
        public int getIndex(String string, String string2) {
            int n2 = this.getLength();
            for (int i2 = 0; i2 < n2; ++i2) {
                Attrs attrs = (Attrs)this.content.get(i2);
                if (!string.equals(attrs.uri) || !string2.equals(attrs.localName)) continue;
                return i2;
            }
            return -1;
        }

        @Override
        public int getIndex(String string) {
            int n2 = this.getLength();
            for (int i2 = 0; i2 < n2; ++i2) {
                Attrs attrs = (Attrs)this.content.get(i2);
                if (!string.equals(attrs.qName)) continue;
                return i2;
            }
            return -1;
        }

        @Override
        public String getType(String string, String string2) {
            int n2 = this.getIndex(string, string2);
            if (n2 >= 0) {
                return this.getType(n2);
            }
            return null;
        }

        @Override
        public String getType(String string) {
            int n2 = this.getIndex(string);
            if (n2 >= 0) {
                return this.getType(n2);
            }
            return null;
        }

        @Override
        public String getValue(String string, String string2) {
            int n2 = this.getIndex(string, string2);
            if (n2 >= 0) {
                return this.getValue(n2);
            }
            return null;
        }

        @Override
        public String getValue(String string) {
            int n2 = this.getIndex(string);
            if (n2 >= 0) {
                return this.getValue(n2);
            }
            return null;
        }

        private static class Attrs {
            final String uri;
            final String localName;
            final String qName;
            final String type;
            final String value;

            Attrs(String string, String string2, String string3, String string4, String string5) {
                this.uri = string;
                this.localName = string2;
                this.qName = string3;
                this.type = string4;
                this.value = string5;
            }
        }
    }
}

