/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.io.AtEndException;
import com.iscobol.io.CobolFile;
import com.iscobol.io.CobolIOException;
import com.iscobol.io.DataPickPut;
import com.iscobol.io.DynamicVConnector;
import com.iscobol.io.DynamicVision;
import com.iscobol.io.FileTypeManager;
import com.iscobol.io.IndexFile;
import com.iscobol.io.InvalidKeyException;
import com.iscobol.io.LineSequentialDFile;
import com.iscobol.io.PathTokenizer;
import com.iscobol.io.RelativeDFile;
import com.iscobol.io.SequentialDFile;
import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.Config;
import com.iscobol.rts.ContextEnv;
import com.iscobol.rts.Factory;
import com.iscobol.rts.FactoryData;
import com.iscobol.rts.FuzzyRegexp;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.INumericVar;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.rts.print.LocalSpoolPrinter;
import com.iscobol.types.CobolVar;
import com.iscobol.types.NumericVar;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public abstract class BaseFile
implements CobolFile,
RuntimeErrorsNumbers {
    public static final boolean acu_compat = Config.b(".properties.acu_compat", false);
    public static final boolean input_nolock = Config.b(".file.input_nolock", true);
    protected int accessMode;
    protected final InvalidKeyException invNoRec;
    protected final InvalidKeyException invDupl;
    protected final AtEndException atEnd;
    protected final String name;
    private ICobolVar buffer;
    private int maxRecordLen;
    private int minRecordLen;
    private String intFileStatus;
    private String extendedStatus;
    private String statusMessage;
    private boolean optional;
    private int openMode = 0;
    private CobolIOException lastException;
    private int lastOp;
    private String osPath;
    private boolean closeLock;
    private int fileType;
    private int openLock;
    private Logger log;
    private int compressionFactor = 0;
    protected boolean lockAutomatic;
    protected boolean assignExt;
    protected int lockMask;
    protected WhileLike whileLike;
    private DataPickPut pickPut = DataPickPut.get();
    protected int numPath = 0;
    protected boolean isfSet = false;
    protected LocalSpoolPrinter.QPrinterAttrs printerAttrs;

    private static MyProperties get() {
        MyProperties myProperties = (MyProperties)IscobolSystem.get(MyProperties.class);
        if (myProperties == null) {
            myProperties = new MyProperties();
            IscobolSystem.set(MyProperties.class, myProperties);
        }
        return myProperties;
    }

    private static String getVar(String string, Set set) {
        if (string.equals(".")) {
            return string;
        }
        String string2 = Config.a(("." + string).toLowerCase(), null);
        if (string2 == null || set.contains(string2)) {
            return string;
        }
        set.add(string2);
        return BaseFile.getVar(string2, set);
    }

    private static String getVar(String string) {
        if (string.equals(".")) {
            return string;
        }
        String string2 = Config.a(("." + string).toLowerCase().replace('-', '_'), null);
        if (acu_compat && string2 != null) {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(string);
            hashSet.add(string2);
            return BaseFile.getVar(string2, hashSet);
        }
        return string2;
    }

    private static String getItemN(String string, boolean bl) throws VarNotFoundException {
        if (string.charAt(0) == '$') {
            String string2 = "";
            string = string.substring(1);
            string2 = !Config.b(".file.env_toupper", true) ? System.getenv(string.substring(1)) : Config.a("." + string.toLowerCase(), (String)null);
            if (string2 != null) {
                return string2;
            }
            if (bl) {
                throw new VarNotFoundException();
            }
            return string;
        }
        return string;
    }

    private static String getItem1(String string, String string2, boolean bl) throws VarNotFoundException {
        String string3;
        if (string.length() > 0 && string.charAt(0) == '$') {
            if (!Config.b(".file.env_toupper", true)) {
                string3 = System.getenv(string2 + string.substring(1));
            } else {
                string3 = BaseFile.getVar(string2 + string.substring(1));
                if (string3 == null) {
                    string3 = BaseFile.getVar(string.substring(1));
                }
            }
        } else {
            string3 = !Config.b(".file.env_toupper", true) ? System.getenv(string2 + string) : BaseFile.getVar(string2 + string);
        }
        if (string3 != null) {
            return string3;
        }
        if (bl) {
            throw new VarNotFoundException();
        }
        return string;
    }

    public static String expandFileName(String string) {
        try {
            return BaseFile.expandFileName(string, false);
        }
        catch (VarNotFoundException varNotFoundException) {
            return string;
        }
    }

    private static String expandFileName(String string, boolean bl) throws VarNotFoundException {
        char c2 = File.separatorChar;
        String string2 = Config.a(".file.env_naming_prefix", ".file.env_naming.prefix", "");
        if (Config.b(".file.env_naming", false) && (Config.b(".file.acu_compat", false) || string.indexOf(c2) >= 0) && Config.a("." + string.toLowerCase(), "").length() != 0) {
            return Config.a("." + string.toLowerCase(), string);
        }
        if (string.indexOf(c2) >= 0) {
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.separator, true);
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (File.separator.equals(string3)) {
                    stringBuffer.append(string3);
                } else if (n2 == 0) {
                    stringBuffer.append(BaseFile.getItem1(string3, string2, bl));
                } else {
                    stringBuffer.append(BaseFile.getItemN(string3, bl));
                }
                ++n2;
            }
            return stringBuffer.toString();
        }
        String string4 = BaseFile.getItem1(string, string2, bl);
        return string4;
    }

    public static boolean isIndexFile(BaseFile baseFile) {
        return baseFile != null && baseFile.getClass().getName().equals("com.iscobol.io.IndexFile");
    }

    public static String[] getFilePrefix(int n2) {
        String string = "";
        MyProperties myProperties = BaseFile.get();
        BaseFile baseFile = myProperties.getFd().getTdd().lastUsedFile;
        string = baseFile instanceof IndexFile ? (baseFile instanceof RelativeDFile ? Config.a(".file.relative_file_prefix", ".relative_file_prefix", "").trim() : (baseFile instanceof SequentialDFile || baseFile instanceof LineSequentialDFile ? Config.a(".file.sequential_file_prefix", ".sequential_file_prefix", "").trim() : Config.a(".file.indexed_file_prefix", ".indexed_file_prefix", "").trim())) : (n2 == 32 ? Config.a(".file.binary_file_prefix", ".binary_file_prefix", "").trim() : Config.a(".file.sequential_file_prefix", ".sequential_file_prefix", "").trim());
        if (string.equals("")) {
            string = Config.a(".file.prefix", ".file_prefix", "").trim();
        }
        if (!string.equals(myProperties.filePrefixDesc)) {
            myProperties.filePrefixDesc = string;
            char c2 = '\n';
            if (string.length() > 0) {
                if (string.toLowerCase().startsWith("isf://") || string.toLowerCase().startsWith("@") || string.toLowerCase().contains(" @") || string.toLowerCase().contains(" isf://") || string.contains(c2 + "isf://") || string.contains(c2 + "@")) {
                    MyProperties.access$102(myProperties, string.split("" + c2));
                } else {
                    PathTokenizer pathTokenizer = new PathTokenizer(string);
                    int n3 = pathTokenizer.countTokens();
                    if (n3 > 0) {
                        MyProperties.access$102(myProperties, new String[n3]);
                        for (int i2 = 0; i2 < n3; ++i2) {
                            ((MyProperties)myProperties).filePrefixArray[i2] = pathTokenizer.nextToken();
                        }
                    }
                }
            } else {
                MyProperties.access$102(myProperties, null);
            }
        }
        return myProperties.filePrefixArray;
    }

    public static String[] getFullPaths(String string, int[] nArray) {
        return BaseFile.getFullPaths(string, nArray, null);
    }

    public static String[] getFullPaths(String string, int[] nArray, BaseFile baseFile) {
        String[] stringArray;
        String string2;
        char c2;
        String string3 = string.toString().trim();
        if (string3.length() > 0 && string3.charAt(0) == '\"' && string3.charAt(string3.length() - 1) == '\"') {
            string3 = string3.substring(1, string3.length() - 1);
        }
        String string4 = "";
        if (string3.length() > 0 && string3.replace('\\', '/').charAt(0) != '/' && string3.replace('\\', '/').contains("/")) {
            String string5 = string3.replace('\\', '/').substring(0, string3.replace('\\', '/').indexOf("/"));
            if (ContextEnv.get().getProperty("dd_" + string5) != null) {
                string3 = string3.replace(string5, ContextEnv.get().getProperty("dd_" + string5));
                return new String[]{string3};
            }
        }
        if (Config.b(".file.env_naming", false)) {
            string3 = BaseFile.expandFileName(string3);
        } else if (string3.length() > 3 && string3.charAt(0) == '-' && string3.charAt(2) == ' ') {
            switch (string3.charAt(1)) {
                case 'E': 
                case 'e': {
                    string3 = Config.a("." + string3.substring(3).trim().toLowerCase(), "");
                }
            }
        }
        String string6 = Config.a(".file.prefix_separator", ".file_prefix.separator", File.separator).trim();
        String string7 = com.iscobol.rts.File.getcwd(string6);
        if ("PRINTER?".equalsIgnoreCase(string3)) {
            nArray[0] = 17;
            return new String[]{string3};
        }
        if (string3.length() > 3 && string3.charAt(2) == ' ' && ((c2 = string3.charAt(0)) == '-' || c2 == '+')) {
            nArray[0] = c2 == '+' ? 32 : 16;
            switch (string3.charAt(1)) {
                case 'F': 
                case 'f': {
                    nArray[0] = nArray[0] | 0;
                    string3 = string3.substring(3).trim();
                    if (BaseFile.isAbsolutePath(string3)) {
                        return new String[]{string3};
                    }
                    return new String[]{string7 + string3};
                }
                case 'Q': 
                case 'q': {
                    LocalSpoolPrinter.QPrinterAttrs qPrinterAttrs = LocalSpoolPrinter.handleDashQPrinter(string3.substring(3).trim());
                    string3 = qPrinterAttrs.direct ? "-p spooler-direct" : "-p spooler";
                    if (baseFile != null) {
                        baseFile.printerAttrs = qPrinterAttrs;
                    }
                }
                case 'P': 
                case 'p': {
                    nArray[0] = nArray[0] | 1;
                    return new String[]{string3};
                }
                case 'S': 
                case 's': {
                    string2 = string3.substring(1);
                    if (string2.equalsIgnoreCase("s in")) {
                        nArray[0] = nArray[0] | 2;
                        return new String[]{string3};
                    }
                    if (string2.equalsIgnoreCase("s out")) {
                        nArray[0] = nArray[0] | 3;
                        return new String[]{string3};
                    }
                    if (!string2.equalsIgnoreCase("s err")) break;
                    nArray[0] = nArray[0] | 4;
                    return new String[]{string3};
                }
            }
        }
        if ((string4 = Config.a(".file.case", string4)).length() > 0) {
            if (string4.charAt(0) == 'L' || string4.charAt(0) == 'l') {
                string3 = string3.toLowerCase();
            } else if (string4.charAt(0) == 'U' || string4.charAt(0) == 'u') {
                string3 = string3.toUpperCase();
            }
        }
        String[] stringArray2 = BaseFile.getFilePrefix(nArray[0]);
        nArray[0] = 0;
        String string8 = string2 = string3.indexOf(46) == -1 ? BaseFile.getFileSuffix() : "";
        if (stringArray2 != null && stringArray2.length > 0 && (BaseFile.getApplyFilePath() || !BaseFile.isAbsolutePath(string3))) {
            stringArray = new String[stringArray2.length];
            for (int i2 = 0; i2 < stringArray2.length; ++i2) {
                if (BaseFile.isAbsolutePath(stringArray2[i2])) {
                    if (stringArray2[i2].endsWith(string6)) {
                        stringArray[i2] = stringArray2[i2] + string3 + string2;
                        continue;
                    }
                    stringArray[i2] = stringArray2[i2] + string6 + string3 + string2;
                    continue;
                }
                stringArray[i2] = string7 + stringArray2[i2] + string6 + string3 + string2;
            }
        } else {
            stringArray = BaseFile.isAbsolutePath(string3) ? new String[]{string3 + string2} : new String[]{string7 + string3 + string2};
        }
        return stringArray;
    }

    private static boolean getApplyFilePath() {
        return Config.a(".file.apply_file_path", ".apply_file_path", false);
    }

    private static boolean getIoCreates() {
        return Config.a(".file.io_creates", ".io_creates", false);
    }

    private static boolean getExtendCreates() {
        return Config.a(".file.extend_creates", ".extend_creates", false);
    }

    private static String getFileSuffix() {
        String string = Config.a(".file.suffix", ".file_suffix", null);
        if (string == null || string.length() == 0) {
            return "";
        }
        return "." + string;
    }

    public BaseFile(String string, int n2, ICobolVar iCobolVar, int n3, boolean bl, int n4) {
        this.name = string;
        this.invNoRec = new InvalidKeyException(111, "", this, 8);
        this.invDupl = new InvalidKeyException(100, "", this, 3);
        this.atEnd = new AtEndException(this, 6);
        this.init(string, n2, iCobolVar, n3, bl, n4);
    }

    private void init(String string, int n2, ICobolVar iCobolVar, int n3, boolean bl, int n4) {
        this.buffer = iCobolVar.getIParent() != null ? iCobolVar.getIParent() : iCobolVar;
        this.maxRecordLen = n2 > 0 ? n2 : this.buffer.getMemoryLength();
        this.minRecordLen = n3 > 0 ? n3 : this.maxRecordLen;
        this.intFileStatus = "00";
        this.extendedStatus = "00";
        this.statusMessage = "";
        this.optional = bl;
        this.closeLock = false;
        this.accessMode = n4;
    }

    private void initOperation(int n2) {
        this.intFileStatus = "00";
        this.extendedStatus = "00";
        this.statusMessage = "";
        ((MyProperties)BaseFile.get()).fd.getTdd().lastUsedFile = this;
        this.lastException = null;
        this.lastOp = n2;
    }

    private void initOperation(int n2, boolean bl) {
        this.initOperation(n2);
        if (bl) {
            this.lastOp |= 0x100;
        }
    }

    protected static boolean isAbsolutePath(String string) {
        return string.indexOf(":/") >= 0 || com.iscobol.rts.File.isAbsolute(string, new File(string));
    }

    @Override
    public String getOsPath() {
        return this.osPath;
    }

    @Override
    public Logger getLogger() {
        return this.log;
    }

    protected abstract void peerOpen(String var1, int var2, int var3);

    protected abstract void peerClose(int var1);

    private void myPeerOpen(String string, int n2, int n3) {
        this.osPath = string;
        this.openLock = n3;
        this.peerOpen(string, n2, n3);
    }

    @Override
    public boolean isMultilock() {
        return (this.openLock & 0x100) != 0;
    }

    @Override
    public Object getResourceUniqueId() {
        return this.osPath;
    }

    protected final int getFileType() {
        return this.fileType & 0xF;
    }

    protected final boolean isBinary() {
        return (this.fileType & 0x20) > 0;
    }

    @Override
    public final void open(CobolVar cobolVar, int n2, int n3) {
        this.open((ICobolVar)cobolVar, n2, n3);
    }

    @Override
    public final void open(ICobolVar iCobolVar, int n2, int n3) {
        int n4;
        int n5;
        CharSequence charSequence;
        this.log = LoggerFactory.get(8);
        if (this.log != null) {
            charSequence = new StringBuffer("OPEN:");
            ((StringBuffer)charSequence).append(this.name);
            ((StringBuffer)charSequence).append(", ");
            ((StringBuffer)charSequence).append(OPEN[n2]);
            ((StringBuffer)charSequence).append(", lock=");
            ((StringBuffer)charSequence).append(LOCK[n3 & 7]);
            if ((n3 & 0x80) != 0) {
                ((StringBuffer)charSequence).append(", AUTOMATIC");
            }
            if ((n3 & 0x100) != 0) {
                ((StringBuffer)charSequence).append(", MULTI");
            }
            if ((n3 & 0x200) != 0) {
                ((StringBuffer)charSequence).append(", MASS_UPDATE");
            }
            if ((n3 & 0x400) != 0) {
                ((StringBuffer)charSequence).append(", BULK");
            }
            if ((n3 & 0x800) != 0) {
                ((StringBuffer)charSequence).append(", TRANSACTION");
            }
            this.log.info(((StringBuffer)charSequence).toString());
        }
        this.lockMask = n2 == 1 && input_nolock ? 0 : -1;
        this.lockAutomatic = (n3 & 0x80) != 0;
        this.initOperation(1);
        if (this.openMode != 0) {
            CobolIOException.get(135, "", this, 1);
            return;
        }
        if (this.closeLock) {
            CobolIOException.get(141, "", this, 1);
            return;
        }
        charSequence = iCobolVar.toString().trim();
        if (BaseFile.isRemoveNameSpaces((String)charSequence)) {
            charSequence = iCobolVar.toString().trim().replaceAll(" ", "");
        }
        if (((String)charSequence).length() == 0) {
            CobolIOException.get(130, "", this, 1);
            return;
        }
        if (BaseFile.isIndexFile(this) && Config.a(".file.index.strip_extension", 0) == 1 && (n5 = ((String)charSequence).lastIndexOf(46)) > 0) {
            charSequence = ((String)charSequence).substring(0, n5);
        }
        int[] nArray = new int[]{0};
        if (this.assignExt) {
            try {
                BaseFile.expandFileName((String)charSequence, true);
                this.myPeerOpen((String)charSequence, n2, n3);
                return;
            }
            catch (VarNotFoundException varNotFoundException) {
                // empty catch block
            }
        }
        String[] stringArray = BaseFile.getFullPaths((String)charSequence, nArray, this);
        this.fileType = nArray[0];
        String[] stringArray2 = new String[]{stringArray[0]};
        if (stringArray.length > 1 && this.canCreate(n2)) {
            for (n4 = 0; n4 < stringArray.length; ++n4) {
                stringArray2[0] = stringArray[n4];
                this.checkISF(stringArray2, this.name);
                if (this.exists(stringArray2[0])) break;
            }
            if (n4 == stringArray.length) {
                n4 = 0;
            }
            this.initOperation(1);
        } else {
            for (n4 = 0; n4 < stringArray.length - 1; ++n4) {
                try {
                    this.numPath = n4;
                    stringArray2[0] = stringArray[n4];
                    this.checkISF(stringArray2, this.name);
                    this.myPeerOpen(stringArray2[0], n2, n3);
                    return;
                }
                catch (CobolIOException cobolIOException) {
                    if (cobolIOException.getErrNum() != 130) {
                        throw cobolIOException;
                    }
                    this.initOperation(1);
                    continue;
                }
            }
        }
        stringArray2[0] = stringArray[n4];
        this.checkISF(stringArray2, this.name);
        this.myPeerOpen(stringArray2[0], n2, n3);
    }

    @Override
    public final void close() {
        this.close(0);
    }

    @Override
    public final void close(int n2) {
        if (this.log != null) {
            StringBuffer stringBuffer = new StringBuffer("CLOSE opts=" + n2 + ":");
            stringBuffer.append(this.name);
            this.log.info(stringBuffer.toString());
        }
        this.initOperation(2);
        if (this.openMode == 0) {
            CobolIOException.get(101, "", this, 2);
        }
        this.peerClose(n2);
        this.openMode = 0;
    }

    @Override
    public final void closeReel() {
        if (this.log != null) {
            StringBuffer stringBuffer = new StringBuffer("CLOSE REEL:");
            stringBuffer.append(this.name);
            this.log.info(stringBuffer.toString());
        }
        this.initOperation(2);
        if (this.openMode == 0) {
            CobolIOException.get(101, "", this, 2);
        }
        CobolIOException.get(206, "", this, 2);
    }

    @Override
    public CobolFile key(CobolVar[] cobolVarArray, boolean bl) {
        return this.key((ICobolVar[])cobolVarArray, bl);
    }

    @Override
    public CobolFile key(ICobolVar[] iCobolVarArray, boolean bl) {
        throw new IscobolRuntimeException(3, new IllegalArgumentException("KEY").toString());
    }

    @Override
    public void keyReset() {
        throw new IscobolRuntimeException(3, new IllegalArgumentException("KEYRESET").toString());
    }

    @Override
    public CobolFile relativeKey(NumericVar numericVar) {
        return this.relativeKey((INumericVar)numericVar);
    }

    @Override
    public CobolFile relativeKey(INumericVar iNumericVar) {
        throw new IscobolRuntimeException(3, new IllegalArgumentException("KEY").toString());
    }

    @Override
    public CobolFile collatingSequence(byte[] byArray) {
        throw new IscobolRuntimeException(3, new IllegalArgumentException("COLLATING SEQUENCE").toString());
    }

    @Override
    public boolean write(boolean bl, int n2, int n3) {
        if (n3 == 0) {
            return this.write(bl, n2);
        }
        throw new IscobolRuntimeException(3, new IllegalArgumentException("CONTROL/CONVERSION").toString());
    }

    @Override
    public boolean write(boolean bl, int n2) {
        if (this.log != null) {
            StringBuffer stringBuffer = new StringBuffer("WRITE:");
            stringBuffer.append(this.name);
            stringBuffer.append(", lock=");
            stringBuffer.append(bl);
            stringBuffer.append(", len=");
            stringBuffer.append(n2);
            this.log.info(stringBuffer.toString());
            if (LoggerFactory.get(32) != null) {
                stringBuffer.delete(0, stringBuffer.capacity());
                stringBuffer.append("record-data=");
                if ((this.openLock & 0x1000) != 0) {
                    stringBuffer.append("********Encrypted Value******");
                } else {
                    stringBuffer.append(this.buffer.toString());
                }
                this.log.info(stringBuffer.toString());
            }
        }
        this.initOperation(3);
        if ((this.openMode & 2) == 0) {
            if (this.openMode == 0) {
                CobolIOException.get(101, "", this, 3);
            } else {
                CobolIOException.get(137, "", this, 3);
            }
        }
        return false;
    }

    @Override
    public boolean advance(int n2, int n3) {
        throw new IscobolRuntimeException(3, new IllegalArgumentException("ADVANCE").toString());
    }

    @Override
    public boolean page(int n2) {
        throw new IscobolRuntimeException(3, new IllegalArgumentException("PAGE").toString());
    }

    @Override
    public CobolFile setLinage(CobolVar cobolVar) {
        return this.setLinage((ICobolVar)cobolVar);
    }

    @Override
    public CobolFile setLinage(ICobolVar iCobolVar) {
        throw new IscobolRuntimeException(3, new IllegalArgumentException("LINAGE").toString());
    }

    @Override
    public CobolFile setLinage(CobolVar cobolVar, CobolVar cobolVar2, CobolVar cobolVar3, CobolVar cobolVar4) {
        return this.setLinage((ICobolVar)cobolVar, (ICobolVar)cobolVar2, (ICobolVar)cobolVar3, (ICobolVar)cobolVar4);
    }

    @Override
    public CobolFile setLinage(ICobolVar iCobolVar, ICobolVar iCobolVar2, ICobolVar iCobolVar3, ICobolVar iCobolVar4) {
        throw new IscobolRuntimeException(3, new IllegalArgumentException("LINAGE").toString());
    }

    @Override
    public NumericVar getLinageCounter() {
        throw new IscobolRuntimeException(3, new IllegalArgumentException("LINAGE-COUNTER").toString());
    }

    @Override
    public int linageCounter() {
        throw new IscobolRuntimeException(3, new IllegalArgumentException("LINAGE-COUNTER").toString());
    }

    @Override
    public void rewrite(boolean bl, int n2) {
        if (this.log != null) {
            StringBuffer stringBuffer = new StringBuffer("REWRITE:");
            stringBuffer.append(this.name);
            stringBuffer.append(", lock=");
            stringBuffer.append(bl);
            stringBuffer.append(", len=");
            stringBuffer.append(n2);
            this.log.info(stringBuffer.toString());
            if (LoggerFactory.get(32) != null) {
                stringBuffer.delete(0, stringBuffer.capacity());
                stringBuffer.append("record-data=");
                if ((this.openLock & 0x1000) != 0) {
                    stringBuffer.append("********Encrypted Value******");
                } else {
                    stringBuffer.append(this.buffer.toString());
                }
                this.log.info(stringBuffer.toString());
            }
        }
        this.initOperation(4);
        if (this.openMode != 3) {
            if (this.openMode == 0) {
                CobolIOException.get(101, "", this, 4);
            } else {
                CobolIOException.get(138, "", this, 4);
            }
        }
    }

    @Override
    public void delete() {
        if (this.log != null) {
            StringBuffer stringBuffer = new StringBuffer("DELETE:");
            stringBuffer.append(this.name);
            this.log.info(stringBuffer.toString());
        }
        this.initOperation(5);
        if (this.openMode != 3) {
            if (this.openMode == 0) {
                CobolIOException.get(101, "", this, 5);
            } else {
                CobolIOException.get(138, "", this, 5);
            }
        }
    }

    @Override
    public int readNext(boolean bl, CobolVar cobolVar) {
        return this.readNext(bl, (ICobolVar)cobolVar);
    }

    @Override
    public int readNext(boolean bl, ICobolVar iCobolVar) {
        return this.readNext(bl ? 1 : 0, iCobolVar);
    }

    @Override
    public int readNext(int n2, ICobolVar iCobolVar) {
        if (this.log != null) {
            StringBuffer stringBuffer = new StringBuffer("READ NEXT:");
            stringBuffer.append(this.name);
            stringBuffer.append(", lock=");
            stringBuffer.append(n2);
            this.log.info(stringBuffer.toString());
        }
        this.initOperation(6, n2 > 0);
        if ((this.openMode & 1) == 0) {
            if (this.openMode == 0) {
                CobolIOException.get(101, "", this, 6);
            } else {
                CobolIOException.get(136, "", this, 6);
            }
        }
        return 0;
    }

    @Override
    public int readPrev(boolean bl, CobolVar cobolVar) {
        return this.readPrev(bl, (ICobolVar)cobolVar);
    }

    @Override
    public int readPrev(boolean bl, ICobolVar iCobolVar) {
        return this.readPrev(bl ? 1 : 0, iCobolVar);
    }

    @Override
    public int readPrev(int n2, ICobolVar iCobolVar) {
        if (this.log != null) {
            StringBuffer stringBuffer = new StringBuffer("READ PREV:");
            stringBuffer.append(this.name);
            stringBuffer.append(", lock=");
            stringBuffer.append(n2);
            this.log.info(stringBuffer.toString());
        }
        this.initOperation(7, n2 > 0);
        if ((this.openMode & 1) == 0) {
            if (this.openMode == 0) {
                CobolIOException.get(101, "", this, 7);
            } else {
                CobolIOException.get(136, "", this, 7);
            }
        }
        return 0;
    }

    @Override
    public int readKey(CobolVar[] cobolVarArray, boolean bl, CobolVar cobolVar) {
        return this.readKey((ICobolVar[])cobolVarArray, bl, (ICobolVar)cobolVar);
    }

    @Override
    public int readKey(ICobolVar[] iCobolVarArray, boolean bl, ICobolVar iCobolVar) {
        return this.readKey(iCobolVarArray, bl ? 1 : 0, iCobolVar);
    }

    @Override
    public int readKey(ICobolVar[] iCobolVarArray, int n2, ICobolVar iCobolVar) {
        if (this.log != null) {
            StringBuffer stringBuffer = new StringBuffer("READ KEY:");
            stringBuffer.append(this.name);
            stringBuffer.append(", lock=");
            stringBuffer.append(n2);
            this.log.info(stringBuffer.toString());
        }
        this.initOperation(8, n2 > 0);
        if ((this.openMode & 1) == 0) {
            if (this.openMode == 0) {
                CobolIOException.get(101, "", this, 8);
            } else {
                CobolIOException.get(136, "", this, 8);
            }
        }
        return 0;
    }

    @Override
    public void start(CobolVar[] cobolVarArray, int n2, int n3) {
        this.start((ICobolVar[])cobolVarArray, n2, n3);
    }

    @Override
    public void start(ICobolVar[] iCobolVarArray, int n2, int n3) {
        this.whileLike = null;
        if (this.log != null) {
            StringBuffer stringBuffer = new StringBuffer("START:");
            stringBuffer.append(this.name);
            stringBuffer.append(", type=");
            stringBuffer.append(START[n2]);
            if (this instanceof IndexFile) {
                stringBuffer.append(", keyNum=");
                stringBuffer.append(((IndexFile)this).findKeyNum(iCobolVarArray));
            }
            stringBuffer.append(", keyLen=");
            stringBuffer.append(n3);
            this.log.info(stringBuffer.toString());
        }
        this.initOperation(9);
        if ((this.openMode & 1) == 0) {
            if (this.openMode == 0) {
                CobolIOException.get(101, "", this, 9);
            } else {
                CobolIOException.get(136, "", this, 9);
            }
        }
    }

    @Override
    public void unlock() {
        if (this.log != null) {
            StringBuffer stringBuffer = new StringBuffer("UNLOCK:");
            stringBuffer.append(this.name);
            this.log.info(stringBuffer.toString());
        }
        this.initOperation(10);
        if (this.openMode == 0) {
            CobolIOException.get(101, "", this, 10);
        }
    }

    @Override
    public void deleteFile(CobolVar cobolVar) {
        this.deleteFile((ICobolVar)cobolVar);
    }

    @Override
    public void deleteFile(ICobolVar iCobolVar) {
        int n2;
        String[] stringArray;
        this.log = LoggerFactory.get(8);
        if (this.log != null) {
            stringArray = new StringBuffer("DELETE FILE:");
            stringArray.append(this.name);
            this.log.info(stringArray.toString());
        }
        this.initOperation(11);
        if (this.openMode != 0) {
            CobolIOException.get(135, "", this, 11);
        }
        stringArray = BaseFile.isRemoveNameSpaces(iCobolVar.toString()) ? BaseFile.getFullPaths(iCobolVar.toString().replace(" ", ""), new int[]{0}) : BaseFile.getFullPaths(iCobolVar.toString(), new int[]{0});
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            int n3;
            if (!BaseFile.isIndexFile(this) || Config.a(".file.index.strip_extension", 0) != 1 || (n3 = stringArray[n2].lastIndexOf(46)) <= 0) continue;
            stringArray[n2] = stringArray[n2].substring(0, n3);
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            String[] stringArray2 = new String[]{stringArray[n2]};
            this.checkISF(stringArray2, this.name);
            if (this.exists(stringArray2[0])) break;
        }
        if (n2 == stringArray.length) {
            CobolIOException.get(203, "", this, 11);
        }
    }

    @Override
    public void like(ICobolVar[] iCobolVarArray, ICobolVar iCobolVar, int n2) {
        if (iCobolVarArray != null) {
            String string = Factory.rightTrim(iCobolVar.toString());
            if (this.log != null) {
                StringBuffer stringBuffer = new StringBuffer("WHILE LIKE:");
                stringBuffer.append(string);
                this.log.info(stringBuffer.toString());
            }
            try {
                this.whileLike = new WhileLikeRE(iCobolVarArray, n2, string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.whileLike = null;
                CobolIOException.get(111, "28 " + patternSyntaxException.getMessage(), this, 9);
            }
        } else {
            this.whileLike = null;
        }
    }

    @Override
    public void like(ICobolVar[] iCobolVarArray, ICobolVar iCobolVar, int n2, int n3) {
        if (iCobolVarArray != null) {
            String string = Factory.rightTrim(iCobolVar.toString());
            if (this.log != null) {
                StringBuffer stringBuffer = new StringBuffer("WHILE LIKE:");
                stringBuffer.append(string);
                this.log.info(stringBuffer.toString());
            }
            this.whileLike = new WhileLikeApprox(iCobolVarArray, n2, string, n3);
        } else {
            this.whileLike = null;
        }
    }

    protected boolean isLike() {
        if (this.whileLike != null) {
            return this.whileLike.isLike();
        }
        return false;
    }

    protected void setOpenMode(int n2) {
        this.openMode = n2;
    }

    @Override
    public boolean isOpen() {
        return this.openMode != 0;
    }

    @Override
    public int getOpenMode() {
        return this.openMode;
    }

    public boolean isWritable() {
        return (this.openMode & 2) != 0;
    }

    @Override
    public String getLogicName() {
        return this.name;
    }

    @Override
    public void setFileStatus(String string) {
        this.intFileStatus = string;
    }

    @Override
    public String getFileStatus() {
        return this.intFileStatus;
    }

    public static void setLockId(long l2) {
        ((MyProperties)BaseFile.get()).fd.getTdd().pidLock = l2;
    }

    public static long getLockId() {
        return ((MyProperties)BaseFile.get()).fd.getTdd().pidLock;
    }

    @Override
    public void setExtendedStatus(String string) {
        int n2 = string == null ? 0 : string.length();
        switch (n2) {
            case 0: {
                this.extendedStatus = "00";
                break;
            }
            case 1: {
                this.extendedStatus = "0" + string;
                break;
            }
            default: {
                this.extendedStatus = string;
            }
        }
    }

    @Override
    public String getExtendedStatus() {
        return this.extendedStatus;
    }

    @Override
    public void setStatusMessage(String string) {
        this.statusMessage = string;
    }

    @Override
    public String getStatusMessage() {
        return this.statusMessage;
    }

    public boolean isOptional(int n2) {
        switch (n2) {
            case 3: {
                return this.optional || BaseFile.getIoCreates();
            }
            case 6: {
                return this.optional || BaseFile.getExtendCreates();
            }
        }
        return this.optional;
    }

    private boolean canCreate(int n2) {
        switch (n2) {
            case 2: {
                return true;
            }
            case 1: 
            case 3: 
            case 6: {
                return this.isOptional(n2);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exists(String string) {
        boolean bl = this.optional;
        boolean bl2 = this.closeLock;
        int n2 = this.lastOp;
        try {
            this.optional = false;
            this.closeLock = false;
            this.myPeerOpen(string, 1, 0);
            this.close();
        }
        catch (CobolIOException cobolIOException) {
            int n3 = cobolIOException.getErrNum();
            if (n3 == 130 || n3 == 147) {
                boolean bl3 = false;
                return bl3;
            }
            this.setFileStatus("00");
        }
        finally {
            this.optional = bl;
            this.closeLock = bl2;
            this.lastOp = n2;
        }
        return true;
    }

    @Override
    public final byte[] getBufferRO() {
        return this.pickPut.toCodeSet(this.buffer.getBytes());
    }

    public final int getBufferLength() {
        return this.maxRecordLen;
    }

    @Override
    public final void updateBuffer(byte[] byArray) {
        this.buffer.setUsingMaxLen(this.pickPut.fromCodeSet(byArray));
    }

    public char[] getBufferAsChars() {
        return this.buffer.basicToString().toCharArray();
    }

    protected ICobolVar getBufferAsVar() {
        return this.buffer;
    }

    public int getMinRecordLen() {
        return this.minRecordLen;
    }

    public int getMaxRecordLen() {
        return this.maxRecordLen;
    }

    @Override
    public void setCloseLock() {
        this.closeLock = true;
    }

    @Override
    public final void finalize() {
        try {
            this.peerClose(0);
        }
        catch (CobolIOException cobolIOException) {
            // empty catch block
        }
    }

    public static BaseFile getLastUsedFile() {
        return ((MyProperties)BaseFile.get()).fd.getTdd().lastUsedFile;
    }

    @Override
    public void setLastException(CobolIOException cobolIOException) {
        this.lastException = cobolIOException;
    }

    @Override
    public CobolIOException getLastException() {
        return this.lastException;
    }

    @Override
    public CobolFile setAssignExt(boolean bl) {
        this.assignExt = bl;
        return this;
    }

    public int getLastOp() {
        return this.lastOp;
    }

    public int getAccessMode() {
        return this.accessMode;
    }

    public String toString() {
        return this.buffer.toString();
    }

    @Override
    public final CobolFile setCodeSet(byte[] byArray) {
        this.pickPut = DataPickPut.get(byArray, this.maxRecordLen);
        return this;
    }

    public static String getBasename(String string) {
        String string2 = string.replace('\\', '/');
        if (string2.lastIndexOf(47) >= 0) {
            string2 = string2.substring(string2.lastIndexOf(47) + 1);
        }
        return string2;
    }

    public int getNumPath() {
        return this.numPath;
    }

    public static String getFileServerUrl(String string) {
        block3: {
            String string2;
            block2: {
                string2 = "isf://";
                if (string.startsWith("isf://")) break block2;
                string2 = "@";
                if (!string.startsWith("@") || string.startsWith("@[")) break block3;
            }
            return string.substring(string2.length());
        }
        return null;
    }

    public void checkISF(String[] stringArray, String string) {
        this.isfSet = BaseFile.checkISF(stringArray, string, this.isfSet, null);
    }

    public static boolean checkISF(String[] stringArray, boolean bl, String string) {
        bl = BaseFile.checkISF(stringArray, null, bl, string);
        return bl;
    }

    public static boolean checkISF(String[] stringArray, String string, boolean bl, String string2) {
        BaseFile baseFile = BaseFile.getLastUsedFile();
        if (baseFile instanceof IndexFile && !(baseFile instanceof SequentialDFile) && !(baseFile instanceof RelativeDFile) && !(baseFile instanceof LineSequentialDFile) && stringArray[0].startsWith("@") && (FileTypeManager.getIndexIn() != null && (FileTypeManager.getIndexIn() == DynamicVision.class || FileTypeManager.getIndexIn() == DynamicVConnector.class) || ((IndexFile)baseFile)._clazz != null && (((IndexFile)baseFile)._clazz.toString().trim().equalsIgnoreCase("com.iscobol.io.DynamicVision") || ((IndexFile)baseFile)._clazz.toString().trim().equalsIgnoreCase("com.iscobol.io.DynamicVConnector")) || string != null && IndexFile.isIdxInConfig(string) != null && (IndexFile.isIdxInConfig(string) instanceof DynamicVision || IndexFile.isIdxInConfig(string) instanceof DynamicVConnector) || Config.b(".file.env_naming", false) && IndexFile.isIdxInConfig(BaseFile.getBasename(stringArray[0])) != null && (IndexFile.isIdxInConfig(BaseFile.getBasename(stringArray[0])) instanceof DynamicVision || IndexFile.isIdxInConfig(BaseFile.getBasename(stringArray[0])) instanceof DynamicVConnector))) {
            return false;
        }
        if (stringArray[0].toLowerCase().startsWith("isf://") || stringArray[0].startsWith("@")) {
            stringArray[0] = stringArray[0].startsWith("@") ? stringArray[0].substring(1) : stringArray[0].substring(6);
            if (stringArray[0].contains(":")) {
                String string3;
                String string4;
                String string5 = stringArray[0].substring(0, stringArray[0].indexOf(":"));
                stringArray[0] = stringArray[0].substring(stringArray[0].indexOf(58) + 1);
                if (stringArray[0].contains(":")) {
                    string4 = stringArray[0].substring(0, stringArray[0].indexOf(":"));
                    stringArray[0] = stringArray[0].substring(stringArray[0].indexOf(58) + 1);
                } else {
                    string4 = "" + Config.a(".file.remote.port", 10997);
                }
                Logger logger = LoggerFactory.get(8);
                String string6 = BaseFile.getBasename(stringArray[0]).toLowerCase().replace('-', '_');
                if (string2 != null) {
                    string3 = string2;
                } else {
                    baseFile = BaseFile.getLastUsedFile();
                    string3 = "index.";
                    if (baseFile instanceof RelativeDFile) {
                        string3 = "relative.";
                    } else if (baseFile instanceof SequentialDFile) {
                        string3 = "sequential.";
                    } else if (baseFile instanceof LineSequentialDFile) {
                        string3 = "linesequential.";
                    }
                }
                Config.b(".file." + string3 + string6, "com.iscobol.io.DynamicRemote");
                Config.b(".file.remote.host." + string6, string5);
                Config.b(".file.remote.port." + string6, string4);
                bl = true;
                if (logger != null) {
                    StringBuffer stringBuffer = new StringBuffer("    Found isf:// or @ file type:");
                    stringBuffer.append(stringArray[0]);
                    stringBuffer.append(", host = ");
                    stringBuffer.append(string5);
                    stringBuffer.append(", port = ");
                    stringBuffer.append(string4);
                    logger.info(stringBuffer.toString());
                }
            }
        } else if (bl) {
            String string7;
            baseFile = BaseFile.getLastUsedFile();
            Logger logger = LoggerFactory.get(8);
            String string8 = BaseFile.getBasename(stringArray[0]).toLowerCase().replace('-', '_');
            if (string2 != null) {
                string7 = string2;
            } else {
                string7 = "index.";
                if (baseFile instanceof RelativeDFile) {
                    string7 = "relative.";
                } else if (baseFile instanceof SequentialDFile) {
                    string7 = "sequential.";
                } else if (baseFile instanceof LineSequentialDFile) {
                    string7 = "linesequential.";
                }
            }
            Config.d(".file." + string7 + string8);
            Config.d(".file.remote.host." + string8);
            Config.d(".file.remote.port." + string8);
            if (logger != null) {
                StringBuffer stringBuffer = new StringBuffer("    Unset ISF properties:");
                stringBuffer.append(stringArray[0]);
                logger.info(stringBuffer.toString());
            }
            bl = false;
        }
        return bl;
    }

    public static boolean isRemoveNameSpaces(String string) {
        boolean bl = false;
        if (!(Config.a(".file.remove_name_spaces", 0) != 1 || string.trim().startsWith("-F ") || string.trim().startsWith("+F ") || string.trim().startsWith("-E ") || string.trim().startsWith("+E ") || string.trim().startsWith("-P ") || string.trim().startsWith("+P ") || string.trim().startsWith("-S ") || string.trim().startsWith("+S ") || string.trim().startsWith("-Q ") || string.trim().startsWith("+Q "))) {
            bl = true;
        }
        return bl;
    }

    @Override
    public void setCompressionFactor(int n2) {
        this.compressionFactor = n2;
    }

    @Override
    public int getCompressionFactor() {
        return this.compressionFactor;
    }

    static class VarNotFoundException
    extends Exception {
        VarNotFoundException() {
        }
    }

    static class MyProperties {
        private String filePrefixDesc = "";
        private String[] filePrefixArray;
        private final FactoryData fd = Factory.getCurrent();

        MyProperties() {
        }

        FactoryData getFd() {
            return this.fd;
        }

        static /* synthetic */ String[] access$102(MyProperties myProperties, String[] stringArray) {
            myProperties.filePrefixArray = stringArray;
            return stringArray;
        }
    }

    static class WhileLikeApprox
    extends WhileLike {
        private final FuzzyRegexp fuzzyRE;
        private final int maxErrs;

        WhileLikeApprox(ICobolVar[] iCobolVarArray, int n2, String string, int n3) throws PatternSyntaxException {
            super(iCobolVarArray, n2);
            boolean bl = (n2 & 1) == 1;
            this.maxErrs = n3;
            this.fuzzyRE = new FuzzyRegexp(string, bl);
        }

        @Override
        boolean isLike() {
            CharSequence charSequence;
            String string;
            if (this.key.length == 1) {
                string = this.key[0].toString();
            } else {
                charSequence = new StringBuffer(255);
                for (int i2 = 0; i2 < this.key.length; ++i2) {
                    charSequence.append(this.key[i2].toString());
                }
                string = charSequence.toString();
            }
            switch (this.flags & 6) {
                case 6: {
                    charSequence = string.trim();
                    break;
                }
                case 2: {
                    charSequence = Factory.leftTrim(string);
                    break;
                }
                case 4: {
                    charSequence = Factory.rightTrim(string);
                    break;
                }
                default: {
                    charSequence = string;
                }
            }
            return this.fuzzyRE.isInDistance(this.maxErrs, (String)charSequence);
        }
    }

    static class WhileLikeRE
    extends WhileLike {
        private final Pattern regex;
        private static final String zeroesStr = "0000000000000000000000000000000000000000000000000000000000000000";

        WhileLikeRE(ICobolVar[] iCobolVarArray, int n2, String string) throws PatternSyntaxException {
            super(iCobolVarArray, n2);
            int n3 = (n2 & 1) == 1 ? 66 : 0;
            this.regex = Pattern.compile(string, n3);
        }

        @Override
        boolean isLike() {
            CharSequence charSequence;
            String string;
            if (this.key.length == 1) {
                string = this.key[0] instanceof INumericVar && this.key[0].getLength() > this.key[0].toString().length() ? zeroesStr.substring(0, this.key[0].getLength() - this.key[0].toString().length()) + this.key[0].toString() : this.key[0].toString();
            } else {
                charSequence = new StringBuffer(255);
                for (int i2 = 0; i2 < this.key.length; ++i2) {
                    if (this.key[i2] instanceof INumericVar && this.key[0].getLength() > this.key[0].toString().length()) {
                        ((StringBuffer)charSequence).append(zeroesStr.substring(0, this.key[i2].getLength() - this.key[i2].toString().length()) + this.key[i2].toString());
                        continue;
                    }
                    ((StringBuffer)charSequence).append(this.key[i2]);
                }
                string = ((StringBuffer)charSequence).toString();
            }
            switch (this.flags & 6) {
                case 6: {
                    charSequence = string.trim();
                    break;
                }
                case 2: {
                    charSequence = Factory.leftTrim(string);
                    break;
                }
                case 4: {
                    charSequence = Factory.rightTrim(string);
                    break;
                }
                default: {
                    charSequence = string;
                }
            }
            return this.regex.matcher(charSequence).matches();
        }
    }

    static abstract class WhileLike {
        protected ICobolVar[] key;
        protected final int flags;

        WhileLike(ICobolVar[] iCobolVarArray, int n2) {
            this.key = iCobolVarArray;
            this.flags = n2;
        }

        abstract boolean isLike();
    }
}

