/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.io.AtEndException;
import com.iscobol.io.DataStream;
import com.iscobol.io.FileStatus;
import com.iscobol.io.FileStatusDefault;
import com.iscobol.io.InvalidKeyException;
import com.iscobol.rts.Config;
import com.iscobol.rts.IscobolRuntimeException;

public class CobolIOException
extends IscobolRuntimeException {
    final String initialMessage;
    final transient DataStream ds;
    final String fs;
    final String extFs;
    final String stMsg;
    static FileStatus status = new FileStatusDefault();

    protected static String buildMsg(DataStream dataStream) {
        String string = dataStream.getFileStatus();
        String string2 = dataStream.getExtendedStatus();
        String string3 = dataStream.getStatusMessage();
        StringBuffer stringBuffer = new StringBuffer(dataStream.getLogicName());
        stringBuffer.append(" (");
        stringBuffer.append(dataStream.getOsPath());
        stringBuffer.append(") FS=[");
        stringBuffer.append(string);
        stringBuffer.append("]");
        stringBuffer.append(string2 == null ? "" : ",EXFS=[" + string2 + "]");
        if (string3 != null) {
            stringBuffer.append(": ");
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    public CobolIOException(CobolIOException cobolIOException) {
        this(cobolIOException.getErrNum(), cobolIOException.getInitialMessage(), cobolIOException.ds);
    }

    protected CobolIOException(int n2, String string, DataStream dataStream) {
        super(n2, string);
        this.initialMessage = string;
        this.ds = dataStream;
        this.fs = this.ds.getFileStatus();
        String string2 = this.ds.getExtendedStatus();
        this.extFs = string2 != null && string2.length() == 0 ? null : string2;
        this.stMsg = this.ds.getStatusMessage();
    }

    final void throwMe() {
        this.ds.setFileStatus(this.fs);
        this.ds.setStatusMessage(this.stMsg);
        if (this.extFs != null) {
            this.ds.setExtendedStatus(this.extFs);
        }
        this.ds.setLastException(this);
        if (this.ds.getLogger() != null) {
            this.ds.getLogger().info(this.getMessage());
        }
        throw this;
    }

    public String getInitialMessage() {
        return this.initialMessage;
    }

    private CobolIOException getEx(int n2) {
        CobolIOException cobolIOException;
        switch (this.getErrNum()) {
            case 100: {
                cobolIOException = new InvalidKeyException(this);
                break;
            }
            case 110: {
                cobolIOException = new AtEndException(this);
                break;
            }
            case 111: {
                if (n2 == 6 || n2 == 7) {
                    cobolIOException = new AtEndException(this);
                    break;
                }
                cobolIOException = new InvalidKeyException(this);
                break;
            }
            default: {
                cobolIOException = this;
            }
        }
        return cobolIOException;
    }

    public static void get(int n2, String string, DataStream dataStream, int n3) {
        if ((n2 = status.map(n2, string, dataStream, n3)) != 0) {
            CobolIOException cobolIOException = new CobolIOException(n2, CobolIOException.buildMsg(dataStream), dataStream).getEx(n3);
            dataStream.setLastException(cobolIOException);
            if (dataStream.getLogger() != null) {
                dataStream.getLogger().info(cobolIOException.getMessage());
            }
            throw cobolIOException;
        }
    }

    public static void get(Exception exception, DataStream dataStream) {
        CobolIOException.get(exception, dataStream, 0);
    }

    public static void get(Exception exception, DataStream dataStream, int n2) {
        int n3 = status.map(exception, dataStream, n2);
        if (n3 != 0) {
            CobolIOException cobolIOException = new CobolIOException(n3, exception.getMessage(), dataStream).getEx(n2);
            dataStream.setLastException(cobolIOException);
            if (dataStream.getLogger() != null) {
                dataStream.getLogger().info(exception.getMessage());
            }
            throw cobolIOException;
        }
    }

    public static boolean isErrorsOk(boolean bl) {
        int n2 = Config.a(".file.errors_ok", ".errors_ok", 0);
        return n2 == 1 ? true : n2 == 2 && bl;
    }

    public static boolean isErrorsOk() {
        return Config.a(".file.errors_ok", ".errors_ok", false);
    }

    static {
        String string = Config.a(".file.status", null);
        if (string != null) {
            try {
                status = (FileStatus)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

