/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.io.AtEndException;
import com.iscobol.io.CobolFile;
import com.iscobol.io.CobolIOException;
import com.iscobol.io.DataStream;
import com.iscobol.io.DynamicJavaSort;
import com.iscobol.io.ItemToSort;
import com.iscobol.io.SortFile;
import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.Config;
import com.iscobol.rts.DynamicSort;
import com.iscobol.rts.Factory;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IPicAnyLength;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.rts.SortKey;
import com.iscobol.rts.SortKeyItem;
import com.iscobol.types.CobolVar;
import com.iscobol.types.NumericVar;
import com.iscobol.types.PicX;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class CobolSort
implements DataStream,
RuntimeErrorsNumbers {
    public static final int BUFFERSIZE = Config.a(".sort.memsize", 0x100000);
    public static final int NMERGE = Config.a(".sort.maxfiles", 16);
    private String logicName;
    private ICobolVar path;
    private ICobolVar record;
    private int recSize;
    private ICobolVar fileStatus;
    private String intFileStatus = "";
    private Vector<SortKeyItem> keys = new Vector();
    private SortKey key = new SortKey();
    private final int maxElem;
    private Vector<ItemToSort> array = new Vector();
    private int readElem;
    private SortFile finalFile;
    private String extendedStatus = "00";
    private String statusMessage = "";
    private CobolIOException lastException;
    private Logger log;
    private int[] collatingSeq = new int[256];
    private boolean isInpEnd;
    private boolean isOutEnd;
    private Vector<SortFile> files = new Vector();
    private CobolFile[] using;
    private ICobolVar[] uNames;
    private CobolFile[] giving;
    private ICobolVar[] gNames;
    private DynamicSort sortClass;

    public CobolSort(String string, ICobolVar iCobolVar, ICobolVar iCobolVar2, int n2, ICobolVar iCobolVar3) {
        this(string, iCobolVar, iCobolVar2, n2, iCobolVar3, null);
    }

    public CobolSort(String string, ICobolVar iCobolVar, ICobolVar iCobolVar2, int n2, ICobolVar iCobolVar3, byte[] byArray) {
        this.logicName = string;
        this.path = iCobolVar;
        this.record = iCobolVar2;
        this.fileStatus = iCobolVar3;
        this.log = LoggerFactory.get(8);
        this.recSize = this.record.getMaxLength();
        this.maxElem = BUFFERSIZE / this.recSize;
        for (int i2 = 0; i2 < this.collatingSeq.length; ++i2) {
            this.collatingSeq[i2] = i2;
        }
    }

    public CobolSort(ICobolVar iCobolVar) {
        this.logicName = "table$sort";
        this.record = iCobolVar;
        this.recSize = iCobolVar.getMaxLength();
        this.maxElem = iCobolVar.getLastDimension();
        for (int i2 = 0; i2 < this.collatingSeq.length; ++i2) {
            this.collatingSeq[i2] = i2;
        }
    }

    public CobolSort collatingSequence(byte[] byArray) {
        if (byArray != null) {
            for (int i2 = 0; i2 < byArray.length && i2 < this.collatingSeq.length; ++i2) {
                this.collatingSeq[i2] = byArray[i2] & 0xFF;
            }
        }
        return this;
    }

    @Override
    public void finalize() {
        Iterator<SortFile> iterator = this.files.iterator();
        while (iterator.hasNext()) {
            iterator.next().finalize();
        }
        this.array = new Vector();
        this.keys = new Vector();
        this.key.keyArray = null;
        this.readElem = 0;
        this.using = null;
        this.uNames = null;
        this.giving = null;
        this.gNames = null;
        this.sortClass = null;
    }

    public CobolSort keyAdd(CobolVar cobolVar, boolean bl) {
        return this.keyAdd((ICobolVar)cobolVar, bl);
    }

    public CobolSort keyAdd(ICobolVar iCobolVar, boolean bl) {
        if (this.maxElem > 0) {
            SortKeyItem sortKeyItem;
            if (iCobolVar instanceof IPicAnyLength) {
                sortKeyItem = new SortKeyItem(bl, iCobolVar.getType(), (IPicAnyLength)iCobolVar, this.key);
            } else {
                try {
                    iCobolVar = iCobolVar.intIAt(1);
                }
                catch (IscobolRuntimeException iscobolRuntimeException) {
                    // empty catch block
                }
                sortKeyItem = new SortKeyItem(bl, iCobolVar.getType(), iCobolVar.getOffset(), iCobolVar.length(), 0, this.key);
            }
            this.keys.addElement(sortKeyItem);
        }
        return this;
    }

    public void keyTable(CobolVar cobolVar) {
        this.keyTable((ICobolVar)cobolVar);
    }

    public void keyTable(ICobolVar iCobolVar) {
        int n2 = iCobolVar.length() / 7;
        if (n2 > 0) {
            PicX picX = Factory.getVarAlphanum(iCobolVar.getBytes(), 0, n2 * 7, false, null, null, null, "KEY-TABLE", true, false);
            PicX picX2 = Factory.getVarAlphanum(picX, 0, 7, false, null, new int[]{7}, new int[]{n2}, "SORT-KEY", true, false);
            NumericVar numericVar = Factory.getVarCompX(picX2, 0, 1, false, null, new int[]{7}, new int[]{n2}, "KEY-ASCENDING", true, 1, 0, false, false, false);
            NumericVar numericVar2 = Factory.getVarCompX(picX2, 1, 1, false, null, new int[]{7}, new int[]{n2}, "KEY-TYPE", true, 1, 0, false, false, false);
            NumericVar numericVar3 = Factory.getVarCompX(picX2, 2, 2, false, null, new int[]{7}, new int[]{n2}, "KEY-OFFSET", true, 2, 0, false, false, false);
            NumericVar numericVar4 = Factory.getVarCompX(picX2, 4, 2, false, null, new int[]{7}, new int[]{n2}, "KEY-SIZE", true, 2, 0, false, false, false);
            NumericVar numericVar5 = Factory.getVarCompX(picX2, 6, 1, false, null, new int[]{7}, new int[]{n2}, "KEY-DIGITS", true, 1, 0, false, false, false);
            int[] nArray = new int[1];
            int n3 = 0;
            for (int i2 = 1; i2 <= n2; ++i2) {
                nArray[0] = i2;
                n3 = numericVar2.at(nArray).integer();
                if (n3 == 8) {
                    n3 = 9;
                } else if (n3 == 9) {
                    n3 = 8;
                }
                this.keys.addElement(new SortKeyItem(numericVar.at(nArray).integer() == 0, n3, numericVar3.at(nArray).integer(), numericVar4.at(nArray).integer(), numericVar5.at(nArray).integer(), this.key));
            }
        }
    }

    public SortKey getKey() {
        this.getKeyArray();
        return this.key;
    }

    public SortKeyItem[] getKeyArray() {
        if (this.key.keyArray == null && this.keys.size() > 0) {
            this.key.keyArray = this.keys.toArray(new SortKeyItem[this.keys.size()]);
        }
        return this.key.keyArray;
    }

    public void releaseSort() {
        if (this.key.keyArray == null && this.keys.size() > 0) {
            this.key.keyArray = this.keys.toArray(new SortKeyItem[this.keys.size()]);
        }
        if (this.array.size() == this.maxElem) {
            Collections.sort(this.array);
            this.writeBuffer();
        }
        byte[] byArray = new byte[this.recSize];
        Factory.myArraycopy(this.record.getBytes(), 0, byArray, 0, this.recSize);
        this.array.addElement(new ItemToSort(this.key.keyArray, byArray));
    }

    public void returnSort(CobolVar cobolVar) {
        this.returnSort((ICobolVar)cobolVar);
    }

    public void returnSort(ICobolVar iCobolVar) {
        byte[] byArray = null;
        if (this.finalFile == null) {
            if (this.readElem == this.array.size()) {
                AtEndException.get(this, 6);
            } else {
                byArray = this.array.elementAt((int)this.readElem++).memory;
            }
        } else {
            try {
                this.finalFile.read();
            }
            catch (IOException iOException) {
                CobolIOException.get(iOException, this, 6);
            }
            if (this.finalFile.isAtEnd()) {
                AtEndException.get(this, 6);
            } else {
                byArray = this.finalFile.buffer.memory;
            }
        }
        this.record.set(byArray, 0, this.recSize, true);
        if (iCobolVar != null) {
            iCobolVar.setUsingMaxLen(byArray);
        }
    }

    public void sort(byte[] byArray) {
        this.key.setCollatingSequence(byArray);
        this.doSort();
    }

    public void sort() {
        this.key.setCollatingSequence(this.collatingSeq);
        this.doSort();
    }

    private void doSort() {
        if (this.array.size() > 1) {
            Collections.sort(this.array);
        }
        if (this.files.size() > 0) {
            this.merge();
            this.finalFile = this.files.elementAt(0);
            try {
                this.finalFile.openRead();
            }
            catch (IOException iOException) {
                CobolIOException.get(iOException, this, 6);
            }
        }
    }

    public void tableSort() {
        this.tableSort(null);
    }

    public void tableSort(SortHelper sortHelper) {
        ICobolVar iCobolVar;
        int n2;
        if (this.maxElem <= 0) {
            return;
        }
        if (this.keys.size() == 0) {
            this.keyAdd(this.record, false);
        }
        this.getKeyArray();
        int n3 = this.record.intIAt(1).getOffset();
        for (n2 = 0; n2 < this.key.keyArray.length; ++n2) {
            this.key.keyArray[n2].removeOffset(n3);
        }
        this.recSize = this.record.intIAt(1).length();
        for (n2 = 1; n2 <= this.maxElem; ++n2) {
            iCobolVar = this.record.intIAt(n2);
            byte[] byArray = new byte[this.recSize];
            System.arraycopy(iCobolVar.getBytes(), 0, byArray, 0, this.recSize);
            this.array.addElement(new ItemToSort(this.key.keyArray, byArray, n2));
        }
        Collections.sort(this.array);
        if (this.record.isDynamicLength() && sortHelper != null) {
            ICobolVar iCobolVar2 = sortHelper.getTmpVar();
            HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
            HashMap<Integer, Integer> hashMap2 = new HashMap<Integer, Integer>();
            Iterator<ItemToSort> iterator = this.array.iterator();
            n2 = 1;
            while (iterator.hasNext()) {
                iCobolVar = this.record.intIAt(n2);
                ItemToSort itemToSort = iterator.next();
                iCobolVar.set(itemToSort.memory, 0, this.recSize, true);
                Integer n4 = itemToSort.getIndex();
                Integer n5 = (Integer)hashMap.get(n4);
                if (n5 == null) {
                    n5 = n4;
                }
                if (n5 != n2) {
                    ICobolVar iCobolVar3 = this.record.intIAt(n5);
                    iCobolVar2.dynSet(iCobolVar);
                    iCobolVar.dynSet(iCobolVar3);
                    iCobolVar3.dynSet(iCobolVar2);
                    Integer n6 = n2;
                    n4 = (Integer)hashMap2.get(n6);
                    if (n4 != null) {
                        hashMap2.remove(n6);
                        n6 = n4;
                    }
                    hashMap.put(n6, n5);
                    hashMap2.put(n5, n6);
                }
                ++n2;
            }
        } else {
            Iterator<ItemToSort> iterator = this.array.iterator();
            n2 = 1;
            while (iterator.hasNext()) {
                iCobolVar = this.record.intIAt(n2);
                ItemToSort itemToSort = iterator.next();
                iCobolVar.set(itemToSort.memory, 0, this.recSize, true);
                ++n2;
            }
        }
        this.finalize();
    }

    private void writeBuffer() {
        if (this.files.size() == NMERGE) {
            this.merge();
        } else {
            SortFile sortFile = new SortFile(this.recSize, this.getKeyArray());
            try {
                sortFile.create();
            }
            catch (IOException iOException) {
                CobolIOException.get(iOException, this, 1);
            }
            this.files.addElement(sortFile);
            Iterator<ItemToSort> iterator = this.array.iterator();
            while (iterator.hasNext()) {
                try {
                    sortFile.write(iterator.next());
                }
                catch (IOException iOException) {
                    CobolIOException.get(iOException, this, 3);
                }
            }
            sortFile.close();
            this.array.removeAllElements();
        }
    }

    private void merge() {
        ItemToSort itemToSort;
        SortFile sortFile4;
        SortFile sortFile2 = null;
        int n2 = 0;
        if (this.array.size() == 0 && this.files.size() < 2 || this.files.size() < 1) {
            return;
        }
        SortFile sortFile3 = new SortFile(this.recSize, this.getKeyArray());
        try {
            sortFile3.create();
        }
        catch (IOException iOException) {
            CobolIOException.get(iOException, this, 1);
        }
        for (SortFile sortFile4 : this.files) {
            try {
                sortFile4.openRead();
                sortFile4.read();
            }
            catch (IOException iOException) {
                CobolIOException.get(iOException, this, 6);
            }
        }
        do {
            itemToSort = null;
            Iterator<SortFile> iterator = this.files.iterator();
            while (iterator.hasNext()) {
                sortFile4 = iterator.next();
                if (sortFile4.isAtEnd()) {
                    sortFile4.finalize();
                    iterator.remove();
                    continue;
                }
                if (itemToSort != null) {
                    if (itemToSort.compareTo(sortFile4.buffer) <= 0) continue;
                    itemToSort = sortFile4.buffer;
                    sortFile2 = sortFile4;
                    continue;
                }
                itemToSort = sortFile4.buffer;
                sortFile2 = sortFile4;
            }
            if (n2 < this.array.size()) {
                ItemToSort itemToSort2 = this.array.elementAt(n2);
                if (itemToSort == null || itemToSort.compareTo(itemToSort2) > 0) {
                    itemToSort = itemToSort2;
                    sortFile2 = null;
                }
            }
            if (itemToSort == null) continue;
            try {
                sortFile3.write(itemToSort);
            }
            catch (IOException iOException) {
                CobolIOException.get(iOException, this, 3);
            }
            if (sortFile2 != null) {
                try {
                    sortFile2.read();
                }
                catch (IOException iOException) {
                    CobolIOException.get(iOException, this, 6);
                }
                continue;
            }
            ++n2;
        } while (itemToSort != null);
        if (this.files.size() == 1) {
            sortFile4 = this.files.elementAt(0);
            sortFile4.finalize();
            this.files.remove(0);
        }
        this.files.addElement(sortFile3);
        sortFile3.close();
        this.array.removeAllElements();
    }

    @Override
    public void setFileStatus(String string) {
        if (this.fileStatus != null) {
            this.fileStatus.set(string);
        } else {
            this.intFileStatus = string;
        }
    }

    @Override
    public String getFileStatus() {
        if (this.fileStatus != null) {
            return this.fileStatus.toString();
        }
        return this.intFileStatus;
    }

    @Override
    public void setExtendedStatus(String string) {
        int n2 = string == null ? 0 : string.length();
        switch (n2) {
            case 0: {
                this.extendedStatus = "00";
                break;
            }
            case 1: {
                this.extendedStatus = "0" + string;
                break;
            }
            case 2: {
                this.extendedStatus = string;
                break;
            }
            default: {
                this.extendedStatus = string.substring(n2 - 2, n2);
            }
        }
    }

    @Override
    public String getExtendedStatus() {
        return this.extendedStatus;
    }

    @Override
    public void setStatusMessage(String string) {
        this.statusMessage = string;
    }

    @Override
    public String getStatusMessage() {
        return this.statusMessage;
    }

    @Override
    public void setLastException(CobolIOException cobolIOException) {
        this.lastException = cobolIOException;
    }

    @Override
    public CobolIOException getLastException() {
        return this.lastException;
    }

    @Override
    public String getLogicName() {
        return this.logicName;
    }

    @Override
    public String getOsPath() {
        if (this.path != null) {
            return this.path.toString();
        }
        return "";
    }

    @Override
    public Logger getLogger() {
        return this.log;
    }

    public void setUsing(CobolFile[] cobolFileArray, ICobolVar[] iCobolVarArray) {
        this.using = cobolFileArray;
        this.uNames = iCobolVarArray;
    }

    public void setGiving(CobolFile[] cobolFileArray, ICobolVar[] iCobolVarArray) {
        this.giving = cobolFileArray;
        this.gNames = iCobolVarArray;
    }

    public void initSort(byte[] byArray) {
        if (this.log != null) {
            this.log.info("SORT: " + this.getOsPath());
        }
        if (byArray != null) {
            this.key.setCollatingSequence(byArray);
        } else {
            this.key.setCollatingSequence(this.collatingSeq);
        }
        String string = Config.a(".sort", null);
        if (string == null) {
            this.sortClass = new DynamicJavaSort();
        } else {
            try {
                this.sortClass = (DynamicSort)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                throw new IscobolRuntimeException(5, string + " (" + exception + ")");
            }
        }
        int n2 = this.sortClass.initSort(this.getOsPath(), this.record, this.getKey(), this.using, this.uNames, this.giving, this.gNames);
        if (n2 != 1) {
            n2 = this.sortClass.getCobErrno();
            this.finalize();
            CobolIOException.get(n2, null, this, 1);
        }
        if (this.using != null && this.using.length > 0 && this.giving != null && this.giving.length > 0) {
            this.finalize();
        }
        this.isOutEnd = false;
        this.isInpEnd = false;
    }

    public void endInput() {
        if (this.sortClass == null) {
            throw new IscobolRuntimeException(3, "endInput (" + this.logicName + ")");
        }
        this.isInpEnd = true;
        int n2 = this.sortClass.endInput();
        if (n2 != 1) {
            n2 = this.sortClass.getCobErrno();
            this.finalize();
            CobolIOException.get(n2, null, this, 1);
        }
        if (this.giving != null && this.giving.length > 0) {
            this.finalize();
        }
    }

    public void endOutput() {
        if (this.sortClass == null) {
            throw new IscobolRuntimeException(3, "endOutput (" + this.logicName + ")");
        }
        this.isOutEnd = true;
        int n2 = this.sortClass.endOutput();
        if (n2 != 1) {
            n2 = this.sortClass.getCobErrno();
            this.finalize();
            CobolIOException.get(n2, null, this, 1);
        }
        this.finalize();
    }

    public void releaseRecord() {
        this.releaseRecord(this.recSize);
    }

    public void releaseRecord(int n2) {
        if (this.isInpEnd || this.sortClass == null) {
            throw new IscobolRuntimeException(24, this.logicName);
        }
        int n3 = this.sortClass.releaseRecord(n2);
        if (n3 != 1) {
            n3 = this.sortClass.getCobErrno();
            this.finalize();
            CobolIOException.get(n3, null, this, 1);
        }
    }

    public void returnRecord(CobolVar cobolVar) {
        this.returnRecord((ICobolVar)cobolVar);
    }

    public void returnRecord(ICobolVar iCobolVar) {
        if (this.isOutEnd || this.sortClass == null) {
            throw new IscobolRuntimeException(25, this.logicName);
        }
        int n2 = this.sortClass.returnRecord();
        if (n2 < 0) {
            if (this.sortClass.getCobErrno() == 110) {
                AtEndException.get(this, 1);
            } else {
                n2 = this.sortClass.getCobErrno();
                this.finalize();
                CobolIOException.get(n2, null, this, 1);
            }
        }
        if (iCobolVar != null) {
            iCobolVar.setUsingMaxLen(this.record.getBytes());
        }
    }

    public static interface SortHelper {
        public ICobolVar getTmpVar();
    }
}

