/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.io.DataPickPut;

final class DataPickPutConverter
extends DataPickPut {
    private final byte[] codeSet;
    private final byte[] codeSetReverse;
    private final byte[] codeSetBuffer;
    private final int maxRecordLen;

    public DataPickPutConverter(byte[] byArray, int n2) {
        this.maxRecordLen = n2;
        this.codeSet = byArray;
        this.codeSetReverse = new byte[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            this.codeSetReverse[this.codeSet[i2] & 0xFF] = (byte)i2;
        }
        this.codeSetBuffer = new byte[this.maxRecordLen];
    }

    @Override
    public final byte[] toCodeSet(byte[] byArray) {
        for (int i2 = 0; i2 < this.maxRecordLen; ++i2) {
            this.codeSetBuffer[i2] = this.codeSet[byArray[i2] & 0xFF];
        }
        return this.codeSetBuffer;
    }

    @Override
    public final byte[] fromCodeSet(byte[] byArray) {
        for (int i2 = 0; i2 < this.maxRecordLen; ++i2) {
            this.codeSetBuffer[i2] = this.codeSetReverse[byArray[i2] & 0xFF];
        }
        return this.codeSetBuffer;
    }
}

