/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.gui.ScreenUtility;
import com.iscobol.io.BaseFile;
import com.iscobol.io.CobolFile;
import com.iscobol.io.CobolIOException;
import com.iscobol.io.DataStream;
import com.iscobol.io.FileTypeManager;
import com.iscobol.io.JavaToIscobolError;
import com.iscobol.io.LineSeqFile;
import com.iscobol.io.PrinterFile;
import com.iscobol.rts.Config;
import com.iscobol.rts.DynamicInput;
import com.iscobol.rts.DynamicOutput;
import com.iscobol.rts.Factory;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IPicN;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.MixingCharAndBytesException;
import com.iscobol.rts.PrintBackgroundMonitor;
import com.iscobol.rts.PrintBackgroundMonitorFactory;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.rts.print.LocalSpoolPrinter;
import com.iscobol.rts.print.SpoolPrinterList;
import com.iscobol.types.CobolVar;
import com.iscobol.types.NumericVar;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.StringTokenizer;

public abstract class DeviceFile
extends BaseFile
implements CobolFile,
RuntimeErrorsNumbers {
    static boolean isMVSPrint = false;
    protected DynamicOutput outFile;
    protected DynamicInput inpFile;
    protected Process proc;
    private boolean spoolPrinter;
    private boolean graphicPrinter;
    private int linageCounter;
    private ICobolVar linage;
    private ICobolVar footing;
    private ICobolVar top;
    private ICobolVar bottom;
    private Object clazz;
    private int[] chnls;

    public static String[] breakCmdLine(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        char c2 = '\u0000';
        block4: for (int i2 = 0; i2 < string.length(); ++i2) {
            char c3 = string.charAt(i2);
            switch (c3) {
                case '\u0000': 
                case '\t': 
                case ' ': {
                    if (c2 != '\u0000') {
                        stringBuilder.append(c3);
                        continue block4;
                    }
                    if (stringBuilder.length() <= 0) continue block4;
                    arrayList.add(stringBuilder.toString());
                    stringBuilder.delete(0, stringBuilder.length());
                    continue block4;
                }
                case '\"': 
                case '\'': {
                    if (c2 == '\u0000') {
                        c2 = c3;
                        continue block4;
                    }
                    if (c2 == c3) {
                        arrayList.add(stringBuilder.toString());
                        stringBuilder.delete(0, stringBuilder.length());
                        c2 = '\u0000';
                        continue block4;
                    }
                    stringBuilder.append(c3);
                    continue block4;
                }
                default: {
                    stringBuilder.append(c3);
                }
            }
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(stringBuilder.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public DeviceFile(String string, int n2, ICobolVar iCobolVar, int n3, boolean bl, boolean bl2, Class clazz) {
        this(string, n2, iCobolVar, n3, bl, bl2);
        this.clazz = clazz;
    }

    public DeviceFile(String string, int n2, ICobolVar iCobolVar, int n3, boolean bl, boolean bl2, String string2) {
        this(string, n2, iCobolVar, n3, bl, bl2);
        this.clazz = string2;
    }

    public DeviceFile(String string, int n2, ICobolVar iCobolVar, int n3, boolean bl, boolean bl2) {
        super(string, n2, iCobolVar, n3, bl, 1);
    }

    private DynamicOutput getOutInstance() {
        try {
            if (this.clazz != null) {
                if (this.clazz instanceof Class) {
                    return (DynamicOutput)((Class)this.clazz).newInstance();
                }
                return (DynamicOutput)Class.forName((String)this.clazz).newInstance();
            }
            return (DynamicOutput)FileTypeManager.getOutput().newInstance();
        }
        catch (Exception exception) {
            throw new IscobolRuntimeException(5, " (" + exception + ")");
        }
    }

    private DynamicInput getInInstance() {
        try {
            if (this.clazz != null) {
                if (this.clazz instanceof Class) {
                    return (DynamicInput)((Class)this.clazz).newInstance();
                }
                return (DynamicInput)Class.forName((String)this.clazz).newInstance();
            }
            return (DynamicInput)FileTypeManager.getInput().newInstance();
        }
        catch (Exception exception) {
            throw new IscobolRuntimeException(5, " (" + exception + ")");
        }
    }

    protected boolean isSpoolPrinter() {
        return this.spoolPrinter;
    }

    protected boolean isGraphicPrinter() {
        return this.graphicPrinter;
    }

    protected void pipedOpen(String string, int n2, int n3) {
        String string2 = string.substring(2, string.length()).trim();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = this.isBinary();
        String string3 = null;
        if (string.equalsIgnoreCase("PRINTER?") || string2.equalsIgnoreCase("spooler") || (bl = string2.equalsIgnoreCase("preview")) || (bl3 = string2.toLowerCase().startsWith("pdf")) || (bl2 = string2.equalsIgnoreCase("spooler-direct"))) {
            switch (n2) {
                case 2: 
                case 6: {
                    try {
                        string3 = bl3 ? (string2.length() > 3 ? string2.substring(3).trim() : null) : string;
                        LocalSpoolPrinter localSpoolPrinter = SpoolPrinterList.get().newSpoolPrinter(bl, bl2, bl3, string3, bl4);
                        if (this.printerAttrs != null) {
                            this.printerAttrs.copyTo(localSpoolPrinter);
                            this.printerAttrs = null;
                        }
                        Output output = new Output(localSpoolPrinter, this, bl4);
                        output.preview = bl;
                        output.direct = bl2;
                        output.pdf = bl3;
                        this.outFile = output;
                    }
                    catch (IOException iOException) {
                        ScreenUtility.handleIOException(iOException);
                    }
                    this.spoolPrinter = true;
                    this.graphicPrinter = !bl2;
                    break;
                }
                case 1: 
                case 3: {
                    CobolIOException.get(142, "", this, 1);
                    break;
                }
                default: {
                    throw new IscobolRuntimeException(3, new IllegalArgumentException("OPEN").toString());
                }
            }
            this.setOpenMode(n2);
        } else {
            try {
                String[] stringArray = DeviceFile.breakCmdLine(string2);
                this.proc = Runtime.getRuntime().exec(stringArray);
                switch (n2) {
                    case 2: 
                    case 6: {
                        this.outFile = new Output(this.proc.getOutputStream(), bl4);
                        break;
                    }
                    case 3: {
                        this.outFile = new Output(this.proc.getOutputStream(), bl4);
                        this.inpFile = new Input(this.proc.getInputStream(), bl4);
                    }
                    case 1: {
                        this.inpFile = new Input(this.proc.getInputStream(), bl4);
                        break;
                    }
                    default: {
                        throw new IscobolRuntimeException(3, new IllegalArgumentException("OPEN").toString());
                    }
                }
                this.setOpenMode(n2);
            }
            catch (IOException iOException) {
                CobolIOException.get(iOException, this, 1);
            }
        }
    }

    @Override
    public void peerOpen(String string, int n2, int n3) {
        this.spoolPrinter = false;
        switch (this.getFileType()) {
            case 1: {
                this.pipedOpen(string, n2, n3);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.stdOpen(n2);
                break;
            }
            default: {
                this.fileOpen(string, n2, n3);
            }
        }
        this.linageCounter = 1;
    }

    protected void stdOpen(int n2) {
        block0 : switch (n2) {
            case 2: 
            case 6: {
                switch (this.getFileType()) {
                    case 3: {
                        this.outFile = new Output(System.out, this.isBinary());
                        break block0;
                    }
                    case 4: {
                        this.outFile = new Output(System.err, this.isBinary());
                        break block0;
                    }
                }
                CobolIOException.get(142, "", this, 1);
                break;
            }
            case 1: {
                switch (this.getFileType()) {
                    case 2: {
                        this.inpFile = new Input(System.in, this.isBinary());
                        break block0;
                    }
                }
                CobolIOException.get(142, "", this, 1);
                break;
            }
            case 3: {
                CobolIOException.get(142, "", this, 1);
            }
        }
        this.setOpenMode(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fileOpen(String string, int n2, int n3) {
        switch (n2) {
            case 2: {
                this.outFile = this.getOutInstance();
                int n4 = this.outFile.open(string, n3, this.getMaxRecordLen(), 0, this.isBinary(), false, this instanceof LineSeqFile, false, this.assignExt);
                if (n4 == 1) break;
                try {
                    CobolIOException.get(this.outFile.getCobErrno(), "", this, 1);
                    break;
                }
                finally {
                    if (n4 == 0) {
                        this.outFile = null;
                    }
                }
            }
            case 3: {
                CobolIOException.get(142, "", this, 1);
                break;
            }
            case 6: {
                this.outFile = this.getOutInstance();
                int n5 = this.outFile.open(string, n3, this.getMaxRecordLen(), 0, this.isBinary(), true, this instanceof LineSeqFile, this.isOptional(n2), this.assignExt);
                if (n5 == 1) break;
                try {
                    CobolIOException.get(this.outFile.getCobErrno(), "", this, 1);
                    break;
                }
                finally {
                    if (n5 == 0) {
                        this.outFile = null;
                    }
                }
            }
            case 1: {
                this.inpFile = this.getInInstance();
                int n6 = this.inpFile.open(string, n3, this.getMaxRecordLen(), 0, this.isBinary(), this instanceof LineSeqFile, this.isOptional(n2), this.assignExt);
                if (n6 == 1) break;
                try {
                    if (this.isOptional(n2)) break;
                    CobolIOException.get(this.inpFile.getCobErrno(), "", this, 1);
                    break;
                }
                finally {
                    if (n6 == 0) {
                        this.inpFile = null;
                    }
                }
            }
            default: {
                throw new IscobolRuntimeException(3, new IllegalArgumentException("OPEN").toString());
            }
        }
        this.setOpenMode(n2);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void peerClose(int var1_1) {
        switch (this.getFileType()) {
            case 2: {
                this.inpFile = null;
                break;
            }
            case 3: 
            case 4: {
                if (this.outFile != null && this.outFile.flush() != 1) {
                    CobolIOException.get(this.outFile.getCobErrno(), "", this, 2);
                }
                this.outFile = null;
                break;
            }
            default: {
                if (this.inpFile == null) ** GOTO lbl20
                try {
                    if (this.inpFile.close() == 1) ** GOTO lbl29
                    CobolIOException.get(this.inpFile.getCobErrno(), "", this, 2);
                }
                finally {
                    this.inpFile = null;
                    this.setOpenMode(0);
                }
lbl20:
                // 1 sources

                if (this.outFile != null) {
                    try {
                        if (!(this.outFile instanceof Output && ((Output)this.outFile).printInBackground || this.outFile.close() == 1)) {
                            CobolIOException.get(this.outFile.getCobErrno(), "", this, 2);
                        }
                    }
                    finally {
                        this.outFile = null;
                        this.setOpenMode(0);
                    }
                }
lbl29:
                // 5 sources

                if (this.proc == null) break;
                var2_3 = new Thread(){

                    @Override
                    public void run() {
                        Process process = DeviceFile.this.proc;
                        if (process != null) {
                            try {
                                String string;
                                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                                while ((string = bufferedReader.readLine()) != null) {
                                    System.err.println(string);
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                };
                var2_3.setDaemon(true);
                var2_3.start();
                try {
                    var3_5 = this.proc.waitFor();
                    if (var3_5 != 0) {
                        CobolIOException.get(205, "" + var3_5, this, 2);
                    }
                }
                catch (InterruptedException var3_6) {
                    CobolIOException.get(var3_6, this, 2);
                }
                this.proc = null;
            }
        }
        this.setOpenMode(0);
    }

    @Override
    public boolean advance(int n2, int n3) {
        boolean bl = false;
        int n4 = this.getTotLinage();
        if ((this.getOpenMode() & 2) != 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.outFile.write(10) == 0) {
                    CobolIOException.get(this.outFile.getCobErrno(), "", this, 3);
                }
                ++this.linageCounter;
                if (n4 > 0 && this.linageCounter > n4) {
                    bl = true;
                    this.linageCounter = 1;
                    continue;
                }
                if (this.footing == null || this.linageCounter < this.footing.toint()) continue;
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean page(int n2) {
        if ((this.getOpenMode() & 2) != 0) {
            int n3 = this.getTotLinage();
            if (n3 > 0) {
                this.advance(n3 - this.linageCounter + 1, n2);
            } else if (this.outFile.write(12) == 0) {
                CobolIOException.get(this.outFile.getCobErrno(), "", this, 3);
            }
            this.linageCounter = 1;
        }
        return false;
    }

    private int getChnlLine(int n2) {
        if (this.chnls == null) {
            int n3;
            this.chnls = new int[13];
            String string = Config.a(".printer.channels", "");
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":", true);
            for (n3 = 0; stringTokenizer.hasMoreTokens() && n3 < this.chnls.length; ++n3) {
                String string2 = stringTokenizer.nextToken();
                if (":".equals(string2)) {
                    this.chnls[n3] = 1;
                    continue;
                }
                try {
                    this.chnls[n3] = Integer.parseInt(string2);
                    if (this.chnls[n3] < 1) {
                        this.chnls[n3] = 1;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.chnls[n3] = 1;
                }
                if (!stringTokenizer.hasMoreTokens()) continue;
                stringTokenizer.nextToken();
            }
            while (n3 < this.chnls.length) {
                this.chnls[n3] = 1;
                ++n3;
            }
        }
        return this.chnls[n2 - 1];
    }

    @Override
    public boolean writeAdvancing(int n2, int n3, boolean bl, int n4, int n5) {
        int n6;
        boolean bl2 = false;
        int n7 = this.getTotLinage();
        super.write(bl, n4);
        if (this.isGraphicPrinter()) {
            n5 |= 1;
        }
        if (!isMVSPrint) {
            switch (n2) {
                case 6: {
                    if (this.getChnlLine(n3) != 1) break;
                    n2 = 4;
                    break;
                }
                case 5: {
                    if (this.getChnlLine(n3) != 1) break;
                    n2 = 3;
                }
            }
        }
        switch (n2) {
            default: {
                n6 = this.outFile.writeAdvancing(n2, n3, this.getBufferAsVar(), n4, n5);
                break;
            }
            case 1: {
                bl2 = this.checkOverflow(n3);
                if (bl2) {
                    this.newPage(n4, n5);
                    n6 = this.outFile.writeAdvancing(n2, 1, this.getBufferAsVar(), n4, n5);
                    this.linageCounter = 1;
                    break;
                }
                n6 = this.outFile.writeAdvancing(n2, n3, this.getBufferAsVar(), n4, n5);
                this.linageCounter += n3;
                bl2 = this.checkFooting();
                break;
            }
            case 2: {
                bl2 = this.checkOverflow(n3);
                if (bl2) {
                    n6 = this.outFile.writeAdvancing(n2, 1, this.getBufferAsVar(), n4, n5);
                    this.newPage(n4, n5);
                    this.linageCounter = 1;
                    break;
                }
                n6 = this.outFile.writeAdvancing(n2, n3, this.getBufferAsVar(), n4, n5);
                this.linageCounter += n3;
                bl2 = this.checkFooting();
                break;
            }
            case 3: {
                n6 = n7 > 0 ? this.outFile.writeAdvancing(1, n7 - this.linageCounter + 1, this.getBufferAsVar(), n4, n5) : this.outFile.writeAdvancing(n2, n3, this.getBufferAsVar(), n4, n5);
                this.linageCounter = 1;
                break;
            }
            case 4: {
                n7 = this.getTotLinage();
                n6 = n7 > 0 ? this.outFile.writeAdvancing(2, n7 - this.linageCounter + 1, this.getBufferAsVar(), n4, n5) : this.outFile.writeAdvancing(n2, n3, this.getBufferAsVar(), n4, n5);
                this.linageCounter = 1;
                break;
            }
            case 5: {
                if (isMVSPrint) {
                    n6 = this.outFile.writeAdvancing(n2, n3, this.getBufferAsVar(), n4, n5);
                    this.linageCounter = this.getChnlLine(n3);
                    break;
                }
                if (this.linageCounter > (n3 = this.getChnlLine(n3))) {
                    ICobolVar iCobolVar = this.getBufferAsVar();
                    n7 = this.getTotLinage();
                    if (n7 > 0) {
                        int n8 = n7 - this.linageCounter + 1 + n3;
                        n6 = this.outFile.writeAdvancing(1, n8, iCobolVar, n4, n5);
                    } else {
                        n6 = this.outFile.writeAdvancing(8, 0, iCobolVar, 0, 0);
                        n6 = this.outFile.writeAdvancing(1, n3 - 1, iCobolVar, n4, n5);
                    }
                } else {
                    ICobolVar iCobolVar = this.getBufferAsVar();
                    n6 = this.outFile.writeAdvancing(1, n3 - this.linageCounter, iCobolVar, n4, n5);
                }
                this.linageCounter = n3;
                break;
            }
            case 6: {
                if (isMVSPrint) {
                    n6 = this.outFile.writeAdvancing(n2, n3, this.getBufferAsVar(), n4, n5);
                    this.linageCounter = this.getChnlLine(n3);
                    break;
                }
                if (this.linageCounter >= (n3 = this.getChnlLine(n3))) {
                    ICobolVar iCobolVar = this.getBufferAsVar();
                    n7 = this.getTotLinage();
                    if (n7 > 0) {
                        int n9 = n7 - this.linageCounter + 1 + n3;
                        n6 = this.outFile.writeAdvancing(2, n9, iCobolVar, n4, n5);
                    } else {
                        n6 = this.outFile.writeAdvancing(2, 0, iCobolVar, n4, n5);
                        n6 = this.outFile.writeAdvancing(8, 0, iCobolVar, 0, 0);
                        n6 = this.outFile.writeAdvancing(7, n3 - 1, iCobolVar, n4, n5);
                    }
                } else {
                    ICobolVar iCobolVar = this.getBufferAsVar();
                    n6 = this.outFile.writeAdvancing(2, n3 - this.linageCounter, iCobolVar, n4, n5);
                }
                this.linageCounter = n3;
            }
        }
        if (n6 != 1) {
            CobolIOException.get(this.outFile.getCobErrno(), "", this, 3);
        }
        return bl2;
    }

    @Override
    public CobolFile setLinage(ICobolVar iCobolVar) {
        return this.setLinage(iCobolVar, null, null, null);
    }

    @Override
    public CobolFile setLinage(ICobolVar iCobolVar, ICobolVar iCobolVar2, ICobolVar iCobolVar3, ICobolVar iCobolVar4) {
        this.linage = iCobolVar;
        this.footing = iCobolVar2;
        this.top = iCobolVar3;
        this.bottom = iCobolVar4;
        return this;
    }

    private int getTotLinage() {
        int n2 = 0;
        if (this.linage != null) {
            n2 += this.linage.toint();
        }
        if (this.top != null) {
            n2 += this.top.toint();
        }
        if (this.bottom != null) {
            n2 += this.bottom.toint();
        }
        return n2;
    }

    @Override
    public int linageCounter() {
        return this.linageCounter;
    }

    private boolean checkOverflow(int n2) {
        return this.linage != null && this.linageCounter + n2 > this.linage.toint();
    }

    private boolean checkFooting() {
        return this.footing != null && this.linageCounter >= this.footing.toint();
    }

    private void newPage(int n2, int n3) {
        if (this.linage != null) {
            int n4;
            int n5 = this.linage.toint();
            int n6 = 0;
            if (n5 > this.linageCounter) {
                n6 += n5 - this.linageCounter;
            }
            if (this.bottom != null) {
                n6 += this.bottom.toint();
            }
            if (this.top != null) {
                n6 += this.top.toint();
            }
            if (n6 > 0 && (n4 = this.outFile.writeAdvancing(7, n6, null, n2, n3)) != 1) {
                CobolIOException.get(this.outFile.getCobErrno(), "", this, 3);
            }
            this.linageCounter = 1;
        }
    }

    @Override
    public NumericVar getLinageCounter() {
        return Factory.getNumLiteral(this.linageCounter, 10, 0, false);
    }

    @Override
    public void rewrite(boolean bl, int n2) {
        if (this.getOpenMode() != 0) {
            CobolIOException.get(101, "01", this, 4);
        } else {
            CobolIOException.get(101, "02", this, 4);
        }
    }

    @Override
    public void delete() {
        if (this.getOpenMode() != 0) {
            CobolIOException.get(101, "01", this, 5);
        } else {
            CobolIOException.get(101, "02", this, 5);
        }
    }

    @Override
    public int readPrev(boolean bl, ICobolVar iCobolVar) {
        throw new IscobolRuntimeException(4, this.getLogicName());
    }

    @Override
    public int readKey(ICobolVar[] iCobolVarArray, boolean bl, ICobolVar iCobolVar) {
        throw new IscobolRuntimeException(4, this.getLogicName());
    }

    @Override
    public void start(ICobolVar[] iCobolVarArray, int n2, int n3) {
        throw new IscobolRuntimeException(4, this.getLogicName());
    }

    @Override
    public void deleteFile(ICobolVar iCobolVar) {
        super.deleteFile(iCobolVar);
        switch (this.getFileType()) {
            default: {
                break;
            }
            case 0: {
                this.outFile = this.getOutInstance();
                if (this.outFile.remove(com.iscobol.rts.File.get(this.getOsPath())) != 1) {
                    CobolIOException.get(this.outFile.getCobErrno(), "", this, 11);
                }
                this.outFile = null;
            }
        }
    }

    public final void print() {
        this.print(0);
    }

    public final void print(int n2) {
        PrintBackgroundMonitor printBackgroundMonitor = (PrintBackgroundMonitor)IscobolSystem.get(PrintBackgroundMonitor.class);
        if (printBackgroundMonitor != null) {
            try {
                IOException iOException;
                block8: {
                    if (Config.b(".file.page_eject_on_close", false) && (n2 & 1) == 0) {
                        try {
                            printBackgroundMonitor.getSpoolPrinter().write(12);
                        }
                        catch (MixingCharAndBytesException mixingCharAndBytesException) {
                            if (!printBackgroundMonitor.isDirect()) break block8;
                            if (mixingCharAndBytesException.getErrorCode() == 3) {
                                printBackgroundMonitor.getSpoolPrinter().write((byte)12);
                            }
                            if (mixingCharAndBytesException.getErrorCode() != 4) break block8;
                            printBackgroundMonitor.getSpoolPrinter().writeBytes(new byte[]{12});
                        }
                    }
                }
                if ((iOException = printBackgroundMonitor.getSpoolPrinter().printAndClose()) != null) {
                    throw iOException;
                }
            }
            catch (IOException iOException) {
                int n3 = JavaToIscobolError.map(iOException);
                CobolIOException.get(n3, "", this, 2);
            }
        }
    }

    public final boolean closeDeferred(Runnable runnable) {
        if (this.outFile instanceof Output) {
            Output output = (Output)this.outFile;
            if (output.remWriter != null) {
                boolean bl = output.printInBackground = !output.preview && (!output.pdf && Config.b("iscobol.print.spooler_async", true) || output.pdf && Config.b("iscobol.print.pdf_async", false));
                if (output.printInBackground) {
                    PrintBackgroundMonitor printBackgroundMonitor = PrintBackgroundMonitorFactory.getInstance(runnable, output.remWriter, output.direct, output.cp);
                    if (printBackgroundMonitor != null) {
                        printBackgroundMonitor.start();
                        this.close();
                        return true;
                    }
                    output.printInBackground = false;
                }
            }
        }
        return false;
    }

    public static class Input
    implements DynamicInput {
        BufferedReader inpReader;
        BufferedInputStream inpStream;
        int cobErrno;

        public Input() {
        }

        public Input(InputStream inputStream, boolean bl) {
            if (bl) {
                this.inpStream = new BufferedInputStream(inputStream);
            } else {
                this.inpReader = new BufferedReader(new InputStreamReader(inputStream));
            }
        }

        @Override
        public int getCobErrno() {
            return this.cobErrno;
        }

        @Override
        public int open(String string, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            if (bl4) {
                string = BaseFile.expandFileName(string);
            }
            File file = new File(string);
            try {
                if (bl) {
                    this.inpStream = new BufferedInputStream(new FileInputStream(file));
                } else {
                    this.inpReader = new BufferedReader(new FileReader(file));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.cobErrno = file.exists() ? 131 : 130;
                return 0;
            }
            return 1;
        }

        @Override
        public String readLine() throws IOException {
            return this.inpReader.readLine();
        }

        @Override
        public int read(char[] cArray, int n2, int n3) throws IOException {
            return this.inpReader.read(cArray, n2, n3);
        }

        @Override
        public int read(byte[] byArray, int n2, int n3) throws IOException {
            return this.inpStream.read(byArray, n2, n3);
        }

        @Override
        public int close() {
            try {
                if (this.inpReader != null) {
                    this.inpReader.close();
                }
                return 1;
            }
            catch (IOException iOException) {
                this.cobErrno = JavaToIscobolError.map(iOException);
                return 0;
            }
        }

        public boolean exists(File file) {
            return file.exists();
        }
    }

    public static class Output
    implements DynamicOutput {
        private static final int CLOSED = 0;
        private static final int REMOTE = 1;
        private static final int WRITER = 2;
        private static final int STREAM = 3;
        private int type;
        protected boolean printInBackground;
        protected boolean preview;
        protected boolean pdf;
        protected boolean cp;
        protected int maxRecSize;
        protected int minRecSize;
        protected boolean binary;
        protected boolean lineSequential;
        protected boolean direct;
        protected LocalSpoolPrinter remWriter;
        protected Writer outWriter;
        protected OutputStream outStream;
        protected int cobErrno = 0;

        public Output(LocalSpoolPrinter localSpoolPrinter, DataStream dataStream, boolean bl) {
            this.binary = bl;
            this.remWriter = localSpoolPrinter;
            this.type = 1;
            if (dataStream instanceof PrinterFile) {
                this.cp = ((PrinterFile)dataStream).isCp();
            }
            if (Config.b(".printer.dialog.always", false)) {
                try {
                    if (!this.remWriter.setup()) {
                        CobolIOException.get(142, "", dataStream, 1);
                    }
                }
                catch (IOException iOException) {
                    CobolIOException.get(JavaToIscobolError.map(iOException), "", dataStream, 1);
                }
            }
        }

        public Output() {
            this.type = 0;
        }

        public Output(OutputStream outputStream, boolean bl) {
            this.binary = bl;
            if (this.binary) {
                this.outStream = outputStream;
                this.type = 3;
            } else {
                this.outWriter = new OutputStreamWriter(outputStream);
                this.type = 2;
            }
        }

        public Output(OutputStream outputStream) {
            this.binary = true;
            this.outStream = outputStream;
            this.type = 3;
        }

        public boolean isDirect() {
            return this.direct;
        }

        @Override
        public int getCobErrno() {
            return this.cobErrno;
        }

        @Override
        public int open(String string, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
            int n5 = 1;
            if (bl5) {
                string = Config.a("." + string.toLowerCase(), string);
            }
            File file = new File(string);
            this.lineSequential = bl3;
            this.maxRecSize = n3;
            this.minRecSize = n4;
            if (bl4) {
                if (!file.exists()) {
                    this.cobErrno = 202;
                    n5 = -1;
                    try {
                        file.createNewFile();
                    }
                    catch (IOException iOException) {
                        this.cobErrno = JavaToIscobolError.map(iOException);
                        return 0;
                    }
                }
            } else if (bl2) {
                if (!file.exists()) {
                    this.cobErrno = 130;
                    n5 = 0;
                    return n5;
                }
            } else {
                try {
                    if (file.exists()) {
                        file.delete();
                    }
                    file.createNewFile();
                }
                catch (IOException iOException) {
                    this.cobErrno = JavaToIscobolError.map(iOException);
                    return 0;
                }
            }
            try {
                this.binary = bl;
                if (this.binary) {
                    this.outStream = new FileOutputStream(file.getPath(), bl2);
                    this.type = 3;
                } else {
                    this.outWriter = new FileWriter(file.getPath(), bl2);
                    this.type = 2;
                }
            }
            catch (IOException iOException) {
                this.cobErrno = JavaToIscobolError.map(iOException);
                return 0;
            }
            return n5;
        }

        @Override
        public int close() {
            try {
                switch (this.type) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        IOException iOException = this.remWriter.printAndClose();
                        if (iOException != null) {
                            throw iOException;
                        }
                        break;
                    }
                    case 2: {
                        this.outWriter.close();
                        break;
                    }
                    case 3: {
                        this.outStream.close();
                        break;
                    }
                    default: {
                        throw new IscobolRuntimeException(3, "DeviceFile.close type=" + this.type);
                    }
                }
            }
            catch (IOException iOException) {
                this.cobErrno = JavaToIscobolError.map(iOException);
                return 0;
            }
            return 1;
        }

        @Override
        public int flush() {
            try {
                switch (this.type) {
                    case 1: {
                        this.remWriter.flush();
                        break;
                    }
                    case 2: {
                        this.outWriter.flush();
                        break;
                    }
                    case 3: {
                        this.outStream.flush();
                        break;
                    }
                    default: {
                        throw new IscobolRuntimeException(3, "DeviceFile.flush type=" + this.type);
                    }
                }
            }
            catch (IOException iOException) {
                this.cobErrno = JavaToIscobolError.map(iOException);
                return 0;
            }
            return 1;
        }

        @Override
        public void setMinRecSize(int n2) {
            this.minRecSize = n2;
        }

        private int tailTrim(char[] cArray, int n2) {
            int n3;
            for (n3 = n2 - 1; n3 >= 0 && cArray[n3] == ' '; --n3) {
            }
            if (++n3 < this.minRecSize && (n3 = this.minRecSize) > n2) {
                n3 = n2;
            }
            return n3;
        }

        private int tailTrim(byte[] byArray, int n2) {
            int n3;
            for (n3 = n2 - 1; n3 >= 0 && byArray[n3] == 32; --n3) {
            }
            if (++n3 < this.minRecSize && (n3 = this.minRecSize) > n2) {
                n3 = n2;
            }
            return n3;
        }

        private int tailTrimBytes(byte[] byArray, int n2) {
            int n3 = n2;
            try {
                String string = new String(byArray, 0, n2, CobolVar.encoding);
                int n4 = 0;
                n3 = string.length() - 1;
                while (n3 >= 0 && string.charAt(n3) == ' ') {
                    --n3;
                    ++n4;
                }
                n3 = n2 - n4;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (n3 < this.minRecSize) {
                n3 = this.minRecSize;
            }
            return n3;
        }

        @Override
        public int writeAdvancing(int n2, int n3, ICobolVar iCobolVar, int n4, int n5) {
            int n6;
            boolean bl = (n5 & 2) == 0;
            boolean bl2 = (n5 & 1) == 0;
            boolean bl3 = !(iCobolVar instanceof IPicN);
            switch (n2) {
                default: {
                    n6 = this.write(iCobolVar, n4, bl, bl3);
                    if (n6 != 1 || !bl2) break;
                    n6 = this.write(13, bl3);
                    break;
                }
                case 1: {
                    n6 = this.advance(n3, bl2, bl3);
                    if (n6 != 1 || (n6 = this.write(iCobolVar, n4, bl, bl3)) != 1 || !bl2) break;
                    n6 = this.write(13, bl3);
                    break;
                }
                case 2: {
                    n6 = this.write(iCobolVar, n4, bl, bl3);
                    if (n6 != 1) break;
                    if (n6 == 1 && bl2) {
                        n6 = this.write(13, bl3);
                    }
                    if (n6 != 1) break;
                    n6 = this.advance(n3, bl2, bl3);
                    break;
                }
                case 3: {
                    n6 = this.page(bl3);
                    if (n6 != 1 || (n6 = this.write(iCobolVar, n4, bl, bl3)) != 1 || !bl2) break;
                    n6 = this.write(13, bl3);
                    break;
                }
                case 4: {
                    n6 = this.write(iCobolVar, n4, bl, bl3);
                    if (n6 != 1) break;
                    if (n6 == 1 && bl2) {
                        n6 = this.write(13, bl3);
                    }
                    if (n6 != 1) break;
                    n6 = this.page(bl3);
                    break;
                }
                case 8: {
                    n6 = this.page(bl3);
                    break;
                }
                case 7: {
                    n6 = this.advance(n3, bl2, bl3);
                }
            }
            return n6;
        }

        private int advance(int n2, boolean bl, boolean bl2) {
            int n3 = 1;
            if (bl) {
                for (int i2 = 0; i2 < n2 && n3 == 1; ++i2) {
                    n3 = this.write(10, bl2);
                }
            } else {
                for (int i3 = 0; i3 < n2 && n3 == 1; ++i3) {
                    n3 = this.write(10, bl2);
                }
            }
            return n3;
        }

        private int page(boolean bl) {
            return this.write(12, bl);
        }

        @Override
        public int write(ICobolVar iCobolVar, int n2, boolean bl) {
            return this.write(iCobolVar, n2, bl, !(iCobolVar instanceof IPicN));
        }

        protected int write(ICobolVar iCobolVar, int n2, boolean bl, boolean bl2) {
            try {
                switch (this.type) {
                    case 1: {
                        if (this.binary) {
                            byte[] byArray = iCobolVar.getBytes();
                            int n3 = n2 = n2 < byArray.length ? n2 : byArray.length;
                            if (bl) {
                                this.remWriter.write(byArray, 0, this.tailTrim(byArray, n2));
                                break;
                            }
                            this.remWriter.write(byArray, 0, n2);
                            break;
                        }
                        if (bl2) {
                            byte[] byArray = iCobolVar.getBytes();
                            byte[] byArray2 = new byte[byArray.length];
                            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                            int n4 = n2 = n2 < byArray2.length ? n2 : byArray2.length;
                            if (bl) {
                                this.remWriter.writeBytes(byArray2, 0, this.tailTrimBytes(byArray2, n2));
                                break;
                            }
                            this.remWriter.writeBytes(byArray2, 0, n2);
                            break;
                        }
                        char[] cArray = iCobolVar.basicToString().toCharArray();
                        int n5 = n2 = n2 < cArray.length ? n2 : cArray.length;
                        if (bl) {
                            this.remWriter.write(cArray, 0, this.tailTrim(cArray, n2));
                            break;
                        }
                        this.remWriter.write(cArray, 0, n2);
                        break;
                    }
                    case 2: {
                        char[] cArray = iCobolVar.basicToString().toCharArray();
                        int n6 = n2 = n2 < cArray.length ? n2 : cArray.length;
                        if (bl) {
                            this.outWriter.write(cArray, 0, this.tailTrim(cArray, n2));
                            break;
                        }
                        this.outWriter.write(cArray, 0, n2);
                        break;
                    }
                    case 3: {
                        byte[] byArray = iCobolVar.getBytes();
                        int n7 = n2 = n2 < byArray.length ? n2 : byArray.length;
                        if (bl) {
                            this.outStream.write(byArray, 0, this.tailTrim(byArray, n2));
                            break;
                        }
                        this.outStream.write(byArray, 0, n2);
                        break;
                    }
                    default: {
                        throw new IscobolRuntimeException(3, "DeviceFile.write1 type=" + this.type);
                    }
                }
            }
            catch (IOException iOException) {
                this.cobErrno = JavaToIscobolError.map(iOException);
                return 0;
            }
            return 1;
        }

        @Override
        public int write(int n2) {
            return this.write(n2, false);
        }

        public void writeChar(int n2) {
            if (this.remWriter != null) {
                try {
                    this.remWriter.write(n2);
                }
                catch (IOException iOException) {
                    this.cobErrno = JavaToIscobolError.map(iOException);
                }
            }
        }

        public void writeByte(byte by) {
            if (this.remWriter != null) {
                try {
                    this.remWriter.write(by);
                }
                catch (IOException iOException) {
                    this.cobErrno = JavaToIscobolError.map(iOException);
                }
            }
        }

        public void writeCharX(byte by) {
            if (this.remWriter != null) {
                try {
                    this.remWriter.writeBytes(new byte[]{by}, 0, 1);
                }
                catch (IOException iOException) {
                    this.cobErrno = JavaToIscobolError.map(iOException);
                }
            }
        }

        protected int write(int n2, boolean bl) {
            try {
                switch (this.type) {
                    case 1: {
                        if (this.binary) {
                            this.remWriter.write((byte)n2);
                            break;
                        }
                        if (bl) {
                            this.remWriter.writeBytes(new byte[]{(byte)n2});
                            break;
                        }
                        this.remWriter.write(n2);
                        break;
                    }
                    case 2: {
                        this.outWriter.write(n2);
                        break;
                    }
                    case 3: {
                        this.outStream.write((byte)n2);
                        break;
                    }
                    default: {
                        throw new IscobolRuntimeException(3, "DeviceFile.write3 type=" + this.type);
                    }
                }
            }
            catch (IOException iOException) {
                this.cobErrno = JavaToIscobolError.map(iOException);
                return 0;
            }
            return 1;
        }

        public boolean exists(File file) {
            return file.exists();
        }

        public boolean create(File file) throws IOException {
            return file.createNewFile();
        }

        @Override
        public int remove(File file) {
            if (!file.delete()) {
                this.cobErrno = 203;
                return 0;
            }
            return 1;
        }

        public void setMVSPrint() {
            isMVSPrint = true;
        }
    }
}

