/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.io.BaseFile;
import com.iscobol.java.CobolVarHelper;
import com.iscobol.java.IsCobol;
import com.iscobol.rts.Config;
import com.iscobol.rts.DynamicFile;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.KeyDescription;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.so.DynamicCall;
import com.iscobol.types.PicX;
import java.io.File;

public class DynamicBtrieve
implements DynamicFile,
RuntimeErrorsNumbers,
Cloneable {
    public static final String LIBNAME = "wbtrv32.dll";
    public static final String FUNNAME = "BTRCALL";
    public static final int COMP_OPT = 66;
    public static final DynamicCall dCall;
    public static final short VAR_RECS = 1;
    public static final short DATA_COMP = 8;
    public static final short DUP = 1;
    public static final short MOD = 2;
    public static final short SEG = 16;
    public static final short B_OPEN = 0;
    public static final short B_CLOSE = 1;
    public static final short B_INSERT = 2;
    public static final short B_UPDATE = 3;
    public static final short B_DELETE = 4;
    public static final short B_GET_EQUAL = 5;
    public static final short B_GET_NEXT = 6;
    public static final short B_GET_PREVIOUS = 7;
    public static final short B_GET_GT = 8;
    public static final short B_GET_GE = 9;
    public static final short B_GET_LT = 10;
    public static final short B_GET_LE = 11;
    public static final short B_GET_FIRST = 12;
    public static final short B_GET_LAST = 13;
    public static final short B_CREATE = 14;
    public static final short B_STAT = 15;
    public static final short B_EXTEND = 16;
    public static final short B_SET_DIR = 17;
    public static final short B_GET_DIR = 18;
    public static final short B_BEGIN_TRAN = 19;
    public static final short B_END_TRAN = 20;
    public static final short B_ABORT_TRAN = 21;
    public static final short B_GET_POSITION = 22;
    public static final short B_GET_DIRECT = 23;
    public static final short B_STEP_NEXT = 24;
    public static final short B_STOP = 25;
    public static final short B_VERSION = 26;
    public static final short B_UNLOCK = 27;
    public static final short B_RESET = 28;
    public static final short B_SET_OWNER = 29;
    public static final short B_CLEAR_OWNER = 30;
    public static final short B_BUILD_INDEX = 31;
    public static final short B_DROP_INDEX = 32;
    public static final short B_STEP_FIRST = 33;
    public static final short B_STEP_LAST = 34;
    public static final short B_STEP_PREVIOUS = 35;
    public static final short B_GET_NEXT_EXTENDED = 36;
    public static final short B_GET_PREV_EXTENDED = 37;
    public static final short B_STEP_NEXT_EXT = 38;
    public static final short B_STEP_PREVIOUS_EXT = 39;
    public static final short B_EXT_INSERT = 40;
    public static final short B_MISC_DATA = 41;
    public static final short B_CONTINUOUS = 42;
    public static final short B_SEEK_PERCENT = 44;
    public static final short B_GET_PERCENT = 45;
    public static final short B_CHUNK_UPDATE = 53;
    public static final short B_KEY_EQUAL = 55;
    public static final short B_KEY_NEXT = 56;
    public static final short B_KEY_PREV = 57;
    public static final short B_KEY_GT = 58;
    public static final short B_KEY_GE = 59;
    public static final short B_KEY_LT = 60;
    public static final short B_KEY_LE = 61;
    public static final short B_KEY_FIRST = 62;
    public static final short B_KEY_LAST = 63;
    public static final short B_EXTENDED_STAT = 65;
    public static final short B_LOGIN = 78;
    public static final short B_NORMAL = 0;
    public static final short ACCELERATED = -1;
    public static final short READONLY = -2;
    public static final short EXCLUSIVE = -4;
    public static final short S_WAIT_LOCK = 100;
    public static final short S_NOWAIT_LOCK = 200;
    public static final short M_WAIT_LOCK = 300;
    public static final short M_NOWAIT_LOCK = 400;
    public static final short KEY_BIAS = 50;
    public static final short B_NO_ERROR = 0;
    public static final short B_INVALID_FUNCTION = 1;
    public static final short B_IO_ERROR = 2;
    public static final short B_FILE_NOT_OPEN = 3;
    public static final short B_KEY_VALUE_NOT_FOUND = 4;
    public static final short B_DUPLICATE_KEY_VALUE = 5;
    public static final short B_INVALID_KEYNUMBER = 6;
    public static final short B_DIFFERENT_KEYNUMBER = 7;
    public static final short B_POSITION_NOT_SET = 8;
    public static final short B_END_OF_FILE = 9;
    public static final short B_MODIFIABLE_KEYVALUE_ERROR = 10;
    public static final short B_FILENAME_BAD = 11;
    public static final short B_FILE_NOT_FOUND = 12;
    public static final short B_EXTENDED_FILE_ERROR = 13;
    public static final short B_PREIMAGE_OPEN_ERROR = 14;
    public static final short B_PREIMAGE_IO_ERROR = 15;
    public static final short B_EXPANSION_ERROR = 16;
    public static final short B_CLOSE_ERROR = 17;
    public static final short B_DISKFULL = 18;
    public static final short B_UNRECOVERABLE_ERROR = 19;
    public static final short B_RECORD_MANAGER_INACTIVE = 20;
    public static final short B_KEYBUFFER_TOO_SHORT = 21;
    public static final short B_DATALENGTH_ERROR = 22;
    public static final short B_POSITIONBLOCK_LENGTH = 23;
    public static final short B_PAGE_SIZE_ERROR = 24;
    public static final short B_CREATE_IO_ERROR = 25;
    public static final short B_NUMBER_OF_KEYS = 26;
    public static final short B_INVALID_KEY_POSITION = 27;
    public static final short B_INVALID_RECORD_LENGTH = 28;
    public static final short B_INVALID_KEYLENGTH = 29;
    public static final short B_NOT_A_BTRIEVE_FILE = 30;
    public static final short B_FILE_ALREADY_EXTENDED = 31;
    public static final short B_EXTEND_IO_ERROR = 32;
    public static final short B_BTR_CANNOT_UNLOAD = 33;
    public static final short B_INVALID_EXTENSION_NAME = 34;
    public static final short B_DIRECTORY_ERROR = 35;
    public static final short B_TRANSACTION_ERROR = 36;
    public static final short B_TRANSACTION_IS_ACTIVE = 37;
    public static final short B_TRANSACTION_FILE_IO_ERROR = 38;
    public static final short B_END_TRANSACTION_ERROR = 39;
    public static final short B_TRANSACTION_MAX_FILES = 40;
    public static final short B_OPERATION_NOT_ALLOWED = 41;
    public static final short B_INCOMPLETE_ACCEL_ACCESS = 42;
    public static final short B_INVALID_RECORD_ADDRESS = 43;
    public static final short B_NULL_KEYPATH = 44;
    public static final short B_INCONSISTENT_KEY_FLAGS = 45;
    public static final short B_ACCESS_TO_FILE_DENIED = 46;
    public static final short B_MAXIMUM_OPEN_FILES = 47;
    public static final short B_INVALID_ALT_SEQUENCE_DEF = 48;
    public static final short B_KEY_TYPE_ERROR = 49;
    public static final short B_OWNER_ALREADY_SET = 50;
    public static final short B_INVALID_OWNER = 51;
    public static final short B_ERROR_WRITING_CACHE = 52;
    public static final short B_INVALID_INTERFACE = 53;
    public static final short B_VARIABLE_PAGE_ERROR = 54;
    public static final short B_AUTOINCREMENT_ERROR = 55;
    public static final short B_INCOMPLETE_INDEX = 56;
    public static final short B_EXPANED_MEM_ERROR = 57;
    public static final short B_COMPRESS_BUFFER_TOO_SHORT = 58;
    public static final short B_FILE_ALREADY_EXISTS = 59;
    public static final short B_REJECT_COUNT_REACHED = 60;
    public static final short B_SMALL_EX_GET_BUFFER_ERROR = 61;
    public static final short B_INVALID_GET_EXPRESSION = 62;
    public static final short B_INVALID_EXT_INSERT_BUFF = 63;
    public static final short B_OPTIMIZE_LIMIT_REACHED = 64;
    public static final short B_INVALID_EXTRACTOR = 65;
    public static final short B_RI_TOO_MANY_DATABASES = 66;
    public static final short B_RIDDF_CANNOT_OPEN = 67;
    public static final short B_RI_CASCADE_TOO_DEEP = 68;
    public static final short B_RI_CASCADE_ERROR = 69;
    public static final short B_RI_VIOLATION = 71;
    public static final short B_RI_REFERENCED_FILE_CANNOT_OPEN = 72;
    public static final short B_RI_OUT_OF_SYNC = 73;
    public static final short B_END_CHANGED_TO_ABORT = 74;
    public static final short B_RI_CONFLICT = 76;
    public static final short B_CANT_LOOP_IN_SERVER = 77;
    public static final short B_DEAD_LOCK = 78;
    public static final short B_PROGRAMMING_ERROR = 79;
    public static final short B_CONFLICT = 80;
    public static final short B_LOCKERROR = 81;
    public static final short B_LOST_POSITION = 82;
    public static final short B_READ_OUTSIDE_TRANSACTION = 83;
    public static final short B_RECORD_INUSE = 84;
    public static final short B_FILE_INUSE = 85;
    public static final short B_FILE_TABLE_FULL = 86;
    public static final short B_NOHANDLES_AVAILABLE = 87;
    public static final short B_INCOMPATIBLE_MODE_ERROR = 88;
    public static final short B_DEVICE_TABLE_FULL = 90;
    public static final short B_SERVER_ERROR = 91;
    public static final short B_TRANSACTION_TABLE_FULL = 92;
    public static final short B_INCOMPATIBLE_LOCK_TYPE = 93;
    public static final short B_PERMISSION_ERROR = 94;
    public static final short B_SESSION_NO_LONGER_VALID = 95;
    public static final short B_COMMUNICATIONS_ERROR = 96;
    public static final short B_DATA_MESSAGE_TOO_SMALL = 97;
    public static final short B_INTERNAL_TRANSACTION_ERROR = 98;
    public static final short B_REQUESTER_CANT_ACCESS_RUNTIME = 99;
    public static final short B_NO_CACHE_BUFFERS_AVAIL = 100;
    public static final short B_NO_OS_MEMORY_AVAIL = 101;
    public static final short B_NO_STACK_AVAIL = 102;
    public static final short B_CHUNK_OFFSET_TOO_LONG = 103;
    public static final short B_LOCALE_ERROR = 104;
    public static final short B_CANNOT_CREATE_WITH_BAT = 105;
    public static final short B_CHUNK_CANNOT_GET_NEXT = 106;
    public static final short B_CHUNK_INCOMPATIBLE_FILE = 107;
    public static final short B_TRANSACTION_TOO_COMPLEX = 109;
    public static final short B_ARCH_BLOG_OPEN_ERROR = 110;
    public static final short B_ARCH_FILE_NOT_LOGGED = 111;
    public static final short B_ARCH_FILE_IN_USE = 112;
    public static final short B_ARCH_LOGFILE_NOT_FOUND = 113;
    public static final short B_ARCH_LOGFILE_INVALID = 114;
    public static final short B_ARCH_DUMPFILE_ACCESS_ERROR = 115;
    public static final short B_LOCATOR_FILE_INDICATOR = 116;
    public static final short B_NO_SYSTEM_LOCKS_AVAILABLE = 130;
    public static final short B_FILE_FULL = 132;
    public static final short B_MORE_THAN_5_CONCURRENT_USERS = 133;
    public static final short B_ISR_NOT_FOUND = 134;
    public static final short B_ISR_INVALID = 135;
    public static final short B_ACS_NOT_FOUND = 136;
    public static final short B_CANNOT_CONVERT_RP = 137;
    public static final short B_INVALID_NULL_INDICATOR = 138;
    public static final short B_INVALID_KEY_OPTION = 139;
    public static final short B_INCOMPATIBLE_CLOSE = 140;
    public static final short B_INVALID_USERNAME = 141;
    public static final short B_INVALID_DATABASE = 142;
    public static final short B_NO_SSQL_RIGHTS = 143;
    public static final short B_ALREADY_LOGGED_IN = 144;
    public static final short B_NO_DATABASE_SERVICES = 145;
    public static final short B_DUPLICATE_SYSTEM_KEY = 146;
    public static final short B_LOG_SEGMENT_MISSING = 147;
    public static final short B_ROLL_FORWARD_ERROR = 148;
    public static final short B_SYSTEM_KEY_INTERNAL = 149;
    public static final short B_DBS_INTERNAL_ERROR = 150;
    public static final short B_NESTING_DEPTH_ERROR = 151;
    public static final short B_INVALID_PARAMETER_TO_MKDE = 160;
    public static final short B_EXTENDED_SYSTEM = 999;
    public static final short B_EXTENDED_MISSING_FILE = 998;
    private KeyDescription[] keys;
    private int openMode = 0;
    private int lockType;
    private boolean lockWait;
    private boolean lockMulti;
    private boolean exclLock;
    private String path = "";
    private int errno;
    private int lastOp;
    private String sysError;
    private String errMsg;
    private int maxRecordSize;
    private int minRecordSize;
    private long numOfRecords;
    private ICobolVar currentPosition;
    private int currentKey;
    private CobolVarHelper operation_h = new CobolVarHelper("all", 66).pic9Comp5("operation", 4, 0);
    private ICobolVar operation = this.operation_h.get("operation");
    CobolVarHelper dataLen_h = new CobolVarHelper("all", 66).pic9Comp5("dataLen", 4, 0);
    private ICobolVar dataLen = this.dataLen_h.get("dataLen");
    CobolVarHelper keyNum_h = new CobolVarHelper("all", 66).picS9Comp5("keyNum", 4, 0);
    private ICobolVar keyNum = this.keyNum_h.get("keyNum");
    private CobolVarHelper posBlock1_h = new CobolVarHelper("all", 66).picX("posBlock", 128);
    private ICobolVar posBlock = this.posBlock1_h.get("all");
    CobolVarHelper versionBuffer_h = new CobolVarHelper("all", 66).group("").occurs(3).pic9Comp5("Version", 4, 0).pic9Comp5("Revision", 4, 0).picX("MKDEId", 1).endGroup();
    private PicX keyBuffer = new PicX(new byte[256], 0, 256, null, null, "", false, false);
    private PicX asKeyBuffer = new PicX(new byte[256], 0, 256, null, null, "", false, false);
    CobolVarHelper keyLen_h = new CobolVarHelper("all", 66).pic9Comp5("keyLen", 4, 0);
    private ICobolVar keyLen = this.keyLen_h.get("keyLen");
    private CobolVarHelper startRecPos_h = new CobolVarHelper("all", 66).pic9Comp5("startRecPos", 9, 0);
    private ICobolVar startRecPos = this.startRecPos_h.get("startRecPos");
    private CobolVarHelper rewRecPos_h = new CobolVarHelper("all", 66).pic9Comp5("rewRecPos", 9, 0);
    private ICobolVar rewRecPos = this.rewRecPos_h.get("rewRecPos");
    private ICobolVar localBuffer;
    private byte[] localBytes;

    private int callBtrv(int n2, ICobolVar iCobolVar, ICobolVar iCobolVar2, ICobolVar iCobolVar3, ICobolVar iCobolVar4, ICobolVar iCobolVar5, ICobolVar iCobolVar6) {
        this.operation.set(n2);
        Object[] objectArray = new ICobolVar[]{this.operation.setByVal(true), iCobolVar, iCobolVar2, iCobolVar3, iCobolVar4, iCobolVar5.setByVal(true), iCobolVar6.setByVal(true)};
        Object object = dCall.call(objectArray);
        int n3 = ((ICobolVar)object).toint();
        return this.mapError(n3, n2);
    }

    private int mapError(int n2, int n3) {
        this.errno = n2;
        this.lastOp = n3;
        this.errMsg = "Btrieve#" + n2;
        this.sysError = "B" + n2;
        if (this.errno == 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public String getVersion() {
        StringBuffer stringBuffer = new StringBuffer("Btrieve");
        ICobolVar iCobolVar = this.versionBuffer_h.get("all");
        iCobolVar.set(new byte[iCobolVar.length()]);
        this.dataLen.set(iCobolVar.length());
        this.keyNum.set(0);
        ICobolVar iCobolVar2 = this.versionBuffer_h.get("Version");
        ICobolVar iCobolVar3 = this.versionBuffer_h.get("Revision");
        ICobolVar iCobolVar4 = this.versionBuffer_h.get("MKDEId");
        this.keyLen.set(0);
        int n2 = this.callBtrv(26, this.posBlock, iCobolVar, this.dataLen, this.asKeyBuffer, this.keyLen, this.keyNum);
        for (int i2 = 1; i2 <= 3; ++i2) {
            if (iCobolVar2.intIAt(i2).toint() <= 0) continue;
            stringBuffer.append(':');
            stringBuffer.append(iCobolVar2.intIAt(i2).toint());
            stringBuffer.append('.');
            stringBuffer.append(iCobolVar3.intIAt(i2).toint());
            stringBuffer.append(' ');
            stringBuffer.append(iCobolVar4.intIAt(i2).toString());
        }
        return stringBuffer.toString();
    }

    @Override
    public int build(String string, String string2, int n2, int n3, int n4, int n5, int n6, int n7, int n8, KeyDescription[] keyDescriptionArray, byte[] byArray, boolean bl) {
        int n9;
        if (bl) {
            string = BaseFile.expandFileName(string);
        }
        this.keys = keyDescriptionArray;
        int n10 = this.keys.length;
        int n11 = 0;
        for (n9 = 0; n9 < n10; ++n9) {
            n11 += this.keys[n9].getNumSegments();
        }
        n9 = 0;
        if (n7 > n8) {
            n9 |= 1;
        }
        if (n5 > 0) {
            n9 |= 8;
        }
        CobolVarHelper cobolVarHelper = new CobolVarHelper("all", 66).picS9Comp5("minRecordLen", 4, 0).picS9Comp5("pageSize", 4, 0).picS9Comp5("numOfKeys", 2, 0).picS9Comp5("fileVersion", 2, 0).picX("reserved", 4).picS9Comp5("fileFlags", 4, 0).picS9Comp5("extraPointers", 2, 0).picX("reserved", 1).picS9Comp5("preallocPages", 4, 0).group("keys").occurs(n11).picS9Comp5("keyPosition", 4, 0).picS9Comp5("keyLength", 4, 0).picS9Comp5("keyFlags", 4, 0).picX("reserved", 4).picX("extKeyType", 1).picS9Comp5("nullValue", 2, 0).picX("reserved", 2).picS9Comp5("keyNumber", 2, 0).picS9Comp5("acsNumber", 2, 0).endGroup();
        ICobolVar iCobolVar = cobolVarHelper.get("all");
        iCobolVar = cobolVarHelper.get("all");
        iCobolVar.set(new byte[iCobolVar.length()]);
        this.dataLen.set(iCobolVar.length());
        cobolVarHelper.get("minRecordLen").set(n8);
        cobolVarHelper.get("pageSize").set(4096);
        cobolVarHelper.get("numOfKeys").set(n10);
        cobolVarHelper.get("fileVersion").set(0);
        cobolVarHelper.get("fileFlags").set(n9);
        ICobolVar iCobolVar2 = cobolVarHelper.get("keyPosition");
        ICobolVar iCobolVar3 = cobolVarHelper.get("keyLength");
        ICobolVar iCobolVar4 = cobolVarHelper.get("keyFlags");
        ICobolVar iCobolVar5 = cobolVarHelper.get("extKeyType");
        ICobolVar iCobolVar6 = cobolVarHelper.get("nullValue");
        ICobolVar iCobolVar7 = cobolVarHelper.get("keyNumber");
        ICobolVar iCobolVar8 = cobolVarHelper.get("acsNumber");
        int n12 = 0;
        for (int i2 = 0; i2 < n10; ++i2) {
            int n13;
            int n14 = this.keys[i2].getNumSegments();
            int n15 = n13 = i2 == 0 ? 0 : 2;
            if (this.keys[i2].isDup()) {
                n13 |= 1;
            }
            int n16 = 0;
            while (true) {
                KeyDescription.Segs segs = this.keys[i2].getSegment(n16);
                iCobolVar2.intIAt(++n12).set(segs.offset + 1);
                iCobolVar3.intIAt(n12).set(segs.size);
                if (++n16 >= n14) break;
                iCobolVar4.intIAt(n12).set(n13 | 0x10);
            }
            iCobolVar4.intIAt(n12).set(n13);
        }
        this.asKeyBuffer.set(string + '\u0000');
        this.keyLen.set(string.length());
        this.keyNum.set(0);
        return this.callBtrv(14, this.posBlock, iCobolVar, this.dataLen, this.asKeyBuffer, this.keyLen, this.keyNum);
    }

    @Override
    public int open(String string, int n2, int n3, KeyDescription[] keyDescriptionArray, int n4, int n5, int n6, int n7, boolean bl, boolean bl2) {
        this.minRecordSize = n5;
        this.maxRecordSize = n4;
        this.localBytes = new byte[this.maxRecordSize];
        this.localBuffer = new PicX(this.localBytes, 0, this.maxRecordSize, null, null, "localBuffer", false, false);
        this.lockType = n3;
        this.lockMulti = (this.lockType & 0x100) != 0;
        this.currentKey = -1;
        this.lockWait = Config.b(".file.index.lock_wait", false);
        if (bl2) {
            string = BaseFile.expandFileName(string);
        }
        if (this.keys == null) {
            this.keys = keyDescriptionArray;
        }
        CobolVarHelper cobolVarHelper = new CobolVarHelper("all", 66).picX("owner", 16);
        ICobolVar iCobolVar = cobolVarHelper.get("all");
        iCobolVar.set(new byte[iCobolVar.length()]);
        this.dataLen.set(0);
        this.asKeyBuffer.set(string + '\u0000');
        this.keyLen.set(string.length());
        block0 : switch (n2) {
            case 2: 
            case 6: {
                this.keyNum.set((short)-4);
                this.exclLock = true;
                break;
            }
            case 3: {
                switch (this.lockType & 0xF) {
                    default: {
                        this.keyNum.set((short)0);
                        this.exclLock = false;
                        break block0;
                    }
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                }
                this.keyNum.set((short)-4);
                this.exclLock = true;
                break;
            }
            case 1: {
                this.keyNum.set((short)-2);
                this.exclLock = false;
            }
        }
        int n8 = this.callBtrv(0, this.posBlock, iCobolVar, this.dataLen, this.asKeyBuffer, this.keyLen, this.keyNum);
        if (n8 == 1) {
            this.openMode = n2;
        }
        return n8;
    }

    @Override
    public boolean isOpen() {
        return this.openMode != 0;
    }

    @Override
    public String getDescription() {
        return this.path;
    }

    @Override
    public int getCobErrno() {
        switch (this.errno) {
            case 0: {
                return 0;
            }
            case 5: {
                return 100;
            }
            case 3: {
                return 101;
            }
            case 1: 
            case 22: 
            case 23: 
            case 24: {
                return 102;
            }
            case 6: 
            case 21: 
            case 26: 
            case 27: 
            case 29: 
            case 45: 
            case 49: {
                return 103;
            }
            case 47: {
                return 104;
            }
            case 30: {
                return 105;
            }
            case 81: {
                if (this.lastOp == 0) {
                    return 113;
                }
                return 107;
            }
            case 84: {
                return 107;
            }
            case 85: 
            case 88: {
                return 113;
            }
            case 9: {
                return 110;
            }
            case 4: {
                return 111;
            }
            case 8: {
                return 112;
            }
            case 12: {
                return 130;
            }
            case 998: {
                return 130;
            }
            case 94: {
                return 131;
            }
            case 41: {
                return 35;
            }
        }
        return 133;
    }

    @Override
    public String getSysErrno() {
        return this.sysError;
    }

    @Override
    public String getErrMsg() {
        return this.errMsg;
    }

    @Override
    public int close() {
        int n2 = 1;
        if (this.isOpen()) {
            CobolVarHelper cobolVarHelper = new CobolVarHelper("all", 66).picX("data", 1);
            ICobolVar iCobolVar = cobolVarHelper.get("all");
            this.dataLen.set(0);
            n2 = this.callBtrv(1, this.posBlock, iCobolVar, this.dataLen, this.asKeyBuffer, this.keyLen, this.keyNum);
            this.openMode = 0;
            this.keys = null;
            this.path = "";
        }
        return n2;
    }

    private int getStat() {
        CobolVarHelper cobolVarHelper = new CobolVarHelper("all", 66).picS9Comp5("minRecordLen", 4, 0).picS9Comp5("pageSize", 4, 0).picS9Comp5("numOfIndexes", 4, 0).picS9Comp5("numOfRecords", 9, 0).picS9Comp5("fileFlags", 4, 0).picX("reserved", 2).picS9Comp5("unusedPages", 4, 0).group("keys").occurs(119).picS9Comp5("keyPosition", 4, 0).picS9Comp5("keyLength", 4, 0).picS9Comp5("keyFlags", 4, 0).picS9Comp5("numOfUniqueVal", 9, 0).picX("extKeyType", 1).picS9Comp5("nullValue", 2, 0).picX("reserved", 2).picS9Comp5("keyNumber", 2, 0).picS9Comp5("acsNumber", 2, 0).endGroup();
        ICobolVar iCobolVar = cobolVarHelper.get("all");
        this.dataLen.set(iCobolVar.length());
        this.keyLen.set(this.asKeyBuffer.length());
        this.keyNum.set(0);
        int n2 = this.callBtrv(15, this.posBlock, iCobolVar, this.dataLen, this.asKeyBuffer, this.keyLen, this.keyNum);
        if (n2 == 1) {
            this.minRecordSize = cobolVarHelper.get("minRecordLen").toint();
            if (this.maxRecordSize < this.minRecordSize) {
                this.maxRecordSize = this.minRecordSize;
            }
            int n3 = cobolVarHelper.get("numOfIndexes").toint();
            this.numOfRecords = cobolVarHelper.get("numOfRecords").tolong();
            if (n3 > 0) {
                ICobolVar iCobolVar2 = cobolVarHelper.get("keyPosition");
                ICobolVar iCobolVar3 = cobolVarHelper.get("keyLength");
                ICobolVar iCobolVar4 = cobolVarHelper.get("keyNumber");
                ICobolVar iCobolVar5 = cobolVarHelper.get("keyFlags");
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                this.keys = new KeyDescription[n3];
                n4 = 1;
                while (true) {
                    if ((iCobolVar5.intIAt(n4).toint() & 0x10) == 0) {
                        this.keys[n5] = new KeyDescription(n4 - n6, (iCobolVar5.intIAt(n4).toint() & 1) != 0);
                        int n7 = n6 + 1;
                        int n8 = 0;
                        while (n7 <= n4) {
                            this.keys[n5].setSegment(n8, iCobolVar3.intIAt(n7).toint(), iCobolVar2.intIAt(n7).toint() - 1);
                            ++n7;
                            ++n8;
                        }
                        n6 = n4;
                        if (++n5 == n3) break;
                    }
                    ++n4;
                }
            }
        }
        return n2;
    }

    @Override
    public int getNumKeys() {
        if (this.keys == null) {
            this.getStat();
            if (this.keys == null) {
                return 0;
            }
        }
        return this.keys.length;
    }

    @Override
    public int getMaxRecordSize() {
        if (this.maxRecordSize == 0) {
            this.getStat();
        }
        return this.maxRecordSize;
    }

    @Override
    public int getMinRecordSize() {
        if (this.minRecordSize == 0) {
            this.getStat();
        }
        return this.minRecordSize;
    }

    @Override
    public KeyDescription getKey(int n2) {
        KeyDescription keyDescription;
        if (n2 >= 0 && n2 < this.getNumKeys()) {
            keyDescription = this.keys[n2];
        } else {
            keyDescription = null;
            this.mapError(1, 15);
        }
        return keyDescription;
    }

    @Override
    public long getNumRecords() {
        this.getStat();
        return this.numOfRecords;
    }

    @Override
    public byte[] getSequence() {
        return null;
    }

    @Override
    public void setCurrentRecord(long l2) {
    }

    @Override
    public long getCurrentRecord() {
        return 0L;
    }

    private int buildKey(PicX picX, KeyDescription keyDescription, byte[] byArray, int n2) {
        int n3 = keyDescription.length();
        byte[] byArray2 = picX.getMemory();
        int n4 = 0;
        int n5 = 0;
        while (n4 < n3) {
            KeyDescription.Segs segs = keyDescription.getSegment(n5);
            System.arraycopy(byArray, segs.offset + n2, byArray2, n4, segs.size);
            n4 += segs.size;
            ++n5;
        }
        return n3;
    }

    private int lockBias(int n2) {
        int n3 = n2 > 0 && !this.exclLock ? (this.lockMulti ? (this.lockWait || n2 == 3 ? 300 : 400) : (this.lockWait || n2 == 3 ? 100 : 200)) : 0;
        return n3;
    }

    @Override
    public long read(byte[] byArray, int n2, int n3, int n4) {
        PicX picX = new PicX(byArray, n2, this.maxRecordSize, null, null, "", false, false);
        this.currentPosition = null;
        this.dataLen.set(this.maxRecordSize);
        this.keyNum.set(n3);
        this.keyLen.set(this.buildKey(this.keyBuffer, this.getKey(n3), byArray, n2));
        int n5 = this.callBtrv(5 + this.lockBias(n4), this.posBlock, picX, this.dataLen, this.keyBuffer, this.keyLen, this.keyNum);
        if (n5 == 1) {
            this.currentKey = n3;
            n5 = this.dataLen.toint();
        }
        return n5;
    }

    @Override
    public long read(byte[] byArray, int n2, KeyDescription keyDescription, int n3) {
        return this.read(byArray, n2, this.findKey(keyDescription), n3);
    }

    @Override
    public long next(byte[] byArray, int n2, int n3) {
        int n4;
        this.dataLen.set(this.maxRecordSize);
        if (this.currentKey < 0) {
            PicX picX = new PicX(byArray, n2, this.maxRecordSize, null, null, "", false, false);
            this.currentKey = 0;
            this.keyNum.set(this.currentKey);
            this.keyLen.set(0);
            this.currentPosition = null;
            n4 = this.callBtrv(12 + this.lockBias(n3), this.posBlock, picX, this.dataLen, this.keyBuffer, this.keyLen, this.keyNum);
            if (n4 == 1) {
                n4 = this.dataLen.toint();
            }
        } else {
            this.keyNum.set(this.currentKey);
            this.keyLen.set(0);
            if (this.currentPosition != null) {
                byte[] byArray2 = this.currentPosition.getBytes();
                System.arraycopy(byArray2, 0, this.localBytes, 0, byArray2.length);
                n4 = this.callBtrv(23 + this.lockBias(n3), this.posBlock, this.localBuffer, this.dataLen, this.keyBuffer, this.keyLen, this.keyNum);
                if (n4 == 1) {
                    System.arraycopy(this.localBytes, 0, byArray, n2, this.maxRecordSize);
                    this.currentPosition = null;
                    n4 = this.dataLen.toint();
                }
            } else {
                PicX picX = new PicX(byArray, n2, this.maxRecordSize, null, null, "", false, false);
                n4 = this.callBtrv(6 + this.lockBias(n3), this.posBlock, picX, this.dataLen, this.keyBuffer, this.keyLen, this.keyNum);
                if (n4 == 1) {
                    n4 = this.dataLen.toint();
                }
            }
        }
        return n4;
    }

    @Override
    public long previous(byte[] byArray, int n2, int n3) {
        PicX picX = new PicX(byArray, n2, this.maxRecordSize, null, null, "", false, false);
        this.currentPosition = null;
        this.dataLen.set(this.maxRecordSize);
        this.keyNum.set(this.currentKey);
        this.keyLen.set(0);
        int n4 = this.callBtrv(7 + this.lockBias(n3), this.posBlock, picX, this.dataLen, this.keyBuffer, this.keyLen, this.keyNum);
        if (n4 == 1) {
            n4 = this.dataLen.toint();
        }
        return n4;
    }

    @Override
    public long start(byte[] byArray, int n2, int n3, int n4, int n5) {
        int n6;
        switch (n5) {
            case 0: {
                n6 = 12;
                break;
            }
            case 1: {
                n6 = 13;
                break;
            }
            case 5: {
                n6 = 5;
                break;
            }
            case 6: {
                n6 = 8;
                break;
            }
            case 7: {
                n6 = 9;
                break;
            }
            case 8: {
                n6 = 10;
                break;
            }
            case 9: {
                n6 = 11;
                break;
            }
            default: {
                throw new IscobolRuntimeException(3, new IllegalArgumentException("START").toString());
            }
        }
        PicX picX = new PicX(byArray, n2, this.maxRecordSize, null, null, "", false, false);
        this.dataLen.set(this.maxRecordSize);
        this.keyNum.set(n3);
        this.keyLen.set(this.buildKey(this.keyBuffer, this.getKey(n3), byArray, n2));
        long l2 = this.callBtrv(n6 + 50, this.posBlock, picX, this.dataLen, this.keyBuffer, this.keyLen, this.keyNum);
        if (l2 == 1L) {
            this.currentKey = n3;
            this.dataLen.set(this.startRecPos_h.get("all").length());
            l2 = this.callBtrv(22, this.posBlock, this.startRecPos, this.dataLen, this.keyBuffer, this.keyLen, this.keyNum);
            if (l2 == 1L) {
                this.currentPosition = this.startRecPos;
            }
        } else if (this.errno == 9) {
            this.errno = 4;
        }
        return l2;
    }

    @Override
    public long start(byte[] byArray, int n2, KeyDescription keyDescription, int n3, int n4) {
        return this.start(byArray, n2, this.findKey(keyDescription), n3, n4);
    }

    @Override
    public long write(byte[] byArray, int n2, int n3, boolean bl) {
        if (this.minRecordSize == this.maxRecordSize) {
            n3 = this.maxRecordSize;
        }
        PicX picX = new PicX(byArray, n2, n3, null, null, "", false, false);
        picX.set(byArray, n2, n3, false);
        this.dataLen.set(n3);
        this.keyLen.set(this.asKeyBuffer.length());
        this.keyNum.set(-1);
        return this.callBtrv(2, this.posBlock, picX, this.dataLen, this.asKeyBuffer, this.keyLen, this.keyNum);
    }

    @Override
    public long rewrite(byte[] byArray, int n2, int n3, boolean bl) {
        if (n3 == 0 || this.minRecordSize == this.maxRecordSize) {
            n3 = this.maxRecordSize;
        }
        PicX picX = new PicX(byArray, n2, n3, null, null, "", false, false);
        this.keyNum.set(0);
        this.dataLen.set(this.rewRecPos.length());
        int n4 = this.currentKey >= 0 ? this.callBtrv(22, this.posBlock, this.rewRecPos, this.dataLen, this.asKeyBuffer, this.keyLen, this.keyNum) : 1;
        if (n4 == 1) {
            this.dataLen.set(n3);
            this.keyNum.set(0);
            this.keyLen.set(this.buildKey(this.asKeyBuffer, this.getKey(0), byArray, n2));
            n4 = this.callBtrv(5, this.posBlock, this.localBuffer, this.dataLen, this.asKeyBuffer, this.keyLen, this.keyNum);
            if (n4 == 1) {
                this.keyLen.set(this.asKeyBuffer.length());
                this.keyNum.set(-1);
                n4 = this.callBtrv(3, this.posBlock, picX, this.dataLen, this.asKeyBuffer, this.keyLen, this.keyNum);
                if (n4 == 1 && this.currentKey >= 0) {
                    byte[] byArray2 = this.rewRecPos.getBytes();
                    System.arraycopy(byArray2, 0, this.localBytes, 0, byArray2.length);
                    n4 = this.callBtrv(23, this.posBlock, this.localBuffer, this.dataLen, this.keyBuffer, this.keyLen, this.keyNum);
                }
            }
        }
        return n4;
    }

    @Override
    public long delete(byte[] byArray, int n2) {
        int n3 = this.maxRecordSize;
        PicX picX = new PicX(byArray, n2, n3, null, null, "", false, false);
        this.keyNum.set(0);
        this.dataLen.set(this.rewRecPos.length());
        int n4 = this.currentKey >= 0 ? this.callBtrv(22, this.posBlock, this.rewRecPos, this.dataLen, this.asKeyBuffer, this.keyLen, this.keyNum) : 1;
        if (n4 == 1) {
            this.dataLen.set(n3);
            this.keyNum.set(0);
            this.keyLen.set(this.buildKey(this.asKeyBuffer, this.getKey(0), byArray, n2));
            n4 = this.callBtrv(5, this.posBlock, this.localBuffer, this.dataLen, this.asKeyBuffer, this.keyLen, this.keyNum);
            if (n4 == 1) {
                this.keyLen.set(this.asKeyBuffer.length());
                this.keyNum.set(-1);
                n4 = this.callBtrv(4, this.posBlock, picX, this.dataLen, this.asKeyBuffer, this.keyLen, this.keyNum);
                if (n4 == 1 && this.currentKey >= 0) {
                    byte[] byArray2 = this.rewRecPos.getBytes();
                    System.arraycopy(byArray2, 0, this.localBytes, 0, byArray2.length);
                    this.callBtrv(23, this.posBlock, this.localBuffer, this.dataLen, this.keyBuffer, this.keyLen, this.keyNum);
                }
            }
        }
        return n4;
    }

    @Override
    public int unlock() {
        this.dataLen.set(this.maxRecordSize);
        this.keyNum.set(-2);
        int n2 = this.callBtrv(27, this.posBlock, this.localBuffer, this.dataLen, this.asKeyBuffer, this.keyLen, this.keyNum);
        return n2;
    }

    @Override
    public int remove(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return this.mapError(998, 0);
        }
        if (!file.delete()) {
            return this.mapError(999, 0);
        }
        return 1;
    }

    @Override
    public int rename(String string, String string2) {
        File file = new File(string);
        File file2 = new File(string2);
        if (!file.exists()) {
            return this.mapError(998, 0);
        }
        if (!file.renameTo(file2)) {
            return this.mapError(999, 0);
        }
        return 1;
    }

    @Override
    public void sync(int n2) {
    }

    @Override
    public int begin() {
        return this.mapError(41, 0);
    }

    @Override
    public int commit(int n2) {
        return this.mapError(41, 0);
    }

    @Override
    public int rollback() {
        return this.mapError(41, 0);
    }

    @Override
    public int recover() {
        return this.mapError(41, 0);
    }

    @Override
    public boolean isKeySelectedByNum() {
        return true;
    }

    private int findKey(KeyDescription keyDescription) {
        int n2;
        int n3 = this.getNumKeys();
        try {
            for (n2 = 0; n2 < n3 && !keyDescription.equals(this.getKey(n2)); ++n2) {
            }
        }
        catch (NullPointerException nullPointerException) {
            n2 = -1;
        }
        return n2;
    }

    public static void main(String[] stringArray) {
        DynamicBtrieve dynamicBtrieve = new DynamicBtrieve();
        System.out.println(dynamicBtrieve.getVersion());
        System.out.println(dynamicBtrieve.build("testFile", "remarks", 0, 0, 0, 0, 0, 10, 0, null, null, false));
    }

    static {
        IsCobol.call(LIBNAME, null);
        dCall = new DynamicCall(FUNNAME, 1);
    }
}

