/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import IT.picosoft.iiop.Corba;
import IT.picosoft.iiop.CorbaArg;
import IT.picosoft.iiop.CorbaException;
import IT.picosoft.iiop.CorbaMethod;
import IT.picosoft.iiop.IiopServer;
import IT.picosoft.iiop.Principal;
import com.iscobol.io.BaseFile;
import com.iscobol.io.TransactionException;
import com.iscobol.rts.Config;
import com.iscobol.rts.DynamicFile;
import com.iscobol.rts.Factory;
import com.iscobol.rts.IOUtil;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.KeyDescription;
import com.iscobol.rts.MonitorFinalize;
import com.iscobol.rts.RuntimeErrorsNumbers;

public class DynamicConnector
implements DynamicFile,
RuntimeErrorsNumbers,
Cloneable {
    public static final int Finput = 0;
    public static final int Foutput = 1;
    public static final int Fio = 2;
    public static final int Fextend = 3;
    public static final int Fopen_mask = 3;
    public static final int Ftext = 4;
    public static final int Fbinary = 0;
    public static final int Flocal_only = 8;
    public static final int Fmulti_lock = 16;
    public static final int Fmulti_records = 32;
    public static final int Ftruncate = 64;
    public static final int Fread_lock = 256;
    public static final int Fwrite_lock = 512;
    public static final int Fbuffered = 1024;
    public static final int Fmass_update = 1536;
    public static final int Flock_mask = 1792;
    public static final int Fis_device = 2048;
    public static final int Fopt_lock = 4096;
    public static final int Fappend = 8192;
    public static final int Ftrans = 16384;
    public static final int F_EQUALS = 0;
    public static final int F_NOT_LESS = 1;
    public static final int F_GREATER = 2;
    public static final int F_LESS = 3;
    public static final int F_NOT_GREATER = 4;
    public static final int E_SYS_ERR = 1;
    public static final int E_PARAM_ERR = 2;
    public static final int E_TOO_MANY_FILES = 3;
    public static final int E_MODE_CLASH = 4;
    public static final int E_REC_LOCKED = 5;
    public static final int E_BROKEN = 6;
    public static final int E_DUPLICATE = 7;
    public static final int E_NOT_FOUND = 8;
    public static final int E_UNDEF_RECORD = 9;
    public static final int E_DISK_FULL = 10;
    public static final int E_FILE_LOCKED = 11;
    public static final int E_REC_CHANGED = 12;
    public static final int E_MISMATCH = 13;
    public static final int E_NO_MEMORY = 14;
    public static final int E_MISSING_FILE = 15;
    public static final int E_PERMISSION = 16;
    public static final int E_NO_SUPPORT = 17;
    public static final int E_NO_LOCKS = 18;
    public static final int E_INTERFACE = 19;
    public static final int E_LICENSE_ERR = 20;
    public static final int E_UNKNOWN_ERR = 21;
    public static final int E_TRANSACTION = 22;
    public static final int W_NO_SUPPORT = 100;
    public static final int W_DUP_OK = 101;
    public static final int W_WRONG_LEN_OK = 151;
    public static final int W_MISSING_OK = 152;
    private int theFile = -1;
    protected MyConn theConn;
    private int openMode = 0;
    private KeyDescription[] keys;
    private int maxRecordSize;
    private int minRecordSize;
    private String path = "";
    private int errno;
    private String sysError;
    private String errMsg;
    protected static final Object exit = "";

    protected DynamicConnector(int n2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicConnector() {
        Object object = exit;
        synchronized (object) {
            Class<?> clazz = this.getClass();
            this.theConn = (MyConn)IscobolSystem.get(clazz);
            if (this.theConn == null) {
                String string = this.getServerPgm();
                final MyConn myConn = new MyConn(FileServer.get(string), IscobolSystem.getContext());
                myConn.conn.init();
                this.theConn = myConn;
                if (myConn.conn != null) {
                    IscobolSystem.set(clazz, myConn);
                    Factory.getCurrentMonitor().addObjToFinalize(new MonitorFinalize(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void monitorFinalize() {
                            Object object = exit;
                            synchronized (object) {
                                if (IscobolSystem.getContext() == DynamicConnector.this.getContext()) {
                                    myConn.conn.exit();
                                    myConn.conn = null;
                                }
                            }
                        }
                    });
                }
            }
        }
    }

    protected String getServerPgm() {
        return Config.a(".file.connector.program", "fscsc") + " 1:" + Thread.currentThread().getName().replace(' ', '-');
    }

    @Override
    public String getSysErrno() {
        return this.sysError;
    }

    @Override
    public String getErrMsg() {
        return this.errMsg;
    }

    @Override
    public int getCobErrno() {
        switch (this.errno) {
            case 0: {
                return 0;
            }
            case 1: {
                return 133;
            }
            case 2: {
                return 102;
            }
            case 3: {
                return 104;
            }
            case 4: {
                return 125;
            }
            case 5: {
                return 107;
            }
            case 6: {
                return 105;
            }
            case 7: {
                return 100;
            }
            case 8: {
                return 111;
            }
            case 9: {
                return 112;
            }
            case 10: {
                return 127;
            }
            case 11: {
                return 113;
            }
            case 12: {
                return 128;
            }
            case 13: {
                return 128;
            }
            case 14: {
                return 116;
            }
            case 15: {
                return 130;
            }
            case 16: {
                return 131;
            }
            case 17: {
                return 126;
            }
            case 18: {
                return 129;
            }
            case 19: {
                return 140;
            }
            case 20: {
                return 133;
            }
            case 22: {
                return 122;
            }
            case 100: {
                return 204;
            }
            case 101: {
                return 200;
            }
            case 151: {
                return 201;
            }
            case 152: {
                return 203;
            }
            case 21: {
                return 134;
            }
        }
        if ((this.errno & 0x7FFF0000) != 0) {
            return this.errno;
        }
        return 134;
    }

    protected FileServer getConn() {
        return this.theConn.conn;
    }

    protected IscobolSystem.Context getContext() {
        return this.theConn.cont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumRecords() {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            byte[] byArray = new byte[11];
            int n2 = this.getConn().info(this.theFile, -4, byArray);
            return Long.parseLong(new String(byArray, 0, 10));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumKeys() {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            if (this.keys == null) {
                byte[] byArray = new byte[256];
                int n2 = this.getConn().info(this.theFile, -1, byArray);
                if (n2 == 0) {
                    return this.mapError();
                }
                int[] nArray = IOUtil.csv2Int(byArray);
                this.maxRecordSize = nArray[0];
                this.minRecordSize = nArray[1];
                this.keys = new KeyDescription[nArray[2]];
            }
            return this.keys.length;
        }
    }

    @Override
    public int getMaxRecordSize() {
        if (this.keys == null) {
            this.getNumKeys();
        }
        return this.maxRecordSize;
    }

    @Override
    public int getMinRecordSize() {
        if (this.keys == null) {
            this.getNumKeys();
        }
        return this.minRecordSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyDescription getKey(int n2) {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            KeyDescription keyDescription;
            if (n2 >= 0 && n2 < this.getNumKeys()) {
                if (this.keys[n2] == null) {
                    byte[] byArray = new byte[256];
                    int n3 = this.getConn().info(this.theFile, n2, byArray);
                    if (n3 == 0) {
                        this.mapError();
                        return null;
                    }
                    this.keys[n2] = new KeyDescription(byArray);
                }
                keyDescription = this.keys[n2];
            } else {
                keyDescription = null;
                this.mapError(2);
            }
            return keyDescription;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getSequence() {
        byte[] byArray = new byte[256];
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            int n2 = this.getConn().info(this.theFile, -5, byArray);
            if (n2 == 0) {
                this.mapError();
                return null;
            }
            return byArray;
        }
    }

    private int findKey(KeyDescription keyDescription) {
        int n2;
        int n3 = this.getNumKeys();
        try {
            for (n2 = 0; n2 < n3 && !keyDescription.equals(this.getKey(n2)); ++n2) {
            }
        }
        catch (NullPointerException nullPointerException) {
            n2 = -1;
        }
        return n2;
    }

    private int mapError(int n2, int n3) {
        this.errno = n2;
        this.sysError = "" + n3;
        this.errMsg = "";
        return 0;
    }

    private int mapError(int n2) {
        this.errno = n2;
        this.sysError = "";
        this.errMsg = "";
        return 0;
    }

    private int mapError() {
        return this.mapError(this.getConn());
    }

    private int mapError(FileServer fileServer) {
        this.errno = fileServer.f_errno;
        int n2 = fileServer.f_int_errno;
        if (this.errno == 21 && (n2 & 0x7FFF0000) != 0) {
            this.errno = n2;
            this.sysError = "HEX FS=" + Integer.toHexString(n2 & 0xFFFF);
        } else {
            short s2 = (short)(n2 & 0xFFFF);
            short s3 = (short)(n2 >>> 16);
            this.sysError = "" + s2 + "," + s3;
        }
        this.errMsg = "";
        return 0;
    }

    int mapOpen(int n2, int n3) {
        int n4;
        switch (n2) {
            default: {
                n4 = 0;
                break;
            }
            case 2: {
                n4 = 1;
                break;
            }
            case 3: {
                n4 = 2;
                break;
            }
            case 6: {
                n4 = 3;
            }
        }
        switch (n3 & 0xF) {
            default: {
                break;
            }
            case 1: 
            case 6: {
                n4 |= 0x300;
                break;
            }
            case 4: {
                n4 |= 0x200;
                break;
            }
            case 3: 
            case 5: {
                n4 |= 0x100;
            }
        }
        if ((n3 & 0x100) != 0) {
            n4 |= 0x10;
        }
        if ((n3 & 0x200) != 0) {
            n4 |= 0x600;
        }
        if ((n3 & 0x800) != 0) {
            n4 |= 0x4000;
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int build(String string, String string2, int n2, int n3, int n4, int n5, int n6, int n7, int n8, KeyDescription[] keyDescriptionArray, byte[] byArray, boolean bl) {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            if (bl) {
                string = BaseFile.expandFileName(string);
            }
            String string3 = new String(IOUtil.int2Csv(new int[]{n2, n3, n4, n5, n6}, new int[]{1, 1, 1, 3, 1}));
            String string4 = "" + n7 + "," + n8 + "," + keyDescriptionArray.length;
            StringBuffer stringBuffer = new StringBuffer();
            int n9 = 0;
            while (true) {
                stringBuffer.append(keyDescriptionArray[n9].toString());
                if (++n9 >= keyDescriptionArray.length) break;
                stringBuffer.append(',');
            }
            if (this.getConn().make(string, string2, string3, string4, stringBuffer.toString(), byArray) == 0) {
                return this.mapError();
            }
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int open(String string, int n2, int n3, KeyDescription[] keyDescriptionArray, int n4, int n5, int n6, int n7, boolean bl, boolean bl2) {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            if (bl2) {
                string = BaseFile.expandFileName(string);
            }
            String string2 = "" + n4 + "," + n5 + "," + n6;
            switch (n2) {
                case 1: 
                case 2: 
                case 3: 
                case 6: {
                    this.theFile = this.getConn().open(string, this.mapOpen(n2, n3), string2);
                    if (this.theFile != 0) break;
                    return this.mapError();
                }
                default: {
                    throw new IscobolRuntimeException(3, new IllegalArgumentException("OPEN").toString());
                }
            }
            this.openMode = n2;
            this.path = string;
            return 1;
        }
    }

    @Override
    public void setCurrentRecord(long l2) {
    }

    @Override
    public long getCurrentRecord() {
        return 0L;
    }

    @Override
    public boolean isOpen() {
        return this.openMode != 0;
    }

    @Override
    public String getDescription() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int close() {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            if (this.isOpen()) {
                FileServer fileServer = this.getConn();
                this.openMode = 0;
                if (fileServer != null && fileServer.close(this.theFile) == 0) {
                    this.theFile = 0;
                    this.keys = null;
                    this.path = "";
                    return this.mapError();
                }
                this.theFile = 0;
                this.keys = null;
                this.path = "";
            }
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(byte[] byArray, int n2, int n3, boolean bl) {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            FileServer fileServer = this.getConn();
            int n4 = fileServer.write(this.theFile, byArray, n2, n3, bl);
            this.errno = fileServer.f_errno;
            if (n4 == 0) {
                return this.mapError(fileServer);
            }
            return 1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long rewrite(byte[] byArray, int n2, int n3, boolean bl) {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            FileServer fileServer = this.getConn();
            int n4 = fileServer.rewrite(this.theFile, byArray, n2, n3, bl);
            this.errno = fileServer.f_errno;
            if (n4 == 0) {
                return this.mapError(fileServer);
            }
            return 1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long delete(byte[] byArray, int n2) {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            if (this.getConn().delete(this.theFile, byArray, n2) == 0) {
                return this.mapError();
            }
            return 1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long next(byte[] byArray, int n2, int n3) {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            FileServer fileServer = this.getConn();
            int n4 = fileServer.next(this.theFile, byArray, n2, n3);
            this.errno = fileServer.f_errno;
            if (n4 == 0) {
                return this.mapError(fileServer);
            }
            return n4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long previous(byte[] byArray, int n2, int n3) {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            FileServer fileServer = this.getConn();
            int n4 = fileServer.previous(this.theFile, byArray, n2, n3);
            this.errno = fileServer.f_errno;
            if (n4 == 0) {
                return this.mapError(fileServer);
            }
            return n4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long read(byte[] byArray, int n2, int n3, int n4) {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            FileServer fileServer = this.getConn();
            int n5 = fileServer.read(this.theFile, byArray, n2, n3, n4);
            this.errno = fileServer.f_errno;
            if (n5 == 0) {
                return this.mapError(fileServer);
            }
            return n5;
        }
    }

    @Override
    public long read(byte[] byArray, int n2, KeyDescription keyDescription, int n3) {
        return this.read(byArray, n2, this.findKey(keyDescription), n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long start(byte[] byArray, int n2, int n3, int n4, int n5) {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            int n6;
            switch (n5) {
                case 0: {
                    byte[] byArray2 = new byte[byArray.length];
                    n6 = this.getConn().start(this.theFile, byArray2, 0, n3, n4, 1);
                    break;
                }
                case 1: {
                    byte[] byArray3 = new byte[byArray.length];
                    for (int i2 = byArray.length - 1; i2 >= 0; --i2) {
                        byArray3[i2] = -1;
                    }
                    n6 = this.getConn().start(this.theFile, byArray3, 0, n3, n4, 4);
                    break;
                }
                case 5: {
                    n6 = this.getConn().start(this.theFile, byArray, n2, n3, n4, 0);
                    break;
                }
                case 6: {
                    n6 = this.getConn().start(this.theFile, byArray, n2, n3, n4, 2);
                    break;
                }
                case 7: {
                    n6 = this.getConn().start(this.theFile, byArray, n2, n3, n4, 1);
                    break;
                }
                case 8: {
                    n6 = this.getConn().start(this.theFile, byArray, n2, n3, n4, 3);
                    break;
                }
                case 9: {
                    n6 = this.getConn().start(this.theFile, byArray, n2, n3, n4, 4);
                    break;
                }
                default: {
                    throw new IscobolRuntimeException(3, new IllegalArgumentException("START").toString());
                }
            }
            if (n6 == 0) {
                return this.mapError();
            }
            return 1L;
        }
    }

    @Override
    public long start(byte[] byArray, int n2, KeyDescription keyDescription, int n3, int n4) {
        return this.start(byArray, n2, this.findKey(keyDescription), n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int unlock() {
        int n2;
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            n2 = this.getConn().unlock(this.theFile);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync(int n2) {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            this.getConn().sync(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int remove(String string) {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            int n2 = this.getConn().remove(string);
            if (n2 == 0) {
                return this.mapError();
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int rename(String string, String string2) {
        int n2;
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            n2 = this.getConn().rename(string, string2);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int begin() {
        int n2 = 0;
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            n2 = this.getConn().begin();
            if (n2 == 0) {
                this.errno = 22;
                int n3 = this.getConn().f_int_errno;
                short s2 = (short)(n3 & 0xFFFF);
                short s3 = (short)(n3 >>> 16);
                TransactionException.get(this.getCobErrno(), "" + s2 + "," + s3, 12);
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int commit(int n2) {
        int n3 = 0;
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            n3 = this.getConn().commit(n2);
            if (n3 == 0) {
                this.errno = 22;
                int n4 = this.getConn().f_int_errno;
                short s2 = (short)(n4 & 0xFFFF);
                short s3 = (short)(n4 >>> 16);
                TransactionException.get(this.getCobErrno(), "" + s2 + "," + s3, 13);
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int rollback() {
        int n2 = 0;
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            n2 = this.getConn().rollback();
            if (n2 == 0) {
                this.errno = 22;
                int n3 = this.getConn().f_int_errno;
                short s2 = (short)(n3 & 0xFFFF);
                short s3 = (short)(n3 >>> 16);
                TransactionException.get(this.getCobErrno(), "" + s2 + "," + s3, 14);
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int recover() {
        int n2;
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            n2 = this.getConn().recover();
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getVersion() {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            int n2;
            int n3;
            int n4;
            byte[] byArray = new byte[255];
            byte[] byArray2 = new byte[255];
            byte[] byArray3 = new byte[255];
            int n5 = this.getConn().version(byArray, byArray2, byArray3, 0, null);
            for (n4 = 0; n4 < byArray.length && byArray[n4] != 0; ++n4) {
            }
            for (n3 = 0; n3 < byArray2.length && byArray2[n3] != 0; ++n3) {
            }
            for (n2 = 0; n2 < byArray3.length && byArray3[n2] != 0; ++n2) {
            }
            return this.getClass().getName() + "$Revision$||" + new String(byArray, 0, n4) + ";" + new String(byArray2, 0, n3) + ";" + new String(byArray3, 0, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int config(int n2, String string, String string2) {
        MyConn myConn = this.theConn;
        synchronized (myConn) {
            int n3 = this.getConn().config(n2, string, string2);
            return n3;
        }
    }

    @Override
    public boolean isKeySelectedByNum() {
        return false;
    }

    public void finalize() {
        this.close();
    }

    protected static class MyConn {
        FileServer conn;
        IscobolSystem.Context cont;

        MyConn(FileServer fileServer, IscobolSystem.Context context) {
            this.conn = fileServer;
            this.cont = context;
        }
    }

    static class FileServer {
        private static final String id = "IDL:IT/picosoft/picojdbc/JDBCPicoDb:1.0";
        public static final short Finput = 0;
        public static final short Foutput = 1;
        public static final short Fio = 2;
        public static final short Fextend = 3;
        public static final short Fopen_mask = 3;
        public static final short Ftext = 4;
        public static final short Fbinary = 0;
        public static final short Flocal_only = 8;
        public static final short Fmulti_lock = 16;
        public static final short Fmulti_records = 32;
        public static final short Ftruncate = 64;
        public static final short Fread_lock = 256;
        public static final short Fwrite_lock = 512;
        public static final short Fbuffered = 1024;
        public static final short Fmass_update = 1536;
        public static final short Flock_mask = 1792;
        public static final short Fis_device = 2048;
        public static final short Fopt_lock = 4096;
        public static final short Fappend = 8192;
        public static final short Ftrans = 16384;
        private static final String key = "key";
        public short f_errno;
        public int f_int_errno;
        protected Server server;

        public static FileServer get(String string) throws IscobolRuntimeException {
            return new FileServer(string);
        }

        protected FileServer(Server server) throws IscobolRuntimeException {
            this.server = server;
        }

        private FileServer(String string) throws IscobolRuntimeException {
            this.server = Server.get(string);
        }

        public int init() throws IscobolRuntimeException {
            Object[] objectArray = new Object[1];
            this.server.call("D_init", objectArray);
            return (Integer)objectArray[0];
        }

        public int exit() throws IscobolRuntimeException {
            Object[] objectArray = new Object[1];
            this.server.call("E_exit", objectArray);
            this.server.finalize();
            return (Integer)objectArray[0];
        }

        public int make(String string, String string2, String string3, String string4, String string5, byte[] byArray) throws IscobolRuntimeException {
            Object[] objectArray = new Object[9];
            objectArray[3] = string;
            objectArray[4] = string2;
            objectArray[5] = string3;
            objectArray[6] = string4;
            objectArray[7] = string5;
            objectArray[8] = byArray != null ? new Principal(byArray) : null;
            this.server.call("A_make", objectArray);
            this.f_errno = (Short)objectArray[1];
            this.f_int_errno = (Integer)objectArray[2];
            return (Integer)objectArray[0];
        }

        public int open(String string, int n2, String string2) throws IscobolRuntimeException {
            Object[] objectArray = new Object[6];
            objectArray[3] = string;
            objectArray[4] = new Short((short)n2);
            objectArray[5] = string2;
            this.server.call("B_open", objectArray);
            this.f_errno = (Short)objectArray[1];
            this.f_int_errno = (Integer)objectArray[2];
            return (Integer)objectArray[0];
        }

        public int close(int n2) throws IscobolRuntimeException {
            Object[] objectArray = new Object[4];
            objectArray[3] = new Integer(n2);
            this.server.call("C_close", objectArray);
            this.f_errno = (Short)objectArray[1];
            this.f_int_errno = (Integer)objectArray[2];
            return (Integer)objectArray[0];
        }

        public int write(int n2, byte[] byArray, int n3, int n4, boolean bl) throws IscobolRuntimeException {
            Object[] objectArray = new Object[6];
            objectArray[3] = new Integer(n2);
            objectArray[4] = new Principal(byArray, n3, n4 == 0 ? byArray.length - n3 : n4);
            objectArray[5] = new Boolean(bl);
            this.server.call("F_write", objectArray);
            this.f_errno = (Short)objectArray[1];
            this.f_int_errno = (Integer)objectArray[2];
            return (Integer)objectArray[0];
        }

        public int rewrite(int n2, byte[] byArray, int n3, int n4, boolean bl) throws IscobolRuntimeException {
            Object[] objectArray = new Object[6];
            objectArray[3] = new Integer(n2);
            objectArray[4] = new Principal(byArray, n3, n4 == 0 ? byArray.length - n3 : n4);
            objectArray[5] = new Boolean(bl);
            this.server.call("G_rewrite", objectArray);
            this.f_errno = (Short)objectArray[1];
            this.f_int_errno = (Integer)objectArray[2];
            return (Integer)objectArray[0];
        }

        public int delete(int n2, byte[] byArray, int n3) throws IscobolRuntimeException {
            Object[] objectArray = new Object[5];
            objectArray[3] = new Integer(n2);
            objectArray[4] = new Principal(byArray, n3, byArray.length - n3);
            this.server.call("H_delete", objectArray);
            this.f_errno = (Short)objectArray[1];
            this.f_int_errno = (Integer)objectArray[2];
            return (Integer)objectArray[0];
        }

        public int next(int n2, byte[] byArray, int n3, int n4) throws IscobolRuntimeException {
            Object[] objectArray = new Object[7];
            objectArray[3] = new Integer(n2);
            objectArray[4] = new Principal(byArray, n3, byArray.length - n3);
            objectArray[5] = new Integer(byArray.length - n3);
            objectArray[6] = new Boolean(n4 > 0);
            this.server.call("I_next", objectArray);
            this.f_errno = (Short)objectArray[1];
            this.f_int_errno = (Integer)objectArray[2];
            if (this.f_errno == 5) {
                BaseFile.setLockId(((Integer)objectArray[0]).intValue());
                return 0;
            }
            return (Integer)objectArray[0];
        }

        public int previous(int n2, byte[] byArray, int n3, int n4) throws IscobolRuntimeException {
            Object[] objectArray = new Object[7];
            objectArray[3] = new Integer(n2);
            objectArray[4] = new Principal(byArray, n3, byArray.length - n3);
            objectArray[5] = new Integer(byArray.length - n3);
            objectArray[6] = new Boolean(n4 > 0);
            this.server.call("J_previous", objectArray);
            this.f_errno = (Short)objectArray[1];
            this.f_int_errno = (Integer)objectArray[2];
            if (this.f_errno == 5) {
                BaseFile.setLockId(((Integer)objectArray[0]).intValue());
                return 0;
            }
            return (Integer)objectArray[0];
        }

        public int read(int n2, byte[] byArray, int n3, int n4, int n5) throws IscobolRuntimeException {
            Object[] objectArray = new Object[7];
            objectArray[3] = new Integer(n2);
            objectArray[4] = new Principal(byArray, n3, byArray.length - n3);
            objectArray[5] = new Integer(n4);
            objectArray[6] = new Boolean(n5 > 0);
            this.server.call("K_read", objectArray);
            this.f_errno = (Short)objectArray[1];
            this.f_int_errno = (Integer)objectArray[2];
            if (this.f_errno == 5) {
                BaseFile.setLockId(((Integer)objectArray[0]).intValue());
                return 0;
            }
            return (Integer)objectArray[0];
        }

        public int start(int n2, byte[] byArray, int n3, int n4, int n5, int n6) throws IscobolRuntimeException {
            Object[] objectArray = new Object[8];
            objectArray[3] = new Integer(n2);
            objectArray[4] = new Principal(byArray, n3, byArray.length - n3);
            objectArray[5] = new Integer(n4);
            objectArray[6] = new Integer(n5);
            objectArray[7] = new Short((short)n6);
            this.server.call("L_start", objectArray);
            this.f_errno = (Short)objectArray[1];
            this.f_int_errno = (Integer)objectArray[2];
            return (Integer)objectArray[0];
        }

        public int unlock(int n2) throws IscobolRuntimeException {
            Object[] objectArray = new Object[4];
            objectArray[3] = new Integer(n2);
            this.server.call("M_unlock", objectArray);
            this.f_errno = (Short)objectArray[1];
            this.f_int_errno = (Integer)objectArray[2];
            return (Integer)objectArray[0];
        }

        public int sync(int n2) throws IscobolRuntimeException {
            Object[] objectArray = new Object[4];
            objectArray[3] = new Integer(n2);
            this.server.call("N_sync", objectArray);
            this.f_errno = (Short)objectArray[1];
            this.f_int_errno = (Integer)objectArray[2];
            return (Integer)objectArray[0];
        }

        public int remove(String string) throws IscobolRuntimeException {
            Object[] objectArray = new Object[4];
            objectArray[3] = string;
            this.server.call("O_remove", objectArray);
            this.f_errno = (Short)objectArray[1];
            this.f_int_errno = (Integer)objectArray[2];
            return (Integer)objectArray[0];
        }

        public int rename(String string, String string2) throws IscobolRuntimeException {
            Object[] objectArray = new Object[5];
            objectArray[3] = string;
            objectArray[4] = string2;
            this.server.call("P_rename", objectArray);
            this.f_errno = (Short)objectArray[1];
            this.f_int_errno = (Integer)objectArray[2];
            return (Integer)objectArray[0];
        }

        public int info(int n2, int n3, byte[] byArray) throws IscobolRuntimeException {
            Object[] objectArray = new Object[7];
            objectArray[3] = new Integer(n2);
            objectArray[4] = new Integer(n3);
            objectArray[5] = new Principal(byArray);
            objectArray[6] = new Integer(byArray.length);
            this.server.call("Q_info", objectArray);
            this.f_errno = (Short)objectArray[1];
            this.f_int_errno = (Integer)objectArray[2];
            return (Integer)objectArray[0];
        }

        public int begin() throws IscobolRuntimeException {
            Object[] objectArray = new Object[3];
            this.server.call("R_begin", objectArray);
            this.f_errno = (Short)objectArray[1];
            this.f_int_errno = (Integer)objectArray[2];
            return (Integer)objectArray[0];
        }

        public int commit(int n2) throws IscobolRuntimeException {
            Object[] objectArray = new Object[4];
            objectArray[3] = new Integer(n2);
            this.server.call("S_commit", objectArray);
            this.f_errno = (Short)objectArray[1];
            this.f_int_errno = (Integer)objectArray[2];
            return (Integer)objectArray[0];
        }

        public int rollback() throws IscobolRuntimeException {
            Object[] objectArray = new Object[3];
            this.server.call("T_rollback", objectArray);
            this.f_errno = (Short)objectArray[1];
            this.f_int_errno = (Integer)objectArray[2];
            return (Integer)objectArray[0];
        }

        public int recover() throws IscobolRuntimeException {
            Object[] objectArray = new Object[3];
            this.server.call("U_recover", objectArray);
            this.f_errno = (Short)objectArray[1];
            this.f_int_errno = (Integer)objectArray[2];
            return (Integer)objectArray[0];
        }

        public int version(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int[] nArray) throws IscobolRuntimeException {
            Object[] objectArray = new Object[8];
            objectArray[3] = new Principal(byArray);
            objectArray[4] = new Principal(byArray2);
            objectArray[5] = new Principal(byArray3);
            objectArray[6] = new Integer(n2);
            this.server.call("V_version", objectArray);
            if (nArray != null && nArray.length > 0) {
                nArray[0] = (Integer)objectArray[7];
            }
            this.f_errno = (Short)objectArray[1];
            this.f_int_errno = (Integer)objectArray[2];
            return (Integer)objectArray[0];
        }

        public int config(int n2, String string, String string2) throws IscobolRuntimeException {
            Object[] objectArray = new Object[4];
            objectArray[1] = new Integer(n2);
            objectArray[2] = string;
            objectArray[3] = string2;
            this.server.call("Y_config", objectArray);
            return (Integer)objectArray[0];
        }

        public int initsrv() throws IscobolRuntimeException {
            Object[] objectArray = new Object[1];
            this.server.call("W_initsrv", objectArray);
            return (Integer)objectArray[0];
        }

        public int exitsrv() throws IscobolRuntimeException {
            Object[] objectArray = new Object[1];
            this.server.call("X_exitsrv", objectArray);
            return (Integer)objectArray[0];
        }
    }

    static class Server
    extends IiopServer
    implements Corba,
    RuntimeErrorsNumbers {
        public static final CorbaArg[] make_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_string, 0L, 1), new CorbaArg(TCD_string, 0L, 1), new CorbaArg(TCD_string, 0L, 1), new CorbaArg(TCD_string, 0L, 1), new CorbaArg(TCD_string, 0L, 1), new CorbaArg(TCD_Principal, 0L, 1)};
        public static final CorbaArg[] open_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_string, 0L, 1), new CorbaArg(TCD_short, 0L, 1), new CorbaArg(TCD_string, 0L, 1)};
        public static final CorbaArg[] close_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_long, 0L, 1)};
        public static final CorbaArg[] write_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_long, 0L, 1), new CorbaArg(TCD_Principal, 0L, 1), new CorbaArg(TCD_boolean, 0L, 1)};
        public static final CorbaArg[] rewrite_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_long, 0L, 1), new CorbaArg(TCD_Principal, 0L, 1), new CorbaArg(TCD_boolean, 0L, 1)};
        public static final CorbaArg[] delete_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_long, 0L, 1), new CorbaArg(TCD_Principal, 0L, 1)};
        public static final CorbaArg[] read_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_long, 0L, 1), new CorbaArg(TCD_Principal, 0L, 3), new CorbaArg(TCD_long, 0L, 1), new CorbaArg(TCD_boolean, 0L, 1)};
        public static final CorbaArg[] next_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_long, 0L, 1), new CorbaArg(TCD_Principal, 0L, 2), new CorbaArg(TCD_long, 0L, 1), new CorbaArg(TCD_boolean, 0L, 1)};
        public static final CorbaArg[] previous_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_long, 0L, 1), new CorbaArg(TCD_Principal, 0L, 2), new CorbaArg(TCD_long, 0L, 1), new CorbaArg(TCD_boolean, 0L, 1)};
        public static final CorbaArg[] start_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_long, 0L, 1), new CorbaArg(TCD_Principal, 0L, 1), new CorbaArg(TCD_long, 0L, 1), new CorbaArg(TCD_long, 0L, 1), new CorbaArg(TCD_short, 0L, 1)};
        public static final CorbaArg[] unlock_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_long, 0L, 1)};
        public static final CorbaArg[] sync_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_long, 0L, 1)};
        public static final CorbaArg[] remove_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_string, 0L, 1)};
        public static final CorbaArg[] rename_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_string, 0L, 1), new CorbaArg(TCD_string, 0L, 1)};
        public static final CorbaArg[] info_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_long, 0L, 1), new CorbaArg(TCD_long, 0L, 1), new CorbaArg(TCD_Principal, 0L, 2), new CorbaArg(TCD_long, 0L, 1)};
        public static final CorbaArg[] begin_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2)};
        public static final CorbaArg[] commit_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_long, 0L, 1)};
        public static final CorbaArg[] rollback_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2)};
        public static final CorbaArg[] recover_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2)};
        public static final CorbaArg[] version_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_short, 0L, 2), new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_Principal, 0L, 2), new CorbaArg(TCD_Principal, 0L, 2), new CorbaArg(TCD_Principal, 0L, 2), new CorbaArg(TCD_long, 0L, 1), new CorbaArg(TCD_long, 0L, 2)};
        public static final CorbaArg[] init_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2)};
        public static final CorbaArg[] exit_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2)};
        public static final CorbaArg[] config_params = new CorbaArg[]{new CorbaArg(TCD_long, 0L, 2), new CorbaArg(TCD_long, 0L, 1), new CorbaArg(TCD_string, 0L, 1), new CorbaArg(TCD_string, 0L, 1)};

        public static Server get(String string) throws IscobolRuntimeException {
            Server server;
            try {
                server = new Server(string);
            }
            catch (CorbaException corbaException) {
                Server.throwException(corbaException);
                server = null;
            }
            return server;
        }

        protected Server(String string) throws CorbaException {
            super(string);
            this.methods.put(new CorbaMethod("A_make", make_params));
            this.methods.put(new CorbaMethod("B_open", open_params));
            this.methods.put(new CorbaMethod("C_close", close_params));
            this.methods.put(new CorbaMethod("D_init", init_params));
            this.methods.put(new CorbaMethod("E_exit", exit_params));
            this.methods.put(new CorbaMethod("F_write", write_params));
            this.methods.put(new CorbaMethod("G_rewrite", rewrite_params));
            this.methods.put(new CorbaMethod("H_delete", delete_params));
            this.methods.put(new CorbaMethod("I_next", next_params));
            this.methods.put(new CorbaMethod("J_previous", previous_params));
            this.methods.put(new CorbaMethod("K_read", read_params));
            this.methods.put(new CorbaMethod("L_start", start_params));
            this.methods.put(new CorbaMethod("M_unlock", unlock_params));
            this.methods.put(new CorbaMethod("N_sync", sync_params));
            this.methods.put(new CorbaMethod("O_remove", remove_params));
            this.methods.put(new CorbaMethod("P_rename", rename_params));
            this.methods.put(new CorbaMethod("Q_info", info_params));
            this.methods.put(new CorbaMethod("R_begin", begin_params));
            this.methods.put(new CorbaMethod("S_commit", commit_params));
            this.methods.put(new CorbaMethod("T_rollback", rollback_params));
            this.methods.put(new CorbaMethod("U_recover", recover_params));
            this.methods.put(new CorbaMethod("V_version", version_params));
            this.methods.put(new CorbaMethod("Y_config", config_params));
        }

        public synchronized void call(String string, Object[] objectArray) throws IscobolRuntimeException {
            try {
                this.invoke(string, objectArray);
            }
            catch (CorbaException corbaException) {
                Server.throwException(corbaException);
            }
        }

        @Override
        public synchronized void finalize() {
            try {
                super.finalize();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        static void throwException(CorbaException corbaException) throws IscobolRuntimeException {
            throw new IscobolRuntimeException(3, "IIOP: " + corbaException.getMessage());
        }
    }
}

