/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.dci.Dci;
import com.iscobol.io.BaseFile;
import com.iscobol.rts.DynamicFile;
import com.iscobol.rts.Factory;
import com.iscobol.rts.IOUtil;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.KeyDescription;
import com.iscobol.rts.MonitorFinalize;
import com.iscobol.rts.RuntimeErrorsNumbers;
import java.util.ArrayList;

public class DynamicDci
implements DynamicFile,
RuntimeErrorsNumbers,
Cloneable {
    private int theFile = -1;
    private MyConn theConn;
    private int openMode = 0;
    private KeyDescription[] keys;
    private int maxRecordSize;
    private int minRecordSize;
    private String path = "";
    private int errno;
    private String sysError;
    private String errMsg;
    private static final Object exit = new Object(){

        protected void finalize() {
            Dci.exit();
        }
    };

    public static int setenv(byte[] byArray, byte[] byArray2) {
        MyConn myConn = (MyConn)IscobolSystem.get(MyConn.class);
        if (myConn == null) {
            Env env = (Env)IscobolSystem.get(Env.class);
            if (env == null) {
                env = new Env();
                IscobolSystem.set(Env.class, env);
            }
            env.set(byArray, byArray2);
        } else {
            Dci.dci__setenv(myConn.conn, byArray, byArray2);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicDci() {
        Object object = exit;
        synchronized (object) {
            this.theConn = (MyConn)IscobolSystem.get(MyConn.class);
            if (this.theConn == null) {
                MyConn myConn;
                Env env = (Env)IscobolSystem.get(Env.class);
                if (env == null) {
                    myConn = new MyConn(Dci.c_connect(null, null, null));
                } else {
                    myConn = new MyConn(Dci.c_connect(env.database, env.login, env.password));
                    env.update(myConn);
                }
                this.theConn = myConn;
                if (myConn.conn >= 0) {
                    IscobolSystem.set(MyConn.class, myConn);
                    Factory.getCurrentMonitor().addObjToFinalize(new MonitorFinalize(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void monitorFinalize() {
                            Object object = exit;
                            synchronized (object) {
                                Dci.c_disconn(myConn.conn);
                                myConn.conn = -1;
                            }
                        }
                    });
                }
            }
        }
    }

    private int getConn() {
        return this.theConn.conn;
    }

    @Override
    public String getSysErrno() {
        return this.sysError;
    }

    @Override
    public String getErrMsg() {
        return this.errMsg;
    }

    public int getFErrno() {
        return this.errno;
    }

    @Override
    public int getCobErrno() {
        switch (this.errno) {
            case 0: {
                return 0;
            }
            case 1: {
                return 133;
            }
            case 2: {
                return 102;
            }
            case 3: {
                return 104;
            }
            case 4: {
                return 125;
            }
            case 5: {
                return 107;
            }
            case 6: {
                return 105;
            }
            case 7: {
                return 100;
            }
            case 8: {
                return 111;
            }
            case 9: {
                return 112;
            }
            case 10: {
                return 127;
            }
            case 11: {
                return 113;
            }
            case 12: {
                return 128;
            }
            case 13: {
                return 128;
            }
            case 14: {
                return 116;
            }
            case 15: {
                return 130;
            }
            case 16: {
                return 131;
            }
            case 17: {
                return 126;
            }
            case 18: {
                return 129;
            }
            case 19: {
                return 140;
            }
            case 20: {
                return 133;
            }
            case 22: {
                return 122;
            }
            case 100: {
                return 204;
            }
            case 101: {
                return 200;
            }
        }
        return 134;
    }

    private void setLock(boolean bl) {
        if (bl) {
            Dci.set_f_no_lock(0);
        } else {
            Dci.set_f_no_lock(1);
        }
    }

    @Override
    public long getNumRecords() {
        byte[] byArray = new byte[11];
        int n2 = Dci.i_info(this.theFile, -4, byArray);
        return Long.parseLong(new String(byArray, 0, 10));
    }

    @Override
    public int getNumKeys() {
        if (this.keys == null) {
            byte[] byArray = new byte[256];
            int n2 = Dci.i_info(this.theFile, -1, byArray);
            if (n2 == 0) {
                return this.mapError();
            }
            int[] nArray = IOUtil.csv2Int(byArray);
            this.maxRecordSize = nArray[0];
            this.minRecordSize = nArray[1];
            this.keys = new KeyDescription[nArray[2]];
        }
        return this.keys.length;
    }

    @Override
    public int getMaxRecordSize() {
        if (this.keys == null) {
            this.getNumKeys();
        }
        return this.maxRecordSize;
    }

    @Override
    public int getMinRecordSize() {
        if (this.keys == null) {
            this.getNumKeys();
        }
        return this.minRecordSize;
    }

    @Override
    public KeyDescription getKey(int n2) {
        KeyDescription keyDescription;
        if (n2 >= 0 && n2 < this.getNumKeys()) {
            if (this.keys[n2] == null) {
                byte[] byArray = new byte[256];
                int n3 = Dci.i_info(this.theFile, n2, byArray);
                if (n3 == 0) {
                    this.mapError();
                    return null;
                }
                this.keys[n2] = new KeyDescription(byArray);
            }
            keyDescription = this.keys[n2];
        } else {
            keyDescription = null;
            this.mapError(2);
        }
        return keyDescription;
    }

    @Override
    public byte[] getSequence() {
        return null;
    }

    private int findKey(KeyDescription keyDescription) {
        int n2;
        int n3 = this.getNumKeys();
        try {
            for (n2 = 0; n2 < n3 && !keyDescription.equals(this.getKey(n2)); ++n2) {
            }
        }
        catch (NullPointerException nullPointerException) {
            n2 = -1;
        }
        return n2;
    }

    private int mapError(int n2, int n3) {
        this.errno = n2;
        this.sysError = "" + n3;
        this.errMsg = "";
        return 0;
    }

    private int mapError(int n2) {
        this.errno = n2;
        this.sysError = "";
        this.errMsg = "";
        return 0;
    }

    private int mapError() {
        this.errno = Dci.f_errno();
        this.sysError = "" + Dci.f_int_errno();
        this.errMsg = Dci.f_errmsg();
        if (this.errMsg == null) {
            this.errMsg = "";
        }
        return 0;
    }

    int mapOpen(int n2, int n3) {
        int n4;
        switch (n2) {
            default: {
                n4 = 0;
                break;
            }
            case 2: {
                n4 = 1;
                break;
            }
            case 3: {
                n4 = 2;
                break;
            }
            case 6: {
                n4 = 3;
            }
        }
        switch (n3 & 0xF) {
            default: {
                break;
            }
            case 1: 
            case 6: {
                n4 |= 0x300;
                break;
            }
            case 4: {
                n4 |= 0x200;
                break;
            }
            case 3: 
            case 5: {
                n4 |= 0x100;
            }
        }
        if ((n3 & 0x100) != 0) {
            n4 |= 0x10;
        }
        if ((n3 & 0x200) != 0) {
            n4 |= 0x600;
        }
        if ((n3 & 0x800) != 0) {
            n4 |= 0x4000;
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int build(String string, String string2, int n2, int n3, int n4, int n5, int n6, int n7, int n8, KeyDescription[] keyDescriptionArray, byte[] byArray, boolean bl) {
        Object object = exit;
        synchronized (object) {
            if (bl) {
                string = BaseFile.expandFileName(string);
            }
            if (this.getConn() < 0) {
                return this.mapError(1, 5510);
            }
            String string3 = new String(IOUtil.int2Csv(new int[]{n2, n3, n4, n5, n6}, new int[]{1, 1, 1, 3, 1}));
            String string4 = "" + n7 + "," + n8 + "," + keyDescriptionArray.length;
            StringBuffer stringBuffer = new StringBuffer();
            int n9 = 0;
            while (true) {
                stringBuffer.append(keyDescriptionArray[n9].toString());
                if (++n9 >= keyDescriptionArray.length) break;
                stringBuffer.append(',');
            }
            if (Dci.c_make(this.getConn(), string, string2, string3, string4, stringBuffer.toString(), null) == 0) {
                return this.mapError();
            }
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int open(String string, int n2, int n3, KeyDescription[] keyDescriptionArray, int n4, int n5, int n6, int n7, boolean bl, boolean bl2) {
        Object object = exit;
        synchronized (object) {
            if (bl2) {
                string = BaseFile.expandFileName(string);
            }
            if (this.getConn() < 0) {
                return this.mapError(1, 5510);
            }
            String string2 = "" + n4 + "," + n5 + "," + n6;
            switch (n2) {
                case 1: 
                case 2: 
                case 3: 
                case 6: {
                    this.theFile = Dci.c_open(this.getConn(), string, this.mapOpen(n2, n3), string2);
                    if (this.theFile >= 0) break;
                    return this.mapError();
                }
                default: {
                    throw new IscobolRuntimeException(3, new IllegalArgumentException("OPEN").toString());
                }
            }
            this.openMode = n2;
            this.path = string;
            return 1;
        }
    }

    @Override
    public void setCurrentRecord(long l2) {
    }

    @Override
    public long getCurrentRecord() {
        return 0L;
    }

    @Override
    public boolean isOpen() {
        return this.openMode != 0;
    }

    @Override
    public String getDescription() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int close() {
        Object object = exit;
        synchronized (object) {
            if (this.isOpen()) {
                this.openMode = 0;
                if (this.getConn() >= 0 && Dci.c_close(this.getConn(), this.theFile) == 0) {
                    return this.mapError();
                }
                this.theFile = -1;
                this.keys = null;
                this.path = "";
                return 1;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(byte[] byArray, int n2, int n3, boolean bl) {
        Object object = exit;
        synchronized (object) {
            if (this.getConn() < 0) {
                return this.mapError(1, 5510);
            }
            this.setLock(bl);
            int n4 = Dci.i_write(this.theFile, byArray, n2, n3);
            this.errno = Dci.f_errno();
            if (n4 == 0) {
                return this.mapError();
            }
            return 1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long rewrite(byte[] byArray, int n2, int n3, boolean bl) {
        Object object = exit;
        synchronized (object) {
            if (this.getConn() < 0) {
                return this.mapError(1, 5510);
            }
            this.setLock(bl);
            int n4 = Dci.i_rewrite(this.theFile, byArray, n2, n3);
            this.errno = Dci.f_errno();
            if (n4 == 0) {
                return this.mapError();
            }
            return 1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long delete(byte[] byArray, int n2) {
        Object object = exit;
        synchronized (object) {
            if (this.getConn() < 0) {
                return this.mapError(1, 5510);
            }
            if (Dci.i_delete(this.theFile, byArray, n2) == 0) {
                return this.mapError();
            }
            return 1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long next(byte[] byArray, int n2, int n3) {
        Object object = exit;
        synchronized (object) {
            if (this.getConn() < 0) {
                return this.mapError(1, 5510);
            }
            this.setLock(n3 > 0);
            int n4 = Dci.i_next(this.theFile, byArray, n2);
            this.errno = Dci.f_errno();
            if (n4 == 0) {
                return this.mapError();
            }
            return n4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long previous(byte[] byArray, int n2, int n3) {
        Object object = exit;
        synchronized (object) {
            if (this.getConn() < 0) {
                return this.mapError(1, 5510);
            }
            this.setLock(n3 > 0);
            int n4 = Dci.i_previous(this.theFile, byArray, n2);
            this.errno = Dci.f_errno();
            if (n4 == 0) {
                return this.mapError();
            }
            return n4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long read(byte[] byArray, int n2, int n3, int n4) {
        Object object = exit;
        synchronized (object) {
            if (this.getConn() < 0) {
                return this.mapError(1, 5510);
            }
            this.setLock(n4 > 0);
            int n5 = Dci.i_read(this.theFile, byArray, n2, n3);
            this.errno = Dci.f_errno();
            if (n5 == 0) {
                return this.mapError();
            }
            return n5;
        }
    }

    @Override
    public long read(byte[] byArray, int n2, KeyDescription keyDescription, int n3) {
        return this.read(byArray, n2, this.findKey(keyDescription), n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long start(byte[] byArray, int n2, int n3, int n4, int n5) {
        Object object = exit;
        synchronized (object) {
            int n6;
            if (this.getConn() < 0) {
                return this.mapError(1, 5510);
            }
            switch (n5) {
                case 0: {
                    byte[] byArray2 = new byte[byArray.length];
                    n6 = Dci.i_start(this.theFile, byArray2, 0, n3, n4, 1);
                    break;
                }
                case 1: {
                    byte[] byArray3 = new byte[byArray.length];
                    for (int i2 = byArray.length - 1; i2 >= 0; --i2) {
                        byArray3[i2] = -1;
                    }
                    n6 = Dci.i_start(this.theFile, byArray3, 0, n3, n4, 4);
                    break;
                }
                case 5: {
                    n6 = Dci.i_start(this.theFile, byArray, n2, n3, n4, 0);
                    break;
                }
                case 6: {
                    n6 = Dci.i_start(this.theFile, byArray, n2, n3, n4, 2);
                    break;
                }
                case 7: {
                    n6 = Dci.i_start(this.theFile, byArray, n2, n3, n4, 1);
                    break;
                }
                case 8: {
                    n6 = Dci.i_start(this.theFile, byArray, n2, n3, n4, 3);
                    break;
                }
                case 9: {
                    n6 = Dci.i_start(this.theFile, byArray, n2, n3, n4, 4);
                    break;
                }
                default: {
                    throw new IscobolRuntimeException(3, new IllegalArgumentException("START").toString());
                }
            }
            if (n6 == 0) {
                return this.mapError();
            }
            return 1L;
        }
    }

    @Override
    public long start(byte[] byArray, int n2, KeyDescription keyDescription, int n3, int n4) {
        return this.start(byArray, n2, this.findKey(keyDescription), n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int unlock() {
        int n2;
        Object object = exit;
        synchronized (object) {
            if (this.getConn() < 0) {
                return this.mapError(1, 5510);
            }
            n2 = Dci.i_unlock(this.theFile);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync(int n2) {
        Object object = exit;
        synchronized (object) {
            if (this.getConn() >= 0) {
                Dci.i_sync(n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int remove(String string) {
        int n2 = 0;
        Object object = exit;
        synchronized (object) {
            if (this.getConn() >= 0) {
                n2 = Dci.c_remove(this.getConn(), string);
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int rename(String string, String string2) {
        int n2;
        Object object = exit;
        synchronized (object) {
            if (this.getConn() < 0) {
                return this.mapError(1, 5510);
            }
            n2 = Dci.i_rename(string, string2);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int begin() {
        int n2 = 0;
        Object object = exit;
        synchronized (object) {
            if (this.getConn() >= 0) {
                n2 = Dci.c_begin(this.getConn());
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int commit(int n2) {
        int n3 = 0;
        Object object = exit;
        synchronized (object) {
            if (this.getConn() >= 0) {
                n3 = Dci.c_commit(this.getConn(), n2);
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int rollback() {
        int n2 = 0;
        Object object = exit;
        synchronized (object) {
            if (this.getConn() >= 0) {
                n2 = Dci.c_rollback(this.getConn());
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int recover() {
        int n2;
        Object object = exit;
        synchronized (object) {
            if (this.getConn() < 0) {
                return this.mapError(1, 5510);
            }
            n2 = Dci.i_recover();
        }
        return n2;
    }

    @Override
    public String getVersion() {
        int n2;
        int n3;
        int n4;
        byte[] byArray = new byte[255];
        byte[] byArray2 = new byte[255];
        byte[] byArray3 = new byte[255];
        int n5 = Dci.i_version(byArray, byArray2, byArray3, 0, null);
        for (n4 = 0; n4 < byArray.length && byArray[n4] != 0; ++n4) {
        }
        for (n3 = 0; n3 < byArray2.length && byArray2[n3] != 0; ++n3) {
        }
        for (n2 = 0; n2 < byArray3.length && byArray3[n2] != 0; ++n2) {
        }
        return new String(byArray, 0, n4) + ";" + new String(byArray2, 0, n3) + ";" + new String(byArray3, 0, n2);
    }

    @Override
    public boolean isKeySelectedByNum() {
        return false;
    }

    public void finalize() {
        this.close();
    }

    static {
        Dci.i_init();
    }

    public static class Env {
        String database;
        String login;
        String password;
        private ArrayList<byte[][]> env = new ArrayList();

        void set(byte[] byArray, byte[] byArray2) {
            String string;
            this.env.add(new byte[][]{byArray, byArray2});
            switch (string = new String(byArray).trim().toUpperCase()) {
                case "DCI_DATABASE": {
                    this.database = new String(byArray2).trim();
                    break;
                }
                case "DCI_LOGIN": {
                    this.login = new String(byArray2).trim();
                    break;
                }
                case "DCI_PASSWORD": {
                    this.password = new String(byArray2).trim();
                    break;
                }
            }
        }

        void update(MyConn myConn) {
            if (myConn != null && myConn.conn >= 0) {
                int n2 = this.env.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    byte[][] byArray = this.env.get(i2);
                    Dci.dci__setenv(myConn.conn, byArray[0], byArray[1]);
                }
                this.env.clear();
            }
        }
    }

    public static class MyConn {
        private int conn;

        MyConn(int n2) {
            this.conn = n2;
        }

        public int getConn() {
            return this.conn;
        }
    }
}

