/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import IT.picosoft.isam.DictInfo64;
import IT.picosoft.isam.Isam;
import IT.picosoft.isam.IsamException;
import IT.picosoft.isam.KeyDesc64;
import IT.picosoft.isam.KeyPart;
import com.iscobol.io.BaseFile;
import com.iscobol.rts.Config;
import com.iscobol.rts.DynamicFile;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.KeyDescription;
import com.iscobol.rts.RuntimeErrorsNumbers;

public class DynamicJIsam
implements DynamicFile,
RuntimeErrorsNumbers,
Cloneable {
    public static final int ISAM_NO_ENCR_KEY = 140;
    private Isam theFile;
    private int openMode = 0;
    private KeyDescription[] keys;
    private KeyDesc64[] isamKeys;
    private int maxRecordSize;
    private int minRecordSize;
    private boolean lockMulti;
    private boolean exclLock;
    private String path = "";
    private int errno;
    private Exception errio;
    private static boolean readLockWait = false;
    private static boolean readLockTest = false;
    private static boolean outLock = Config.b(".file.output_lock", true);
    private static boolean extLock = Config.b(".file.extend_lock", true);

    @Override
    public String getSysErrno() {
        if (this.errio != null) {
            return this.errio.getMessage();
        }
        return "";
    }

    @Override
    public String getErrMsg() {
        if (this.errio != null) {
            return this.errio.getMessage();
        }
        return "";
    }

    private static String getEncryptionKey() throws IsamException {
        String string = Config.a(".file.encryption.key", null);
        if (string == null || string.length() == 0) {
            throw new IsamException(140, "Missing encryption key");
        }
        return string;
    }

    @Override
    public int getCobErrno() {
        switch (this.errno) {
            case 0: {
                return 0;
            }
            case 100: {
                return 100;
            }
            case 133: {
                return 133;
            }
            case 102: {
                return 102;
            }
            case 104: {
                return 104;
            }
            case 125: {
                return 125;
            }
            case 107: {
                return 107;
            }
            case 106: {
                return 106;
            }
            case 105: {
                return 105;
            }
            case 108: {
                return 108;
            }
            case 111: {
                return 111;
            }
            case 110: {
                return 110;
            }
            case 112: {
                return 112;
            }
            case 127: {
                return 127;
            }
            case 113: {
                return 113;
            }
            case 128: {
                return 128;
            }
            case 116: {
                return 116;
            }
            case 130: {
                return 130;
            }
            case 131: {
                return 131;
            }
            case 126: {
                return 126;
            }
            case 129: {
                return 129;
            }
            case 122: {
                return 122;
            }
            case 132: {
                return 132;
            }
            case 103: {
                return 103;
            }
            case 140: {
                return 149;
            }
        }
        return 134;
    }

    @Override
    public synchronized long getNumRecords() {
        DictInfo64 dictInfo64 = new DictInfo64();
        try {
            this.theFile.indexInfo(dictInfo64);
        }
        catch (IsamException isamException) {
            this.mapError(isamException);
        }
        return dictInfo64.di_nrecords64;
    }

    @Override
    public synchronized int getNumKeys() {
        if (this.keys == null) {
            DictInfo64 dictInfo64 = new DictInfo64();
            try {
                this.theFile.indexInfo(dictInfo64);
            }
            catch (IsamException isamException) {
                this.mapError(isamException);
            }
            this.maxRecordSize = this.minRecordSize = dictInfo64.di_recsize64;
            this.keys = new KeyDescription[dictInfo64.di_nkeys];
            this.isamKeys = new KeyDesc64[dictInfo64.di_nkeys];
        }
        return this.keys.length;
    }

    @Override
    public int getMaxRecordSize() {
        if (this.keys == null) {
            this.getNumKeys();
        }
        return this.maxRecordSize;
    }

    @Override
    public int getMinRecordSize() {
        if (this.keys == null) {
            this.getNumKeys();
        }
        return this.minRecordSize;
    }

    @Override
    public synchronized KeyDescription getKey(int n2) {
        KeyDescription keyDescription;
        if (n2 >= 0 && n2 < this.getNumKeys()) {
            if (this.keys[n2] == null) {
                this.isamKeys[n2] = new KeyDesc64();
                try {
                    this.theFile.indexInfo(this.isamKeys[n2], n2 + 1);
                }
                catch (IsamException isamException) {
                    this.mapError(isamException);
                }
                this.keys[n2] = new KeyDescription(this.isamKeys[n2].k_nparts, (this.isamKeys[n2].k_flags & 1) == 1);
                for (int i2 = 0; i2 < this.isamKeys[n2].k_nparts; ++i2) {
                    this.keys[n2].setSegment(i2, this.isamKeys[n2].k_part[i2].kp_leng, this.isamKeys[n2].k_part[i2].kp_start);
                }
            }
            keyDescription = this.keys[n2];
        } else {
            keyDescription = null;
            this.mapError(new IsamException(102));
        }
        return keyDescription;
    }

    @Override
    public byte[] getSequence() {
        byte[] byArray;
        try {
            byArray = this.theFile.getCollatingSequence();
        }
        catch (IsamException isamException) {
            byArray = null;
            this.mapError(isamException);
        }
        return byArray;
    }

    private KeyDesc64 findKey(int n2) {
        this.getKey(n2);
        return this.isamKeys[n2];
    }

    private KeyDesc64 findKey(KeyDescription keyDescription) {
        int n2 = this.getNumKeys();
        try {
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!keyDescription.equals(this.getKey(i2))) continue;
                return this.isamKeys[i2];
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    private int mapError(IsamException isamException) {
        this.errno = isamException.getIserrno();
        this.errio = isamException.getIserrio();
        return 0;
    }

    int mapOpen(int n2, int n3) {
        int n4;
        switch (n2) {
            default: {
                n4 = 0;
                break;
            }
            case 2: {
                n4 = 1;
                break;
            }
            case 3: 
            case 6: {
                n4 = 2;
            }
        }
        switch (n3 & 0xF) {
            default: {
                n4 |= 0x400;
                break;
            }
            case 1: 
            case 6: {
                n4 |= 0x800;
                this.exclLock = true;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n4 |= 0x400;
            }
        }
        if ((n3 & 0x100) != 0 && (n4 & 0x800) == 0) {
            this.lockMulti = true;
            n4 |= 0x400;
        }
        if ((n3 & 0x800) != 0) {
            n4 |= 4;
        }
        return n4;
    }

    @Override
    public int build(String string, String string2, int n2, int n3, int n4, int n5, int n6, int n7, int n8, KeyDescription[] keyDescriptionArray, byte[] byArray, boolean bl) {
        int n9;
        int n10;
        if (n7 == 0) {
            throw new IscobolRuntimeException(3, new IllegalArgumentException("OPEN").toString());
        }
        if (bl) {
            string = BaseFile.expandFileName(string);
        }
        KeyDesc64 keyDesc64 = new KeyDesc64();
        if (keyDescriptionArray != null && keyDescriptionArray.length > 0 && keyDescriptionArray[0] != null) {
            keyDesc64.k_flags = keyDescriptionArray[0].isDup() ? (short)1 : 0;
            keyDesc64.k_nparts = (short)keyDescriptionArray[0].getNumSegments();
            for (n10 = 0; n10 < keyDesc64.k_nparts && n10 < 16; ++n10) {
                keyDesc64.k_part[n10] = new KeyPart();
                keyDesc64.k_part[n10].kp_leng = (short)keyDescriptionArray[0].segment[n10].size;
                keyDesc64.k_part[n10].kp_start = (short)keyDescriptionArray[0].segment[n10].offset;
                keyDesc64.k_part[n10].kp_type = 0;
            }
        } else {
            keyDesc64.k_flags = 0;
            keyDesc64.k_nparts = 0;
        }
        Isam isam = null;
        String string3 = null;
        try {
            if (n6 != 0) {
                string3 = DynamicJIsam.getEncryptionKey();
                isam = Isam.open(string, 2050, string3);
            } else {
                isam = Isam.open(string, 2050);
            }
            Isam.erase(string);
            isam.close();
        }
        catch (IsamException isamException) {
            switch (isamException.getIserrno()) {
                case 133: {
                    if (isam != null) {
                        try {
                            isam.close();
                            Isam.erase(string);
                            break;
                        }
                        catch (IsamException isamException2) {
                            return this.mapError(isamException2);
                        }
                    }
                    return this.mapError(isamException);
                }
                case 130: {
                    if (isam != null) break;
                    try {
                        Isam.erase(string);
                    }
                    catch (IsamException isamException3) {}
                    break;
                }
                case 105: {
                    try {
                        Isam.erase(string);
                    }
                    catch (IsamException isamException4) {}
                    break;
                }
                default: {
                    return this.mapError(isamException);
                }
            }
        }
        try {
            isam = Config.a(".jisam.version", 2) == 1 ? Isam.buildNodeSize(string, n7, keyDesc64, 2049, (short)0, (short)0, 1) : (n6 != 0 ? Isam.build(string, n7, keyDesc64, 2049, byArray, string3) : Isam.build(string, n7, keyDesc64, 2049, byArray));
            if (keyDescriptionArray != null && keyDescriptionArray.length > 1) {
                for (int i2 = 1; i2 < keyDescriptionArray.length; ++i2) {
                    if (keyDescriptionArray[i2] == null) continue;
                    keyDesc64.k_flags = keyDescriptionArray[i2].isDup() ? (short)1 : 0;
                    keyDesc64.k_nparts = (short)keyDescriptionArray[i2].getNumSegments();
                    for (n10 = 0; n10 < keyDesc64.k_nparts && n10 < 16; ++n10) {
                        keyDesc64.k_part[n10] = new KeyPart();
                        keyDesc64.k_part[n10].kp_leng = (short)keyDescriptionArray[i2].segment[n10].size;
                        keyDesc64.k_part[n10].kp_start = (short)keyDescriptionArray[i2].segment[n10].offset;
                        keyDesc64.k_part[n10].kp_type = 0;
                    }
                    isam.addindex(keyDesc64);
                }
            }
            isam.close();
            n9 = 1;
        }
        catch (IsamException isamException) {
            n9 = this.mapError(isamException);
        }
        return n9;
    }

    @Override
    public synchronized int open(String string, int n2, int n3, KeyDescription[] keyDescriptionArray, int n4, int n5, int n6, int n7, boolean bl, boolean bl2) {
        int n8;
        boolean bl3;
        boolean bl4 = bl3 = (n3 & 0x1000) != 0;
        if (bl2) {
            string = BaseFile.expandFileName(string);
        }
        if (n2 == 2 && outLock) {
            n3 = 1;
        } else if (n2 == 6 && extLock) {
            n3 = 1;
        }
        switch (n2) {
            case 2: 
            case 6: {
                n3 = 1;
            }
            case 1: 
            case 3: {
                try {
                    this.theFile = bl3 ? Isam.open(string, this.mapOpen(n2, n3), !Config.b(".jisam.autolock_allowed", false), DynamicJIsam.getEncryptionKey()) : Isam.open(string, this.mapOpen(n2, n3), !Config.b(".jisam.autolock_allowed", false));
                    n8 = 1;
                    this.openMode = n2;
                    this.path = string;
                }
                catch (IsamException isamException) {
                    n8 = this.mapError(isamException);
                }
                break;
            }
            default: {
                throw new IscobolRuntimeException(3, new IllegalArgumentException("OPEN").toString());
            }
        }
        return n8;
    }

    @Override
    public synchronized void setCurrentRecord(long l2) {
        this.theFile.setRecNum((int)l2);
    }

    @Override
    public synchronized long getCurrentRecord() {
        return this.theFile.getRecNum();
    }

    @Override
    public String getDescription() {
        return this.path;
    }

    @Override
    public synchronized int close() {
        int n2;
        if (this.theFile != null) {
            try {
                this.theFile.close();
                n2 = 1;
                this.theFile = null;
                this.keys = null;
                this.openMode = 0;
                this.path = "";
            }
            catch (IsamException isamException) {
                n2 = this.mapError(isamException);
            }
        } else {
            n2 = 1;
        }
        return n2;
    }

    @Override
    public boolean isOpen() {
        return this.openMode != 0;
    }

    @Override
    public synchronized long write(byte[] byArray, int n2, int n3, boolean bl) {
        int n4;
        this.errno = 0;
        try {
            this.theFile.write(byArray, n2);
            if (!this.exclLock && !this.lockMulti) {
                this.theFile.release();
            }
            n4 = 1;
        }
        catch (IsamException isamException) {
            n4 = this.mapError(isamException);
        }
        return n4;
    }

    @Override
    public synchronized long rewrite(byte[] byArray, int n2, int n3, boolean bl) {
        int n4;
        this.errno = 0;
        try {
            this.theFile.rewrite(byArray, n2);
            if (!this.exclLock && !this.lockMulti) {
                this.theFile.release();
            }
            n4 = 1;
        }
        catch (IsamException isamException) {
            n4 = this.mapError(isamException);
        }
        return n4;
    }

    @Override
    public synchronized long delete(byte[] byArray, int n2) {
        int n3;
        try {
            this.theFile.delete(byArray, n2);
            if (!this.exclLock && !this.lockMulti) {
                this.theFile.release();
            }
            n3 = 1;
        }
        catch (IsamException isamException) {
            n3 = this.mapError(isamException);
        }
        return n3;
    }

    private synchronized int setLock(int n2, int n3) throws IsamException {
        int n4 = n2;
        if (n3 > 0 && !this.exclLock) {
            n4 |= 0x100;
            if (!this.lockMulti) {
                this.theFile.release();
            }
        }
        if (n3 > 0 && (readLockWait || n3 == 3)) {
            n4 |= 0x1000;
        }
        if (n3 == 0 && readLockTest) {
            n4 |= 0x2000;
            n4 |= 0x100;
        }
        return n4;
    }

    @Override
    public synchronized long next(byte[] byArray, int n2, int n3) {
        int n4;
        this.errno = 0;
        try {
            if (!this.exclLock && !this.lockMulti) {
                this.theFile.release();
            }
            this.theFile.read(byArray, n2, this.setLock(2, n3));
            n4 = this.getMaxRecordSize();
        }
        catch (IsamException isamException) {
            n4 = this.mapError(isamException);
        }
        return n4;
    }

    @Override
    public synchronized long previous(byte[] byArray, int n2, int n3) {
        int n4;
        this.errno = 0;
        try {
            if (!this.exclLock && !this.lockMulti) {
                this.theFile.release();
            }
            this.theFile.read(byArray, n2, this.setLock(3, n3));
            n4 = this.getMaxRecordSize();
        }
        catch (IsamException isamException) {
            n4 = this.mapError(isamException);
        }
        return n4;
    }

    private synchronized int read(byte[] byArray, int n2, KeyDesc64 keyDesc64, int n3) {
        int n4;
        this.errno = 0;
        try {
            this.theFile.start(keyDesc64, 0, byArray, n2, 5);
            if (!this.exclLock && !this.lockMulti) {
                this.theFile.release();
            }
            this.theFile.read(byArray, n2, this.setLock(2, n3));
            n4 = this.getMaxRecordSize();
        }
        catch (IsamException isamException) {
            n4 = this.mapError(isamException);
        }
        return n4;
    }

    @Override
    public long read(byte[] byArray, int n2, int n3, int n4) {
        return this.read(byArray, n2, this.findKey(n3), n4);
    }

    @Override
    public long read(byte[] byArray, int n2, KeyDescription keyDescription, int n3) {
        return this.read(byArray, n2, this.findKey(keyDescription), n3);
    }

    private synchronized int start(byte[] byArray, int n2, KeyDesc64 keyDesc64, int n3, int n4) {
        int n5;
        try {
            switch (n4) {
                case 0: {
                    this.theFile.start(keyDesc64, n3, byArray, n2, 0);
                    break;
                }
                case 1: {
                    this.theFile.start(keyDesc64, n3, byArray, n2, 1);
                    break;
                }
                case 5: {
                    this.theFile.start(keyDesc64, n3, byArray, n2, 5);
                    break;
                }
                case 6: {
                    this.theFile.start(keyDesc64, n3, byArray, n2, 6);
                    break;
                }
                case 7: {
                    this.theFile.start(keyDesc64, n3, byArray, n2, 7);
                    break;
                }
                case 8: {
                    this.theFile.start(keyDesc64, n3, byArray, n2, 8);
                    break;
                }
                case 9: {
                    this.theFile.start(keyDesc64, n3, byArray, n2, 9);
                    break;
                }
                default: {
                    throw new IscobolRuntimeException(3, new IllegalArgumentException("START").toString());
                }
            }
            n5 = 1;
        }
        catch (IsamException isamException) {
            n5 = this.mapError(isamException);
        }
        return n5;
    }

    @Override
    public long start(byte[] byArray, int n2, int n3, int n4, int n5) {
        return this.start(byArray, n2, this.findKey(n3), n4, n5);
    }

    @Override
    public long start(byte[] byArray, int n2, KeyDescription keyDescription, int n3, int n4) {
        return this.start(byArray, n2, this.findKey(keyDescription), n3, n4);
    }

    @Override
    public synchronized int unlock() {
        int n2;
        try {
            this.theFile.release();
            n2 = 1;
        }
        catch (IsamException isamException) {
            n2 = this.mapError(isamException);
        }
        return n2;
    }

    @Override
    public synchronized int recover() {
        int n2;
        try {
            this.theFile.rebuild();
            n2 = 1;
        }
        catch (IsamException isamException) {
            n2 = this.mapError(isamException);
        }
        return n2;
    }

    @Override
    public void sync(int n2) {
    }

    @Override
    public int remove(String string) {
        int n2;
        try {
            Isam.erase(string);
            n2 = 1;
        }
        catch (IsamException isamException) {
            n2 = this.mapError(isamException);
        }
        return n2;
    }

    @Override
    public int rename(String string, String string2) {
        int n2;
        try {
            Isam.rename(string, string2);
            n2 = 1;
        }
        catch (IsamException isamException) {
            n2 = this.mapError(isamException);
        }
        return n2;
    }

    @Override
    public int begin() {
        return 1;
    }

    @Override
    public int commit(int n2) {
        return 1;
    }

    @Override
    public int rollback() {
        return 1;
    }

    @Override
    public String getVersion() {
        return Isam.version();
    }

    @Override
    public boolean isKeySelectedByNum() {
        return false;
    }

    public void finalize() {
        this.close();
    }

    static {
        if (Config.b(".file.index.lock_wait", false)) {
            readLockWait = true;
        }
        if (Config.b(".file.index.read_lock_test", false)) {
            readLockTest = true;
        }
        if (Config.b(".file.index.lock_read_anyhow", false)) {
            Isam.LOCK_READ_ANYHOW = true;
        }
        Isam.setFileNameExtension(Config.a(".file.index.data_suffix", null), Config.a(".file.index.index_suffix", null));
    }
}

