/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.io.AtEndException;
import com.iscobol.io.CobolFile;
import com.iscobol.io.CobolIOException;
import com.iscobol.io.ItemToSort;
import com.iscobol.io.JavaToIscobolError;
import com.iscobol.io.SortFile;
import com.iscobol.rts.Config;
import com.iscobol.rts.DynamicSort;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.rts.SortKey;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;

public class DynamicJavaSort
implements DynamicSort,
RuntimeErrorsNumbers {
    public static final int BUFFERSIZE = Config.a(".sort.memsize", 0x100000);
    public static final int NMERGE = Config.a(".sort.maxfiles", 16);
    private Vector array = new Vector();
    private Vector files = new Vector();
    private int maxRecSize;
    private int intSize;
    private int totElem;
    private int maxElem;
    private int readElem;
    private int cobErrno;
    private SortKey key;
    private String path;
    private CobolFile[] giving;
    private ICobolVar[] gNames;
    private ICobolVar record;
    private SortFile finalFile;
    private boolean mergeOnly;

    @Override
    public int initSort(String string, ICobolVar iCobolVar, SortKey sortKey, CobolFile[] cobolFileArray, ICobolVar[] iCobolVarArray, CobolFile[] cobolFileArray2, ICobolVar[] iCobolVarArray2) {
        this.path = string;
        this.record = iCobolVar;
        this.key = sortKey;
        this.giving = cobolFileArray2;
        this.gNames = iCobolVarArray2;
        this.cobErrno = 0;
        this.maxRecSize = this.record.getMaxLength();
        this.intSize = this.maxRecSize + 4;
        int n2 = 1;
        this.maxElem = BUFFERSIZE / this.intSize;
        if (cobolFileArray != null && cobolFileArray.length > 0) {
            for (int i2 = 0; i2 < cobolFileArray.length; ++i2) {
                try {
                    cobolFileArray[i2].open(iCobolVarArray[i2], 1, 1);
                    while (n2 == 1) {
                        n2 = this.releaseRecord(cobolFileArray[i2].readNext(false, this.record));
                    }
                }
                catch (AtEndException atEndException) {
                    // empty catch block
                }
                cobolFileArray[i2].close();
            }
            if (n2 == 1) {
                n2 = this.endInput();
            }
        }
        return n2;
    }

    @Override
    public int initMerge(String string, ICobolVar iCobolVar, SortKey sortKey, CobolFile[] cobolFileArray, ICobolVar[] iCobolVarArray, CobolFile[] cobolFileArray2, ICobolVar[] iCobolVarArray2) {
        this.mergeOnly = true;
        return this.initSort(string, iCobolVar, sortKey, cobolFileArray, iCobolVarArray, cobolFileArray2, iCobolVarArray2);
    }

    private static int getRecLen(byte[] byArray) {
        int n2 = byArray.length - 4;
        int n3 = (byArray[n2++] & 0xFF) << 24;
        n3 |= (byArray[n2++] & 0xFF) << 16;
        n3 |= (byArray[n2++] & 0xFF) << 8;
        return n3 |= byArray[n2] & 0xFF;
    }

    private static void putRecLen(byte[] byArray, int n2) {
        int n3 = byArray.length - 4;
        byArray[n3++] = (byte)(n2 >>> 24);
        byArray[n3++] = (byte)(n2 >>> 16);
        byArray[n3++] = (byte)(n2 >>> 8);
        byArray[n3] = (byte)n2;
    }

    @Override
    public int releaseRecord(int n2) {
        if (this.array.size() == this.maxElem) {
            if (!this.mergeOnly) {
                Collections.sort(this.array);
            }
            try {
                this.writeBuffer();
            }
            catch (IOException iOException) {
                this.cobErrno = JavaToIscobolError.map(iOException);
                return 0;
            }
        }
        byte[] byArray = new byte[this.intSize];
        System.arraycopy(this.record.getBytes(), 0, byArray, 0, n2);
        DynamicJavaSort.putRecLen(byArray, n2);
        this.array.addElement(new ItemToSort(this.key.keyArray, byArray));
        ++this.totElem;
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int endInput() {
        if (this.array.size() > 1) {
            Collections.sort(this.array);
        }
        if (this.files.size() > 0) {
            try {
                this.merge();
                this.finalFile = (SortFile)this.files.elementAt(0);
                this.finalFile.openRead();
            }
            catch (IOException iOException) {
                this.cobErrno = JavaToIscobolError.map(iOException);
                return 0;
            }
        }
        if (this.giving != null && this.giving.length > 0) {
            try {
                this.giving[0].open(this.gNames[0], 2, 1);
                while (true) {
                    int n2;
                    if ((n2 = this.returnRecord()) < 0) {
                        if (this.cobErrno == 110) {
                            break;
                        }
                        int n3 = 0;
                        return n3;
                    }
                    this.giving[0].updateBuffer(this.record.getBytes());
                    this.giving[0].write(false, n2);
                }
            }
            catch (CobolIOException cobolIOException) {
                this.cobErrno = cobolIOException.getErrNum();
                int n4 = 0;
                return n4;
            }
            finally {
                this.giving[0].close();
                this.finalize();
            }
        }
        return 1;
    }

    @Override
    public int returnRecord() {
        byte[] byArray = null;
        int n2 = -1;
        if (this.finalFile == null) {
            if (this.readElem == this.array.size()) {
                this.cobErrno = 110;
                return n2;
            }
            byArray = ((ItemToSort)this.array.elementAt((int)this.readElem++)).memory;
            n2 = DynamicJavaSort.getRecLen(byArray);
        } else {
            try {
                this.finalFile.read();
            }
            catch (IOException iOException) {
                this.cobErrno = JavaToIscobolError.map(iOException);
                return n2;
            }
            if (this.finalFile.isAtEnd()) {
                this.cobErrno = 110;
                return n2;
            }
            byArray = this.finalFile.buffer.memory;
            n2 = DynamicJavaSort.getRecLen(byArray);
        }
        this.record.set(byArray, 0, n2, true);
        return n2;
    }

    @Override
    public int endOutput() {
        this.finalize();
        return 1;
    }

    private void writeBuffer() throws IOException {
        if (this.files.size() == NMERGE) {
            this.merge();
        } else {
            SortFile sortFile = new SortFile(this.intSize, this.key.keyArray);
            sortFile.create();
            this.files.addElement(sortFile);
            Iterator iterator = this.array.iterator();
            while (iterator.hasNext()) {
                sortFile.write((ItemToSort)iterator.next());
            }
            sortFile.close();
            this.array.removeAllElements();
        }
    }

    private void merge() throws IOException {
        ItemToSort itemToSort;
        SortFile sortFile4;
        SortFile sortFile2 = null;
        int n2 = 0;
        if (this.array.size() == 0 && this.files.size() < 2 || this.files.size() < 1) {
            return;
        }
        SortFile sortFile3 = new SortFile(this.intSize, this.key.keyArray);
        sortFile3.create();
        for (SortFile sortFile4 : this.files) {
            sortFile4.openRead();
            sortFile4.read();
        }
        do {
            itemToSort = null;
            Iterator iterator = this.files.iterator();
            while (iterator.hasNext()) {
                sortFile4 = (SortFile)iterator.next();
                if (sortFile4.isAtEnd()) {
                    sortFile4.finalize();
                    iterator.remove();
                    continue;
                }
                if (itemToSort != null) {
                    if (itemToSort.compareTo(sortFile4.buffer) <= 0) continue;
                    itemToSort = sortFile4.buffer;
                    sortFile2 = sortFile4;
                    continue;
                }
                itemToSort = sortFile4.buffer;
                sortFile2 = sortFile4;
            }
            if (n2 < this.array.size()) {
                ItemToSort itemToSort2 = (ItemToSort)this.array.elementAt(n2);
                if (itemToSort == null || itemToSort.compareTo(itemToSort2) > 0) {
                    itemToSort = itemToSort2;
                    sortFile2 = null;
                }
            }
            if (itemToSort == null) continue;
            sortFile3.write(itemToSort);
            if (sortFile2 != null) {
                sortFile2.read();
                continue;
            }
            ++n2;
        } while (itemToSort != null);
        if (this.files.size() == 1) {
            sortFile4 = (SortFile)this.files.elementAt(0);
            sortFile4.finalize();
            this.files.remove(0);
        }
        this.files.addElement(sortFile3);
        sortFile3.close();
        this.array.removeAllElements();
    }

    public void finalize() {
        Iterator iterator = this.files.iterator();
        while (iterator.hasNext()) {
            ((SortFile)iterator.next()).finalize();
        }
        this.array.clear();
        this.readElem = 0;
    }

    @Override
    public int getCobErrno() {
        return this.cobErrno;
    }
}

