/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import IT.picosoft.isam.IsamException;
import IT.picosoft.isam.OSFile;
import com.iscobol.io.BaseFile;
import com.iscobol.io.DynamicSequential;
import com.iscobol.io.FileLock;
import com.iscobol.rts.KeyDescription;
import java.util.GregorianCalendar;

public class DynamicMFSequential
extends DynamicSequential {
    private static final byte[] padding = new byte[]{0, 0, 0};
    private static byte[] dummy = new byte[]{0, 0, 0};
    private final int HEADER_LEN = 128;
    private boolean varLen;
    private long lastLen;
    private int recHeaderLen;
    private FileLock lock;

    private int getRecHeaderLen() {
        return this.maxRecordSize >= 4095 ? 4 : 2;
    }

    private void writeHeader(OSFile oSFile) throws IsamException {
        byte[] byArray = new byte[128];
        byArray[0] = 48;
        if (this.getRecHeaderLen() == 4) {
            byArray[3] = 124;
        } else {
            byArray[1] = 126;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n2 = gregorianCalendar.get(1);
        int n3 = gregorianCalendar.get(2) + 1;
        int n4 = gregorianCalendar.get(5);
        int n5 = gregorianCalendar.get(11);
        int n6 = gregorianCalendar.get(12);
        int n7 = gregorianCalendar.get(13);
        int n8 = gregorianCalendar.get(14) / 10;
        byArray[22] = byArray[8] = (byte)(48 + n2 % 100 / 10);
        byArray[23] = byArray[9] = (byte)(48 + n2 % 10);
        byArray[24] = byArray[10] = (byte)(48 + n3 / 10);
        byArray[25] = byArray[11] = (byte)(48 + n3 % 10);
        byArray[26] = byArray[12] = (byte)(48 + n4 / 10);
        byArray[27] = byArray[13] = (byte)(48 + n4 % 10);
        byArray[28] = byArray[14] = (byte)(48 + n5 / 10);
        byArray[29] = byArray[15] = (byte)(48 + n5 % 10);
        byArray[30] = byArray[16] = (byte)(48 + n6 / 10);
        byArray[31] = byArray[17] = (byte)(48 + n6 % 10);
        byArray[32] = byArray[18] = (byte)(48 + n7 / 10);
        byArray[33] = byArray[19] = (byte)(48 + n7 % 10);
        byArray[34] = byArray[20] = (byte)(48 + n8 / 10);
        byArray[35] = byArray[21] = (byte)(48 + n8 % 10);
        byArray[37] = 62;
        byArray[39] = 1;
        byArray[48] = 1;
        byArray[54] = (byte)((this.maxRecordSize & 0xFF000000) >>> 24);
        byArray[55] = (byte)((this.maxRecordSize & 0xFF0000) >>> 16);
        byArray[56] = (byte)((this.maxRecordSize & 0xFF00) >>> 8);
        byArray[57] = (byte)(this.maxRecordSize & 0xFF);
        byArray[58] = (byte)((this.minRecordSize & 0xFF000000) >>> 24);
        byArray[59] = (byte)((this.minRecordSize & 0xFF0000) >>> 16);
        byArray[60] = (byte)((this.minRecordSize & 0xFF00) >>> 8);
        byArray[61] = (byte)(this.minRecordSize & 0xFF);
        byArray[78] = 1;
        byArray[108] = 88;
        byArray[109] = 106;
        byArray[110] = 57;
        byArray[111] = 119;
        oSFile.write(byArray, 0, byArray.length);
        this.currPos = byArray.length;
        this.fileLen = byArray.length;
        this.lastLen = 0L;
    }

    private int readHeader() {
        byte[] byArray = new byte[128];
        try {
            int n2 = this.theFile.read(byArray, 0, byArray.length);
            if (n2 != byArray.length) {
                return this.mapError(new IsamException(102));
            }
            int n3 = (byArray[54] & 0xFF) << 24 | (byArray[55] & 0xFF) << 16 | (byArray[56] & 0xFF) << 8 | byArray[57] & 0xFF;
            if (n3 > this.maxRecordSize) {
                return this.mapError(new IsamException(102));
            }
        }
        catch (IsamException isamException) {
            return this.mapError(isamException);
        }
        return 1;
    }

    private int getRecHeader() throws IsamException {
        int n2;
        if (this.recHeaderLen == 4) {
            n2 = this.theFile.readInt();
            n2 &= 0xFFFFFFF;
        } else {
            n2 = this.theFile.readChar();
            n2 &= 0xFFF;
        }
        return n2;
    }

    private void putRecHeader(int n2) throws IsamException {
        if (this.recHeaderLen == 4) {
            this.theFile.writeInt(n2 | 0x40000000);
        } else {
            this.theFile.writeChar(n2 | 0x4000);
        }
    }

    @Override
    protected OSFile getOSFile(boolean bl) {
        return new OSFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public int build(String var1_1, String var2_2, int var3_3, int var4_4, int var5_5, int var6_6, int var7_7, int var8_8, int var9_9, KeyDescription[] var10_10, byte[] var11_11, boolean var12_12) {
        if (var12_12) {
            var1_1 = BaseFile.expandFileName(var1_1);
        }
        this.maxRecordSize = var8_8;
        this.minRecordSize = var9_9;
        this.varLen = var9_9 != 0 && var8_8 != var9_9;
        var14_13 = new OSFile();
        this.lock = null;
        var15_14 = false;
        try {
            var14_13.open(var1_1, 1);
            var15_14 = true;
            this.lock = new FileLock(var1_1, var14_13, true, false);
        }
        catch (IsamException var16_16) {
            switch (var16_16.getIserrno()) {
                case 130: {
                    ** break;
lbl18:
                    // 1 sources

                    break;
                }
                default: {
                    var17_20 = this.mapError(var16_16);
                    return var17_20;
                }
            }
        }
        finally {
            try {
                if (this.lock != null) {
                    this.lock.finalize();
                    this.lock = null;
                }
                if (var15_14) {
                    var14_13.close();
                }
            }
            catch (IsamException var16_17) {}
        }
        try {
            var14_13.open(var1_1, 577);
            if (this.varLen) {
                this.writeHeader(var14_13);
            }
            var14_13.close();
            var13_24 = 1;
        }
        catch (IsamException var16_18) {
            var13_24 = this.mapError(var16_18);
        }
        return var13_24;
    }

    @Override
    public int open(String string, int n2, int n3, KeyDescription[] keyDescriptionArray, int n4, int n5, int n6, int n7, boolean bl, boolean bl2) {
        this.varLen = n5 != 0 && n4 != n5;
        int n8 = n2 == 6 ? 3 : n2;
        int n9 = super.open(string, n8, n3, keyDescriptionArray, n4, n5, n6, n7, bl, bl2);
        if (n9 == 1) {
            if (this.varLen) {
                n9 = this.readHeader();
                this.recHeaderLen = this.getRecHeaderLen();
            }
            if (n2 == 6) {
                try {
                    this.currPos = this.fileLen;
                    this.theFile.seek(this.currPos);
                    this.openMode = 6;
                }
                catch (IsamException isamException) {
                    n9 = this.mapError(isamException);
                }
            }
        }
        return n9;
    }

    @Override
    public long write(byte[] byArray, int n2, int n3, boolean bl) {
        block7: {
            try {
                this.errno = 0;
                long l2 = this.theFile.length();
                if (this.openMode == 6 || this.currPos == l2) {
                    this.theFile.seek(this.theFile.length());
                }
                if (!this.varLen) {
                    return super.write(byArray, n2, n3, bl);
                }
                if (n3 > this.maxRecordSize) {
                    n3 = this.maxRecordSize;
                }
                if (this.currPos >= this.fileLen) {
                    this.putRecHeader(n3);
                    this.theFile.write(byArray, n2, n3);
                    this.lastLen = n3;
                    int n4 = (n3 += this.recHeaderLen) % 4;
                    if (n4 > 0) {
                        this.theFile.write(padding, 0, 4 - n4);
                        n3 += n4;
                    }
                    this.currPos += (long)n3;
                    this.fileLen += (long)n3;
                    break block7;
                }
                return this.mapError(new IsamException(100));
            }
            catch (IsamException isamException) {
                return this.mapError(isamException);
            }
        }
        return 1L;
    }

    @Override
    public long rewrite(byte[] byArray, int n2, int n3, boolean bl) {
        this.errno = 0;
        if (!this.varLen) {
            return super.rewrite(byArray, n2, n3, bl);
        }
        if (this.lastLen != (long)n3) {
            this.errno = -2;
            return 0L;
        }
        if (this.currPos == 0L || this.currPos - (long)n3 - (long)this.recHeaderLen < 0L) {
            this.errno = -2;
            return 0L;
        }
        try {
            this.theFile.seek(this.currPos - (long)n3);
            this.theFile.write(byArray, n2, n3);
        }
        catch (IsamException isamException) {
            return this.mapError(isamException);
        }
        return 1L;
    }

    @Override
    public long delete(byte[] byArray, int n2) {
        if (this.varLen) {
            this.errno = -3;
            return 0L;
        }
        return super.delete(byArray, n2);
    }

    @Override
    public synchronized long next(byte[] byArray, int n2, int n3) {
        int n4;
        this.errno = 0;
        if (!this.varLen) {
            return super.next(byArray, n2, n3);
        }
        try {
            if (this.currPos < 0L) {
                return this.mapError(new IsamException(112));
            }
            int n5 = this.getRecHeader();
            if (n5 < this.minRecordSize || n5 > this.maxRecordSize) {
                return this.mapError(new IsamException(105));
            }
            n4 = this.theFile.read(byArray, n2, n5);
            this.lastLen = n4;
            int n6 = (n5 += this.recHeaderLen) % 4;
            if (n6 > 0) {
                this.theFile.read(dummy, 0, 4 - n6);
                n5 += n6;
            }
            if (n4 <= 0) {
                this.currPos = -1L;
                return this.mapError(new IsamException(110));
            }
            if (n3 > 0) {
                this.lock(this.currPos, n5);
            }
            this.currPos += (long)n5;
        }
        catch (IsamException isamException) {
            return this.mapError(isamException);
        }
        return n4;
    }

    @Override
    public synchronized long previous(byte[] byArray, int n2, int n3) {
        this.errno = 0;
        if (this.varLen) {
            this.errno = -3;
            return 0L;
        }
        return super.previous(byArray, n2, n3);
    }
}

