/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import IT.picosoft.isam.FLock;
import IT.picosoft.isam.IsamException;
import IT.picosoft.isam.OSFile;
import com.iscobol.io.BaseFile;
import com.iscobol.io.FileLock;
import com.iscobol.rts.Config;
import com.iscobol.rts.DynamicFile;
import com.iscobol.rts.IOUtil;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.KeyDescription;
import com.iscobol.rts.RuntimeErrorsNumbers;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;

public class DynamicRelative
implements DynamicFile,
RuntimeErrorsNumbers,
Cloneable {
    public static final int ERR_BOUNDARY_VIOLATION = -1;
    public static final int ERR_INVSEQDELREW = -2;
    public static final int ERR_NOTPERMITTED = -3;
    protected OSFile theFile;
    protected byte[] locBuffer;
    private byte[] delBuffer;
    private long currRecord;
    protected boolean positioned;
    protected boolean atBegin;
    protected boolean atEnd;
    private int accessMode;
    private FileLock lock;
    protected boolean exclusiveLock;
    protected boolean multipleLock;
    protected boolean readLock;
    private FLock lastLock;
    protected Hashtable allLocks;
    protected int realRecordSize;
    protected int maxRecordSize;
    protected int minRecordSize;
    private String path = "";
    protected int errno;
    protected Exception errio;
    protected int openMode = 0;
    private static boolean outLock = Config.b(".file.output_lock", true);
    private static boolean extLock = Config.b(".file.extend_lock", true);

    @Override
    public String getSysErrno() {
        if (this.errio != null) {
            return this.errio.getMessage();
        }
        return "";
    }

    @Override
    public String getErrMsg() {
        if (this.errio != null) {
            return this.errio.getMessage();
        }
        return "";
    }

    @Override
    public int getCobErrno() {
        switch (this.errno) {
            case 0: {
                return 0;
            }
            case 100: {
                return 100;
            }
            case 101: {
                return 101;
            }
            case 133: {
                return 133;
            }
            case 102: {
                return 102;
            }
            case 104: {
                return 104;
            }
            case 125: {
                return 125;
            }
            case 107: {
                return 107;
            }
            case 105: {
                return 105;
            }
            case 108: {
                return 108;
            }
            case 111: {
                return 111;
            }
            case 110: {
                return 110;
            }
            case 112: {
                return 112;
            }
            case 127: {
                return 127;
            }
            case 113: {
                return 113;
            }
            case 128: {
                return 128;
            }
            case 116: {
                return 116;
            }
            case 130: {
                return 130;
            }
            case 131: {
                return 131;
            }
            case 126: {
                return 126;
            }
            case 129: {
                return 129;
            }
            case 122: {
                return 122;
            }
            case -1: {
                return 145;
            }
            case -2: {
                return 143;
            }
            case -3: {
                return 126;
            }
        }
        return 134;
    }

    private void recordUnlock(FLock fLock) throws IsamException {
        fLock.l_type = (short)2;
        this.theFile.fcntl(6, this.lastLock);
        this.allLocks.remove(fLock);
    }

    private synchronized void allRecordUnlock() throws IsamException {
        Enumeration enumeration = this.allLocks.elements();
        while (enumeration.hasMoreElements()) {
            FLock fLock = (FLock)enumeration.nextElement();
            fLock.l_type = (short)2;
            this.theFile.fcntl(6, fLock);
        }
        this.allLocks.clear();
    }

    protected synchronized void recordUnlockPos(long l2) throws IsamException {
        Long l3 = new Long(l2);
        FLock fLock = (FLock)this.allLocks.get(l3);
        if (fLock != null) {
            fLock.l_type = (short)2;
            this.theFile.fcntl(6, fLock);
            this.allLocks.remove(l3);
        }
    }

    private synchronized void recordLockNum(boolean bl, long l2, int n2) throws IsamException {
        if (bl && !this.exclusiveLock) {
            try {
                FLock fLock = new FLock();
                fLock.l_whence = 0;
                fLock.l_start = (l2 - 1L) * (long)this.realRecordSize;
                fLock.l_len = n2;
                fLock.l_type = this.readLock || this.openMode == 1 ? (short)0 : 1;
                Long l3 = new Long(fLock.l_start);
                FLock fLock2 = (FLock)this.allLocks.get(l3);
                if (fLock2 != null) {
                    if (fLock2.l_type == 0 && fLock.l_type == 1 || fLock2.l_len < fLock.l_len) {
                        this.allLocks.remove(fLock2);
                        this.theFile.fcntl(6, fLock);
                        this.allLocks.put(l3, fLock);
                    }
                } else {
                    if (!this.multipleLock) {
                        this.allRecordUnlock();
                    }
                    this.theFile.fcntl(6, fLock);
                    this.allLocks.put(l3, fLock);
                }
            }
            catch (IsamException isamException) {
                if (isamException.getIserrno() == 113) {
                    throw new IsamException(107);
                }
                throw isamException;
            }
        }
    }

    private void setLockType(int n2) {
        this.exclusiveLock = false;
        this.multipleLock = false;
        this.readLock = false;
        this.lastLock = null;
        this.allLocks = new Hashtable();
        switch (n2 & 0xF) {
            default: {
                break;
            }
            case 1: 
            case 6: {
                this.exclusiveLock = true;
                break;
            }
            case 4: {
                this.readLock = false;
                break;
            }
            case 3: 
            case 5: {
                this.readLock = true;
            }
        }
        if ((n2 & 0x100) != 0) {
            this.multipleLock = true;
        }
    }

    @Override
    public long getNumRecords() {
        long l2 = 0L;
        if (this.theFile != null) {
            try {
                l2 = this.theFile.length() / (long)this.realRecordSize;
            }
            catch (IsamException isamException) {
                // empty catch block
            }
        }
        return l2;
    }

    @Override
    public int getNumKeys() {
        return 0;
    }

    @Override
    public int getMaxRecordSize() {
        return this.maxRecordSize;
    }

    @Override
    public int getMinRecordSize() {
        return this.minRecordSize;
    }

    @Override
    public KeyDescription getKey(int n2) {
        KeyDescription keyDescription;
        if (n2 == 0) {
            keyDescription = new KeyDescription(0, false);
        } else {
            this.mapError(new IsamException(102));
            keyDescription = null;
        }
        return keyDescription;
    }

    @Override
    public byte[] getSequence() {
        return null;
    }

    protected int mapError(IsamException isamException) {
        this.errno = isamException.getIserrno();
        this.errio = isamException.getIserrio();
        return 0;
    }

    protected boolean isDeleted(byte[] byArray) {
        return IOUtil.equals(byArray, 0, this.delBuffer, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public int build(String var1_1, String var2_2, int var3_3, int var4_4, int var5_5, int var6_6, int var7_7, int var8_8, int var9_9, KeyDescription[] var10_10, byte[] var11_11, boolean var12_12) {
        if (var12_12) {
            var1_1 = BaseFile.expandFileName(var1_1);
        }
        var14_13 = new OSFile();
        this.lock = null;
        var15_14 = false;
        try {
            var14_13.open(var1_1, 1);
            var15_14 = true;
            this.lock = new FileLock(var1_1, var14_13, true, false);
        }
        catch (IsamException var16_16) {
            switch (var16_16.getIserrno()) {
                case 130: {
                    ** break;
lbl15:
                    // 1 sources

                    break;
                }
                default: {
                    var17_20 = this.mapError(var16_16);
                    return var17_20;
                }
            }
        }
        finally {
            try {
                if (this.lock != null) {
                    this.lock.finalize();
                    this.lock = null;
                }
                if (var15_14) {
                    var14_13.close();
                }
            }
            catch (IsamException var16_17) {}
        }
        try {
            var14_13.open(var1_1, 577);
            var14_13.close();
            var13_24 = 1;
        }
        catch (IsamException var16_18) {
            var13_24 = this.mapError(var16_18);
        }
        return var13_24;
    }

    protected OSFile getOSFile(boolean bl) {
        return new OSFile();
    }

    @Override
    public int open(String string, int n2, int n3, KeyDescription[] keyDescriptionArray, int n4, int n5, int n6, int n7, boolean bl, boolean bl2) {
        int n8;
        if (bl2) {
            string = BaseFile.expandFileName(string);
        }
        this.accessMode = n7;
        this.maxRecordSize = this.realRecordSize = n4;
        this.minRecordSize = n5;
        this.locBuffer = new byte[this.maxRecordSize];
        this.delBuffer = new byte[this.maxRecordSize];
        this.setLockType(n3);
        this.theFile = this.getOSFile(this.exclusiveLock);
        try {
            int n9 = 0;
            if (n2 == 2 && outLock) {
                n9 = 128;
            } else if (n2 == 6 && extLock) {
                n9 = 128;
            } else if (this.exclusiveLock) {
                n9 = 128;
            }
            switch (n2) {
                case 2: {
                    this.theFile.open(string, n9 | 1);
                    if (this.readLock) break;
                    this.exclusiveLock = true;
                    break;
                }
                case 3: 
                case 6: {
                    this.theFile.open(string, n9 | 2);
                    break;
                }
                case 1: {
                    this.theFile.open(string, n9 | 0);
                    if (!this.exclusiveLock) break;
                    this.readLock = true;
                    break;
                }
                default: {
                    throw new IscobolRuntimeException(3, new IllegalArgumentException("OPEN").toString());
                }
            }
            this.openMode = n2;
            try {
                this.lock = new FileLock(string, this.theFile, this.exclusiveLock, this.readLock);
            }
            catch (IsamException isamException) {
                this.theFile.close();
                throw isamException;
            }
            this.currRecord = 1L;
            this.positioned = true;
            this.atBegin = true;
            this.atEnd = false;
            n8 = 1;
            this.path = string;
        }
        catch (IsamException isamException) {
            this.theFile = null;
            n8 = this.mapError(isamException);
        }
        return n8;
    }

    @Override
    public void setCurrentRecord(long l2) {
        this.currRecord = l2;
        this.positioned = true;
        this.atEnd = false;
        this.atBegin = false;
    }

    @Override
    public String getDescription() {
        return this.path;
    }

    @Override
    public int close() {
        int n2;
        if (this.theFile != null) {
            try {
                this.lock.finalize();
                this.theFile.close();
                n2 = 1;
                this.theFile = null;
                this.openMode = 0;
                this.path = "";
            }
            catch (IsamException isamException) {
                n2 = this.mapError(isamException);
            }
        } else {
            n2 = 1;
        }
        return n2;
    }

    @Override
    public boolean isOpen() {
        return this.openMode != 0;
    }

    protected long nextRecNum() {
        if (this.atBegin) {
            return 1L;
        }
        if (this.currRecord <= 0L) {
            return 0L;
        }
        if (this.positioned) {
            return this.currRecord;
        }
        return this.currRecord + 1L;
    }

    private long prevRecNum() {
        if (this.atEnd) {
            return this.getNumRecords();
        }
        if (this.currRecord <= 0L) {
            return 0L;
        }
        if (this.positioned) {
            return this.currRecord;
        }
        return this.currRecord - 1L;
    }

    @Override
    public long getCurrentRecord() {
        if (this.atBegin || this.atEnd) {
            return 0L;
        }
        return this.currRecord;
    }

    @Override
    public long write(byte[] byArray, int n2, int n3, boolean bl) {
        this.errno = 0;
        if (n3 > this.maxRecordSize) {
            n3 = this.maxRecordSize;
        }
        try {
            long l2;
            if (this.openMode == 6) {
                this.theFile.seek(this.theFile.length());
                this.theFile.write(byArray, n2, n3);
                l2 = this.theFile.length() / (long)this.realRecordSize + 1L;
            } else {
                l2 = this.nextRecNum();
                if (l2 < 1L) {
                    this.errno = -2;
                    return 0L;
                }
                long l3 = (l2 - 1L) * (long)this.realRecordSize;
                this.theFile.seek(l3);
                int n4 = this.theFile.read(this.locBuffer);
                if (n4 < 0 || Arrays.equals(this.delBuffer, this.locBuffer)) {
                    this.theFile.seek(l3);
                    this.theFile.write(byArray, n2, n3);
                    if (!this.exclusiveLock) {
                        this.recordUnlockPos(l3);
                    }
                } else {
                    return this.mapError(new IsamException(100));
                }
            }
            this.currRecord = l2;
            this.positioned = false;
            this.atEnd = false;
            this.atBegin = false;
        }
        catch (IsamException isamException) {
            return this.mapError(isamException);
        }
        return 1L;
    }

    @Override
    public long rewrite(byte[] byArray, int n2, int n3, boolean bl) {
        this.errno = 0;
        if (n3 > this.maxRecordSize) {
            n3 = this.maxRecordSize;
        }
        try {
            long l2 = this.getCurrentRecord();
            if (l2 < 1L) {
                this.errno = -2;
                return 0L;
            }
            long l3 = (l2 - 1L) * (long)this.realRecordSize;
            this.theFile.seek(l3);
            int n4 = this.theFile.read(this.locBuffer);
            if (n4 >= 0 && !Arrays.equals(this.delBuffer, this.locBuffer)) {
                this.theFile.seek(l3);
                this.theFile.write(byArray, n2, n3);
                if (!this.exclusiveLock) {
                    this.recordUnlockPos(l3);
                }
            } else {
                return this.mapError(new IsamException(111));
            }
            this.currRecord = l2;
            this.positioned = false;
            this.atEnd = false;
            this.atBegin = false;
        }
        catch (IsamException isamException) {
            return this.mapError(isamException);
        }
        return 1L;
    }

    @Override
    public long delete(byte[] byArray, int n2) {
        try {
            long l2 = this.getCurrentRecord();
            if (l2 < 1L) {
                this.errno = -2;
                return 0L;
            }
            long l3 = (l2 - 1L) * (long)this.realRecordSize;
            this.theFile.seek(l3);
            int n3 = this.theFile.read(this.locBuffer);
            if (n3 < 0 || Arrays.equals(this.delBuffer, this.locBuffer)) {
                return this.mapError(new IsamException(111));
            }
            this.theFile.seek(l3);
            this.theFile.write(this.delBuffer);
            this.currRecord = l2;
            this.positioned = false;
            this.atEnd = false;
            this.atBegin = false;
        }
        catch (IsamException isamException) {
            return this.mapError(isamException);
        }
        return 1L;
    }

    private int myNext(byte[] byArray, int n2, int n3, long l2) throws IsamException {
        int n4;
        this.currRecord = l2 < 1L ? 1L : l2;
        long l3 = (this.currRecord - 1L) * (long)this.realRecordSize;
        this.theFile.seek(l3);
        do {
            if ((n4 = this.theFile.read(this.locBuffer)) <= 0) continue;
            if (this.isDeleted(this.locBuffer)) {
                l3 = this.currRecord * (long)this.realRecordSize;
                ++this.currRecord;
                continue;
            }
            System.arraycopy(this.locBuffer, 0, byArray, n2, n3);
            break;
        } while (n4 > 0);
        return n4;
    }

    private int myPrev(byte[] byArray, int n2, int n3, long l2) throws IsamException {
        int n4 = 0;
        this.currRecord = l2;
        while (this.currRecord > 0L) {
            long l3 = (this.currRecord - 1L) * (long)this.realRecordSize;
            this.theFile.seek(l3);
            n4 = this.theFile.read(this.locBuffer);
            if (this.isDeleted(this.locBuffer)) {
                --this.currRecord;
                continue;
            }
            System.arraycopy(this.locBuffer, 0, byArray, n2, n3);
            break;
        }
        if (this.currRecord == 0L) {
            this.currRecord = 1L;
        }
        return n4;
    }

    @Override
    public long next(byte[] byArray, int n2, int n3) {
        int n4;
        int n5 = byArray.length - n2;
        this.errno = 0;
        if (n5 > this.maxRecordSize) {
            n5 = this.maxRecordSize;
        }
        if (this.theFile == null) {
            return this.mapError(new IsamException(110));
        }
        if (this.currRecord <= 0L || this.atEnd) {
            return this.mapError(new IsamException(112));
        }
        try {
            n4 = this.myNext(byArray, n2, n5, this.nextRecNum());
            if (n4 <= 0) {
                this.positioned = false;
                this.atBegin = false;
                this.atEnd = true;
                return this.mapError(new IsamException(110));
            }
            this.recordLockNum(n3 > 0, this.currRecord, n5);
            this.positioned = false;
            this.atEnd = false;
            this.atBegin = false;
        }
        catch (IsamException isamException) {
            this.currRecord = 0L;
            this.positioned = false;
            this.atEnd = false;
            this.atBegin = false;
            return this.mapError(isamException);
        }
        return n4;
    }

    @Override
    public long previous(byte[] byArray, int n2, int n3) {
        int n4;
        int n5 = byArray.length - n2;
        this.errno = 0;
        if (n5 > this.maxRecordSize) {
            n5 = this.maxRecordSize;
        }
        if (this.theFile == null) {
            return this.mapError(new IsamException(110));
        }
        if (this.currRecord <= 0L || this.atBegin) {
            return this.mapError(new IsamException(112));
        }
        try {
            n4 = this.myPrev(byArray, n2, n5, this.prevRecNum());
            if (n4 <= 0) {
                this.positioned = false;
                this.atEnd = false;
                this.atBegin = true;
                return this.mapError(new IsamException(110));
            }
            this.recordLockNum(n3 > 0, this.currRecord, n5);
            this.positioned = false;
            this.atEnd = false;
            this.atBegin = false;
        }
        catch (IsamException isamException) {
            this.currRecord = 0L;
            this.positioned = false;
            this.atEnd = false;
            this.atBegin = false;
            return this.mapError(isamException);
        }
        return n4;
    }

    private long read(byte[] byArray, int n2, int n3) {
        int n4;
        int n5 = byArray.length - n2;
        this.errno = 0;
        if (n5 > this.maxRecordSize) {
            n5 = this.maxRecordSize;
        }
        if (this.theFile == null) {
            return this.mapError(new IsamException(111));
        }
        try {
            long l2 = this.nextRecNum();
            this.currRecord = 0L;
            this.positioned = false;
            this.atEnd = false;
            this.atBegin = false;
            if (l2 < 1L) {
                return this.mapError(new IsamException(111));
            }
            long l3 = (l2 - 1L) * (long)this.realRecordSize;
            this.theFile.seek(l3);
            n4 = this.theFile.read(this.locBuffer);
            this.recordLockNum(n3 > 0, l2, n5);
            if (n4 < 0 || this.isDeleted(this.locBuffer)) {
                return this.mapError(new IsamException(111));
            }
            System.arraycopy(this.locBuffer, 0, byArray, 0, this.maxRecordSize);
            this.currRecord = l2;
        }
        catch (IsamException isamException) {
            return this.mapError(isamException);
        }
        return n4;
    }

    @Override
    public long read(byte[] byArray, int n2, int n3, int n4) {
        return this.read(byArray, n2, n4);
    }

    @Override
    public long read(byte[] byArray, int n2, KeyDescription keyDescription, int n3) {
        return this.read(byArray, n2, n3);
    }

    private long start(byte[] byArray, int n2, int n3, int n4) {
        int n5;
        int n6 = n5 = byArray != null ? byArray.length - n2 : this.maxRecordSize;
        if (n5 > this.maxRecordSize) {
            n5 = this.maxRecordSize;
        }
        if (this.theFile == null) {
            return this.mapError(new IsamException(111));
        }
        try {
            long l2 = this.nextRecNum();
            this.currRecord = 0L;
            this.positioned = false;
            this.atEnd = false;
            this.atBegin = false;
            long l3 = this.theFile.length() / (long)n5;
            if (n4 == 0) {
                l2 = 1L;
            } else if (n4 == 1) {
                l2 = l3;
            }
            if (l2 < 1L) {
                if (n4 == 6) {
                    l2 = 0L;
                } else if (n4 == 7) {
                    l2 = 1L;
                } else {
                    return this.mapError(new IsamException(111));
                }
            }
            switch (n4) {
                case 5: {
                    if (l2 < 1L || l2 > l3) {
                        return this.mapError(new IsamException(111));
                    }
                    long l4 = (l2 - 1L) * (long)this.realRecordSize;
                    this.theFile.seek(l4);
                    int n7 = this.theFile.read(this.locBuffer);
                    if (n7 >= 0 && !this.isDeleted(this.locBuffer)) break;
                    return this.mapError(new IsamException(111));
                }
                case 6: {
                    ++l2;
                }
                case 7: {
                    int n8;
                    if (l2 > l3) {
                        return this.mapError(new IsamException(111));
                    }
                    if (l2 < 1L) {
                        l2 = 1L;
                    }
                    if ((n8 = this.myNext(this.locBuffer, 0, n5, l2)) > 0) break;
                    return this.mapError(new IsamException(111));
                }
                case 8: {
                    --l2;
                }
                case 9: {
                    int n9;
                    if (l2 < 1L) {
                        return this.mapError(new IsamException(111));
                    }
                    if (l2 > l3) {
                        l2 = l3;
                    }
                    if ((n9 = this.myPrev(this.locBuffer, 0, n5, l2)) > 0) break;
                    return this.mapError(new IsamException(111));
                }
            }
            this.currRecord = l2;
            if (this.currRecord < 1L) {
                return this.mapError(new IsamException(111));
            }
            this.positioned = true;
        }
        catch (IsamException isamException) {
            return this.mapError(isamException);
        }
        return 1L;
    }

    @Override
    public long start(byte[] byArray, int n2, int n3, int n4, int n5) {
        return this.start(byArray, n2, n4, n5);
    }

    @Override
    public long start(byte[] byArray, int n2, KeyDescription keyDescription, int n3, int n4) {
        return this.start(byArray, n2, n3, n4);
    }

    @Override
    public int unlock() {
        try {
            this.allRecordUnlock();
        }
        catch (IsamException isamException) {
            return this.mapError(isamException);
        }
        return 1;
    }

    @Override
    public void sync(int n2) {
    }

    @Override
    public int remove(String string) {
        try {
            OSFile.unlink(string);
        }
        catch (IsamException isamException) {
            return this.mapError(isamException);
        }
        return 1;
    }

    @Override
    public int rename(String string, String string2) {
        try {
            OSFile.rename(string, string2);
        }
        catch (IsamException isamException) {
            return this.mapError(isamException);
        }
        return 1;
    }

    @Override
    public int begin() {
        return 1;
    }

    @Override
    public int commit(int n2) {
        return 1;
    }

    @Override
    public int rollback() {
        return 1;
    }

    @Override
    public int recover() {
        return 1;
    }

    @Override
    public String getVersion() {
        return "$Id: DynamicRelative.java 38325 2024-07-02 10:12:20Z daniela_835 $";
    }

    @Override
    public boolean isKeySelectedByNum() {
        return false;
    }

    public void finalize() {
        this.close();
    }
}

