/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import IT.picosoft.isam.FLock;
import IT.picosoft.isam.IsamException;
import IT.picosoft.isam.OSFile;
import com.iscobol.io.BufferedOSFile;
import com.iscobol.io.DynamicRelative;
import com.iscobol.rts.KeyDescription;
import java.util.Enumeration;

public class DynamicSequential
extends DynamicRelative {
    protected long currPos;
    protected long fileLen;
    protected FLock lckExt = new FLock();

    @Override
    public int getCobErrno() {
        switch (this.errno) {
            case 100: {
                return 137;
            }
        }
        return super.getCobErrno();
    }

    @Override
    protected OSFile getOSFile(boolean bl) {
        if (bl) {
            return new BufferedOSFile();
        }
        return new OSFile();
    }

    private synchronized void unlockAll() throws IsamException {
        Enumeration enumeration = this.allLocks.elements();
        while (enumeration.hasMoreElements()) {
            FLock fLock = (FLock)enumeration.nextElement();
            fLock.l_type = (short)2;
            this.theFile.fcntl(6, fLock);
        }
        this.allLocks.clear();
    }

    protected synchronized void lock(long l2, int n2) throws IsamException {
        if (this.exclusiveLock) {
            return;
        }
        FLock fLock = new FLock();
        try {
            fLock.l_whence = 0;
            fLock.l_start = l2;
            fLock.l_len = n2;
            fLock.l_type = this.readLock || this.openMode == 1 ? (short)0 : 1;
            if (!this.multipleLock) {
                this.unlockAll();
            }
            this.theFile.fcntl(6, fLock);
            this.allLocks.put(new Long(l2), fLock);
        }
        catch (IsamException isamException) {
            if (isamException.getIserrno() == 113) {
                throw new IsamException(107);
            }
            throw isamException;
        }
    }

    @Override
    public int open(String string, int n2, int n3, KeyDescription[] keyDescriptionArray, int n4, int n5, int n6, int n7, boolean bl, boolean bl2) {
        int n8 = super.open(string, n2, n3, keyDescriptionArray, n4, n5, n6, n7, bl, bl2);
        if (n8 == 1) {
            try {
                this.fileLen = this.theFile.length();
                if (this.openMode == 6) {
                    this.lckExt.l_whence = 0;
                    this.lckExt.l_start = 0L;
                    this.lckExt.l_len = 1;
                    this.currPos = this.fileLen;
                    this.theFile.seek(this.currPos);
                }
            }
            catch (IsamException isamException) {
                return this.mapError(isamException);
            }
        }
        return n8;
    }

    @Override
    public long write(byte[] byArray, int n2, int n3, boolean bl) {
        block9: {
            this.errno = 0;
            if (n3 > this.maxRecordSize) {
                n3 = this.maxRecordSize;
            }
            try {
                if (this.currPos >= this.fileLen) {
                    if (this.openMode == 6) {
                        if (!this.exclusiveLock) {
                            this.lckExt.l_type = 1;
                            this.theFile.fcntl(6, this.lckExt);
                        }
                        this.theFile.seek(this.theFile.length());
                    }
                    this.theFile.write(byArray, n2, n3);
                    if (this.openMode != 6 && n3 < this.maxRecordSize) {
                        n3 = this.maxRecordSize;
                        this.theFile.seek(this.currPos + (long)n3);
                    } else if (this.openMode == 6 && !this.exclusiveLock) {
                        this.lckExt.l_type = (short)2;
                        this.theFile.fcntl(6, this.lckExt);
                    }
                    this.currPos += (long)n3;
                    this.fileLen += (long)n3;
                    break block9;
                }
                return this.mapError(new IsamException(100));
            }
            catch (IsamException isamException) {
                return this.mapError(isamException);
            }
        }
        return 1L;
    }

    @Override
    public long rewrite(byte[] byArray, int n2, int n3, boolean bl) {
        this.errno = 0;
        if (n3 > this.maxRecordSize) {
            n3 = this.maxRecordSize;
        }
        if (this.currPos == 0L || this.currPos - (long)this.maxRecordSize < 0L) {
            this.errno = -2;
            return 0L;
        }
        try {
            this.theFile.seek(this.currPos - (long)this.maxRecordSize);
            this.theFile.write(byArray, n2, n3);
            if (n3 < this.maxRecordSize) {
                this.theFile.seek(this.currPos);
            }
        }
        catch (IsamException isamException) {
            return this.mapError(isamException);
        }
        return 1L;
    }

    @Override
    public synchronized long next(byte[] byArray, int n2, int n3) {
        int n4;
        int n5 = byArray.length - n2;
        this.errno = 0;
        if (n5 > this.maxRecordSize) {
            n5 = this.maxRecordSize;
        }
        try {
            if (this.currPos < 0L) {
                return this.mapError(new IsamException(112));
            }
            n4 = this.theFile.read(byArray, n2, n5);
            if (n4 <= 0) {
                this.currPos = -1L;
                return this.mapError(new IsamException(110));
            }
            if (n3 > 0) {
                this.lock(this.currPos, this.maxRecordSize);
            }
            if (n5 < this.maxRecordSize) {
                n5 = this.maxRecordSize;
                this.theFile.seek(this.currPos + (long)n5);
            }
            this.currPos += (long)n5;
        }
        catch (IsamException isamException) {
            return this.mapError(isamException);
        }
        return n4;
    }

    @Override
    public synchronized long previous(byte[] byArray, int n2, int n3) {
        int n4;
        int n5 = byArray.length - n2;
        this.errno = 0;
        if (n5 > this.maxRecordSize) {
            n5 = this.maxRecordSize;
        }
        if (this.theFile == null) {
            return this.mapError(new IsamException(110));
        }
        if (this.currPos < 0L) {
            return this.mapError(new IsamException(112));
        }
        long l2 = this.currPos - (long)(this.maxRecordSize << 1);
        if (l2 < 0L) {
            return this.mapError(new IsamException(110));
        }
        try {
            this.currPos = l2;
            this.theFile.seek(l2);
            n4 = this.theFile.read(byArray, n2, n5);
            if (n4 <= 0) {
                this.currPos = -1L;
                return this.mapError(new IsamException(110));
            }
            if (n3 > 0) {
                this.lock(this.currPos, this.maxRecordSize);
            }
            if (n5 < this.maxRecordSize) {
                n5 = this.maxRecordSize;
                this.theFile.seek(this.currPos + (long)n5);
            }
            this.currPos += (long)n5;
        }
        catch (IsamException isamException) {
            return this.mapError(isamException);
        }
        return n4;
    }

    @Override
    public int unlock() {
        try {
            this.unlockAll();
        }
        catch (IsamException isamException) {
            return this.mapError(isamException);
        }
        return 1;
    }
}

