/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.rts.DynamicFile;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.KeyDescription;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.veryant.vision4j.file.Config;
import com.veryant.vision4j.file.ConfigEntry;
import com.veryant.vision4j.file.FileInfoHelper;
import com.veryant.vision4j.file.FileTable;
import com.veryant.vision4j.file.TransactionLog;
import com.veryant.vision4j.file.TransactionLogEntry;
import com.veryant.vision4j.file.VisionContext;
import com.veryant.vision4j.file.VisionFactory;
import com.veryant.vision4j.file.internals.KeyInfo;
import com.veryant.vision4j.file.internals.LogicalAttributes;
import com.veryant.vision4j.file.internals.PhysicalAttributes;
import java.util.Arrays;

public class DynamicVisionJ
implements DynamicFile,
RuntimeErrorsNumbers {
    private static final String VERSION = "VisionJ 6";
    private static final int WAIT_TIMEOUT;
    private final Config config = new Config();
    private int fileId;
    private String filePath;
    private FileInfoHelper fileInfo;
    private VisionContext visionContext;
    private final VisionFactory visionFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicVisionJ() {
        for (ConfigEntry configEntry : this.config.ALL_ENTRIES) {
            configEntry.parse(com.iscobol.rts.Config.a(".visionj." + configEntry.getName(), (String)null));
        }
        this.visionContext = (VisionContext)IscobolSystem.get(VisionContext.class);
        if (this.visionContext == null) {
            IscobolSystem.Context context = IscobolSystem.getContext();
            synchronized (context) {
                this.visionContext = (VisionContext)IscobolSystem.get(VisionContext.class);
                if (this.visionContext == null) {
                    this.visionContext = new VisionContext(new FileTable(Config.V_MAX_FILES.getIntegerValue()), new TransactionLog());
                    IscobolSystem.set(VisionContext.class, this.visionContext);
                }
            }
        }
        this.visionFactory = new VisionFactory(this.config, this.visionContext.getFileTable());
    }

    @Override
    public boolean isKeySelectedByNum() {
        return true;
    }

    @Override
    public boolean isOpen() {
        return this.fileId > 0;
    }

    @Override
    public String getDescription() {
        return this.filePath;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public int getCobErrno() {
        switch (this.visionFactory.getErrno()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 133;
            }
            case 2: {
                return 102;
            }
            case 3: {
                return 104;
            }
            case 4: {
                return 125;
            }
            case 5: {
                return 107;
            }
            case 6: {
                return 105;
            }
            case 7: {
                return 100;
            }
            case 8: {
                return 111;
            }
            case 9: {
                return 112;
            }
            case 10: {
                return 127;
            }
            case 11: {
                return 113;
            }
            case 12: {
                return 128;
            }
            case 13: {
                return 140;
            }
            case 14: {
                return 116;
            }
            case 15: {
                return 130;
            }
            case 16: {
                return 131;
            }
            case 17: {
                return 126;
            }
            case 18: {
                return 129;
            }
            case 101: {
                return 200;
            }
        }
        return 134;
    }

    @Override
    public String getSysErrno() {
        return String.format("%02d", this.visionFactory.getIntErrno());
    }

    @Override
    public String getErrMsg() {
        return "";
    }

    protected void finalize() {
        if (this.isOpen()) {
            this.close(true);
        }
    }

    private int mapOpen(int n2, int n3) {
        int n4;
        switch (n2) {
            case 1: {
                n4 = 0;
                break;
            }
            case 2: {
                n4 = 1;
                break;
            }
            case 3: {
                n4 = 2;
                break;
            }
            case 6: {
                n4 = 3;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        switch (n3 & 0xF) {
            case 1: 
            case 2: 
            case 4: {
                n4 |= 0x200;
                break;
            }
            case 3: 
            case 5: {
                n4 |= 0x100;
            }
        }
        if ((n3 & 0x100) != 0) {
            n4 |= 0x10;
        }
        if ((n3 & 0x800) != 0) {
            n4 |= 0x4000;
        }
        return n4;
    }

    private int findKey(KeyDescription keyDescription) {
        int n2 = this.getNumKeys();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!keyDescription.equals(this.getKey(i2))) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public synchronized int build(String string, String string2, int n2, int n3, int n4, int n5, int n6, int n7, int n8, KeyDescription[] keyDescriptionArray, byte[] byArray, boolean bl) {
        Object object;
        KeyInfo[] keyInfoArray = new KeyInfo[keyDescriptionArray.length];
        for (int i2 = 0; i2 < keyInfoArray.length; ++i2) {
            object = keyDescriptionArray[i2];
            int n9 = ((KeyDescription)object).segment.length;
            int[] nArray = new int[n9];
            int[] nArray2 = new int[n9];
            for (int i3 = 0; i3 < n9; ++i3) {
                nArray[i3] = ((KeyDescription)object).segment[i3].offset;
                nArray2[i3] = ((KeyDescription)object).segment[i3].size;
            }
            keyInfoArray[i2] = new KeyInfo(keyDescriptionArray[i2].duplicates, nArray, nArray2);
        }
        object = new PhysicalAttributes(n2, n3, n4);
        LogicalAttributes logicalAttributes = new LogicalAttributes(n8, n7, keyInfoArray, n5);
        return this.visionFactory.make(string, (PhysicalAttributes)object, logicalAttributes, byArray) ? 1 : 0;
    }

    @Override
    public synchronized int open(String string, int n2, int n3, KeyDescription[] keyDescriptionArray, int n4, int n5, int n6, int n7, boolean bl, boolean bl2) {
        this.fileId = this.visionFactory.open(string, this.mapOpen(n2, n3));
        if (this.fileId > 0) {
            this.filePath = string;
            this.fileInfo = this.visionFactory.getFileInfo(this.fileId);
            return 1;
        }
        return 0;
    }

    @Override
    public int close() {
        return this.close(false);
    }

    private int close(boolean bl) {
        TransactionLog transactionLog = bl ? null : this.visionContext.getTransactionLog();
        int n2 = this.visionFactory.close(this.fileId, transactionLog) ? 1 : 0;
        this.fileId = 0;
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long read(byte[] byArray, int n2, int n3, int n4) {
        while (true) {
            boolean bl;
            int n5;
            DynamicVisionJ dynamicVisionJ = this;
            synchronized (dynamicVisionJ) {
                this.config.F_NO_LOCK = n4 > 0 ? 0 : 1;
                n5 = this.visionFactory.read(this.fileId, byArray, n3);
                bl = this.visionFactory.getErrno() == 5 && n4 == 3;
            }
            if (!bl) {
                return n5 == 0 ? 0L : (long)n5;
            }
            try {
                Thread.sleep(WAIT_TIMEOUT);
            }
            catch (InterruptedException interruptedException) {
                return 0L;
            }
        }
    }

    @Override
    public long read(byte[] byArray, int n2, KeyDescription keyDescription, int n3) {
        return this.read(byArray, n2, this.findKey(keyDescription), n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long next(byte[] byArray, int n2, int n3) {
        while (true) {
            boolean bl;
            int n4;
            DynamicVisionJ dynamicVisionJ = this;
            synchronized (dynamicVisionJ) {
                this.config.F_NO_LOCK = n3 > 0 ? 0 : 1;
                n4 = this.visionFactory.next(this.fileId, byArray);
                bl = this.visionFactory.getErrno() == 5 && n3 == 3;
            }
            if (!bl) {
                return n4 == 0 ? 0L : (long)n4;
            }
            try {
                Thread.sleep(WAIT_TIMEOUT);
            }
            catch (InterruptedException interruptedException) {
                return 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long previous(byte[] byArray, int n2, int n3) {
        while (true) {
            boolean bl;
            int n4;
            DynamicVisionJ dynamicVisionJ = this;
            synchronized (dynamicVisionJ) {
                this.config.F_NO_LOCK = n3 > 0 ? 0 : 1;
                n4 = this.visionFactory.previous(this.fileId, byArray);
                bl = this.visionFactory.getErrno() == 5 && n3 == 3;
            }
            if (!bl) {
                return n4 == 0 ? 0L : (long)n4;
            }
            try {
                Thread.sleep(WAIT_TIMEOUT);
            }
            catch (InterruptedException interruptedException) {
                return 0L;
            }
        }
    }

    @Override
    public synchronized long start(byte[] byArray, int n2, int n3, int n4, int n5) {
        boolean bl;
        switch (n5) {
            case 0: {
                byte[] byArray2 = new byte[byArray.length];
                bl = this.visionFactory.start(this.fileId, byArray2, n3, n4, 1);
                break;
            }
            case 1: {
                byte[] byArray3 = new byte[byArray.length];
                Arrays.fill(byArray3, (byte)-1);
                bl = this.visionFactory.start(this.fileId, byArray3, n3, n4, 4);
                break;
            }
            case 5: {
                bl = this.visionFactory.start(this.fileId, byArray, n3, n4, 0);
                break;
            }
            case 6: {
                bl = this.visionFactory.start(this.fileId, byArray, n3, n4, 2);
                break;
            }
            case 7: {
                bl = this.visionFactory.start(this.fileId, byArray, n3, n4, 1);
                break;
            }
            case 8: {
                bl = this.visionFactory.start(this.fileId, byArray, n3, n4, 3);
                break;
            }
            case 9: {
                bl = this.visionFactory.start(this.fileId, byArray, n3, n4, 4);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return bl ? 1L : 0L;
    }

    @Override
    public long start(byte[] byArray, int n2, KeyDescription keyDescription, int n3, int n4) {
        return this.start(byArray, n2, this.findKey(keyDescription), n3, n4);
    }

    @Override
    public synchronized long write(byte[] byArray, int n2, int n3, boolean bl) {
        return this.visionFactory.write(this.fileId, byArray, n3, this.visionContext.getTransactionLog()) ? 1L : 0L;
    }

    @Override
    public synchronized long rewrite(byte[] byArray, int n2, int n3, boolean bl) {
        return this.visionFactory.rewrite(this.fileId, byArray, n3, this.visionContext.getTransactionLog()) ? 1L : 0L;
    }

    @Override
    public synchronized long delete(byte[] byArray, int n2) {
        return this.visionFactory.delete(this.fileId, byArray, this.visionContext.getTransactionLog()) ? 1L : 0L;
    }

    @Override
    public synchronized int unlock() {
        return this.visionFactory.unlock(this.fileId) ? 1 : 0;
    }

    @Override
    public synchronized int remove(String string) {
        return this.visionFactory.remove(string) ? 1 : 0;
    }

    @Override
    public synchronized int rename(String string, String string2) {
        return this.visionFactory.rename(string, string2) ? 1 : 0;
    }

    @Override
    public synchronized void sync(int n2) {
        this.visionFactory.sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int begin() {
        TransactionLog transactionLog;
        TransactionLog transactionLog2 = transactionLog = this.visionContext.getTransactionLog();
        synchronized (transactionLog2) {
            if (transactionLog.nestedIndex == Integer.MAX_VALUE) {
                return 0;
            }
            ++transactionLog.nestedIndex;
            if (transactionLog.nestedIndex == 1) {
                transactionLog.init();
            }
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int commit(int n2) {
        TransactionLog transactionLog;
        TransactionLog transactionLog2 = transactionLog = this.visionContext.getTransactionLog();
        synchronized (transactionLog2) {
            if (transactionLog.nestedIndex > 0) {
                --transactionLog.nestedIndex;
                if (transactionLog.nestedIndex == 0) {
                    int[] nArray;
                    boolean bl = true;
                    for (int n3 : nArray = transactionLog.getPostponedCloseList()) {
                        if (this.visionFactory.close(n3, null)) continue;
                        bl = false;
                    }
                    transactionLog.clear();
                    return bl ? 1 : 0;
                }
            }
            transactionLog.nestedIndex = 0;
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int rollback() {
        TransactionLog transactionLog;
        TransactionLog transactionLog2 = transactionLog = this.visionContext.getTransactionLog();
        synchronized (transactionLog2) {
            if (transactionLog.nestedIndex > 0) {
                --transactionLog.nestedIndex;
                if (transactionLog.nestedIndex == 0) {
                    int[] nArray;
                    boolean bl = true;
                    block8: for (TransactionLogEntry transactionLogEntry = transactionLog.getLast(); bl && transactionLogEntry != null; transactionLogEntry = transactionLogEntry.getPrev()) {
                        switch (transactionLogEntry.getType()) {
                            case 2: {
                                bl = this.visionFactory.write(transactionLogEntry.getFileId(), transactionLogEntry.getRecord(), transactionLogEntry.getSize(), null);
                                continue block8;
                            }
                            case 0: {
                                bl = this.visionFactory.delete(transactionLogEntry.getFileId(), transactionLogEntry.getRecord(), null);
                                continue block8;
                            }
                            case 1: {
                                bl = this.visionFactory.rewrite(transactionLogEntry.getFileId(), transactionLogEntry.getRecord(), transactionLogEntry.getSize(), null);
                            }
                        }
                    }
                    for (int n2 : nArray = transactionLog.getPostponedCloseList()) {
                        this.visionFactory.close(n2, null);
                    }
                    transactionLog.clear();
                    return bl ? 1 : 0;
                }
            }
            transactionLog.nestedIndex = 0;
            return 1;
        }
    }

    @Override
    public int recover() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCurrentRecord(long l2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getCurrentRecord() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumKeys() {
        return this.fileInfo.getNumKeys();
    }

    @Override
    public int getMaxRecordSize() {
        return this.fileInfo.getMaxRecSize();
    }

    @Override
    public int getMinRecordSize() {
        return this.fileInfo.getMinRecSize();
    }

    @Override
    public KeyDescription getKey(int n2) {
        if (n2 < 0 || n2 >= this.fileInfo.getNumKeys()) {
            return null;
        }
        KeyInfo keyInfo = this.fileInfo.getKey(n2);
        KeyDescription keyDescription = new KeyDescription(keyInfo.getSegments(), keyInfo.isDuplicate());
        for (int i2 = 0; i2 < keyInfo.getSegments(); ++i2) {
            keyDescription.segment[i2].offset = keyInfo.getOffset(i2);
            keyDescription.segment[i2].size = keyInfo.getSize(i2);
        }
        return keyDescription;
    }

    @Override
    public long getNumRecords() {
        this.fileInfo = this.visionFactory.getFileInfo(this.fileId);
        return this.fileInfo.getTotalRecords();
    }

    @Override
    public byte[] getSequence() {
        return this.visionFactory.info(this.fileId, -5, null);
    }

    static {
        for (ConfigEntry configEntry : Config.ALL_STATIC_ENTRIES) {
            configEntry.parse(com.iscobol.rts.Config.a(".visionj." + configEntry.getName(), (String)null));
        }
        WAIT_TIMEOUT = Config.V_WAIT_TIMEOUT.getIntegerValue();
    }
}

