/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import IT.picosoft.isam.FLock;
import IT.picosoft.isam.IsamException;
import IT.picosoft.isam.OSFile;
import com.iscobol.rts.Config;
import com.iscobol.rts.IscobolSystem;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

public class FileLock {
    private static final boolean OPEN_CHECK = Config.b(".file.open_check", false);
    private static final long OPEN_LOCK_POS = System.getProperty("java.version").compareTo("1.5") >= 0 ? 0x7FFFFFFFFFFFFFFEL : 0x7FFFFFFEL;
    private static final boolean isAS = IscobolSystem.isAS();
    private static final HashMap openFiles = isAS ? new HashMap() : null;
    private static final int[] LOCK_EXCL = new int[]{-1};
    private String filePath;
    private final boolean exclusiveLock;
    private final OSFile file;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileLock(String string, OSFile oSFile, boolean bl, boolean bl2) throws IsamException {
        this.file = oSFile;
        this.exclusiveLock = bl;
        if (this.exclusiveLock) {
            FLock fLock = new FLock();
            fLock.l_whence = 0;
            fLock.l_start = 0L;
            fLock.l_len = 0;
            fLock.l_type = bl2 ? (short)0 : 1;
            if (isAS) {
                try {
                    string = new File(string).getCanonicalPath();
                }
                catch (IOException iOException) {
                    throw new IsamException(iOException);
                }
                HashMap hashMap = openFiles;
                synchronized (hashMap) {
                    if (openFiles.get(string) != null) {
                        throw new IsamException(113);
                    }
                    openFiles.put(string, LOCK_EXCL);
                    try {
                        this.file.fcntl(6, fLock);
                    }
                    catch (IsamException isamException) {
                        openFiles.remove(string);
                        throw isamException;
                    }
                }
            }
            this.file.fcntl(6, fLock);
        } else {
            if (isAS) {
                try {
                    string = new File(string).getCanonicalPath();
                }
                catch (IOException iOException) {
                    throw new IsamException(iOException);
                }
                HashMap hashMap = openFiles;
                synchronized (hashMap) {
                    int[] nArray = (int[])openFiles.get(string);
                    if (nArray == null) {
                        openFiles.put(string, new int[]{1});
                    } else {
                        if (nArray == LOCK_EXCL) {
                            throw new IsamException(113);
                        }
                        nArray[0] = nArray[0] + 1;
                    }
                }
            }
            if (OPEN_CHECK) {
                FLock fLock = new FLock();
                fLock.l_whence = 0;
                fLock.l_start = OPEN_LOCK_POS;
                fLock.l_len = 1;
                fLock.l_type = 0;
                this.file.fcntl(6, fLock);
            }
        }
        this.filePath = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() {
        if (this.filePath != null) {
            if (this.exclusiveLock) {
                FLock fLock = new FLock();
                fLock.l_whence = 0;
                fLock.l_type = (short)2;
                if (isAS) {
                    HashMap hashMap = openFiles;
                    synchronized (hashMap) {
                        openFiles.remove(this.filePath);
                    }
                }
                fLock.l_start = 0L;
                fLock.l_len = 0;
                try {
                    this.file.fcntl(6, fLock);
                }
                catch (IsamException isamException) {}
            } else {
                if (isAS) {
                    HashMap hashMap = openFiles;
                    synchronized (hashMap) {
                        int[] nArray = (int[])openFiles.get(this.filePath);
                        if (nArray != null && (nArray[0] = nArray[0] - 1) == 0) {
                            openFiles.remove(this.filePath);
                        }
                    }
                }
                if (OPEN_CHECK) {
                    FLock fLock = new FLock();
                    fLock.l_whence = 0;
                    fLock.l_type = (short)2;
                    fLock.l_start = OPEN_LOCK_POS;
                    fLock.l_len = 1;
                    try {
                        this.file.fcntl(6, fLock);
                    }
                    catch (IsamException isamException) {
                        // empty catch block
                    }
                }
            }
            this.filePath = null;
        }
    }
}

