/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.io.CobolIOException;
import com.iscobol.io.DataStream;
import com.iscobol.io.FileStatus;
import com.iscobol.io.JavaToIscobolError;

public class FileStatusDefault
implements FileStatus {
    @Override
    public int map(int n2, String string, DataStream dataStream, int n3) {
        if (string != null && string.length() > 0) {
            dataStream.setExtendedStatus(string);
        }
        if ((n2 & 0x7FFF0000) == 0x7FFF0000) {
            char c2 = (char)((n2 & 0xFF00) >>> 8);
            char c3 = (char)(n2 & 0xFF);
            dataStream.setFileStatus("" + c2 + c3);
            dataStream.setStatusMessage("");
            if (c2 == '0') {
                return 0;
            }
            return n2;
        }
        block0 : switch (n2) {
            case 200: {
                dataStream.setFileStatus("02");
                dataStream.setStatusMessage("duplicate key detected");
                n2 = 0;
                break;
            }
            case 201: {
                dataStream.setFileStatus("04");
                dataStream.setStatusMessage("wrong record length in read");
                n2 = 0;
                break;
            }
            case 203: {
                dataStream.setFileStatus("05");
                dataStream.setStatusMessage("optional file missing");
                n2 = 0;
                break;
            }
            case 202: {
                dataStream.setFileStatus("05");
                dataStream.setStatusMessage("optional file created");
                n2 = 0;
                break;
            }
            case 206: {
                dataStream.setFileStatus("07");
                dataStream.setStatusMessage("non-reel/unit device");
                n2 = 0;
                break;
            }
            case 205: {
                dataStream.setFileStatus("0D");
                dataStream.setStatusMessage("command execution failed");
                n2 = 0;
                break;
            }
            case 110: {
                dataStream.setFileStatus("10");
                dataStream.setStatusMessage("end/begin of file");
                break;
            }
            case 100: {
                dataStream.setFileStatus("22");
                dataStream.setStatusMessage("duplicate record");
                break;
            }
            case 111: {
                dataStream.setFileStatus("23");
                dataStream.setStatusMessage("no record found");
                break;
            }
            case 139: {
                dataStream.setFileStatus("24");
                dataStream.setStatusMessage("invalid write");
                break;
            }
            case 133: {
                dataStream.setFileStatus("30");
                dataStream.setStatusMessage("permanent I/O error");
                break;
            }
            case 130: {
                dataStream.setFileStatus("35");
                dataStream.setStatusMessage("missing file");
                break;
            }
            case 131: {
                dataStream.setFileStatus("37");
                dataStream.setStatusMessage("invalid permission");
                if (string != null && string.length() != 0) break;
                dataStream.setExtendedStatus("07");
                break;
            }
            case 142: {
                dataStream.setFileStatus("37");
                dataStream.setStatusMessage("invalid open mode");
                if (string != null && string.length() != 0) break;
                dataStream.setExtendedStatus("09");
                break;
            }
            case 141: {
                dataStream.setFileStatus("38");
                dataStream.setStatusMessage("file closed with lock");
                break;
            }
            case 102: {
                dataStream.setFileStatus("39");
                dataStream.setStatusMessage("file mismatch");
                break;
            }
            case 135: {
                dataStream.setFileStatus("41");
                dataStream.setStatusMessage("already open");
                break;
            }
            case 145: {
                dataStream.setFileStatus("44");
                dataStream.setStatusMessage("boundary violation");
                break;
            }
            case 101: {
                switch (n3) {
                    default: {
                        dataStream.setFileStatus("42");
                        dataStream.setStatusMessage("file not open");
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 262: 
                    case 263: 
                    case 264: {
                        dataStream.setFileStatus("47");
                        dataStream.setStatusMessage("wrong open mode or access mode for start/read");
                        if (string != null && string.length() != 0) break block0;
                        dataStream.setExtendedStatus("02");
                        break;
                    }
                    case 3: {
                        dataStream.setFileStatus("48");
                        dataStream.setStatusMessage("wrong open mode or access mode for write");
                        if (string != null && string.length() != 0) break block0;
                        dataStream.setExtendedStatus("02");
                        break;
                    }
                    case 4: 
                    case 5: {
                        dataStream.setFileStatus("49");
                        dataStream.setStatusMessage("wrong open mode or access mode for rewrite/delete");
                        if (string != null && string.length() != 0) break block0;
                        dataStream.setExtendedStatus("02");
                        break;
                    }
                }
                break;
            }
            case 143: {
                dataStream.setFileStatus("43");
                dataStream.setStatusMessage("invalid delete/rewrite in sequential mode");
                break;
            }
            case 112: {
                dataStream.setFileStatus("46");
                dataStream.setStatusMessage("no current record defined");
                break;
            }
            case 136: {
                dataStream.setFileStatus("47");
                dataStream.setStatusMessage("file not open for INPUT or I-O");
                if (string != null && string.length() != 0) break;
                dataStream.setExtendedStatus("01");
                break;
            }
            case 137: {
                dataStream.setFileStatus("48");
                dataStream.setStatusMessage("file not open for OUTPUT or I-O");
                if (string != null && string.length() != 0) break;
                dataStream.setExtendedStatus("01");
                break;
            }
            case 138: {
                dataStream.setFileStatus("49");
                dataStream.setStatusMessage("file not open for I-O");
                if (string != null && string.length() != 0) break;
                dataStream.setExtendedStatus("01");
                break;
            }
            case 107: {
                dataStream.setFileStatus("51");
                dataStream.setStatusMessage("record locked");
                break;
            }
            case 129: {
                dataStream.setFileStatus("53");
                dataStream.setStatusMessage("no more locks available");
                break;
            }
            case 113: {
                dataStream.setFileStatus("61");
                dataStream.setStatusMessage("file locked");
                break;
            }
            case 104: {
                dataStream.setFileStatus("94");
                dataStream.setStatusMessage("too many files open");
                dataStream.setExtendedStatus("10");
                break;
            }
            case 105: {
                dataStream.setFileStatus("98");
                dataStream.setStatusMessage("file corrupt");
                break;
            }
            case 126: {
                dataStream.setFileStatus("9B");
                dataStream.setStatusMessage("operation not permitted");
                break;
            }
            case 140: {
                dataStream.setFileStatus("9D");
                dataStream.setStatusMessage("no remappable error");
                break;
            }
            case 122: {
                dataStream.setFileStatus("9E");
                dataStream.setStatusMessage("transaction error");
                break;
            }
            case 103: {
                dataStream.setFileStatus("9g");
                dataStream.setStatusMessage("Bad key description");
                break;
            }
            case 147: {
                dataStream.setFileStatus("9N");
                dataStream.setStatusMessage("Network error");
                break;
            }
            case 149: {
                dataStream.setFileStatus("9X");
                dataStream.setStatusMessage("Encryption's key missing");
                break;
            }
            default: {
                dataStream.setFileStatus("9" + (char)n2);
                dataStream.setStatusMessage("unknown error");
                dataStream.setExtendedStatus("" + n2);
                n2 = 134;
            }
        }
        return n2;
    }

    @Override
    public int map(Exception exception, DataStream dataStream, int n2) {
        if (exception instanceof CobolIOException) {
            return this.map(((CobolIOException)exception).getErrNum(), "", dataStream, n2);
        }
        int n3 = JavaToIscobolError.map(exception);
        if (n3 != 134) {
            return this.map(n3, "", dataStream, n2);
        }
        dataStream.setFileStatus("9" + (char)n3);
        String string = exception.getMessage();
        if (string != null) {
            dataStream.setStatusMessage(exception.getMessage());
            dataStream.setExtendedStatus(exception.getMessage());
        } else {
            dataStream.setStatusMessage("Unknown");
            dataStream.setExtendedStatus("Unknown");
        }
        return 134;
    }
}

