/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.io.AtEndException;
import com.iscobol.io.BaseFile;
import com.iscobol.io.CobolFile;
import com.iscobol.io.CobolIOException;
import com.iscobol.io.DynamicJIsam;
import com.iscobol.io.DynamicRelative;
import com.iscobol.io.FileTypeManager;
import com.iscobol.io.InvalidKeyException;
import com.iscobol.io.LockManagerHandler;
import com.iscobol.java.CobolVarHelper;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.Config;
import com.iscobol.rts.DynamicFile;
import com.iscobol.rts.DynamicMultiType;
import com.iscobol.rts.Factory;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.INumericVar;
import com.iscobol.rts.IscobolCall;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.KeyDescription;
import com.iscobol.rts.RuntimeErrorsNumbers;
import java.io.File;
import java.util.Vector;

public class IndexFile
extends BaseFile
implements CobolFile,
RuntimeErrorsNumbers {
    private static final boolean updBuffWithLock = Config.b(".file.index.read_lock_test", false) || Config.b(".file.index.lock_read_anyhow", false);
    protected DynamicFile theFile;
    private INumericVar relativeKey;
    protected Object _clazz;
    private KeyDescription[] keys = new KeyDescription[1];
    private int nKeys = 0;
    private byte[] collatingSeq;
    private static final LockManagerHandler lmh = LockManagerHandler.get();
    private static DynamicFile lastDfTrans = null;
    private static final String open_hook = Config.a(".file.index.open_hook", null);
    private String pathHook;
    private IscobolCall executeHook;
    private int COMP_OPT = 0;

    private static MyProperties get() {
        MyProperties myProperties = (MyProperties)IscobolSystem.get(MyProperties.class);
        if (myProperties == null) {
            myProperties = new MyProperties();
            IscobolSystem.set(MyProperties.class, myProperties);
        }
        return myProperties;
    }

    public static DynamicFile getDefaultDynamicFile(Config config) {
        return IndexFile.getDynamic(Config.a(config, ".file.index", "jisam"));
    }

    public static DynamicFile getDefaultDynamicFile(String string) {
        return IndexFile.getDefaultDynamicFile(string, FileTypeManager.getIndex());
    }

    public static DynamicFile getDefaultDynamicFile(String string, Class clazz) {
        DynamicFile dynamicFile;
        if (clazz != null) {
            try {
                dynamicFile = (DynamicFile)clazz.newInstance();
                MyProperties myProperties = IndexFile.get();
                myProperties.defIdxFileDesc = clazz.getName();
                myProperties.defIdxFileClass = clazz;
                myProperties.putClass();
            }
            catch (InstantiationException instantiationException) {
                throw new IscobolRuntimeException(16, clazz.getName() + " (" + instantiationException + ")");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IscobolRuntimeException(16, clazz.getName() + " (" + illegalAccessException + ")");
            }
            catch (ClassCastException classCastException) {
                throw new IscobolRuntimeException(16, clazz.getName() + " (" + classCastException + ")");
            }
        } else {
            dynamicFile = IndexFile.getDynamic(null);
        }
        return dynamicFile;
    }

    private static DynamicFile getDynamic(String string) {
        MyProperties myProperties = IndexFile.get();
        if (string == null || !string.equals(myProperties.defIdxFileDesc)) {
            myProperties.defIdxFileDesc = string;
            myProperties.defIdxFileClass = FileTypeManager.getIndex(string);
            myProperties.putClass();
        }
        try {
            return (DynamicFile)myProperties.defIdxFileClass.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IscobolRuntimeException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new IscobolRuntimeException(instantiationException);
        }
    }

    public static final DynamicFile isIdxInConfig(String string) {
        if (string != null) {
            string = new File(string).getName();
            String string2 = Config.a(".file.index." + string.toLowerCase().replace('-', '_'), null);
            if (string2 != null) {
                return IndexFile.getDynamic(string2);
            }
        }
        return null;
    }

    DynamicFile isInConfig(String string) {
        return IndexFile.isIdxInConfig(string);
    }

    public static int begin() {
        int n2 = 1;
        MyProperties myProperties = IndexFile.get();
        myProperties.inTransaction = true;
        for (int i2 = myProperties.allDynamicClasses.size() - 1; n2 == 1 && i2 >= 0; --i2) {
            try {
                DynamicFile dynamicFile = (DynamicFile)((Class)myProperties.allDynamicClasses.elementAt(i2)).newInstance();
                dynamicFile = lmh.get(dynamicFile);
                n2 = dynamicFile.begin();
                lastDfTrans = dynamicFile;
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        return n2;
    }

    public static int commit(int n2) {
        int n3 = 1;
        MyProperties myProperties = IndexFile.get();
        myProperties.inTransaction = false;
        for (int i2 = myProperties.allDynamicClasses.size() - 1; n3 == 1 && i2 >= 0; --i2) {
            try {
                DynamicFile dynamicFile = (DynamicFile)((Class)myProperties.allDynamicClasses.elementAt(i2)).newInstance();
                dynamicFile = lmh.get(dynamicFile);
                n3 = dynamicFile.commit(n2);
                lastDfTrans = dynamicFile;
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        return n3;
    }

    public static int rollback() {
        int n2 = 1;
        MyProperties myProperties = IndexFile.get();
        myProperties.inTransaction = false;
        for (int i2 = myProperties.allDynamicClasses.size() - 1; n2 == 1 && i2 >= 0; --i2) {
            try {
                DynamicFile dynamicFile = (DynamicFile)((Class)myProperties.allDynamicClasses.elementAt(i2)).newInstance();
                dynamicFile = lmh.get(dynamicFile);
                n2 = dynamicFile.rollback();
                lastDfTrans = dynamicFile;
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        return n2;
    }

    public static boolean isInTransaction() {
        MyProperties myProperties = IndexFile.get();
        return myProperties.inTransaction;
    }

    public static void sync(int n2) {
        MyProperties myProperties = IndexFile.get();
        for (int i2 = myProperties.allDynamicClasses.size() - 1; i2 >= 0; --i2) {
            try {
                DynamicFile dynamicFile = (DynamicFile)((Class)myProperties.allDynamicClasses.elementAt(i2)).newInstance();
                dynamicFile = lmh.get(dynamicFile);
                dynamicFile.sync(n2);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
    }

    public IndexFile(String string, int n2, ICobolVar iCobolVar, int n3, boolean bl, int n4, Class clazz) {
        super(string, n2, iCobolVar, n3, bl, n4);
        this._clazz = clazz;
    }

    public IndexFile(String string, int n2, ICobolVar iCobolVar, int n3, boolean bl, int n4, ICobolVar iCobolVar2) {
        super(string, n2, iCobolVar, n3, bl, n4);
        this._clazz = iCobolVar2;
    }

    public IndexFile(String string, int n2, ICobolVar iCobolVar, int n3, boolean bl, int n4, String string2) {
        super(string, n2, iCobolVar, n3, bl, n4);
        this._clazz = string2;
    }

    public IndexFile(String string, int n2, ICobolVar iCobolVar, int n3, boolean bl, int n4) {
        super(string, n2, iCobolVar, n3, bl, n4);
        this._clazz = null;
    }

    protected Class getClazz() {
        if (this._clazz == null) {
            return FileTypeManager.getIndex();
        }
        if (this._clazz instanceof Class) {
            return (Class)this._clazz;
        }
        try {
            return Class.forName(this._clazz.toString().trim());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IscobolRuntimeException(5, "" + this._clazz + " (" + classNotFoundException + ")");
        }
    }

    protected int findKeyNum(ICobolVar[] iCobolVarArray) {
        int n2;
        KeyDescription keyDescription = this.findKey(iCobolVarArray);
        for (n2 = this.nKeys - 1; n2 >= 0; --n2) {
            if (!this.keys[n2].equals(keyDescription)) continue;
            return n2;
        }
        return n2;
    }

    private KeyDescription findKey(ICobolVar[] iCobolVarArray) {
        KeyDescription keyDescription;
        if (iCobolVarArray != null) {
            keyDescription = new KeyDescription(iCobolVarArray.length, false);
            for (int i2 = 0; i2 < iCobolVarArray.length; ++i2) {
                keyDescription.setSegment(i2, iCobolVarArray[i2].length(), iCobolVarArray[i2].getOffset());
            }
        } else {
            keyDescription = null;
        }
        return keyDescription;
    }

    private void mapError(int n2, String string, int n3) {
        switch (n2) {
            case 0: {
                break;
            }
            case 100: {
                this.invDupl.throwMe();
                break;
            }
            case 110: {
                this.atEnd.throwMe();
                break;
            }
            case 111: {
                if (n3 == 6 || n3 == 7) {
                    this.atEnd.throwMe();
                    break;
                }
                this.invNoRec.throwMe();
                break;
            }
            default: {
                CobolIOException.get(n2, string, this, n3);
            }
        }
    }

    protected KeyDescription[] getKeys() {
        return this.keys;
    }

    public KeyDescription[] getMyKeys() {
        return this.keys;
    }

    protected void setCurrentRecord(int n2) {
        long l2 = this.relativeKey.tolong();
        if (l2 > 0L) {
            this.theFile.setCurrentRecord(l2);
        } else {
            InvalidKeyException.get(111, "", this, n2);
        }
    }

    private void buildFile(String string, int n2) {
        int n3;
        int n4 = n3 = (n2 & 0x1000) == 0 ? 0 : 1;
        if (this.theFile.build(string, "", 0, 0, 0, this.getCompressionFactor(), n3, this.getBufferLength(), this.getMinRecordLen(), this.keys, this.collatingSeq, this.assignExt) == 0) {
            this.mapError(this.theFile.getCobErrno(), this.theFile.getSysErrno(), 1);
        }
    }

    @Override
    public void peerOpen(String string, int n2, int n3) {
        Object var4_4 = null;
        this.keys = this.getKeys();
        if (open_hook != null) {
            this.theFile = IndexFile.getDefaultDynamicFile(string, this.getOpenHookClass(string));
            string = this.pathHook;
        } else {
            this.theFile = this.isInConfig(string);
            if (this.theFile == null) {
                this.theFile = IndexFile.getDefaultDynamicFile(string, this.getClazz());
            }
        }
        if (this.getLogger() != null) {
            StringBuffer stringBuffer = new StringBuffer("OPENING [");
            stringBuffer.append(string);
            stringBuffer.append("] AS [");
            stringBuffer.append(this.theFile.getClass());
            stringBuffer.append("]");
            this.getLogger().info(stringBuffer.toString());
        }
        if (this.keys != null && this.keys.length > 0 && this.keys[0] != null) {
            this.theFile = lmh.get(this.theFile);
        }
        switch (n2) {
            case 2: {
                this.buildFile(string, n3);
                if (this.theFile.open(string, n2, n3, this.keys, this.getBufferLength(), this.getMinRecordLen(), this.nKeys, this.accessMode, this.isOptional(n2), this.assignExt) != 0) break;
                this.mapError(this.theFile.getCobErrno(), this.theFile.getSysErrno(), 1);
                break;
            }
            case 3: 
            case 6: {
                if (this.theFile.open(string, n2, n3, this.keys, this.getBufferLength(), this.getMinRecordLen(), this.nKeys, this.accessMode, this.isOptional(n2), this.assignExt) != 0) break;
                if (this.theFile.getCobErrno() == 130) {
                    if (!this.isOptional(n2)) {
                        this.mapError(130, this.theFile.getSysErrno(), 1);
                        break;
                    }
                    CobolIOException.get(202, "", this, 1);
                    this.buildFile(string, n3);
                    if (this.theFile.open(string, n2, n3, this.keys, this.getBufferLength(), this.getMinRecordLen(), this.nKeys, this.accessMode, this.isOptional(n2), this.assignExt) != 0) break;
                    this.mapError(this.theFile.getCobErrno(), this.theFile.getSysErrno(), 1);
                    break;
                }
                this.mapError(this.theFile.getCobErrno(), this.theFile.getSysErrno(), 1);
                break;
            }
            case 1: {
                if (this.theFile.open(string, n2, n3, this.keys, this.getBufferLength(), this.getMinRecordLen(), this.nKeys, this.accessMode, this.isOptional(n2), this.assignExt) != 0) break;
                if (this.theFile.getCobErrno() == 130) {
                    if (!this.isOptional(n2)) {
                        this.mapError(130, "", 1);
                        break;
                    }
                    this.mapError(203, "", 1);
                    break;
                }
                this.mapError(this.theFile.getCobErrno(), this.theFile.getSysErrno(), 1);
                break;
            }
            default: {
                throw new IscobolRuntimeException(3, new IllegalArgumentException("OPEN").toString());
            }
        }
        if (this.theFile.isOpen()) {
            int n4 = this.theFile.getNumKeys();
            if (this.getBufferLength() != this.theFile.getMaxRecordSize()) {
                if (this.getLogger() != null) {
                    this.getLogger().info("OPEN: [39] extFs [02] The expected record size " + this.getBufferLength() + " differ from the maximum record size " + this.theFile.getMaxRecordSize());
                }
                this.theFile.close();
                this.mapError(102, "02", 1);
            } else if (n4 > 0 && this.nKeys > n4) {
                this.theFile.close();
                if (this.getLogger() != null) {
                    this.getLogger().info("OPEN: [39] extFs [04] The expected number of keys of the file " + this.nKeys + " is > of the number of the keys " + n4);
                }
                this.mapError(102, "04", 1);
            } else if (!Config.b(".file.extra_keys_ok", false) && n4 > 0 && this.nKeys < n4) {
                this.theFile.close();
                if (this.getLogger() != null) {
                    this.getLogger().info("OPEN: [39] extFs [04] The expected number of keys of the file " + this.nKeys + " is < of the number of the keys " + n4);
                }
                this.mapError(102, "04", 1);
            } else {
                this.setOpenMode(n2);
            }
            if (Config.b(".file.index.check_all_keys", false)) {
                int n5;
                boolean bl = true;
                for (n5 = 0; n5 < this.theFile.getNumKeys() && n5 < this.keys.length && bl; ++n5) {
                    bl = false;
                    for (int i2 = 0; i2 < this.theFile.getNumKeys() && i2 < this.keys.length && !bl; ++i2) {
                        bl = this.theFile.getKey(i2).equals(this.keys[n5]);
                    }
                }
                if (!bl) {
                    this.theFile.close();
                    this.setOpenMode(0);
                    if (this.getLogger() != null) {
                        this.getLogger().info("OPEN: [39] extFs [04] The description of the ordinal key " + n5 + " is wrong!");
                    }
                    this.mapError(102, "04", 1);
                }
            }
        } else {
            this.setOpenMode(n2);
        }
        if (this.getLogger() != null && !(this.theFile instanceof DynamicRelative)) {
            this.getLogger().info("OPENED [" + string + "] AS [" + this.theFile.getClass() + "]");
        }
    }

    @Override
    protected void peerClose(int n2) {
        if (this.theFile != null && this.theFile.isOpen() && this.theFile.close() == 0) {
            this.mapError(this.theFile.getCobErrno(), this.theFile.getSysErrno(), 2);
        }
        this.theFile = null;
        this.setOpenMode(0);
    }

    @Override
    public void keyReset() {
        this.nKeys = 0;
    }

    @Override
    public CobolFile key(ICobolVar[] iCobolVarArray, boolean bl) {
        if (this.nKeys == this.keys.length) {
            KeyDescription[] keyDescriptionArray = new KeyDescription[this.keys.length + 1];
            System.arraycopy(this.keys, 0, keyDescriptionArray, 0, this.keys.length);
            this.keys = keyDescriptionArray;
        }
        this.keys[this.nKeys] = new KeyDescription(iCobolVarArray.length, bl);
        for (int i2 = 0; i2 < iCobolVarArray.length; ++i2) {
            this.keys[this.nKeys].setSegment(i2, iCobolVarArray[i2].length(), iCobolVarArray[i2].getOffset());
        }
        ++this.nKeys;
        return this;
    }

    @Override
    public CobolFile relativeKey(INumericVar iNumericVar) {
        this.relativeKey = iNumericVar;
        return this;
    }

    @Override
    public CobolFile collatingSequence(byte[] byArray) {
        this.collatingSeq = byArray;
        return this;
    }

    @Override
    public boolean write(boolean bl, int n2) {
        super.write(bl, n2);
        if (this.relativeKey != null) {
            if (this.accessMode != 1) {
                this.setCurrentRecord(3);
            }
            long l2 = this.theFile.write(this.getBufferRO(), 0, n2, bl);
            int n3 = this.theFile.getCobErrno();
            if (l2 == 0L || n3 != 0) {
                this.mapError(n3, this.theFile.getSysErrno(), 3);
            } else {
                this.relativeKey.set(this.theFile.getCurrentRecord());
            }
        } else {
            if (this.getLogger() != null && LoggerFactory.get(16) != null) {
                StringBuffer stringBuffer = new StringBuffer("key 1");
                this.writeLogKey(stringBuffer, 0);
                this.getLogger().info(stringBuffer.toString());
            }
            long l3 = this.theFile.write(this.getBufferRO(), 0, n2, bl);
            int n4 = this.theFile.getCobErrno();
            if (l3 == 0L || n4 != 0) {
                this.mapError(n4, this.theFile.getSysErrno(), 3);
            }
        }
        return false;
    }

    @Override
    public boolean writeAdvancing(int n2, int n3, boolean bl, int n4, int n5) {
        return this.write(bl, n4);
    }

    @Override
    public void rewrite(boolean bl, int n2) {
        super.rewrite(bl, n2);
        if (this.relativeKey != null) {
            if (this.accessMode != 1) {
                this.setCurrentRecord(4);
            }
            long l2 = this.theFile.rewrite(this.getBufferRO(), 0, n2, bl);
            int n3 = this.theFile.getCobErrno();
            if (l2 == 0L || n3 != 0) {
                this.mapError(this.theFile.getCobErrno(), this.theFile.getSysErrno(), 3);
            } else {
                this.relativeKey.set(this.theFile.getCurrentRecord());
            }
        } else {
            if (this.getLogger() != null && LoggerFactory.get(16) != null) {
                StringBuffer stringBuffer = new StringBuffer("key 1");
                this.writeLogKey(stringBuffer, 0);
                this.getLogger().info(stringBuffer.toString());
            }
            long l3 = this.theFile.rewrite(this.getBufferRO(), 0, n2, bl);
            int n4 = this.theFile.getCobErrno();
            if (l3 == 0L || n4 != 0) {
                this.mapError(this.theFile.getCobErrno(), this.theFile.getSysErrno(), 4);
            }
        }
    }

    @Override
    public void delete() {
        super.delete();
        if (this.relativeKey != null) {
            long l2;
            if (this.accessMode != 1) {
                this.setCurrentRecord(5);
            }
            if ((l2 = this.theFile.delete(this.getBufferRO(), 0)) == 0L) {
                this.mapError(this.theFile.getCobErrno(), this.theFile.getSysErrno(), 3);
            } else {
                this.relativeKey.set(this.theFile.getCurrentRecord());
            }
        } else if (this.theFile.delete(this.getBufferRO(), 0) == 0L) {
            this.mapError(this.theFile.getCobErrno(), this.theFile.getSysErrno(), 5);
        }
    }

    @Override
    public int readNext(int n2, ICobolVar iCobolVar) {
        long l2 = 0L;
        if (n2 != -1) {
            super.readNext(n2 &= this.lockMask, iCobolVar);
        } else {
            super.readNext(n2 &= 0xFFFFFFFF, iCobolVar);
        }
        if (!this.theFile.isOpen()) {
            AtEndException.get(this, 6);
            return (int)l2;
        }
        byte[] byArray = this.getBufferRO();
        do {
            l2 = this.theFile.next(byArray, 0, n2);
            int n3 = this.theFile.getCobErrno();
            if (l2 == 0L || n3 != 0) {
                if (updBuffWithLock && n3 == 107) {
                    this.updateBuffer(byArray);
                }
                this.mapError(n3, this.theFile.getSysErrno(), 6);
            }
            this.updateBuffer(byArray);
        } while (this.whileLike != null && !this.isLike());
        if (iCobolVar != null) {
            iCobolVar.setUsingMaxLen(byArray);
        }
        if (this.relativeKey != null) {
            this.relativeKey.set(this.theFile.getCurrentRecord());
        }
        return (int)l2;
    }

    @Override
    public int readPrev(int n2, ICobolVar iCobolVar) {
        long l2 = 0L;
        if (n2 != -1) {
            super.readPrev(n2 &= this.lockMask, iCobolVar);
        } else {
            super.readPrev(n2 &= 0xFFFFFFFF, iCobolVar);
        }
        if (!this.theFile.isOpen()) {
            AtEndException.get(this, 7);
            return (int)l2;
        }
        byte[] byArray = this.getBufferRO();
        do {
            l2 = this.theFile.previous(byArray, 0, n2);
            int n3 = this.theFile.getCobErrno();
            if (l2 == 0L || n3 != 0) {
                if (updBuffWithLock && n3 == 107) {
                    this.updateBuffer(byArray);
                }
                this.mapError(n3, this.theFile.getSysErrno(), 7);
            }
            this.updateBuffer(byArray);
        } while (this.whileLike != null && !this.isLike());
        if (iCobolVar != null) {
            iCobolVar.setUsingMaxLen(byArray);
        }
        if (this.relativeKey != null) {
            this.relativeKey.set(this.theFile.getCurrentRecord());
        }
        return (int)l2;
    }

    @Override
    public int readKey(ICobolVar[] iCobolVarArray, int n2, ICobolVar iCobolVar) {
        byte[] byArray;
        long l2 = 0L;
        if (n2 != -1) {
            super.readKey(iCobolVarArray, n2 &= this.lockMask, iCobolVar);
        } else {
            super.readKey(iCobolVarArray, n2 &= 0xFFFFFFFF, iCobolVar);
        }
        if (!this.theFile.isOpen()) {
            InvalidKeyException.get(111, "", this, 8);
            return (int)l2;
        }
        if (this.relativeKey != null) {
            this.setCurrentRecord(8);
            byArray = this.getBufferRO();
            l2 = this.theFile.read(byArray, 0, this.findKey(iCobolVarArray), n2);
            int n3 = this.theFile.getCobErrno();
            if (l2 == 0L || n3 != 0) {
                this.mapError(this.theFile.getCobErrno(), this.theFile.getSysErrno(), 3);
            } else {
                this.relativeKey.set(this.theFile.getCurrentRecord());
            }
        } else {
            if (this.getLogger() != null && LoggerFactory.get(16) != null) {
                StringBuffer stringBuffer = new StringBuffer("key ");
                stringBuffer.append(this.findKeyNum(iCobolVarArray) + 1);
                this.writeLogKey(stringBuffer, this.findKeyNum(iCobolVarArray));
                this.getLogger().info(stringBuffer.toString());
            }
            if (this.theFile.isKeySelectedByNum()) {
                byArray = this.getBufferRO();
                l2 = this.theFile.read(byArray, 0, this.findKeyNum(iCobolVarArray), n2);
            } else {
                byArray = this.getBufferRO();
                l2 = this.theFile.read(byArray, 0, this.findKey(iCobolVarArray), n2);
            }
            int n4 = this.theFile.getCobErrno();
            if (l2 == 0L || n4 != 0) {
                if (updBuffWithLock && n4 == 107) {
                    this.updateBuffer(byArray);
                }
                this.mapError(n4, this.theFile.getSysErrno(), 8);
            }
        }
        this.updateBuffer(byArray);
        if (iCobolVar != null) {
            iCobolVar.setUsingMaxLen(byArray);
        }
        return (int)l2;
    }

    @Override
    public void start(ICobolVar[] iCobolVarArray, int n2, int n3) {
        super.start(iCobolVarArray, n2, n3);
        if (!this.theFile.isOpen()) {
            InvalidKeyException.get(111, "", this, 9);
            return;
        }
        if (this.relativeKey != null) {
            this.theFile.setCurrentRecord(this.relativeKey.tolong());
            long l2 = this.theFile.start(this.getBufferRO(), 0, this.findKey(iCobolVarArray), n3, n2);
            if (l2 == 0L) {
                this.mapError(this.theFile.getCobErrno(), this.theFile.getSysErrno(), 3);
            } else {
                this.relativeKey.set(this.theFile.getCurrentRecord());
            }
        } else {
            long l3;
            if (this.getLogger() != null && LoggerFactory.get(16) != null) {
                StringBuffer stringBuffer = new StringBuffer("key ");
                stringBuffer.append(this.findKeyNum(iCobolVarArray) + 1);
                this.writeLogKey(stringBuffer, this.findKeyNum(iCobolVarArray));
                this.getLogger().info(stringBuffer.toString());
            }
            if ((l3 = this.theFile.isKeySelectedByNum() ? this.theFile.start(this.getBufferRO(), 0, this.findKeyNum(iCobolVarArray), n3, n2) : this.theFile.start(this.getBufferRO(), 0, this.findKey(iCobolVarArray), n3, n2)) == 0L) {
                this.mapError(this.theFile.getCobErrno(), this.theFile.getSysErrno(), 9);
            }
        }
    }

    @Override
    public void unlock() {
        int n2;
        super.unlock();
        if (this.theFile.isOpen() && (n2 = this.theFile.unlock()) == 0) {
            this.mapError(this.theFile.getCobErrno(), this.theFile.getSysErrno(), 10);
        }
    }

    @Override
    public void deleteFile(ICobolVar iCobolVar) {
        int n2;
        CharSequence charSequence;
        super.deleteFile(iCobolVar);
        if (this.getLogger() != null && LoggerFactory.get(16) != null) {
            charSequence = new StringBuffer("key 0");
            this.writeLogKey((StringBuffer)charSequence, 0);
            this.getLogger().info(((StringBuffer)charSequence).toString());
        }
        if (IndexFile.isRemoveNameSpaces((String)(charSequence = iCobolVar.toString().trim()))) {
            charSequence = ((String)charSequence).toString().replace(" ", "");
        }
        if ((this.theFile = this.isInConfig((String)charSequence)) == null) {
            Class clazz = this.getClazz();
            this.theFile = IndexFile.getDefaultDynamicFile((String)charSequence, clazz);
        }
        if ((n2 = this.theFile instanceof DynamicMultiType ? ((DynamicMultiType)this.theFile).removeEx(this.keys, this.getOsPath()) : this.theFile.remove(this.getOsPath())) == 0) {
            int n3 = this.theFile.getCobErrno();
            if (n3 == 130) {
                this.mapError(203, this.theFile.getSysErrno(), 11);
            } else {
                this.mapError(n3, this.theFile.getSysErrno(), 11);
            }
        }
    }

    private void writeLogKey(StringBuffer stringBuffer, int n2) {
        if (this.keys.length > 0) {
            KeyDescription keyDescription = this.keys[n2];
            stringBuffer.append(", key-value=");
            if (keyDescription != null) {
                for (int i2 = 0; i2 < keyDescription.getNumSegments(); ++i2) {
                    stringBuffer.append(this.getBufferAsVar().toString().substring(keyDescription.getSegment((int)i2).offset, keyDescription.getSegment((int)i2).offset + keyDescription.getSegment((int)i2).size));
                }
            }
        }
    }

    private Class getOpenHookClass(String string) {
        this.pathHook = string;
        Class<?> clazz = null;
        CobolVarHelper cobolVarHelper = new CobolVarHelper("varPath", this.COMP_OPT).picX("varPath", 300);
        ICobolVar iCobolVar = cobolVarHelper.get("varPath");
        CobolVarHelper cobolVarHelper2 = new CobolVarHelper("varClazz", this.COMP_OPT).picX("varClazz", 300);
        ICobolVar iCobolVar2 = cobolVarHelper2.get("varClazz");
        iCobolVar.set(string);
        DynamicFile dynamicFile = this.isInConfig(string);
        if (dynamicFile == null) {
            iCobolVar2.set(this.getClazz().getName());
        } else {
            iCobolVar2.set(dynamicFile.getClass().getName());
        }
        try {
            Factory.call(open_hook, null, new ICobolVar[]{iCobolVar, iCobolVar2});
            clazz = iCobolVar2.toString().trim().length() != 0 ? Class.forName(iCobolVar2.toString().trim()) : this.getClazz();
            this.pathHook = iCobolVar.toString().trim();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IscobolRuntimeException(5, "" + iCobolVar2.toString().trim() + " (" + classNotFoundException + ")");
        }
        return clazz;
    }

    public void setCOMP_OPTcp() {
        this.COMP_OPT = 16;
    }

    static class MyProperties {
        private String defIdxFileDesc = "jisam";
        private Class defIdxFileClass = DynamicJIsam.class;
        private Vector allDynamicClasses = new Vector();
        private boolean inTransaction;

        private MyProperties() {
            this.allDynamicClasses.addElement(this.defIdxFileClass);
        }

        private void putClass() {
            int n2;
            int n3 = this.allDynamicClasses.size();
            for (n2 = 0; n2 < n3 && this.allDynamicClasses.elementAt(n2) != this.defIdxFileClass; ++n2) {
            }
            if (n2 == n3) {
                this.allDynamicClasses.addElement(this.defIdxFileClass);
            }
        }
    }
}

