/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.io.AtEndException;
import com.iscobol.io.CobolFile;
import com.iscobol.io.CobolIOException;
import com.iscobol.io.DeviceFile;
import com.iscobol.rts.Config;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IPicN;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.types.PicX;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;

public class LineSeqFile
extends DeviceFile
implements CobolFile,
RuntimeErrorsNumbers {
    public static final String encoding = Config.a(".encoding", new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding());
    private final IPicN nationalBuffer;
    int minRecSize;
    boolean stripTrailingSpace = false;
    private static final PicX eol = new PicX(System.getProperty("line.separator", "\n"));

    public LineSeqFile(String string, int n2, ICobolVar iCobolVar, int n3, boolean bl, Class clazz) {
        super(string, n2, iCobolVar, n3, bl, false, clazz);
        this.nationalBuffer = iCobolVar instanceof IPicN ? (IPicN)iCobolVar : null;
    }

    public LineSeqFile(String string, int n2, ICobolVar iCobolVar, int n3, boolean bl, String string2) {
        super(string, n2, iCobolVar, n3, bl, false, string2);
        this.nationalBuffer = iCobolVar instanceof IPicN ? (IPicN)iCobolVar : null;
    }

    public LineSeqFile(String string, int n2, ICobolVar iCobolVar, int n3, boolean bl) {
        super(string, n2, iCobolVar, n3, bl, false);
        this.nationalBuffer = iCobolVar instanceof IPicN ? (IPicN)iCobolVar : null;
    }

    @Override
    public void peerOpen(String string, int n2, int n3) {
        this.stripTrailingSpace = Config.a(".file.strip_trailing_spaces", ".strip_trailing_spaces", this.stripTrailingSpace);
        super.peerOpen(string, n2, n3);
        if (this.stripTrailingSpace && this.outFile != null) {
            this.minRecSize = Config.a(".file.min_rec_size", ".min_rec_size", 1);
            if (this.minRecSize < 0) {
                this.minRecSize = 0;
            }
            this.outFile.setMinRecSize(this.minRecSize);
        }
    }

    @Override
    public boolean write(boolean bl, int n2) {
        super.write(bl, n2);
        this.outFile.write(this.getBufferAsVar(), n2, this.stripTrailingSpace);
        this.outFile.write(eol, eol.length(), false);
        return false;
    }

    @Override
    public boolean write(boolean bl, int n2, int n3) {
        return this.write(bl, n2);
    }

    @Override
    public boolean writeAdvancing(int n2, int n3, boolean bl, int n4, int n5) {
        super.write(bl, n4);
        n5 = this.stripTrailingSpace ? (n5 &= 0xFFFFFFFD) : (n5 |= 2);
        return super.writeAdvancing(2, 1, bl, n4, n5);
    }

    @Override
    public int readNext(boolean bl, ICobolVar iCobolVar) {
        return this.readNext(bl ? 1 : 0, iCobolVar);
    }

    @Override
    public int readNext(int n2, ICobolVar iCobolVar) {
        int n3 = 0;
        if (n2 != -1) {
            super.readNext(n2 &= this.lockMask, iCobolVar);
        } else {
            super.readNext(n2 &= 0xFFFFFFFF, iCobolVar);
        }
        if (this.inpFile == null) {
            AtEndException.get(this, 6);
            return n3;
        }
        try {
            String string = this.inpFile.readLine();
            if (string == null) {
                AtEndException.get(this, 6);
                return n3;
            }
            byte[] byArray = string.getBytes(encoding);
            n3 = byArray.length;
            this.updateBuffer(byArray);
            if (iCobolVar != null) {
                iCobolVar.setUsingMaxLen(byArray);
            }
        }
        catch (IOException iOException) {
            CobolIOException.get(iOException, this, 6);
        }
        return n3;
    }

    private void myWrite(char[] cArray) throws IOException {
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            this.outFile.write(cArray[i2]);
        }
    }

    @Override
    public char[] getBufferAsChars() {
        if (this.nationalBuffer != null) {
            return this.nationalBuffer.basicToString().toCharArray();
        }
        return super.getBufferAsChars();
    }

    @Override
    protected ICobolVar getBufferAsVar() {
        if (this.nationalBuffer != null) {
            return this.nationalBuffer;
        }
        return super.getBufferAsVar();
    }

    public void setTrailingSpaces() {
        this.stripTrailingSpace = true;
    }
}

