/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.io.BaseFile;
import com.iscobol.io.LockManager;
import com.iscobol.rts.Config;
import com.iscobol.rts.DynamicFile;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.KeyValue;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public class LockManagerHandler {
    public static final HashMap files = new HashMap();
    public final Class theLockManager;
    final LinkedList openFiles;

    public static LockManagerHandler get() {
        LockManagerHandler lockManagerHandler = (LockManagerHandler)IscobolSystem.get(LockManagerHandler.class);
        if (lockManagerHandler == null) {
            lockManagerHandler = new LockManagerHandler();
            IscobolSystem.set(LockManagerHandler.class, lockManagerHandler);
        }
        return lockManagerHandler;
    }

    private LockManagerHandler() {
        block6: {
            this.openFiles = new LinkedList();
            if (IscobolSystem.isAS()) {
                String string = Config.a(".file.lock_manager", null);
                if (string != null) {
                    try {
                        this.theLockManager = Class.forName(string);
                        if (!LockManager.class.isAssignableFrom(this.theLockManager)) {
                            throw new InstantiationException(string + "!=" + LockManager.class);
                        }
                        break block6;
                    }
                    catch (Exception exception) {
                        throw new IscobolRuntimeException(exception);
                    }
                }
                this.theLockManager = null;
            } else {
                this.theLockManager = null;
            }
        }
    }

    public DynamicFile get(DynamicFile dynamicFile) {
        if (this.theLockManager != null) {
            try {
                LockManager lockManager = (LockManager)this.theLockManager.newInstance();
                lockManager.init(dynamicFile);
                return lockManager;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IscobolRuntimeException(illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                throw new IscobolRuntimeException(instantiationException);
            }
        }
        return dynamicFile;
    }

    public static synchronized FileUnique getFileUnique(String string, boolean bl) {
        String string2;
        File file = bl ? new File(BaseFile.expandFileName(string)) : new File(string);
        try {
            string2 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string2 = file.getName();
        }
        FileUnique fileUnique = (FileUnique)files.get(string2);
        if (fileUnique == null) {
            fileUnique = new FileUnique(string);
            files.put(string2, fileUnique);
        }
        return fileUnique;
    }

    public static synchronized void release(int n2) {
        for (FileUnique fileUnique : files.values()) {
            fileUnique.release(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Vector getInfo(String string, int n2) {
        Vector<Info> vector = new Vector<Info>();
        Iterator iterator = files.values().iterator();
        while (iterator.hasNext()) {
            FileUnique fileUnique;
            FileUnique fileUnique2 = fileUnique = (FileUnique)iterator.next();
            synchronized (fileUnique2) {
                if (string == null || string.equals(fileUnique.name)) {
                    for (Records records : fileUnique.files.values()) {
                        if (n2 > 0 && n2 != records.threadId) continue;
                        for (KeyValue keyValue : records.recs) {
                            vector.addElement(new Info(fileUnique.name, records.threadId, records.openMode, records.lockMode, keyValue));
                        }
                    }
                }
            }
        }
        Collections.sort(vector);
        return vector;
    }

    public static class Info
    implements Comparable {
        public final String fileName;
        public final int threadId;
        public final int openMode;
        public final int lockMode;
        public final KeyValue key;

        public Info(String string, int n2, int n3, int n4, KeyValue keyValue) {
            this.fileName = string;
            this.threadId = n2;
            this.openMode = n3;
            this.lockMode = n4;
            this.key = keyValue;
        }

        public int compareTo(Object object) {
            Info info = (Info)object;
            int n2 = this.fileName.compareTo(info.fileName);
            if (n2 != 0) {
                return n2;
            }
            n2 = this.threadId - info.threadId;
            if (n2 != 0) {
                return n2;
            }
            n2 = this.openMode - info.openMode;
            if (n2 != 0) {
                return n2;
            }
            n2 = this.lockMode - info.lockMode;
            if (n2 != 0) {
                return n2;
            }
            n2 = this.key.compareTo(info.key);
            return n2;
        }

        public boolean equals(Object object) {
            if (object instanceof Info) {
                return this.compareTo(object) == 0;
            }
            return false;
        }

        public int hashCode() {
            return this.fileName.hashCode() | this.threadId | this.openMode | this.key.hashCode();
        }

        public String toString() {
            return "[" + this.fileName + "," + this.threadId + "," + this.openMode + "," + this.lockMode + "," + this.key + "]";
        }
    }

    public static class FileUnique {
        private String name;
        private volatile HashMap files = new HashMap();
        private volatile HashMap pkeys = new HashMap();
        private Records exclLock;
        private int openedCnt;

        FileUnique(String string) {
            this.name = string;
        }

        public synchronized Records getLockExcl() {
            return this.exclLock;
        }

        public synchronized Records tryLockExcl(int n2, DynamicFile dynamicFile, int n3, int n4) {
            if (this.exclLock != null || this.openedCnt > 0) {
                return null;
            }
            this.exclLock = new Records(n2, dynamicFile, n3, n4);
            return this.exclLock;
        }

        public synchronized boolean unlockExcl(DynamicFile dynamicFile) {
            if (this.exclLock != null) {
                this.release(dynamicFile);
                this.exclLock = null;
                return true;
            }
            return false;
        }

        public synchronized void addOpened() {
            ++this.openedCnt;
        }

        public synchronized void removeOpened() {
            --this.openedCnt;
        }

        public synchronized void lock(int n2, DynamicFile dynamicFile, int n3, int n4, KeyValue keyValue, int n5) {
            Records records = (Records)this.files.get(dynamicFile);
            if (records == null) {
                records = new Records(n2, dynamicFile, n3, n4);
                this.files.put(dynamicFile, records);
            }
            records.recs.add(keyValue);
            this.pkeys.put(keyValue, records);
        }

        public synchronized void release(DynamicFile dynamicFile, KeyValue keyValue) {
            Records records = (Records)this.files.get(dynamicFile);
            if (records != null) {
                records.recs.remove(keyValue);
                this.pkeys.remove(keyValue);
                this.notifyAll();
            }
        }

        public synchronized void release(DynamicFile dynamicFile) {
            Records records = (Records)this.files.remove(dynamicFile);
            if (records != null) {
                for (KeyValue keyValue : records.recs) {
                    this.pkeys.remove(keyValue);
                }
                this.notifyAll();
            }
        }

        public synchronized void release(int n2) {
            Object[] objectArray = this.files.values().toArray();
            for (int i2 = objectArray.length - 1; i2 >= 0; --i2) {
                if (objectArray[i2] == null) continue;
                Records records = (Records)objectArray[i2];
                if (n2 != records.threadId) continue;
                this.release(records.file);
            }
        }

        public synchronized int getLockTid(KeyValue keyValue) {
            Records records = (Records)this.pkeys.get(keyValue);
            if (records != null) {
                return records.threadId;
            }
            return 0;
        }

        public synchronized boolean isLocked(KeyValue keyValue, DynamicFile dynamicFile) {
            Records records = (Records)this.pkeys.get(keyValue);
            if (records == null) {
                return false;
            }
            return records.file != dynamicFile;
        }

        public synchronized Records tryLock(int n2, DynamicFile dynamicFile, int n3, int n4, KeyValue keyValue, int n5) {
            Records records = (Records)this.pkeys.get(keyValue);
            if (records != null) {
                if (records.file == dynamicFile) {
                    records = null;
                } else if (n5 == 3) {
                    try {
                        do {
                            this.wait();
                        } while (this.pkeys.containsKey(keyValue));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.lock(n2, dynamicFile, n3, n4, keyValue, n5);
                    records = null;
                }
            } else {
                this.lock(n2, dynamicFile, n3, n4, keyValue, n5);
            }
            return records;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Records {
        public final int threadId;
        public final DynamicFile file;
        public final int openMode;
        public final int lockMode;
        private final HashSet recs = new HashSet();

        public Records(int n2, DynamicFile dynamicFile, int n3, int n4) {
            this.file = dynamicFile;
            this.openMode = n3;
            this.lockMode = n4;
            this.threadId = n2;
        }
    }
}

