/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Stack;

class MfFile {
    private final String idxExt = ".idx";
    private final File datFile;
    private File idxFile;
    private final RandomAccessFile idxRAFile;
    private final RandomAccessFile datRAFile;
    final int signature;
    final short idxSize;
    final short mfVersion;
    final long numOfRecords;
    final int maxRec;
    final int minRec;
    final int nKeys;
    final Key[] keys;
    final boolean gteq4095;
    final boolean compressed;
    private byte[] buffer;
    private byte[] sequence = null;
    private long primaryKeyRoot;
    private int tail;
    private Stack status;
    private static final String blanks = "                                            ";

    public MfFile(String string) throws IOException {
        int n2 = string.lastIndexOf(46);
        String string2 = n2 < 1 || string.lastIndexOf(File.separatorChar) > n2 ? string + ".idx" : (string.toLowerCase().endsWith(".idx".toLowerCase()) ? string + ".idx" : string.substring(0, n2) + ".idx");
        this.datFile = new File(string);
        this.idxFile = new File(string2);
        if (!this.idxFile.exists()) {
            this.idxFile = this.datFile;
            this.datRAFile = this.idxRAFile = new RandomAccessFile(this.idxFile, "r");
        } else {
            this.idxRAFile = new RandomAccessFile(this.idxFile, "r");
            this.datRAFile = new RandomAccessFile(this.datFile, "r");
        }
        try {
            long l2;
            int n3;
            this.signature = this.idxRAFile.readShort() & 0xFFFF;
            if (this.signature == 65107) {
                this.compressed = false;
                this.idxRAFile.seek(6L);
                n3 = this.idxRAFile.readShort();
                this.mfVersion = (short)(256 - (n3 & 0xFF));
                this.idxSize = (short)(n3 + this.mfVersion);
                this.nKeys = this.idxRAFile.readShort() & 0xFFFF;
                this.idxRAFile.seek(13L);
                this.minRec = this.maxRec = this.idxRAFile.readShort() & 0xFFFF;
                this.gteq4095 = this.maxRec >= 4095;
                l2 = (long)this.idxRAFile.readInt() & 0xFFFFFFFFL;
                this.idxRAFile.seek(33L);
                this.numOfRecords = (long)this.idxRAFile.readInt() & 0xFFFFFFFFL;
                this.keys = new Key[this.nKeys];
                this.readKeys(l2);
                if (this.datRAFile == this.idxRAFile) {
                    throw new IOException("Invalid file!");
                }
                this.buffer = new byte[this.maxRec + 2];
            } else if ((this.signature & 0xF000) == 12288) {
                this.idxRAFile.seek(41L);
                this.compressed = this.idxRAFile.readByte() != 0;
                this.idxRAFile.seek(43L);
                this.mfVersion = (short)(this.idxRAFile.readByte() & 0xFF);
                this.idxRAFile.seek(54L);
                this.maxRec = this.idxRAFile.readInt();
                this.gteq4095 = this.maxRec >= 4095;
                this.idxRAFile.seek(58L);
                this.minRec = this.idxRAFile.readInt();
                this.idxRAFile.seek(64L);
                this.numOfRecords = this.idxRAFile.readLong();
                this.idxRAFile.seek(140L);
                this.nKeys = this.idxRAFile.readShort() & 0xFFFF;
                this.idxRAFile.seek(144L);
                l2 = this.idxRAFile.readLong();
                this.idxRAFile.seek(172L);
                this.idxSize = this.gteq4095 ? (short)(4 + this.idxRAFile.readInt()) : (short)(2 + this.idxRAFile.readInt());
                this.keys = new Key[this.nKeys];
                if (this.mfVersion == 8) {
                    this.readKeys8(l2);
                    this.status = new Stack();
                    this.status.push(new IndexNode(this.primaryKeyRoot));
                } else if (this.mfVersion == 3 || this.mfVersion == 4) {
                    if (this.datRAFile == this.idxRAFile) {
                        throw new IOException("Invalid file!");
                    }
                    this.readKeys(l2);
                    this.datRAFile.seek(128L);
                } else {
                    throw new IOException("Unsupported version " + this.mfVersion);
                }
                this.buffer = new byte[this.maxRec + this.tail + 3];
            } else {
                throw new IOException("Unsupported file!");
            }
            l2 = this.datRAFile.getFilePointer();
            try {
                int n4;
                byte by;
                if (this.gteq4095) {
                    n3 = this.datRAFile.readInt();
                    by = (byte)((n3 & 0xF0000000) >>> 24);
                    n4 = 4 - (n3 &= 0xFFFFFFF) % 4;
                } else {
                    n3 = this.datRAFile.readChar();
                    by = (byte)((n3 & 0xF000) >>> 8);
                    n4 = 4 - ((n3 &= 0xFFF) + 2) % 4;
                }
                if (n3 >= 256 && by == 48) {
                    this.sequence = new byte[n3 + n4 + this.tail];
                    n3 = this.datRAFile.read(this.sequence, 0, n3 + n4 + this.tail);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.datRAFile.seek(l2);
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    private void readKeys8(long l2) throws IOException {
        long l3 = l2;
        int n2 = 0;
        while (n2 < this.nKeys) {
            int n3;
            int n4 = 0;
            this.idxRAFile.seek(l3);
            this.idxRAFile.readShort();
            n4 += 2;
            if (this.gteq4095) {
                n3 = this.idxRAFile.readShort();
                n4 += 2;
            }
            short s2 = this.idxRAFile.readShort();
            n4 += 2;
            int n5 = s2 - 2;
            this.idxRAFile.readShort();
            n4 += 2;
            l3 = (long)this.idxRAFile.readInt() & 0xFFFFFFFFL;
            n4 += 4;
            while (n4 < n5) {
                this.keys[n2] = new Key();
                short s3 = this.idxRAFile.readShort();
                int n6 = (n4 += 2) + s3 - 2;
                n3 = this.idxRAFile.readInt();
                n4 += 4;
                long l4 = this.idxRAFile.readLong();
                n4 += 8;
                long l5 = this.idxRAFile.readLong();
                n4 += 8;
                if (this.primaryKeyRoot == 0L) {
                    this.primaryKeyRoot = l5;
                }
                this.idxRAFile.readByte();
                ++n4;
                byte by = this.idxRAFile.readByte();
                if ((by & 0x40) != 0) {
                    this.keys[n2].duplicates = true;
                }
                ++n4;
                int n7 = 0;
                while (n4 < n6) {
                    KeyPart keyPart = new KeyPart();
                    keyPart.length = this.idxRAFile.readShort() & 0xFFFF;
                    n4 += 2;
                    keyPart.offset = this.idxRAFile.readInt();
                    n4 += 4;
                    this.idxRAFile.readByte();
                    ++n4;
                    this.idxRAFile.readByte();
                    ++n4;
                    this.keys[n2].length += keyPart.length;
                    this.keys[n2].parts.add(keyPart);
                    ++n7;
                }
                this.keys[n2].nparts = n7;
                ++n2;
            }
        }
    }

    private static long getNumber(byte[] byArray, int n2, int n3) {
        long l2 = 0L;
        switch (n3) {
            case 8: {
                l2 |= (long)(byArray[n2++] & 0xFF) << 56;
            }
            case 7: {
                l2 |= (long)(byArray[n2++] & 0xFF) << 48;
            }
            case 6: {
                l2 |= (long)(byArray[n2++] & 0xFF) << 40;
            }
            case 5: {
                l2 |= (long)(byArray[n2++] & 0xFF) << 32;
            }
            case 4: {
                l2 |= (long)(byArray[n2++] & 0xFF) << 24;
            }
            case 3: {
                l2 |= (long)(byArray[n2++] & 0xFF) << 16;
            }
            case 2: {
                l2 |= (long)(byArray[n2++] & 0xFF) << 8;
            }
            case 1: {
                l2 |= (long)(byArray[n2] & 0xFF);
            }
        }
        return l2;
    }

    private void readNode8(long l2) throws IOException {
        byte[] byArray = new byte[this.idxSize];
        this.idxRAFile.seek(l2);
        this.idxRAFile.read(byArray, 0, this.idxSize);
        int n2 = byArray[this.idxSize - 1] & 0x7F;
        int n3 = 0;
        int n4 = (int)MfFile.getNumber(byArray, n3, 2);
        int n5 = (int)MfFile.getNumber(byArray, n3 += 2, 2) & Short.MAX_VALUE;
        n3 += 2;
        int n6 = this.keys[0].length;
        int n7 = n6 + 6;
        if (n2 > 0) {
            while (n3 < n5) {
                long l3 = MfFile.getNumber(byArray, n3 + n6, 6);
                this.readNode8(l3);
                n3 += n7;
            }
        } else {
            while (n3 < n5) {
                long l4 = MfFile.getNumber(byArray, n3 + n6, 6);
                System.out.println(">l>" + new String(byArray, n3, n6) + "," + Long.toHexString(l4));
                n3 += n7;
            }
        }
    }

    long getNextRecAddr() throws IOException {
        long l2 = -1L;
        IndexNode indexNode = (IndexNode)this.status.peek();
        while (true) {
            if ((l2 = indexNode.getNextAddress()) < 0L) {
                this.status.pop();
                if (this.status.isEmpty()) {
                    return l2;
                }
                indexNode = (IndexNode)this.status.peek();
                continue;
            }
            if (indexNode.level == 0) {
                return l2;
            }
            indexNode = new IndexNode(l2);
            this.status.push(indexNode);
        }
    }

    private void readKeys(long l2) throws IOException {
        long l3 = l2;
        int n2 = 0;
        while (n2 < this.nKeys) {
            if (this.mfVersion < 3) {
                this.idxRAFile.seek((l3 - 1L) * (long)this.idxSize);
            } else {
                this.idxRAFile.seek(l3);
            }
            int n3 = 0;
            short s2 = this.idxRAFile.readShort();
            n3 += 2;
            int n4 = s2 - 2;
            l3 = (long)this.idxRAFile.readInt() & 0xFFFFFFFFL;
            n3 += 4;
            while (n3 < n4) {
                this.keys[n2] = new Key();
                short s3 = this.idxRAFile.readShort();
                int n5 = (n3 += 2) + s3 - 2;
                this.idxRAFile.readInt();
                n3 += 4;
                byte by = this.idxRAFile.readByte();
                ++n3;
                int n6 = 0;
                while (n3 < n5) {
                    KeyPart keyPart = new KeyPart();
                    if ((this.idxRAFile.readByte() & 0x80) != 0) {
                        this.keys[n2].duplicates = true;
                        if (this.mfVersion == 4) {
                            this.tail = this.tail == 0 ? 8 : (this.tail += 4);
                        }
                    }
                    ++n3;
                    keyPart.length = this.idxRAFile.readByte() & 0xFF;
                    ++n3;
                    keyPart.offset = this.idxRAFile.readShort() & 0xFFFF;
                    n3 += 2;
                    this.idxRAFile.readByte();
                    ++n3;
                    this.keys[n2].length += keyPart.length;
                    this.keys[n2].parts.add(keyPart);
                    ++n6;
                }
                this.keys[n2].nparts = n6;
                ++n2;
            }
        }
    }

    String fmt(String string, int n2, boolean bl) {
        int n3 = string.length();
        if (n3 < n2) {
            string = bl ? string + blanks.substring(0, n2 - n3) : blanks.substring(0, n2 - n3) + string;
        }
        return string;
    }

    String fmt(String string, int n2) {
        return this.fmt(string, n2, false);
    }

    String fmt(long l2, int n2, boolean bl) {
        String string = "" + l2;
        return this.fmt(string, n2, bl);
    }

    String fmt(long l2, int n2) {
        return this.fmt(l2, n2, false);
    }

    public void printInfo() {
        System.out.println(this.datFile.getPath() + "  IDXFORMAT\"" + this.mfVersion + "\"");
        System.out.println("# of records:" + this.fmt(this.numOfRecords, 18));
        String string = this.compressed ? " compressed" : "";
        System.out.println("record size:" + this.fmt(this.maxRec, 19) + string);
        System.out.println("# of keys: " + this.fmt(this.nKeys, 20));
        System.out.println("Key  Dups    Seg-1     Seg-2     Seg-3     Seg-4     Seg-5     Seg-6");
        System.out.println("            (sz/of)   (sz/of)   (sz/of)   (sz/of)   (sz/of)   (sz/of)");
        System.out.println("");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.nKeys; ++i2) {
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer.append(this.fmt(i2, 3));
            stringBuffer.append(this.fmt(this.keys[i2].duplicates ? "Y" : "N", 5));
            stringBuffer.append("  ");
            for (int i3 = 0; i3 < this.keys[i2].nparts; ++i3) {
                stringBuffer.append(this.fmt(((KeyPart)this.keys[i2].parts.get((int)i3)).length, 3));
                stringBuffer.append("/");
                stringBuffer.append(this.fmt(((KeyPart)this.keys[i2].parts.get((int)i3)).offset, 6, true));
            }
            System.out.println(stringBuffer);
        }
    }

    public long getValidRecordsNum() {
        return this.numOfRecords;
    }

    private int readNext1(byte[] byArray, int n2, int n3) {
        int n4;
        try {
            while ((n4 = this.datRAFile.read(this.buffer, 0, this.maxRec + 1)) > 0 && this.buffer[this.maxRec] != 10) {
            }
            if (n4 > 0) {
                n4 = Math.min(n3, this.maxRec);
                System.arraycopy(this.buffer, 0, byArray, n2, n4);
            }
        }
        catch (IOException iOException) {
            n4 = -1;
        }
        return n4;
    }

    private int readNext2(byte[] byArray, int n2, int n3) {
        int n4;
        try {
            while ((n4 = this.datRAFile.read(this.buffer, 0, this.maxRec + 2)) > 0 && this.buffer[this.maxRec + 1] != 10) {
            }
            if (n4 > 0) {
                n4 = Math.min(n3, this.maxRec);
                System.arraycopy(this.buffer, 0, byArray, n2, n4);
            }
        }
        catch (IOException iOException) {
            n4 = -1;
        }
        return n4;
    }

    private int readNext34(byte[] byArray, int n2, int n3) {
        int n4;
        try {
            byte by;
            int n5;
            do {
                int n6;
                if (this.gteq4095) {
                    n5 = this.datRAFile.readInt();
                    by = (byte)((n5 & 0xF0000000) >>> 24);
                    n6 = 4 - (n5 &= 0xFFFFFFF) % 4;
                } else {
                    n5 = this.datRAFile.readChar();
                    by = (byte)((n5 & 0xF000) >>> 8);
                    n6 = 4 - ((n5 &= 0xFFF) + 2) % 4;
                }
                if (n6 < 4) {
                    if (this.buffer.length < n5 + n6 + this.tail) {
                        this.buffer = new byte[n5 + n6 + this.tail + 2];
                    }
                    n5 = this.datRAFile.read(this.buffer, 0, n5 + n6 + this.tail);
                    continue;
                }
                n5 = this.datRAFile.read(this.buffer, 0, n5 + this.tail);
            } while (n5 > 0 && by != 64);
            if (n5 > 0) {
                n4 = Math.min(n5, this.maxRec);
                System.arraycopy(this.buffer, 0, byArray, n2, n4);
            } else {
                n4 = -1;
            }
        }
        catch (IOException iOException) {
            n4 = -1;
        }
        return n4;
    }

    private int readNext8(byte[] byArray, int n2, int n3) {
        int n4;
        try {
            long l2 = this.getNextRecAddr();
            if (l2 > 0L) {
                int n5;
                this.datRAFile.seek(l2);
                if (this.gteq4095) {
                    n5 = this.datRAFile.readInt();
                    byte by = (byte)((n5 & 0xF0000000) >>> 24);
                    n5 &= 0xFFFFFFF;
                } else {
                    n5 = this.datRAFile.readChar();
                    byte by = (byte)((n5 & 0xF000) >>> 8);
                    n5 &= 0xFFF;
                }
                n4 = this.datRAFile.read(this.buffer, 0, n5);
                if (n5 > 0) {
                    n4 = Math.min(n5, this.maxRec);
                    System.arraycopy(this.buffer, 0, byArray, n2, n4);
                } else {
                    n4 = -1;
                }
            } else {
                n4 = -1;
            }
        }
        catch (IOException iOException) {
            n4 = -1;
        }
        return n4;
    }

    private int readNext3(byte[] byArray, int n2, int n3) {
        return this.readNext34(byArray, n2, n3);
    }

    private int readNext4(byte[] byArray, int n2, int n3) {
        return this.readNext34(byArray, n2, n3);
    }

    int readNext(byte[] byArray, int n2, int n3) {
        switch (this.mfVersion) {
            case 1: {
                return this.readNext1(byArray, n2, n3);
            }
            case 2: {
                return this.readNext2(byArray, n2, n3);
            }
            case 3: {
                return this.readNext3(byArray, n2, n3);
            }
            case 4: {
                return this.readNext4(byArray, n2, n3);
            }
            case 8: {
                return this.readNext8(byArray, n2, n3);
            }
        }
        return -1;
    }

    public void close() {
        if (this.idxRAFile != null) {
            try {
                this.idxRAFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.datRAFile != null && this.datRAFile != this.idxRAFile) {
            try {
                this.datRAFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public byte[] getSequence() {
        return this.sequence;
    }

    class IndexNode {
        private final long address;
        private final byte[] node;
        private final int level;
        private int offs;
        private final int signature;
        private final int dim;
        private final int kLen;
        private final int kBlkLen;

        IndexNode(long l2) throws IOException {
            this.address = l2;
            this.node = new byte[MfFile.this.idxSize];
            MfFile.this.idxRAFile.seek(this.address);
            MfFile.this.idxRAFile.read(this.node, 0, MfFile.this.idxSize);
            this.level = this.node[MfFile.this.idxSize - 1] & 0x7F;
            this.signature = (int)MfFile.getNumber(this.node, this.offs, 2);
            this.offs += 2;
            if (MfFile.this.gteq4095) {
                this.offs += 2;
            }
            this.dim = (int)MfFile.getNumber(this.node, this.offs, 2) & Short.MAX_VALUE;
            this.offs += 2;
            this.kLen = MfFile.this.keys[0].length;
            this.kBlkLen = this.kLen + 6;
        }

        long getNextAddress() {
            long l2;
            if (this.offs < this.dim) {
                this.offs += this.kLen;
                l2 = MfFile.getNumber(this.node, this.offs, 6);
                this.offs += 6;
            } else {
                l2 = -1L;
            }
            return l2;
        }
    }

    static class Key {
        int nparts;
        boolean duplicates;
        int length;
        ArrayList parts = new ArrayList();

        Key() {
        }
    }

    static class KeyPart {
        int offset;
        int length;

        KeyPart() {
        }
    }
}

