/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.io.AtEndException;
import com.iscobol.io.CobolFile;
import com.iscobol.io.CobolIOException;
import com.iscobol.io.DeviceFile;
import com.iscobol.rts.Config;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IPicN;
import com.iscobol.rts.MixingCharAndBytesException;
import com.iscobol.rts.RuntimeErrorsNumbers;
import java.io.IOException;

public class PrinterFile
extends DeviceFile
implements CobolFile,
RuntimeErrorsNumbers {
    private final IPicN nationalBuffer;
    private boolean cp;

    public PrinterFile(String string, int n2, ICobolVar iCobolVar, int n3, boolean bl, boolean bl2, Class clazz) {
        super(string, n2, iCobolVar, n3, bl, bl2, clazz);
        this.nationalBuffer = iCobolVar instanceof IPicN ? (IPicN)iCobolVar : null;
    }

    public PrinterFile(String string, int n2, ICobolVar iCobolVar, int n3, boolean bl, boolean bl2, String string2) {
        super(string, n2, iCobolVar, n3, bl, bl2, string2);
        this.nationalBuffer = iCobolVar instanceof IPicN ? (IPicN)iCobolVar : null;
    }

    public PrinterFile(String string, int n2, ICobolVar iCobolVar, int n3, boolean bl, boolean bl2) {
        super(string, n2, iCobolVar, n3, bl, bl2);
        this.nationalBuffer = iCobolVar instanceof IPicN ? (IPicN)iCobolVar : null;
    }

    public PrinterFile(String string, int n2, ICobolVar iCobolVar, int n3, boolean bl) {
        super(string, n2, iCobolVar, n3, bl, false);
        this.nationalBuffer = iCobolVar instanceof IPicN ? (IPicN)iCobolVar : null;
    }

    public void setCp(boolean bl) {
        this.cp = bl;
    }

    public boolean isCp() {
        return this.cp;
    }

    @Override
    public void peerOpen(String string, int n2, int n3) {
        super.peerOpen(string, n2, n3);
        if (this.outFile != null) {
            int n4 = Config.a(".file.min_rec_size", ".min_rec_size", 1);
            if (n4 < 0) {
                n4 = 0;
            }
            this.outFile.setMinRecSize(n4);
        }
    }

    @Override
    public final boolean write(boolean bl, int n2) {
        return this.write(bl, n2, 0);
    }

    @Override
    public boolean write(boolean bl, int n2, int n3) {
        int n4;
        boolean bl2;
        super.write(bl, n2);
        boolean bl3 = bl2 = (n3 & 2) == 0;
        if ((n3 & 1) != 0 || this.isGraphicPrinter()) {
            n4 = this.outFile.write(this.getBufferAsVar(), n2, bl2);
        } else {
            n4 = this.outFile.write(this.getBufferAsVar(), n2, bl2);
            if (n4 != 0) {
                n4 = this.outFile.write(13);
            }
        }
        if (n4 != 1) {
            CobolIOException.get(this.outFile.getCobErrno(), "", this, 3);
        }
        return false;
    }

    @Override
    public boolean writeAdvancing(int n2, int n3, boolean bl, int n4, int n5) {
        if (this.isGraphicPrinter()) {
            n5 |= 1;
        }
        return super.writeAdvancing(n2, n3, bl, n4, n5);
    }

    @Override
    public int readNext(boolean bl, ICobolVar iCobolVar) {
        return this.readNext(bl ? 1 : 0, iCobolVar);
    }

    @Override
    public int readNext(int n2, ICobolVar iCobolVar) {
        int n3 = 0;
        if (n2 != -1) {
            super.readNext(n2 &= this.lockMask, iCobolVar);
        } else {
            super.readNext(n2 &= 0xFFFFFFFF, iCobolVar);
        }
        if (this.inpFile == null) {
            AtEndException.get(this, 6);
            return n3;
        }
        try {
            byte[] byArray;
            if (this.isBinary()) {
                byArray = new byte[this.getBufferLength()];
                n3 = this.inpFile.read(byArray, 0, this.getBufferLength());
                if (n3 <= 0) {
                    AtEndException.get(this, 6);
                    return n3;
                }
            } else {
                char[] cArray = new char[this.getBufferLength()];
                n3 = this.inpFile.read(cArray, 0, this.getBufferLength());
                if (n3 <= 0) {
                    AtEndException.get(this, 6);
                    return n3;
                }
                byArray = new String(cArray).substring(0, n3).getBytes();
            }
            this.updateBuffer(byArray);
            if (iCobolVar != null) {
                iCobolVar.setUsingMaxLen(byArray);
            }
        }
        catch (IOException iOException) {
            CobolIOException.get(iOException, this, 6);
        }
        return n3;
    }

    @Override
    protected void peerClose(int n2) {
        this.checkFilePageEject(n2);
        super.peerClose(n2);
    }

    protected void checkFilePageEject(int n2) {
        if (this.outFile != null && Config.b(".file.page_eject_on_close", false) && (n2 & 1) == 0) {
            DeviceFile.Output output;
            if (this.outFile instanceof DeviceFile.Output && (output = (DeviceFile.Output)this.outFile).isDirect()) {
                if (!output.printInBackground) {
                    try {
                        output.write(12);
                    }
                    catch (MixingCharAndBytesException mixingCharAndBytesException) {
                        if (mixingCharAndBytesException.getErrorCode() == 3) {
                            output.writeByte((byte)12);
                        } else if (mixingCharAndBytesException.getErrorCode() == 4) {
                            output.writeCharX((byte)12);
                        }
                    }
                }
            } else {
                try {
                    this.outFile.write(12);
                }
                catch (MixingCharAndBytesException mixingCharAndBytesException) {
                    // empty catch block
                }
            }
        }
    }

    protected final void dfPeerClose(int n2) {
        super.peerClose(n2);
    }

    @Override
    public char[] getBufferAsChars() {
        if (this.nationalBuffer != null) {
            return this.nationalBuffer.basicToString().toCharArray();
        }
        return super.getBufferAsChars();
    }

    @Override
    protected ICobolVar getBufferAsVar() {
        if (this.nationalBuffer != null) {
            return this.nationalBuffer;
        }
        return super.getBufferAsVar();
    }
}

