/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.rts.IOConstants;
import com.iscobol.rts.RuntimeErrorsNumbers;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;

class RMKFile
implements IOConstants,
RuntimeErrorsNumbers {
    static final int HEADER_NODE = 1;
    static final int INDEX_NODE = 5;
    static final int DATA_NODE = 6;
    static final int CURRDATA_NODE = 7;
    static final int BLANK_NODE = 8;
    static final int KFLAG_MASK = 7;
    static final int KFLAG_DUPS = 1;
    static final int KFLAG_PART = 2;
    static final int SIGN = 1380797254;
    static final int MAXKEYS = 255;
    static final int MAX_KEY_SIZE = 255;
    static final int HEADERSIZE = 55;
    static final int KEYSIZE = 36;
    static final NodeItemDesc INITIAL = new NodeItemDesc(null);
    final char vVersion;
    private final File vFile;
    private final RandomAccessFile vRAFile;
    private final char unkn1;
    private final char unkn2;
    private final char unkn3;
    final int minRec;
    final int maxRec;
    final byte dataCompress;
    private final byte spaceCode;
    private final byte numberCode;
    final byte keyCompress;
    private final byte keyNumberCode;
    private final int blockSize;
    private final byte integrityFlag;
    private final long numOfRecords;
    private short nDupKeys;
    private int currIndex;
    private NodeItemDesc curr = INITIAL;
    private NodeItemDesc next;
    final int nKeys;
    final int nKeyParts;
    final Key[] keys;
    private long validRecordsNum;
    private long currBlockNum;
    private int currBlockSize;
    private int currBlockOffs;
    private int errno = 0;
    private final String blanks = "                                            ";

    private static int memcmp(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        while (n4 > 0) {
            if (byArray[n2] != byArray2[n3]) {
                return (byArray[n2] & 0xFF) - (byArray2[n3] & 0xFF);
            }
            ++n2;
            ++n3;
            --n4;
        }
        return 0;
    }

    private static long getNumber(byte[] byArray, int n2, int n3) {
        long l2 = 0L;
        switch (n3) {
            case 8: {
                l2 |= (long)(byArray[n2++] & 0xFF) << 56;
            }
            case 7: {
                l2 |= (long)(byArray[n2++] & 0xFF) << 48;
            }
            case 6: {
                l2 |= (long)(byArray[n2++] & 0xFF) << 40;
            }
            case 5: {
                l2 |= (long)(byArray[n2++] & 0xFF) << 32;
            }
            case 4: {
                l2 |= (long)(byArray[n2++] & 0xFF) << 24;
            }
            case 3: {
                l2 |= (long)(byArray[n2++] & 0xFF) << 16;
            }
            case 2: {
                l2 |= (long)(byArray[n2++] & 0xFF) << 8;
            }
            case 1: {
                l2 |= (long)(byArray[n2] & 0xFF);
            }
        }
        return l2;
    }

    public RMKFile(String string) throws IOException {
        this.vVersion = '\u0000';
        this.vFile = new File(string);
        this.vRAFile = new RandomAccessFile(this.vFile, "r");
        try {
            int n2;
            char c2 = this.vRAFile.readChar();
            long l2 = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
            int n3 = this.vRAFile.readInt();
            if (c2 != '\u0001' || n3 != 1380797254) {
                throw new IOException("Unrecognized RMKF file!");
            }
            this.vRAFile.seek(10L);
            this.unkn1 = this.vRAFile.readChar();
            this.unkn2 = this.vRAFile.readChar();
            this.unkn3 = this.vRAFile.readChar();
            this.minRec = this.vRAFile.readChar();
            this.maxRec = this.vRAFile.readChar();
            this.dataCompress = this.vRAFile.readByte();
            this.spaceCode = this.vRAFile.readByte();
            this.numberCode = this.vRAFile.readByte();
            this.keyCompress = this.vRAFile.readByte();
            this.keyNumberCode = this.vRAFile.readByte();
            this.nKeyParts = this.vRAFile.readByte() & 0xFF;
            this.blockSize = this.vRAFile.readChar();
            this.vRAFile.seek(50L);
            this.validRecordsNum = this.numOfRecords = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
            this.integrityFlag = this.vRAFile.readByte();
            int n4 = 256;
            this.vRAFile.seek(n4);
            this.currBlockOffs = this.blockSize;
            ArrayList<Key> arrayList = new ArrayList<Key>();
            ArrayList<KeyPart> arrayList2 = null;
            byte[] byArray = new byte[36];
            for (n2 = 0; n2 < this.nKeyParts; ++n2) {
                if (n4 + 36 <= this.blockSize) {
                    char c3 = this.vRAFile.readChar();
                    char c4 = this.vRAFile.readChar();
                    byte by = this.vRAFile.readByte();
                    byte by2 = this.vRAFile.readByte();
                    long l3 = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    this.vRAFile.read(byArray, 0, 26);
                    if ((by & 2) == 2) {
                        if (arrayList2 == null) {
                            arrayList2 = new ArrayList<KeyPart>();
                        }
                        arrayList2.add(new KeyPart(c3, c4));
                    } else if (c3 == '\u0000' && c4 == '\u0000') {
                        --n2;
                    } else {
                        boolean bl;
                        boolean bl2 = bl = (by & 1) == 1;
                        if (bl) {
                            this.nDupKeys = (short)(this.nDupKeys + 1);
                        }
                        if (arrayList2 != null) {
                            int n5 = arrayList2.size();
                            KeyPart[] keyPartArray = new KeyPart[n5 + 1];
                            keyPartArray[n5--] = new KeyPart(c3, c4);
                            while (n5 >= 0) {
                                keyPartArray[n5] = (KeyPart)arrayList2.get(n5);
                                --n5;
                            }
                            arrayList.add(new Key(keyPartArray, l3, bl));
                        } else {
                            arrayList.add(new Key(new KeyPart[]{new KeyPart(c3, c4)}, l3, bl));
                        }
                        arrayList2 = null;
                    }
                    n4 += 36;
                    continue;
                }
                if (l2 != 0L) {
                    this.vRAFile.seek(l2 * (long)this.blockSize);
                    c2 = this.vRAFile.readChar();
                    if (c2 != '\u0001') {
                        throw new IOException("Unexpected type: " + c2 + ", offset: " + l2);
                    }
                    l2 = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    n4 = 6;
                    ++this.currBlockNum;
                    --n2;
                    continue;
                }
                throw new IOException("Next header == 0");
            }
            this.keys = new Key[arrayList.size()];
            for (n2 = 0; n2 < this.keys.length; ++n2) {
                this.keys[n2] = (Key)arrayList.get(n2);
            }
            this.nKeys = this.keys.length;
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    public int getErrno() {
        return this.errno;
    }

    public void close() {
        if (this.vRAFile != null) {
            try {
                this.vRAFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public long getValidRecordsNum() {
        return this.validRecordsNum;
    }

    private boolean nextDataBlock() throws IOException {
        while (true) {
            byte by;
            ++this.currBlockNum;
            try {
                this.vRAFile.seek(this.currBlockNum * (long)this.blockSize);
                byte by2 = this.vRAFile.readByte();
                by = this.vRAFile.readByte();
                long l2 = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
            }
            catch (IOException iOException) {
                return false;
            }
            if (by != 6 && by != 7) continue;
            this.currBlockSize = this.vRAFile.readChar() - 10;
            if (this.currBlockSize > 0) break;
        }
        this.currBlockOffs = 0;
        return true;
    }

    private int readRecord(byte[] byArray, int n2, NodeDesc nodeDesc, int n3) {
        int n4;
        int n5 = 0;
        int n6 = 8;
        int n7 = 1;
        while (n6 < nodeDesc.usedSize) {
            int n8 = (int)RMKFile.getNumber(nodeDesc.buffer, n6, 2);
            n6 += 2;
            for (n4 = 0; n4 < this.nDupKeys; ++n4) {
                int n9 = (int)RMKFile.getNumber(nodeDesc.buffer, n6, 4);
                n6 += 4;
            }
            if (n8 == n3) break;
            n6 += (int)RMKFile.getNumber(nodeDesc.buffer, n6, 2);
            n6 += 2;
            ++n7;
        }
        if (n6 < nodeDesc.usedSize) {
            int n10 = (int)RMKFile.getNumber(nodeDesc.buffer, n6, 2);
            n6 += 2;
            if (this.dataCompress == 2) {
                for (n7 = 0; n7 < n10; ++n7) {
                    int n11;
                    if ((n11 = nodeDesc.buffer[n6++] & 0xFF) > 127) {
                        int n12;
                        int n13;
                        if (n11 > 231) {
                            n13 = n11 - 229;
                            n12 = nodeDesc.buffer[n6++];
                            ++n7;
                        } else if (n11 > 211) {
                            n13 = n11 - 210;
                            n12 = 0;
                        } else if (n11 > 191) {
                            n13 = n11 - 190;
                            n12 = 48;
                        } else {
                            n13 = n11 - 126;
                            n12 = 32;
                        }
                        for (n4 = 0; n4 < n13; ++n4) {
                            byArray[n2 + n5++] = n12;
                        }
                        continue;
                    }
                    for (n4 = 0; n4 < n11; ++n4) {
                        byArray[n2 + n5++] = nodeDesc.buffer[n6++];
                    }
                    n7 += n11;
                }
            } else {
                for (n5 = 0; n5 < n10; ++n5) {
                    byArray[n2++] = nodeDesc.buffer[n6++];
                }
            }
        } else {
            this.errno = 105;
            n5 = 0;
        }
        return n5;
    }

    public int readNext(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        this.errno = 0;
        if (this.next == null) {
            if (this.curr == INITIAL) {
                this.start(byArray, n2, 0, 0, 0);
            } else if (this.curr != null) {
                this.next = this.nextKey(this.curr);
            } else {
                this.errno = 112;
                return 0;
            }
        }
        if (this.next == null || this.next.blockNum == 0L) {
            this.errno = 110;
            n4 = 0;
            this.curr = null;
        } else {
            NodeDesc nodeDesc = this.readNode(this.keys[this.currIndex], this.next.blockNum);
            n4 = this.readRecord(byArray, n2, nodeDesc, this.next.blockPos);
            if (n4 >= 0) {
                this.curr = this.next;
                this.next = null;
            }
        }
        return n4;
    }

    public int readNextPh(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5 = 0;
        this.errno = 0;
        if (this.currBlockOffs >= this.currBlockSize && !this.nextDataBlock()) {
            return -1;
        }
        short s2 = this.vRAFile.readShort();
        for (n4 = 0; n4 < this.nDupKeys; ++n4) {
            int n6 = this.vRAFile.readInt();
        }
        int n7 = this.vRAFile.readChar();
        for (n4 = 0; n4 < n7; ++n4) {
            int n8;
            int n9 = this.vRAFile.readByte() & 0xFF;
            if (n9 > 127) {
                int n10;
                int n11;
                if (n9 > 231) {
                    n11 = n9 - 229;
                    n10 = this.vRAFile.readByte();
                    ++n4;
                } else if (n9 > 211) {
                    n11 = n9 - 210;
                    n10 = 0;
                } else if (n9 > 191) {
                    n11 = n9 - 190;
                    n10 = 48;
                } else {
                    n11 = n9 - 126;
                    n10 = 32;
                }
                for (n8 = 0; n8 < n11; ++n8) {
                    byArray[n2 + n5++] = n10;
                }
                continue;
            }
            for (n8 = 0; n8 < n9; ++n8) {
                byArray[n2 + n5++] = this.vRAFile.readByte();
            }
            n4 += n9;
        }
        if (n4 != n7) {
            throw new IOException("Record length doesn't match");
        }
        this.currBlockOffs += 4 + this.nDupKeys * 4;
        this.currBlockOffs += n7;
        return n5;
    }

    private byte[] buildKey(byte[] byArray, Key key) {
        byte[] byArray2 = new byte[key.length];
        int n2 = 0;
        for (int i2 = 0; i2 < key.parts.length; ++i2) {
            System.arraycopy(byArray, key.parts[i2].offset, byArray2, n2, key.parts[i2].length);
            n2 += key.parts[i2].length;
        }
        return byArray2;
    }

    private NodeDesc readNode(Key key, long l2) throws IOException {
        int n2 = key.duplicates ? 4 : 0;
        NodeDesc nodeDesc = new NodeDesc(key, this.blockSize);
        this.vRAFile.seek(l2 * (long)this.blockSize);
        this.vRAFile.read(nodeDesc.buffer, 0, this.blockSize);
        nodeDesc.keyNum = nodeDesc.buffer[0];
        nodeDesc.nodeType = nodeDesc.buffer[1];
        nodeDesc.nextBrot = RMKFile.getNumber(nodeDesc.buffer, 2, 4);
        nodeDesc.usedSize = (int)RMKFile.getNumber(nodeDesc.buffer, 6, 2);
        nodeDesc.branchDepth = (int)RMKFile.getNumber(nodeDesc.buffer, 8, 2);
        return nodeDesc;
    }

    private NodeItemDesc nextKey(NodeItemDesc nodeItemDesc) throws IOException {
        NodeItemDesc nodeItemDesc2 = nodeItemDesc.node.next(nodeItemDesc.index);
        if (nodeItemDesc2 == null && nodeItemDesc.node.nextBrot > 0L) {
            NodeDesc nodeDesc = this.readNode(nodeItemDesc.node.key, nodeItemDesc.node.nextBrot);
            nodeItemDesc2 = nodeDesc.next(0L);
        }
        return nodeItemDesc2;
    }

    private NodeItemDesc findKey(byte[] byArray, long l2, Key key, int n2) throws IOException {
        NodeItemDesc nodeItemDesc = null;
        NodeDesc nodeDesc = this.readNode(key, l2);
        if (nodeDesc.branchDepth != 0) {
            nodeItemDesc = nodeDesc.search(byArray, n2);
            if (nodeItemDesc != null) {
                nodeItemDesc = this.findKey(byArray, nodeItemDesc.blockNum, key, n2);
            }
        } else {
            nodeItemDesc = nodeDesc.search(byArray, n2);
        }
        return nodeItemDesc;
    }

    public int start(byte[] byArray, int n2, int n3, int n4, int n5) throws IOException {
        int n6;
        Key key = this.keys[n3];
        byte[] byArray2 = this.buildKey(byArray, key);
        this.errno = 0;
        this.currIndex = n3;
        NodeItemDesc nodeItemDesc = this.findKey(byArray2, key.root, key, n5);
        if (nodeItemDesc != null) {
            this.next = nodeItemDesc;
            if (n5 == 1 || n5 == 8 || n5 == 9) {
                this.curr = null;
            }
            this.errno = 0;
            n6 = 1;
        } else {
            n6 = 0;
            this.errno = 111;
        }
        return n6;
    }

    String fmt(String string, int n2, boolean bl) {
        int n3 = string.length();
        if (n3 < n2) {
            string = bl ? string + "                                            ".substring(0, n2 - n3) : "                                            ".substring(0, n2 - n3) + string;
        }
        return string;
    }

    String fmt(String string, int n2) {
        return this.fmt(string, n2, false);
    }

    String fmt(long l2, int n2, boolean bl) {
        String string = "" + l2;
        return this.fmt(string, n2, bl);
    }

    String fmt(long l2, int n2) {
        return this.fmt(l2, n2, false);
    }

    public void printInfo() {
        System.out.println(this.vFile.getPath() + "  [RMKF version " + this.vVersion + "]");
        System.out.println("");
        System.out.println("# of records:" + this.fmt(this.numOfRecords, 18));
        System.out.println("file size: " + this.fmt(this.vFile.length(), 20) + " (" + this.vFile.getPath() + ")");
        System.out.println("block size:" + this.fmt(this.blockSize, 20));
        String string = " dataCompress=" + this.dataCompress + " keyCompress=" + this.keyCompress;
        if (this.minRec == this.maxRec) {
            System.out.println("record size:" + this.fmt(this.maxRec, 19) + string);
        } else {
            System.out.println("record size (min/max):" + this.fmt(this.minRec, 9) + "/" + this.maxRec + string);
        }
        System.out.println("# of keys: " + this.fmt(this.nKeys, 20));
        System.out.println("integrity: " + this.fmt(this.integrityFlag, 20));
        System.out.println("");
        System.out.println("Key  Dups    Seg-1     Seg-2     Seg-3     Seg-4     Seg-5     Seg-6");
        System.out.println("            (sz/of)   (sz/of)   (sz/of)   (sz/of)   (sz/of)   (sz/of)");
        System.out.println("");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.nKeys; ++i2) {
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer.append(this.fmt(i2, 3));
            stringBuffer.append(this.fmt(this.keys[i2].duplicates ? "Y" : "N", 5));
            stringBuffer.append("  ");
            for (int i3 = 0; i3 < this.keys[i2].nparts; ++i3) {
                stringBuffer.append(this.fmt(this.keys[i2].parts[i3].length, 3));
                stringBuffer.append("/");
                stringBuffer.append(this.fmt(this.keys[i2].parts[i3].offset, 6, true));
            }
            System.out.println(stringBuffer);
        }
    }

    static class NodeItemDesc {
        long blockNum;
        short blockPos;
        long keyProg;
        short nRepeatedChar;
        short keyValLen;
        int index;
        long nodeAddr;
        byte[] keyVal = new byte[260];
        final NodeDesc node;

        NodeItemDesc(NodeDesc nodeDesc) {
            this.node = nodeDesc;
        }

        NodeItemDesc copy(NodeItemDesc nodeItemDesc) {
            this.blockNum = nodeItemDesc.blockNum;
            this.blockPos = nodeItemDesc.blockPos;
            this.keyProg = nodeItemDesc.keyProg;
            this.nRepeatedChar = nodeItemDesc.nRepeatedChar;
            this.keyValLen = nodeItemDesc.keyValLen;
            this.index = nodeItemDesc.index;
            this.nodeAddr = nodeItemDesc.nodeAddr;
            System.arraycopy(nodeItemDesc.keyVal, 0, this.keyVal, 0, this.keyVal.length);
            return this;
        }
    }

    class NodeDesc {
        short nodeType;
        short keyNum;
        long nextBrot;
        long prevBrot;
        int usedSize;
        int branchDepth;
        int rc;
        short progSize;
        long nodeAddr;
        final Key key;
        final byte[] buffer;

        NodeDesc(Key key, int n2) {
            this.key = key;
            this.buffer = new byte[n2];
        }

        NodeItemDesc next(long l2) {
            NodeItemDesc nodeItemDesc = new NodeItemDesc(this);
            int n2 = 10;
            nodeItemDesc.index = 1;
            while (n2 < this.usedSize) {
                nodeItemDesc.blockNum = RMKFile.getNumber(this.buffer, n2, 4);
                n2 += 4;
                if (this.branchDepth == 0) {
                    nodeItemDesc.blockPos = (short)(this.buffer[n2++] & 0xFF);
                }
                if (this.key.duplicates) {
                    nodeItemDesc.keyProg = RMKFile.getNumber(this.buffer, n2, 4);
                    n2 += 4;
                }
                if (RMKFile.this.keyCompress == 2) {
                    nodeItemDesc.nRepeatedChar = this.buffer[n2++];
                    nodeItemDesc.keyValLen = this.buffer[n2++];
                    n2 += nodeItemDesc.keyValLen;
                } else {
                    n2 += this.key.length;
                }
                if ((long)nodeItemDesc.index > l2) {
                    return nodeItemDesc;
                }
                ++nodeItemDesc.index;
            }
            return null;
        }

        NodeItemDesc search(byte[] byArray, int n2) {
            NodeItemDesc nodeItemDesc = new NodeItemDesc(this);
            NodeItemDesc nodeItemDesc2 = new NodeItemDesc(this);
            int n3 = 10;
            nodeItemDesc2.index = 1;
            while (n3 < this.usedSize) {
                int n4;
                nodeItemDesc2.blockNum = RMKFile.getNumber(this.buffer, n3, 4);
                n3 += 4;
                if (this.branchDepth == 0) {
                    nodeItemDesc2.blockPos = (short)(this.buffer[n3++] & 0xFF);
                }
                if (this.key.duplicates) {
                    nodeItemDesc2.keyProg = RMKFile.getNumber(this.buffer, n3, 4);
                    n3 += 4;
                }
                nodeItemDesc2.nRepeatedChar = this.buffer[n3++];
                nodeItemDesc2.keyValLen = this.buffer[n3++];
                if (nodeItemDesc2.keyValLen > 0) {
                    System.arraycopy(this.buffer, n3, nodeItemDesc2.keyVal, nodeItemDesc2.nRepeatedChar, nodeItemDesc2.keyValLen);
                    n4 = nodeItemDesc2.nRepeatedChar + nodeItemDesc2.keyValLen;
                } else {
                    n4 = nodeItemDesc2.nRepeatedChar;
                }
                int n5 = this.key.length - n4;
                if (n5 > 0) {
                    Arrays.fill(nodeItemDesc2.keyVal, n4, n4 + n5, (byte)32);
                }
                n3 += nodeItemDesc2.keyValLen;
                this.rc = RMKFile.memcmp(nodeItemDesc2.keyVal, 0, byArray, 0, this.key.length);
                switch (n2) {
                    case 9: {
                        if (this.rc <= 0) {
                            nodeItemDesc.copy(nodeItemDesc2);
                            break;
                        }
                        return nodeItemDesc;
                    }
                    case 8: {
                        if (this.rc < 0) {
                            nodeItemDesc.copy(nodeItemDesc2);
                            break;
                        }
                        return nodeItemDesc;
                    }
                    case 7: {
                        if (this.rc < 0) break;
                        return nodeItemDesc2;
                    }
                    case 5: {
                        if (this.branchDepth != 0) {
                            if (this.rc < 0) break;
                            return nodeItemDesc2;
                        }
                        if (this.rc == 0) {
                            return nodeItemDesc2;
                        }
                        if (this.rc <= 0) break;
                        return null;
                    }
                    case 6: {
                        if (this.rc <= 0) break;
                        return nodeItemDesc2;
                    }
                    case 0: {
                        return nodeItemDesc2;
                    }
                    case 1: {
                        nodeItemDesc.copy(nodeItemDesc2);
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                ++nodeItemDesc2.index;
            }
            return nodeItemDesc;
        }
    }

    static class Key {
        final int nparts;
        final long root;
        final boolean duplicates;
        final int length;
        final KeyPart[] parts;

        Key(KeyPart[] keyPartArray, long l2, boolean bl) {
            this.root = l2;
            this.nparts = keyPartArray.length;
            this.parts = keyPartArray;
            this.duplicates = bl;
            int n2 = 0;
            for (int i2 = 0; i2 < this.parts.length; ++i2) {
                n2 += this.parts[i2].length;
            }
            this.length = n2;
        }
    }

    static class KeyPart {
        final int offset;
        final int length;

        KeyPart(int n2, int n3) {
            this.offset = n2;
            this.length = n3;
        }
    }
}

