/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import IT.picosoft.isam.FLock;
import IT.picosoft.isam.IsamException;
import com.iscobol.io.AtEndException;
import com.iscobol.io.BaseRelative;
import com.iscobol.io.CobolFile;
import com.iscobol.io.CobolIOException;
import com.iscobol.io.InvalidKeyException;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.INumericVar;
import com.iscobol.rts.IscobolRuntimeException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;

public class RelativeFile
extends BaseRelative {
    private INumericVar relativeKey;
    private byte[] locBuffer = new byte[this.getBufferLength()];
    private byte[] delBuffer = new byte[this.getBufferLength()];
    private long currRecord;
    private boolean positioned;
    private boolean atBegin;
    private boolean atEnd;
    private Hashtable allLocks;

    public RelativeFile(String string, int n2, ICobolVar iCobolVar, int n3, boolean bl, int n4) {
        super(string, n2, iCobolVar, n3, bl, n4);
    }

    public RelativeFile(String string, int n2, ICobolVar iCobolVar, int n3, boolean bl, int n4, INumericVar iNumericVar) {
        this(string, n2, iCobolVar, n3, bl, n4);
        this.relativeKey = iNumericVar;
    }

    @Override
    public CobolFile relativeKey(INumericVar iNumericVar) {
        this.relativeKey = iNumericVar;
        return this;
    }

    private synchronized void allRecordUnlock() throws IsamException {
        Enumeration enumeration = this.allLocks.elements();
        while (enumeration.hasMoreElements()) {
            FLock fLock = (FLock)enumeration.nextElement();
            fLock.l_type = (short)2;
            this.theFile.fcntl(6, fLock);
        }
        this.allLocks.clear();
    }

    private synchronized void recordUnlockPos(long l2) throws IsamException {
        Long l3 = new Long(l2);
        FLock fLock = (FLock)this.allLocks.get(l3);
        if (fLock != null) {
            fLock.l_type = (short)2;
            this.theFile.fcntl(6, fLock);
            this.allLocks.remove(l3);
        }
    }

    private synchronized void recordLockNum(int n2, long l2, int n3) throws IsamException {
        if (n2 > 0 && !this.exclusiveLock && this.isWritable()) {
            try {
                FLock fLock = new FLock();
                fLock.l_whence = 0;
                fLock.l_start = (l2 - 1L) * (long)n3;
                fLock.l_len = n3;
                fLock.l_type = this.readLock || this.getOpenMode() == 1 ? (short)0 : 1;
                Long l3 = new Long(fLock.l_start);
                FLock fLock2 = (FLock)this.allLocks.get(l3);
                if (fLock2 != null) {
                    if (fLock2.l_type == 0 && fLock.l_type == 1 || fLock2.l_len < fLock.l_len) {
                        this.allLocks.remove(fLock2);
                        this.theFile.fcntl(6, fLock);
                        this.allLocks.put(l3, fLock);
                    }
                } else {
                    if (!this.multipleLock) {
                        this.allRecordUnlock();
                    }
                    this.theFile.fcntl(6, fLock);
                    this.allLocks.put(l3, fLock);
                }
            }
            catch (IsamException isamException) {
                if (isamException.getIserrno() == 113) {
                    throw new IsamException(107);
                }
                throw isamException;
            }
        }
    }

    @Override
    public void peerOpen(String string, int n2, int n3) {
        super.peerOpen(string, n2, n3);
        this.currRecord = 1L;
        this.positioned = true;
        this.atBegin = true;
        this.atEnd = false;
        this.allLocks = new Hashtable();
    }

    private long nextRecNum() {
        if (this.atBegin) {
            return 1L;
        }
        if (this.currRecord <= 0L) {
            return 0L;
        }
        if (this.positioned) {
            return this.currRecord;
        }
        return this.currRecord + 1L;
    }

    private long prevRecNum() {
        if (this.atEnd) {
            try {
                return this.theFile.length() / (long)this.getBufferLength();
            }
            catch (IsamException isamException) {
                CobolIOException.get(RelativeFile.cobolErrno(isamException), "", this, 7);
                return 0L;
            }
        }
        if (this.currRecord <= 0L) {
            return 0L;
        }
        if (this.positioned) {
            return this.currRecord;
        }
        return this.currRecord - 1L;
    }

    private long currRecNum() {
        if (this.atBegin || this.atEnd) {
            return 0L;
        }
        return this.currRecord;
    }

    @Override
    public boolean write(boolean bl, int n2) {
        super.write(bl, n2);
        if (n2 > this.getBufferLength()) {
            n2 = this.getBufferLength();
        }
        try {
            long l2;
            if (this.getOpenMode() == 6) {
                this.theFile.seek(this.theFile.length());
                this.theFile.write(this.getBufferRO(), 0, n2);
                l2 = this.theFile.length() / (long)this.getBufferLength() + 1L;
                if (this.relativeKey != null) {
                    this.relativeKey.set(l2);
                }
            } else {
                l2 = this.relativeKey != null && this.accessMode != 1 ? this.relativeKey.tolong() : this.nextRecNum();
                if (l2 < 1L) {
                    InvalidKeyException.get(139, "", this, 3);
                    return false;
                }
                long l3 = (l2 - 1L) * (long)this.getBufferLength();
                this.theFile.seek(l3);
                int n3 = this.theFile.read(this.locBuffer);
                if (n3 < 0 || Arrays.equals(this.delBuffer, this.locBuffer)) {
                    this.theFile.seek(l3);
                    this.theFile.write(this.getBufferRO(), 0, n2);
                    if (!this.exclusiveLock) {
                        this.recordUnlockPos(l3);
                    }
                } else {
                    InvalidKeyException.get(100, "", this, 3);
                    return false;
                }
            }
            this.currRecord = l2;
            this.positioned = false;
            this.atEnd = false;
            this.atBegin = false;
        }
        catch (IsamException isamException) {
            CobolIOException.get(RelativeFile.cobolErrno(isamException), "", this, 2);
        }
        return false;
    }

    @Override
    public boolean writeAdvancing(int n2, int n3, boolean bl, int n4, int n5) {
        throw new IscobolRuntimeException(3, new IllegalArgumentException("ADVANCING ").toString());
    }

    @Override
    public void rewrite(boolean bl, int n2) {
        super.rewrite(bl, n2);
        try {
            long l2;
            if (this.relativeKey != null && this.accessMode != 1) {
                l2 = this.relativeKey.tolong();
                if (l2 < 1L) {
                    InvalidKeyException.get(139, "", this, 4);
                    return;
                }
            } else {
                l2 = this.currRecNum();
                if (l2 < 1L) {
                    InvalidKeyException.get(143, "", this, 4);
                    return;
                }
            }
            long l3 = (l2 - 1L) * (long)this.getBufferLength();
            this.theFile.seek(l3);
            int n3 = this.theFile.read(this.locBuffer);
            if (n3 >= 0 && !Arrays.equals(this.delBuffer, this.locBuffer)) {
                this.theFile.seek(l3);
                this.theFile.write(this.getBufferRO());
                if (!this.exclusiveLock) {
                    this.recordUnlockPos(l3);
                }
            } else {
                InvalidKeyException.get(111, "", this, 4);
                return;
            }
            this.currRecord = l2;
            this.positioned = false;
            this.atEnd = false;
            this.atBegin = false;
        }
        catch (IsamException isamException) {
            CobolIOException.get(RelativeFile.cobolErrno(isamException), "", this, 2);
        }
    }

    @Override
    public void delete() {
        super.delete();
        try {
            long l2;
            if (this.relativeKey != null && this.accessMode != 1) {
                l2 = this.relativeKey.tolong();
                if (l2 < 1L) {
                    InvalidKeyException.get(139, "", this, 5);
                    return;
                }
            } else {
                l2 = this.currRecNum();
                if (l2 < 1L) {
                    InvalidKeyException.get(143, "", this, 5);
                    return;
                }
            }
            long l3 = (l2 - 1L) * (long)this.getBufferLength();
            this.theFile.seek(l3);
            int n2 = this.theFile.read(this.locBuffer);
            if (n2 < 0 || Arrays.equals(this.delBuffer, this.locBuffer)) {
                InvalidKeyException.get(111, "", this, 5);
                return;
            }
            this.theFile.seek(l3);
            this.theFile.write(this.delBuffer);
            this.currRecord = l2;
            this.positioned = false;
            this.atEnd = false;
            this.atBegin = false;
        }
        catch (IsamException isamException) {
            CobolIOException.get(RelativeFile.cobolErrno(isamException), "", this, 2);
        }
    }

    private int myNext(byte[] byArray, long l2) throws IsamException {
        int n2;
        this.currRecord = l2 < 1L ? 1L : l2;
        long l3 = (this.currRecord - 1L) * (long)byArray.length;
        this.theFile.seek(l3);
        do {
            if ((n2 = this.theFile.read(byArray)) <= 0) continue;
            if (!Arrays.equals(byArray, this.delBuffer)) break;
            l3 = this.currRecord * (long)byArray.length;
            ++this.currRecord;
        } while (n2 > 0);
        return n2;
    }

    private int myPrev(byte[] byArray, long l2) throws IsamException {
        int n2 = 0;
        this.currRecord = l2;
        while (this.currRecord > 0L) {
            long l3 = (this.currRecord - 1L) * (long)byArray.length;
            this.theFile.seek(l3);
            n2 = this.theFile.read(byArray);
            if (!Arrays.equals(byArray, this.delBuffer)) break;
            --this.currRecord;
        }
        if (this.currRecord == 0L) {
            this.currRecord = 1L;
        }
        return n2;
    }

    @Override
    public int readNext(boolean bl, ICobolVar iCobolVar) {
        return this.readNext(bl ? 1 : 0, iCobolVar);
    }

    @Override
    public int readNext(int n2, ICobolVar iCobolVar) {
        int n3 = 0;
        if (n2 != -1) {
            super.readNext(n2 &= this.lockMask, iCobolVar);
        } else {
            super.readNext(n2 &= 0xFFFFFFFF, iCobolVar);
        }
        if (this.theFile == null) {
            AtEndException.get(this, 6);
            return n3;
        }
        if (this.currRecord <= 0L || this.atEnd) {
            CobolIOException.get(112, "", this, 6);
            return n3;
        }
        try {
            byte[] byArray = this.getBufferRO();
            n3 = this.myNext(byArray, this.nextRecNum());
            if (n3 > 0) {
                if (this.relativeKey != null) {
                    this.relativeKey.set(this.currRecord);
                }
                this.recordLockNum(n2, this.currRecord, this.getBufferLength());
                this.updateBuffer(byArray);
                if (iCobolVar != null) {
                    iCobolVar.setUsingMaxLen(byArray);
                }
            } else {
                this.positioned = false;
                this.atBegin = false;
                this.atEnd = true;
                AtEndException.get(this, 6);
                return n3;
            }
            this.positioned = false;
            this.atEnd = false;
            this.atBegin = false;
        }
        catch (IsamException isamException) {
            this.currRecord = 0L;
            this.positioned = false;
            this.atEnd = false;
            this.atBegin = false;
            CobolIOException.get(RelativeFile.cobolErrno(isamException), "", this, 6);
        }
        return n3;
    }

    @Override
    public int readPrev(boolean bl, ICobolVar iCobolVar) {
        return this.readPrev(bl ? 1 : 0, iCobolVar);
    }

    @Override
    public int readPrev(int n2, ICobolVar iCobolVar) {
        int n3 = 0;
        if (n2 != -1) {
            super.readPrev(n2 &= this.lockMask, iCobolVar);
        } else {
            super.readPrev(n2 &= 0xFFFFFFFF, iCobolVar);
        }
        if (this.theFile == null) {
            AtEndException.get(this, 7);
            return n3;
        }
        if (this.currRecord <= 0L || this.atBegin) {
            CobolIOException.get(112, "", this, 7);
        }
        try {
            byte[] byArray = this.getBufferRO();
            n3 = this.myPrev(byArray, this.prevRecNum());
            if (n3 > 0) {
                if (this.relativeKey != null) {
                    this.relativeKey.set(this.currRecord);
                }
                this.recordLockNum(n2, this.currRecord, this.getBufferLength());
                this.updateBuffer(byArray);
                if (iCobolVar != null) {
                    iCobolVar.setUsingMaxLen(byArray);
                }
            } else {
                this.positioned = false;
                this.atEnd = false;
                this.atBegin = true;
                AtEndException.get(this, 7);
                return n3;
            }
            this.positioned = false;
            this.atEnd = false;
            this.atBegin = false;
        }
        catch (IsamException isamException) {
            this.currRecord = 0L;
            this.positioned = false;
            this.atEnd = false;
            this.atBegin = false;
            CobolIOException.get(RelativeFile.cobolErrno(isamException), "", this, 2);
        }
        return n3;
    }

    @Override
    public int readKey(ICobolVar[] iCobolVarArray, boolean bl, ICobolVar iCobolVar) {
        return this.readKey(iCobolVarArray, bl ? 1 : 0, iCobolVar);
    }

    @Override
    public int readKey(ICobolVar[] iCobolVarArray, int n2, ICobolVar iCobolVar) {
        int n3 = 0;
        if (n2 != -1) {
            super.readKey(iCobolVarArray, n2 &= this.lockMask, iCobolVar);
        } else {
            super.readKey(iCobolVarArray, n2 &= 0xFFFFFFFF, iCobolVar);
        }
        if (this.theFile == null) {
            InvalidKeyException.get(111, "", this, 8);
            return n3;
        }
        if (this.relativeKey == null) {
            throw new IscobolRuntimeException(4, this.getLogicName());
        }
        try {
            long l2 = this.relativeKey.tolong();
            this.currRecord = 0L;
            this.positioned = false;
            this.atEnd = false;
            this.atBegin = false;
            if (l2 < 1L) {
                InvalidKeyException.get(111, "", this, 8);
                return n3;
            }
            long l3 = (l2 - 1L) * (long)this.getBufferLength();
            this.theFile.seek(l3);
            n3 = this.theFile.read(this.locBuffer);
            this.recordLockNum(n2, l2, this.getBufferLength());
            if (n3 < 0 || Arrays.equals(this.delBuffer, this.locBuffer)) {
                InvalidKeyException.get(111, "", this, 8);
                return n3;
            }
            this.updateBuffer(this.locBuffer);
            if (iCobolVar != null) {
                iCobolVar.setUsingMaxLen(this.locBuffer);
            }
            this.currRecord = l2;
        }
        catch (IsamException isamException) {
            CobolIOException.get(RelativeFile.cobolErrno(isamException), "", this, 2);
        }
        return n3;
    }

    @Override
    public void start(ICobolVar[] iCobolVarArray, int n2, int n3) {
        super.start(iCobolVarArray, n2, n3);
        if (this.theFile == null) {
            InvalidKeyException.get(111, "", this, 9);
            return;
        }
        this.currRecord = 0L;
        this.positioned = false;
        this.positioned = false;
        this.atEnd = false;
        this.atBegin = false;
        try {
            long l2;
            long l3 = this.theFile.length() / (long)this.getBufferLength();
            if (n2 == 0) {
                l2 = 1L;
            } else if (n2 == 1) {
                l2 = l3;
            } else {
                if (this.relativeKey == null) {
                    throw new IscobolRuntimeException(4, this.getLogicName());
                }
                l2 = this.relativeKey.tolong();
            }
            switch (n2) {
                case 5: {
                    if (l2 < 1L || l2 > l3) {
                        InvalidKeyException.get(111, "", this, 9);
                    }
                    long l4 = (l2 - 1L) * (long)this.getBufferLength();
                    this.theFile.seek(l4);
                    int n4 = this.theFile.read(this.locBuffer);
                    if (n4 >= 0 && !Arrays.equals(this.delBuffer, this.locBuffer)) break;
                    InvalidKeyException.get(111, "", this, 9);
                    return;
                }
                case 6: {
                    ++l2;
                }
                case 7: {
                    if (l2 > l3) {
                        InvalidKeyException.get(111, "", this, 9);
                    } else if (l2 < 1L) {
                        l2 = 1L;
                    }
                    int n5 = this.myNext(this.locBuffer, l2);
                    if (n5 > 0) break;
                    InvalidKeyException.get(111, "", this, 9);
                    break;
                }
                case 8: {
                    --l2;
                }
                case 9: {
                    if (l2 < 1L) {
                        InvalidKeyException.get(111, "", this, 9);
                    } else if (l2 > l3) {
                        l2 = l3;
                    }
                    int n6 = this.myPrev(this.locBuffer, l2);
                    if (n6 > 0) break;
                    InvalidKeyException.get(111, "", this, 9);
                }
            }
            if (this.currRecord < 1L) {
                InvalidKeyException.get(111, "", this, 9);
            }
            this.positioned = true;
            if (this.relativeKey != null) {
                this.relativeKey.set(this.currRecord);
            }
        }
        catch (IsamException isamException) {
            CobolIOException.get(RelativeFile.cobolErrno(isamException), "", this, 2);
        }
    }

    @Override
    public void unlock() {
        super.unlock();
        try {
            this.allRecordUnlock();
        }
        catch (IsamException isamException) {
            CobolIOException.get(RelativeFile.cobolErrno(isamException), "", this, 10);
        }
    }
}

