/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.io.BaseFile;
import com.iscobol.io.MfFile;
import com.iscobol.rts.DynamicFile;
import com.iscobol.rts.KeyDescription;
import com.iscobol.rts.RuntimeErrorsNumbers;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class ScanMF
implements DynamicFile,
RuntimeErrorsNumbers,
Cloneable {
    private MfFile theFile;
    private KeyDescription[] keys;
    private String path = "";
    private int errno;
    private Exception errio = null;

    @Override
    public String getSysErrno() {
        if (this.errio != null) {
            return this.errio.getMessage();
        }
        return "";
    }

    @Override
    public String getErrMsg() {
        if (this.errio != null) {
            return this.errio.getMessage();
        }
        return "";
    }

    @Override
    public int getCobErrno() {
        return this.errno;
    }

    private int mapError(int n2) {
        this.errno = n2;
        return 0;
    }

    @Override
    public synchronized long getNumRecords() {
        if (this.theFile != null) {
            return this.theFile.getValidRecordsNum();
        }
        return -1L;
    }

    @Override
    public synchronized int getNumKeys() {
        int n2;
        if (this.keys != null) {
            n2 = this.keys.length;
        } else if (this.theFile != null) {
            n2 = this.theFile.nKeys;
            this.keys = new KeyDescription[n2];
        } else {
            n2 = -1;
        }
        return n2;
    }

    @Override
    public int getMaxRecordSize() {
        if (this.theFile != null) {
            return this.theFile.maxRec;
        }
        return -1;
    }

    @Override
    public int getMinRecordSize() {
        if (this.theFile != null) {
            return this.theFile.minRec;
        }
        return -1;
    }

    @Override
    public synchronized KeyDescription getKey(int n2) {
        KeyDescription keyDescription = null;
        if (this.theFile != null && n2 >= 0 && n2 < this.getNumKeys()) {
            if (this.keys[n2] == null) {
                this.keys[n2] = new KeyDescription(this.theFile.keys[n2].nparts, this.theFile.keys[n2].duplicates);
                for (int i2 = 0; i2 < this.theFile.keys[n2].nparts; ++i2) {
                    this.keys[n2].setSegment(i2, ((MfFile.KeyPart)this.theFile.keys[n2].parts.get((int)i2)).length, ((MfFile.KeyPart)this.theFile.keys[n2].parts.get((int)i2)).offset);
                }
            }
            keyDescription = this.keys[n2];
        } else {
            keyDescription = null;
            this.mapError(102);
        }
        return keyDescription;
    }

    @Override
    public byte[] getSequence() {
        if (this.theFile != null) {
            return this.theFile.getSequence();
        }
        return null;
    }

    @Override
    public int build(String string, String string2, int n2, int n3, int n4, int n5, int n6, int n7, int n8, KeyDescription[] keyDescriptionArray, byte[] byArray, boolean bl) {
        return this.mapError(126);
    }

    @Override
    public synchronized int open(String string, int n2, int n3, KeyDescription[] keyDescriptionArray, int n4, int n5, int n6, int n7, boolean bl, boolean bl2) {
        this.path = string;
        if (bl2) {
            this.path = BaseFile.expandFileName(this.path);
        }
        try {
            this.theFile = new MfFile(this.path);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (new File(this.path).exists()) {
                return this.mapError(131);
            }
            return this.mapError(130);
        }
        catch (IOException iOException) {
            this.errio = iOException;
            return this.mapError(133);
        }
        if (this.theFile.compressed) {
            this.close();
            return this.mapError(126);
        }
        return 1;
    }

    @Override
    public synchronized void setCurrentRecord(long l2) {
    }

    @Override
    public synchronized long getCurrentRecord() {
        return this.mapError(126);
    }

    @Override
    public String getDescription() {
        return this.path;
    }

    @Override
    public synchronized int close() {
        if (this.theFile != null) {
            this.theFile.close();
            this.theFile = null;
            this.keys = null;
            this.path = "";
        }
        return 1;
    }

    @Override
    public boolean isOpen() {
        return this.theFile != null;
    }

    @Override
    public synchronized long write(byte[] byArray, int n2, int n3, boolean bl) {
        return this.mapError(126);
    }

    @Override
    public synchronized long rewrite(byte[] byArray, int n2, int n3, boolean bl) {
        return this.mapError(126);
    }

    @Override
    public synchronized long delete(byte[] byArray, int n2) {
        return this.mapError(126);
    }

    @Override
    public synchronized long next(byte[] byArray, int n2, int n3) {
        int n4;
        if (this.theFile != null) {
            n4 = this.theFile.readNext(byArray, n2, byArray.length - n2);
            if (n4 < 0) {
                n4 = this.mapError(110);
            }
        } else {
            n4 = this.mapError(101);
        }
        return n4;
    }

    @Override
    public synchronized long previous(byte[] byArray, int n2, int n3) {
        return this.mapError(126);
    }

    @Override
    public long read(byte[] byArray, int n2, KeyDescription keyDescription, int n3) {
        return this.mapError(126);
    }

    @Override
    public long read(byte[] byArray, int n2, int n3, int n4) {
        return this.mapError(126);
    }

    @Override
    public long start(byte[] byArray, int n2, int n3, int n4, int n5) {
        return this.mapError(126);
    }

    @Override
    public long start(byte[] byArray, int n2, KeyDescription keyDescription, int n3, int n4) {
        return this.mapError(126);
    }

    @Override
    public synchronized int unlock() {
        return this.mapError(126);
    }

    @Override
    public synchronized int recover() {
        return this.mapError(126);
    }

    @Override
    public void sync(int n2) {
    }

    @Override
    public int remove(String string) {
        return this.mapError(126);
    }

    @Override
    public int rename(String string, String string2) {
        return this.mapError(126);
    }

    @Override
    public int begin() {
        return 1;
    }

    @Override
    public int commit(int n2) {
        return 1;
    }

    @Override
    public int rollback() {
        return 1;
    }

    @Override
    public String getVersion() {
        return "VisionScan v" + this.theFile.mfVersion;
    }

    @Override
    public boolean isKeySelectedByNum() {
        return true;
    }

    public void finalize() {
        this.close();
    }

    public static void main(String[] stringArray) throws Exception {
        MfFile mfFile = new MfFile(stringArray[0]);
        mfFile.printInfo();
    }
}

