/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.io.BaseFile;
import com.iscobol.io.RMKFile;
import com.iscobol.rts.DynamicFile;
import com.iscobol.rts.KeyDescription;
import com.iscobol.rts.RuntimeErrorsNumbers;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class ScanRMKF
implements DynamicFile,
RuntimeErrorsNumbers,
Cloneable {
    private RMKFile theFile;
    private KeyDescription[] keys;
    private String path = "";
    private int errno;
    private Exception errio = null;

    @Override
    public String getSysErrno() {
        if (this.errio != null) {
            return this.errio.getMessage();
        }
        return "";
    }

    @Override
    public String getErrMsg() {
        if (this.errio != null) {
            return this.errio.getMessage();
        }
        return "";
    }

    @Override
    public int getCobErrno() {
        return this.errno;
    }

    private int mapError(int n2) {
        this.errno = n2;
        return 0;
    }

    private int success() {
        this.errno = 0;
        return 1;
    }

    @Override
    public synchronized long getNumRecords() {
        if (this.theFile != null) {
            return this.theFile.getValidRecordsNum();
        }
        return -1L;
    }

    @Override
    public synchronized int getNumKeys() {
        int n2;
        if (this.keys != null) {
            n2 = this.keys.length;
        } else if (this.theFile != null) {
            n2 = this.theFile.nKeys;
            this.keys = new KeyDescription[n2];
        } else {
            n2 = -1;
        }
        return n2;
    }

    @Override
    public int getMaxRecordSize() {
        if (this.theFile != null) {
            return this.theFile.maxRec;
        }
        return -1;
    }

    @Override
    public int getMinRecordSize() {
        if (this.theFile != null) {
            return this.theFile.minRec;
        }
        return -1;
    }

    @Override
    public synchronized KeyDescription getKey(int n2) {
        KeyDescription keyDescription;
        if (this.theFile != null && n2 >= 0 && n2 < this.getNumKeys()) {
            if (this.keys[n2] == null) {
                this.keys[n2] = new KeyDescription(this.theFile.keys[n2].nparts, this.theFile.keys[n2].duplicates);
                for (int i2 = 0; i2 < this.theFile.keys[n2].nparts; ++i2) {
                    this.keys[n2].setSegment(i2, this.theFile.keys[n2].parts[i2].length, this.theFile.keys[n2].parts[i2].offset);
                }
            }
            keyDescription = this.keys[n2];
        } else {
            keyDescription = null;
            this.mapError(102);
        }
        return keyDescription;
    }

    @Override
    public byte[] getSequence() {
        return null;
    }

    @Override
    public int build(String string, String string2, int n2, int n3, int n4, int n5, int n6, int n7, int n8, KeyDescription[] keyDescriptionArray, byte[] byArray, boolean bl) {
        return this.mapError(126);
    }

    @Override
    public synchronized int open(String string, int n2, int n3, KeyDescription[] keyDescriptionArray, int n4, int n5, int n6, int n7, boolean bl, boolean bl2) {
        this.path = string;
        if (bl2) {
            this.path = BaseFile.expandFileName(this.path);
        }
        try {
            this.theFile = new RMKFile(this.path);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (new File(this.path).exists()) {
                return this.mapError(131);
            }
            return this.mapError(130);
        }
        catch (IOException iOException) {
            this.errio = iOException;
            return this.mapError(133);
        }
        return this.success();
    }

    @Override
    public synchronized void setCurrentRecord(long l2) {
    }

    @Override
    public synchronized long getCurrentRecord() {
        return this.mapError(126);
    }

    @Override
    public String getDescription() {
        return this.path;
    }

    @Override
    public synchronized int close() {
        if (this.theFile != null) {
            this.theFile.close();
            this.theFile = null;
            this.keys = null;
            this.path = "";
        }
        return this.success();
    }

    @Override
    public boolean isOpen() {
        return this.theFile != null;
    }

    @Override
    public synchronized long write(byte[] byArray, int n2, int n3, boolean bl) {
        return this.mapError(126);
    }

    @Override
    public synchronized long rewrite(byte[] byArray, int n2, int n3, boolean bl) {
        return this.mapError(126);
    }

    @Override
    public synchronized long delete(byte[] byArray, int n2) {
        return this.mapError(126);
    }

    @Override
    public synchronized long next(byte[] byArray, int n2, int n3) {
        int n4;
        if (this.theFile != null) {
            try {
                n4 = this.theFile.readNext(byArray, n2, byArray.length - n2);
            }
            catch (IOException iOException) {
                n4 = this.mapError(105);
            }
            if (n4 <= 0) {
                n4 = this.mapError(this.theFile.getErrno());
            } else {
                this.success();
            }
        } else {
            n4 = this.mapError(101);
        }
        return n4;
    }

    private int findKey(KeyDescription keyDescription) {
        int n2;
        int n3 = this.getNumKeys();
        try {
            for (n2 = 0; n2 < n3 && !keyDescription.equals(this.getKey(n2)); ++n2) {
            }
        }
        catch (NullPointerException nullPointerException) {
            n2 = -1;
        }
        return n2;
    }

    @Override
    public synchronized long previous(byte[] byArray, int n2, int n3) {
        return this.mapError(126);
    }

    @Override
    public long read(byte[] byArray, int n2, KeyDescription keyDescription, int n3) {
        return this.read(byArray, n2, this.findKey(keyDescription), n3);
    }

    @Override
    public long read(byte[] byArray, int n2, int n3, int n4) {
        long l2 = this.start(byArray, n2, n3, 0, 5);
        if (l2 == 1L) {
            l2 = this.next(byArray, n2, n4);
        }
        return l2;
    }

    @Override
    public long start(byte[] byArray, int n2, int n3, int n4, int n5) {
        try {
            int n6 = this.theFile.start(byArray, n2, n3, n4, n5);
            if (n6 != 1) {
                return this.mapError(this.theFile.getErrno());
            }
            return this.success();
        }
        catch (IOException iOException) {
            return this.mapError(133);
        }
    }

    @Override
    public long start(byte[] byArray, int n2, KeyDescription keyDescription, int n3, int n4) {
        return this.start(byArray, n2, this.findKey(keyDescription), n3, n4);
    }

    @Override
    public synchronized int unlock() {
        return this.mapError(126);
    }

    @Override
    public synchronized int recover() {
        return this.mapError(126);
    }

    @Override
    public void sync(int n2) {
    }

    @Override
    public int remove(String string) {
        return this.mapError(126);
    }

    @Override
    public int rename(String string, String string2) {
        return this.mapError(126);
    }

    @Override
    public int begin() {
        return this.success();
    }

    @Override
    public int commit(int n2) {
        return this.success();
    }

    @Override
    public int rollback() {
        return this.success();
    }

    @Override
    public String getVersion() {
        return "VisionScan v" + this.theFile.vVersion;
    }

    @Override
    public boolean isKeySelectedByNum() {
        return true;
    }

    public void finalize() {
        this.close();
    }

    public static void main(String[] stringArray) throws Exception {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            ScanRMKF scanRMKF = new ScanRMKF();
            scanRMKF.open(stringArray[i2], 0, 0, null, 0, 0, 0, 0, false, false);
            if (scanRMKF.theFile != null) {
                scanRMKF.theFile.printInfo();
            }
            if (scanRMKF.getCobErrno() != 0) {
                System.out.println(stringArray[i2] + " error=" + scanRMKF.getCobErrno() + ", sys=" + scanRMKF.getSysErrno() + ", msg=" + scanRMKF.getErrMsg());
                continue;
            }
            byte[] byArray = new byte[scanRMKF.getMaxRecordSize()];
            for (int i3 = 0; i3 < scanRMKF.theFile.nKeys; ++i3) {
                long l2;
                scanRMKF.start(byArray, 0, i3, 0, 0);
                int n2 = 0;
                while ((l2 = scanRMKF.next(byArray, 0, byArray.length)) > 0L) {
                    ++n2;
                }
                System.out.println(">>>found " + n2 + " out of " + scanRMKF.getNumRecords());
                System.out.println(">>>exit=" + scanRMKF.getCobErrno());
            }
            scanRMKF.close();
        }
    }

    public static String recToString(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            cArray[i2] = byArray[i2] >= 32 && byArray[i2] <= 127 ? (int)byArray[i2] : 46;
        }
        return new String(cArray);
    }
}

