/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.io.AtEndException;
import com.iscobol.io.BaseFile;
import com.iscobol.io.CobolIOException;
import com.iscobol.rts.Config;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IscobolRuntimeException;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;

public class StringFile
extends BaseFile {
    private static final char[] eol = System.getProperty("line.separator", "\n").toCharArray();
    private ICobolVar varString;
    private StringWriter outFile;
    private StringReader inpFile;
    private boolean lineSeq;
    private int minRecSize;
    private int maxRecSize;
    private boolean stripTrailingSpace;

    public StringFile(String string, ICobolVar iCobolVar, int n2, boolean bl, ICobolVar iCobolVar2, boolean bl2) {
        this(string, 0, iCobolVar, n2, bl, iCobolVar2, bl2);
    }

    public StringFile(String string, int n2, ICobolVar iCobolVar, int n3, boolean bl, ICobolVar iCobolVar2, boolean bl2) {
        super(string, n2, iCobolVar, n3, bl, 1);
        this.varString = iCobolVar2;
        this.lineSeq = bl2;
    }

    private int calcLen() {
        int n2;
        char[] cArray = this.getBufferAsChars();
        for (n2 = cArray.length - 1; n2 >= this.minRecSize && cArray[n2] == ' '; --n2) {
        }
        return n2 + 1;
    }

    @Override
    public void peerOpen(String string, int n2, int n3) {
        this.stripTrailingSpace = Config.a(".file.strip_trailing_spaces", ".strip_trailing_spaces", false);
        if (this.stripTrailingSpace) {
            this.minRecSize = Config.a(".file.min_rec_size", ".min_rec_size", 1);
            if (this.minRecSize < 0) {
                this.minRecSize = 0;
            }
        }
        if (this.varString == null) {
            CobolIOException.get(130, "", this, 1);
        }
        switch (n2) {
            case 3: {
                CobolIOException.get(142, "", this, 1);
                break;
            }
            case 2: 
            case 6: {
                this.outFile = new StringWriter();
                break;
            }
            case 1: {
                this.inpFile = new StringReader(this.varString.toString());
                break;
            }
            default: {
                throw new IscobolRuntimeException(3, new IllegalArgumentException("OPEN").toString());
            }
        }
        this.setOpenMode(n2);
    }

    @Override
    protected void peerClose(int n2) {
        if (this.inpFile != null) {
            this.inpFile.close();
            this.inpFile = null;
        } else if (this.outFile != null) {
            try {
                this.outFile.close();
                this.varString.set(this.outFile.toString());
                this.outFile = null;
            }
            catch (IOException iOException) {
                CobolIOException.get(iOException, this, 2);
            }
        }
        this.setOpenMode(0);
    }

    @Override
    public boolean write(boolean bl, int n2) {
        super.write(bl, n2);
        try {
            if (this.stripTrailingSpace) {
                this.outFile.write(this.getBufferAsChars(), 0, this.calcLen());
            } else {
                this.outFile.write(this.getBufferAsChars(), 0, n2);
            }
            if (this.lineSeq) {
                this.outFile.write(eol);
            }
        }
        catch (IOException iOException) {
            CobolIOException.get(iOException, this, 3);
        }
        return false;
    }

    @Override
    public boolean writeAdvancing(int n2, int n3, boolean bl, int n4, int n5) {
        return false;
    }

    @Override
    public int readNext(int n2, ICobolVar iCobolVar) {
        int n3 = 0;
        super.readNext(n2, iCobolVar);
        try {
            byte[] byArray;
            char[] cArray = new char[this.getBufferLength()];
            if (this.lineSeq) {
                int n4;
                int n5;
                for (n5 = 0; n5 < cArray.length; ++n5) {
                    n4 = this.inpFile.read();
                    if (n4 < 0) {
                        if (n5 != 0) break;
                        AtEndException.get(this, 6);
                        return n3;
                    }
                    if (n4 == 10) {
                        if (n5 <= 0 || cArray[n5 - 1] != '\r') break;
                        --n5;
                        break;
                    }
                    cArray[n5] = (char)n4;
                }
                if (n5 == cArray.length) {
                    this.inpFile.mark(2);
                    n4 = this.inpFile.read();
                    switch (n4) {
                        case 13: {
                            if (this.inpFile.read() == 10) break;
                            this.inpFile.reset();
                            break;
                        }
                        case -1: 
                        case 10: {
                            break;
                        }
                        default: {
                            this.inpFile.reset();
                        }
                    }
                }
                byArray = new String(cArray, 0, n5).getBytes();
            } else {
                n3 = this.inpFile.read(cArray, 0, this.getBufferLength());
                if (n3 <= 0) {
                    AtEndException.get(this, 6);
                    return n3;
                }
                byArray = new String(cArray).getBytes();
            }
            n3 = byArray.length;
            this.updateBuffer(byArray);
            if (iCobolVar != null) {
                iCobolVar.setUsingMaxLen(byArray);
            }
        }
        catch (IOException iOException) {
            CobolIOException.get(iOException, this, 6);
        }
        return n3;
    }

    @Override
    public void deleteFile(ICobolVar iCobolVar) {
        super.deleteFile(iCobolVar);
        if (this.varString == null) {
            CobolIOException.get(203, "", this, 11);
        } else {
            this.varString.set("");
        }
    }

    @Override
    public void rewrite(boolean bl, int n2) {
        if (this.getOpenMode() != 0) {
            CobolIOException.get(101, "01", this, 4);
        } else {
            CobolIOException.get(101, "02", this, 4);
        }
    }

    @Override
    public void delete() {
        if (this.getOpenMode() != 0) {
            CobolIOException.get(101, "01", this, 5);
        } else {
            CobolIOException.get(101, "02", this, 5);
        }
    }

    @Override
    public int readPrev(boolean bl, ICobolVar iCobolVar) {
        throw new IscobolRuntimeException(4, this.getLogicName());
    }

    @Override
    public int readKey(ICobolVar[] iCobolVarArray, boolean bl, ICobolVar iCobolVar) {
        throw new IscobolRuntimeException(4, this.getLogicName());
    }

    @Override
    public void start(ICobolVar[] iCobolVarArray, int n2, int n3) {
        throw new IscobolRuntimeException(4, this.getLogicName());
    }
}

