/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

class VisionFile {
    private final String idxExt = ".vix";
    private File vFile;
    private RandomAccessFile vRAFile;
    final char vVersion;
    private final int blockingFactor;
    private final int blockSize;
    private final int blockSize_4;
    final long numOfRecords;
    private final long deletedRecords;
    private final long totOpens;
    private final long userCount;
    private final long segmentSize;
    final int maxRec;
    final int minRec;
    final int nKeys;
    final Key[] keys;
    private final boolean compressed;
    private boolean hasDuplicates;
    private byte[] buffer;
    private final byte[] node;
    private final byte[] dummyInt = new byte[4];
    private int nodePnt;
    private long validRecordsNum;
    private long deletedRecordsNum;
    private final String fName;
    private final int nDataSegments;
    private int currDataSegment;
    private final long firstDataBlock;
    final byte[] collatingSequence;
    private final String blanks = "                                            ";

    private static final long readInt48(RandomAccessFile randomAccessFile) throws IOException {
        long l2 = randomAccessFile.readChar();
        long l3 = (long)randomAccessFile.readInt() & 0xFFFFFFFFL;
        return l3 |= l2 << 32;
    }

    public VisionFile(String string) throws IOException {
        int n2 = string.lastIndexOf(46);
        this.fName = n2 > 0 && !new File(string + ".vix").exists() ? string.substring(0, n2) : string;
        this.vFile = new File(string);
        this.vRAFile = new RandomAccessFile(this.vFile, "r");
        try {
            int n3 = this.vRAFile.readInt();
            if (n3 != 269620246 && n3 != 269620249) {
                throw new IOException("Unrecognized Vision file!");
            }
            this.vVersion = this.vRAFile.readChar();
            this.blockingFactor = this.vRAFile.readChar();
            this.blockSize = this.blockingFactor * 512;
            this.blockSize_4 = this.blockSize - 4;
            switch (this.vVersion) {
                case '\u0003': {
                    this.node = new byte[this.blockSize];
                    this.nDataSegments = 0;
                    this.vRAFile.seek(24L);
                    this.firstDataBlock = (long)this.vRAFile.readInt() & 0xFFFFFFFEL;
                    this.vRAFile.seek(40L);
                    this.numOfRecords = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    this.deletedRecords = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    this.totOpens = 0L;
                    this.vRAFile.seek(56L);
                    long l2 = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    if (l2 != 0L) {
                        this.collatingSequence = new byte[256];
                        this.vRAFile.seek(l2 + 16L);
                        this.vRAFile.read(this.collatingSequence);
                    } else {
                        this.collatingSequence = null;
                    }
                    this.vRAFile.seek(64L);
                    this.userCount = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    this.segmentSize = 0L;
                    this.vRAFile.seek(96L);
                    this.maxRec = this.vRAFile.readChar();
                    this.minRec = this.vRAFile.readChar();
                    this.buffer = new byte[this.maxRec];
                    this.nKeys = this.vRAFile.readByte() & 0xFF;
                    this.keys = new Key[this.nKeys];
                    int n4 = 1;
                    boolean bl = this.compressed = (this.vRAFile.readByte() & 0xFF) != 0;
                    if ((this.vRAFile.readByte() & 0xFF) != 0) {
                        throw new IOException("Unsupported feature: encryption");
                    }
                    int n5 = 160;
                    int n6 = 32;
                    for (int i2 = 0; i2 < this.nKeys; ++i2) {
                        int n7 = n5 + n6 * i2;
                        int n8 = (n7 + n6) % 512;
                        if (n8 != 0 && n8 <= n6) {
                            n5 = n4 * 512;
                            ++n4;
                            n5 -= n6 * i2;
                        }
                        this.vRAFile.seek(n5 + n6 * i2);
                        int n9 = this.vRAFile.readByte() & 0xFF;
                        int n10 = this.vRAFile.readInt();
                        int n11 = this.vRAFile.readByte() & 0xFF;
                        boolean bl2 = this.vRAFile.readByte() != 0;
                        this.hasDuplicates |= bl2;
                        int n12 = this.vRAFile.readByte() & 0xFF;
                        this.keys[i2] = new Key(n11, bl2, n12, 0);
                        for (int i3 = 0; i3 < n11; ++i3) {
                            short s2 = (short)(this.vRAFile.readByte() & 0xFF);
                            short s3 = (short)(this.vRAFile.readByte() & 0xFF);
                            char c2 = this.vRAFile.readChar();
                            this.keys[i2].parts[i3] = new KeyPart(c2, s3);
                        }
                    }
                    if (this.firstDataBlock > 0L) {
                        this.vRAFile.seek(this.firstDataBlock);
                        break;
                    }
                    this.vRAFile.seek(this.vRAFile.length());
                    break;
                }
                case '\u0004': {
                    this.node = null;
                    this.vRAFile.seek(16L);
                    this.nDataSegments = this.vRAFile.readShort();
                    this.vRAFile.seek(30L);
                    this.firstDataBlock = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    this.vRAFile.seek(52L);
                    this.numOfRecords = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    this.deletedRecords = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    this.vRAFile.seek(64L);
                    this.totOpens = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    this.vRAFile.seek(68L);
                    long l3 = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    if (l3 != 0L) {
                        this.collatingSequence = new byte[256];
                        this.vRAFile.seek(l3 + 16L);
                        this.vRAFile.read(this.collatingSequence);
                    } else {
                        this.collatingSequence = null;
                    }
                    this.vRAFile.seek(76L);
                    this.userCount = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    this.vRAFile.seek(102L);
                    this.segmentSize = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    this.vRAFile.seek(116L);
                    this.maxRec = this.vRAFile.readChar();
                    this.minRec = this.vRAFile.readChar();
                    this.buffer = new byte[this.maxRec];
                    this.nKeys = this.vRAFile.readByte() & 0xFF;
                    this.keys = new Key[this.nKeys];
                    int n13 = 1;
                    boolean bl = this.compressed = (this.vRAFile.readByte() & 0xFF) != 0;
                    if ((this.vRAFile.readByte() & 0xFF) != 0) {
                        throw new IOException("Unsupported feature: encryption");
                    }
                    int n14 = 160;
                    int n15 = 59;
                    for (int i4 = 0; i4 < this.nKeys; ++i4) {
                        int n16 = n14 + n15 * i4;
                        int n17 = (n16 + n15) % 512;
                        if (n17 != 0 && n17 <= n15) {
                            n14 = n13 * 512;
                            ++n13;
                            n14 -= n15 * i4;
                        }
                        this.vRAFile.seek(n14 + n15 * i4);
                        int n18 = this.vRAFile.readByte() & 0xFF;
                        char c3 = this.vRAFile.readChar();
                        int n19 = this.vRAFile.readInt();
                        int n20 = this.vRAFile.readByte() & 0xFF;
                        boolean bl3 = this.vRAFile.readByte() != 0;
                        this.hasDuplicates |= bl3;
                        int n21 = this.vRAFile.readByte() & 0xFF;
                        short s4 = (short)(this.vRAFile.readByte() & 0xFF);
                        this.keys[i4] = new Key(n20, bl3, n21, s4);
                        for (int i5 = 0; i5 < n20; ++i5) {
                            short s5 = (short)(this.vRAFile.readByte() & 0xFF);
                            char c4 = this.vRAFile.readChar();
                            this.keys[i4].parts[i5] = new KeyPart(c4, s5);
                        }
                    }
                    if (this.firstDataBlock > 0L) {
                        this.vRAFile.seek(this.firstDataBlock);
                        break;
                    }
                    this.vRAFile.seek(this.vRAFile.length());
                    break;
                }
                case '\u0005': {
                    this.vRAFile.seek(20L);
                    this.nDataSegments = this.vRAFile.readShort();
                    this.node = null;
                    this.vRAFile.seek(34L);
                    this.firstDataBlock = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    this.vRAFile.seek(62L);
                    this.numOfRecords = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    this.deletedRecords = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    this.vRAFile.seek(82L);
                    long l4 = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    if (l4 != 0L) {
                        this.collatingSequence = new byte[256];
                        this.vRAFile.seek(l4 + 16L);
                        this.vRAFile.read(this.collatingSequence);
                    } else {
                        this.collatingSequence = null;
                    }
                    this.vRAFile.seek(92L);
                    this.userCount = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    this.totOpens = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    this.vRAFile.seek(122L);
                    this.segmentSize = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    this.vRAFile.seek(149L);
                    this.maxRec = this.vRAFile.readInt();
                    this.minRec = this.vRAFile.readInt();
                    this.buffer = new byte[this.maxRec];
                    this.nKeys = this.vRAFile.readByte() & 0xFF;
                    this.keys = new Key[this.nKeys];
                    int n22 = 1;
                    boolean bl = this.compressed = (this.vRAFile.readByte() & 0xFF) != 0;
                    if ((this.vRAFile.readByte() & 0xFF) != 0) {
                        throw new IOException("Unsupported feature: encryption");
                    }
                    int n23 = 194;
                    int n24 = 106;
                    for (int i6 = 0; i6 < this.nKeys; ++i6) {
                        int n25 = n23 + n24 * i6;
                        int n26 = (n25 + n24) % this.blockSize;
                        if (n26 != 0 && n26 <= n24) {
                            n23 = n22 * this.blockSize;
                            ++n22;
                            n23 -= n24 * i6;
                        }
                        if (this.vRAFile.getFilePointer() < (long)(n23 + n24 * i6)) {
                            this.vRAFile.seek(n23 + n24 * i6);
                        }
                        int n27 = this.vRAFile.readByte() & 0xFF;
                        char c5 = this.vRAFile.readChar();
                        int n28 = this.vRAFile.readInt();
                        int n29 = this.vRAFile.readByte() & 0xFF;
                        while (n29 == 0) {
                            n29 = this.vRAFile.readByte() & 0xFF;
                        }
                        byte by = this.vRAFile.readByte();
                        while (by != 0 && by != 1) {
                            by = this.vRAFile.readByte();
                        }
                        boolean bl4 = by != 0;
                        this.hasDuplicates |= bl4;
                        int n30 = this.vRAFile.readByte() & 0xFF;
                        this.keys[i6] = new Key(n29, bl4, n30, 0);
                        for (int i7 = 0; i7 < n29; ++i7) {
                            short s6 = (short)(this.vRAFile.readByte() & 0xFF);
                            short s7 = (short)(this.vRAFile.readByte() & 0xFF);
                            int n31 = this.vRAFile.readInt();
                            this.keys[i6].parts[i7] = new KeyPart(n31, s7);
                        }
                    }
                    if (this.firstDataBlock > 0L) {
                        this.vRAFile.seek(this.firstDataBlock);
                        break;
                    }
                    this.vRAFile.seek(this.vRAFile.length());
                    break;
                }
                case '\u0006': {
                    this.vRAFile.seek(20L);
                    this.nDataSegments = this.vRAFile.readShort();
                    this.node = null;
                    this.vRAFile.seek(34L);
                    this.firstDataBlock = VisionFile.readInt48(this.vRAFile);
                    this.vRAFile.seek(62L);
                    this.numOfRecords = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    this.deletedRecords = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    this.vRAFile.seek(82L);
                    long l5 = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    if (l5 != 0L) {
                        this.collatingSequence = new byte[256];
                        this.vRAFile.seek(l5 + 16L);
                        this.vRAFile.read(this.collatingSequence);
                    } else {
                        this.collatingSequence = null;
                    }
                    this.vRAFile.seek(92L);
                    this.userCount = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    this.totOpens = VisionFile.readInt48(this.vRAFile);
                    this.vRAFile.seek(122L);
                    this.segmentSize = 0L;
                    this.vRAFile.seek(134L);
                    this.maxRec = this.vRAFile.readInt();
                    this.minRec = this.vRAFile.readInt();
                    this.buffer = new byte[this.maxRec];
                    this.nKeys = this.vRAFile.readByte() & 0xFF;
                    this.keys = new Key[this.nKeys];
                    int n32 = 1;
                    boolean bl = this.compressed = (this.vRAFile.readByte() & 0xFF) != 0;
                    if ((this.vRAFile.readByte() & 0xFF) != 0) {
                        throw new IOException("Unsupported feature: encryption");
                    }
                    int n33 = 178;
                    int n34 = 106;
                    for (int i8 = 0; i8 < this.nKeys; ++i8) {
                        int n35 = n33 + n34 * i8;
                        int n36 = (n35 + n34) % this.blockSize;
                        if (n36 != 0 && n36 <= n34) {
                            n33 = n32 * this.blockSize;
                            ++n32;
                            n33 -= n34 * i8;
                        }
                        if (this.vRAFile.getFilePointer() < (long)(n33 + n34 * i8)) {
                            this.vRAFile.seek(n33 + n34 * i8);
                        }
                        int n37 = this.vRAFile.readByte() & 0xFF;
                        int n38 = this.vRAFile.readInt();
                        char c6 = this.vRAFile.readChar();
                        int n39 = this.vRAFile.readByte() & 0xFF;
                        while (n39 == 0) {
                            n39 = this.vRAFile.readByte() & 0xFF;
                        }
                        byte by = this.vRAFile.readByte();
                        while (by != 0 && by != 1) {
                            by = this.vRAFile.readByte();
                        }
                        boolean bl5 = by != 0;
                        this.hasDuplicates |= bl5;
                        int n40 = this.vRAFile.readByte() & 0xFF;
                        this.keys[i8] = new Key(n39, bl5, n40, 0);
                        for (int i9 = 0; i9 < n39; ++i9) {
                            short s8 = (short)(this.vRAFile.readByte() & 0xFF);
                            short s9 = (short)(this.vRAFile.readByte() & 0xFF);
                            int n41 = this.vRAFile.readInt();
                            this.keys[i8].parts[i9] = new KeyPart(n41, s9);
                        }
                    }
                    if (this.firstDataBlock > 0L) {
                        this.vRAFile.seek(this.firstDataBlock);
                        break;
                    }
                    this.vRAFile.seek(this.vRAFile.length());
                    break;
                }
                default: {
                    throw new IOException("Vision version " + this.vVersion + " is not supported yet");
                }
            }
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    String fmt(String string, int n2, boolean bl) {
        int n3 = string.length();
        if (n3 < n2) {
            string = bl ? string + "                                            ".substring(0, n2 - n3) : "                                            ".substring(0, n2 - n3) + string;
        }
        return string;
    }

    String fmt(String string, int n2) {
        return this.fmt(string, n2, false);
    }

    String fmt(long l2, int n2, boolean bl) {
        String string = "" + l2;
        return this.fmt(string, n2, bl);
    }

    String fmt(long l2, int n2) {
        return this.fmt(l2, n2, false);
    }

    public void printInfo() {
        String string;
        System.out.println(this.vFile.getPath() + "  [vision version " + this.vVersion + "]");
        System.out.println("");
        File file = new File(this.vFile.getPath() + ".vix");
        System.out.println("# of records:" + this.fmt(this.numOfRecords, 18));
        System.err.println("# of deleted records:" + this.fmt(this.deletedRecords, 10));
        if (this.vVersion > '\u0003') {
            System.out.println("file size: " + this.fmt(this.vFile.length(), 20) + " (" + this.vFile.getPath() + ")");
            System.out.println("file size: " + this.fmt(file.length(), 20) + " (" + file.getPath() + ")");
            System.out.println("total file size:" + this.fmt(this.vFile.length() + file.length(), 15));
            System.out.println("segment size:" + this.fmt(this.segmentSize, 18));
        } else {
            System.out.println("file size: " + this.fmt(this.vFile.length(), 20));
        }
        String string2 = string = this.compressed ? " compressed" : "";
        if (this.minRec == this.maxRec) {
            System.out.println("record size:" + this.fmt(this.maxRec, 19) + string);
        } else {
            System.out.println("record size (min/max):" + this.fmt(this.minRec, 9) + "/" + this.maxRec + string);
        }
        System.out.println("# of keys: " + this.fmt(this.nKeys, 20));
        System.out.println("user count:" + this.fmt(this.userCount, 20));
        System.out.println("");
        System.out.println("Key  Dups    Seg-1     Seg-2     Seg-3     Seg-4     Seg-5     Seg-6");
        System.out.println("            (sz/of)   (sz/of)   (sz/of)   (sz/of)   (sz/of)   (sz/of)");
        System.out.println("");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.nKeys; ++i2) {
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer.append(this.fmt(i2, 3));
            stringBuffer.append(this.fmt(this.keys[i2].duplicates ? "Y" : "N", 5));
            stringBuffer.append("  ");
            for (int i3 = 0; i3 < this.keys[i2].nparts; ++i3) {
                stringBuffer.append(this.fmt(this.keys[i2].parts[i3].length, 3));
                stringBuffer.append("/");
                stringBuffer.append(this.fmt(this.keys[i2].parts[i3].offset, 6, true));
            }
            System.out.println(stringBuffer);
        }
    }

    public long getValidRecordsNum() {
        return this.numOfRecords;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int readNode3() throws IOException {
        if (this.nodePnt != 0) {
            if (this.nodePnt != this.blockSize_4) return this.blockSize_4 - this.nodePnt;
        }
        this.nodePnt = 0;
        this.vRAFile.read(this.node, 0, this.blockSize_4);
        if (this.node[this.nodePnt++] != 2) throw new IOException("Corrupted file!!");
        long l2 = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
        if (l2 == 0L) return this.blockSize_4 - 1;
        this.vRAFile.seek(l2);
        return this.blockSize_4 - 1;
    }

    private int myReadChar3() throws IOException {
        int n2;
        int n3 = this.readNode3();
        if (n3 < 1) {
            n2 = -1;
        } else if (n3 == 1) {
            n2 = (this.node[this.nodePnt] & 0xFF) << 8;
            this.nodePnt = 0;
            n2 = this.readNode3() >= 1 ? (n2 |= this.node[this.nodePnt++] & 0xFF) : -1;
        } else {
            n2 = (this.node[this.nodePnt++] & 0xFF) << 8;
            n2 |= this.node[this.nodePnt++] & 0xFF;
        }
        return n2;
    }

    private int myRead3(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = n3;
        int n5 = this.readNode3();
        while (n5 > 0 && n5 < n3) {
            System.arraycopy(this.node, this.nodePnt, byArray, n2, n5);
            n2 += n5;
            n3 -= n5;
            this.nodePnt = 0;
            n5 = this.readNode3();
        }
        if (n5 > 0) {
            System.arraycopy(this.node, this.nodePnt, byArray, n2, n3);
            this.nodePnt += n3;
        } else {
            n4 = -1;
        }
        return n4;
    }

    private int fillRecord(int n2, boolean bl, byte[] byArray, int n3, int n4) {
        int n5;
        if (n2 == 0) {
            n5 = 0;
        } else if (bl) {
            int n6 = 0;
            int n7 = 0;
            byte by = 0;
            n5 = 0;
            block10: for (int i2 = 0; i2 < n2; ++i2) {
                switch (n6) {
                    case -5: {
                        for (n7 = this.buffer[i2] & 0xFF; n7 > 0; --n7) {
                            byArray[n5++] = 0;
                        }
                        n6 = 0;
                        continue block10;
                    }
                    case -4: {
                        for (n7 = this.buffer[i2] & 0xFF; n7 > 0; --n7) {
                            byArray[n5++] = 48;
                        }
                        n6 = 0;
                        continue block10;
                    }
                    case -3: {
                        for (n7 = this.buffer[i2] & 0xFF; n7 > 0; --n7) {
                            byArray[n5++] = 32;
                        }
                        n6 = 0;
                        continue block10;
                    }
                    case -2: {
                        if (by == 0) {
                            by = this.buffer[i2];
                            continue block10;
                        }
                        for (n7 = this.buffer[i2] & 0xFF; n7 > 0; --n7) {
                            byArray[n5++] = by;
                        }
                        n6 = 0;
                        by = 0;
                        continue block10;
                    }
                    case -6: {
                        byArray[n5++] = this.buffer[i2];
                        n6 = 0;
                        continue block10;
                    }
                    default: {
                        switch (this.buffer[i2]) {
                            case -6: 
                            case -5: 
                            case -4: 
                            case -3: 
                            case -2: {
                                n6 = this.buffer[i2];
                                continue block10;
                            }
                        }
                        byArray[n5++] = this.buffer[i2];
                    }
                }
            }
        } else {
            n5 = Math.min(n2, n4);
            System.arraycopy(this.buffer, 0, byArray, n3, n5);
        }
        return n5;
    }

    private int readNext3(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        while (n4 == 0) {
            try {
                boolean bl;
                int n5 = this.myReadChar3();
                n4 = this.myReadChar3();
                if (this.hasDuplicates) {
                    this.myRead3(this.dummyInt, 0, 4);
                }
                if (n5 <= 0) continue;
                if (n5 > this.buffer.length) {
                    this.buffer = new byte[n5];
                }
                this.myRead3(this.buffer, 0, n5);
                if (this.compressed) {
                    if ((n4 & 0x8000) != 0) {
                        n4 &= 0xFFFF7FFF;
                        bl = false;
                    } else {
                        bl = true;
                    }
                } else {
                    bl = false;
                }
                if (n4 == 0) {
                    ++this.deletedRecordsNum;
                    continue;
                }
                if ((n4 = this.fillRecord(n4, bl, byArray, n2, n3)) >= this.minRec && n4 <= this.maxRec) {
                    ++this.validRecordsNum;
                    continue;
                }
                n4 = -1;
            }
            catch (IOException iOException) {
                n4 = -1;
            }
        }
        return n4;
    }

    private boolean newDataSegment() {
        if (this.currDataSegment < this.nDataSegments) {
            ++this.currDataSegment;
            String string = this.currDataSegment < 16 ? ".d0" + Integer.toHexString(this.currDataSegment) : ".d" + Integer.toHexString(this.currDataSegment);
            try {
                this.vFile = new File(this.fName + string);
                this.vRAFile.close();
                this.vRAFile = new RandomAccessFile(this.vFile, "r");
                this.vRAFile.seek(512L);
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    private int readNext4(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        while (n4 == 0) {
            try {
                char c2 = this.vRAFile.readChar();
                n4 = this.vRAFile.readChar();
                if (this.hasDuplicates) {
                    this.vRAFile.readInt();
                }
                if (c2 > '\u0000') {
                    boolean bl;
                    if (c2 > this.buffer.length) {
                        this.buffer = new byte[c2];
                    }
                    this.vRAFile.read(this.buffer, 0, c2);
                    if (this.compressed) {
                        if ((n4 & 0x8000) != 0) {
                            n4 &= 0xFFFF7FFF;
                            bl = false;
                        } else {
                            bl = true;
                        }
                    } else {
                        bl = false;
                    }
                    if (n4 == 0) {
                        ++this.deletedRecordsNum;
                        continue;
                    }
                    if ((n4 = this.fillRecord(n4, bl, byArray, n2, n3)) >= this.minRec && n4 <= this.maxRec) {
                        ++this.validRecordsNum;
                        continue;
                    }
                    n4 = -1;
                    continue;
                }
                if (this.newDataSegment()) {
                    n4 = this.readNext4(byArray, n2, n3);
                    continue;
                }
                n4 = -1;
            }
            catch (EOFException eOFException) {
                if (this.newDataSegment()) {
                    n4 = this.readNext4(byArray, n2, n3);
                    continue;
                }
                n4 = -1;
            }
            catch (IOException iOException) {
                n4 = -1;
            }
        }
        return n4;
    }

    private int readNext5(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        while (n4 == 0) {
            try {
                int n5 = this.vRAFile.readInt();
                n4 = this.vRAFile.readInt();
                byte by = this.vRAFile.readByte();
                int n6 = this.vRAFile.readInt();
                char c2 = this.vRAFile.readChar();
                if (n5 > 0) {
                    if (n5 > this.buffer.length) {
                        this.buffer = new byte[n5];
                    }
                    this.vRAFile.read(this.buffer, 0, n5);
                    boolean bl = this.compressed && by != 4;
                    if (by == 1) {
                        ++this.deletedRecordsNum;
                        n4 = 0;
                        continue;
                    }
                    if ((n4 = this.fillRecord(n4, bl, byArray, n2, n3)) >= this.minRec && n4 <= this.maxRec) {
                        ++this.validRecordsNum;
                        continue;
                    }
                    n4 = -1;
                    continue;
                }
                if (this.newDataSegment()) {
                    n4 = this.readNext5(byArray, n2, n3);
                    continue;
                }
                n4 = -1;
            }
            catch (EOFException eOFException) {
                if (this.newDataSegment()) {
                    n4 = this.readNext5(byArray, n2, n3);
                    continue;
                }
                n4 = -1;
            }
            catch (IOException iOException) {
                n4 = -1;
            }
        }
        return n4;
    }

    public int readNext(byte[] byArray, int n2, int n3) {
        if (this.vVersion == '\u0003') {
            return this.readNext3(byArray, n2, n3);
        }
        if (this.vVersion == '\u0004') {
            return this.readNext4(byArray, n2, n3);
        }
        if (this.vVersion == '\u0005' || this.vVersion == '\u0006') {
            return this.readNext5(byArray, n2, n3);
        }
        return -1;
    }

    public int readNext(byte[] byArray) {
        return this.readNext(byArray, 0, byArray.length);
    }

    public void close() {
        if (this.vRAFile != null) {
            try {
                this.vRAFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static class Key {
        final int nparts;
        final boolean duplicates;
        final int length;
        final short boh;
        final KeyPart[] parts;

        Key(int n2, boolean bl, int n3, short s2) {
            this.nparts = n2;
            this.parts = new KeyPart[this.nparts];
            this.duplicates = bl;
            this.length = n3;
            this.boh = s2;
        }
    }

    static class KeyPart {
        final int offset;
        final short length;

        KeyPart(int n2, short s2) {
            this.offset = n2;
            this.length = s2;
        }
    }
}

