/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.io.BaseFile;
import com.iscobol.io.CobolIOException;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.XMLStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.sax.TransformerHandler;
import org.xml.sax.SAXParseException;

public class XmlFile
extends BaseFile {
    public static final int WRITE_ALL = 1;
    public static final int WRITE_PROCESSING_INSTRUCTION = 2;
    public static final int WRITE_PLAIN_TEXT = 3;
    private static final String eol = System.getProperty("line.separator", "\n");
    private ICobolVar varString;
    private int varStringOffset = 1;
    private ICobolVar xmlVar;
    private boolean lineAdv;
    private XMLStream xmlStream;
    private boolean createNewStream;
    private String filePath;
    private ICobolVar documentType;
    private PrintWriter outputFile;
    private StringBuffer inputBuffer;

    public XmlFile(String string, ICobolVar iCobolVar, ICobolVar iCobolVar2, boolean bl, ICobolVar iCobolVar3) {
        super(string, iCobolVar.getMemoryLength(), iCobolVar, 0, false, 1);
        this.varString = iCobolVar2;
        this.lineAdv = bl;
        this.documentType = iCobolVar3;
    }

    @Override
    public void peerOpen(String string, int n2, int n3) {
        ICobolVar iCobolVar = this.getBufferAsVar();
        Object object = iCobolVar.getChildren();
        while (object.hasMoreElements()) {
            ICobolVar iCobolVar2 = (ICobolVar)object.nextElement();
            if (iCobolVar2.getIXMLAttributes() == null) continue;
            this.xmlVar = iCobolVar2;
            break;
        }
        if (this.xmlVar == null) {
            CobolIOException.get(134, "", this, 1);
        }
        this.filePath = string;
        if (this.varString == null) {
            object = new File(string);
            switch (n2) {
                case 1: {
                    if (((File)object).exists() && ((File)object).isFile() && ((File)object).canRead()) break;
                    this.setFileStatus("-4");
                    return;
                }
                case 2: 
                case 6: {
                    if (!((File)object).exists() || ((File)object).isFile() && ((File)object).canWrite()) break;
                    this.setFileStatus("-4");
                    return;
                }
                case 3: {
                    if (!((File)object).exists() || ((File)object).isFile() && ((File)object).canWrite() && ((File)object).canRead()) break;
                    this.setFileStatus("-4");
                    return;
                }
                default: {
                    this.setFileStatus("-4");
                    return;
                }
            }
        }
        this.setOpenMode(n2);
        this.setFileStatus("0");
    }

    @Override
    protected void peerClose(int n2) {
        this.xmlStream = null;
        this.varString = null;
        this.varStringOffset = 1;
        this.documentType = null;
        this.filePath = null;
        this.xmlVar = null;
        this.lineAdv = false;
        if (this.outputFile != null) {
            this.outputFile.close();
            this.outputFile = null;
        }
        this.setOpenMode(0);
    }

    @Override
    public boolean write(boolean bl, int n2) {
        throw new IscobolRuntimeException(4, this.getLogicName());
    }

    @Override
    public boolean writeAdvancing(int n2, int n3, boolean bl, int n4, int n5) {
        throw new IscobolRuntimeException(4, this.getLogicName());
    }

    @Override
    public int readNext(int n2, ICobolVar iCobolVar) {
        throw new IscobolRuntimeException(4, this.getLogicName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readXml(ICobolVar iCobolVar) {
        super.readNext(0, iCobolVar);
        if (iCobolVar == null) {
            if (this.xmlStream == null || this.createNewStream) {
                this.xmlStream = new XMLStream(this.xmlVar, true, this.lineAdv);
                this.createNewStream = false;
            }
            if (this.inputBuffer == null) {
                if (this.varString != null) {
                    this.inputBuffer = new StringBuffer(this.varString.toString());
                } else {
                    if (this.filePath == null) {
                        this.setFileStatus("-1");
                        return;
                    }
                    FileInputStream fileInputStream = null;
                    try {
                        fileInputStream = new FileInputStream(this.filePath.trim());
                        byte[] byArray = new byte[fileInputStream.available()];
                        fileInputStream.read(byArray);
                        fileInputStream.close();
                        this.inputBuffer = new StringBuffer(new String(byArray));
                    }
                    catch (IOException iOException) {
                        this.setFileStatus("-11");
                        return;
                    }
                }
            } else if (this.inputBuffer.length() == 0) {
                this.setFileStatus("-7");
                return;
            }
            try {
                this.xmlStream.readFromString(this.inputBuffer.toString());
                this.setDocumentType(this.xmlStream);
                this.setFileStatus("0");
                if (!this.xmlStream.isOk()) return;
                this.inputBuffer = new StringBuffer();
                return;
            }
            catch (IscobolRuntimeException iscobolRuntimeException) {
                int n2 = 0;
                if (!this.xmlStream.isOk()) throw iscobolRuntimeException;
                if (!(iscobolRuntimeException.getCause() instanceof SAXParseException)) throw iscobolRuntimeException;
                String string = iscobolRuntimeException.getMessage().toLowerCase();
                int n3 = string.indexOf("linenumber");
                if (n3 <= 0) throw iscobolRuntimeException;
                char[] cArray = string.substring(n3 + 10).toCharArray();
                for (int i2 = 0; i2 < cArray.length; ++i2) {
                    if (Character.isDigit(cArray[i2])) {
                        n2 = n2 * 10 + cArray[i2] - 48;
                        continue;
                    }
                    if (n2 > 0) break;
                }
                if (n2 <= 0) throw iscobolRuntimeException;
                --n2;
                BufferedReader bufferedReader = new BufferedReader(new StringReader(this.inputBuffer.toString()));
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                try {
                    int n4 = 0;
                    String string2 = bufferedReader.readLine();
                    while (string2 != null) {
                        if (n4 >= n2) {
                            printWriter.println(string2);
                        }
                        ++n4;
                        string2 = bufferedReader.readLine();
                    }
                    bufferedReader.close();
                    printWriter.close();
                    this.inputBuffer = new StringBuffer(stringWriter.toString());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.createNewStream = true;
                return;
            }
        }
        if (this.xmlStream == null) {
            this.setFileStatus("-2");
            return;
        }
        if (this.xmlStream.readKey(iCobolVar) > 0) {
            this.setFileStatus("0");
            return;
        }
        this.setFileStatus("-7");
    }

    private void setDocumentType(XMLStream xMLStream) {
        if (this.documentType != null && !this.documentType.isFinal()) {
            String string = xMLStream.getSchemaLocation();
            this.documentType.set(string != null ? string : "");
        }
    }

    private void getDocumentType(XMLStream xMLStream) {
        if (this.documentType != null) {
            xMLStream.setSchemaLocation(this.documentType.toString());
        }
    }

    public void writeXml(ICobolVar iCobolVar, ICobolVar iCobolVar2, int n2) {
        super.write(false, this.getBufferLength());
        if (iCobolVar2 == null) {
            XMLStream xMLStream;
            if (this.xmlStream != null) {
                xMLStream = this.xmlStream;
            } else {
                if (iCobolVar.getIXMLAttributes() == null) {
                    this.setFileStatus("-2");
                    return;
                }
                xMLStream = new XMLStream(iCobolVar, true, this.lineAdv);
            }
            this.getDocumentType(xMLStream);
            StringBuffer stringBuffer = new StringBuffer();
            xMLStream.writeToStringBuffer(stringBuffer);
            if (this.varString != null) {
                try {
                    this.varString.intISub(this.varStringOffset).set(stringBuffer.toString());
                }
                catch (IscobolRuntimeException iscobolRuntimeException) {
                    // empty catch block
                }
                this.varStringOffset += stringBuffer.length();
            } else if (this.filePath != null) {
                PrintWriter printWriter = this.getOutputFile();
                if (printWriter == null) {
                    return;
                }
                printWriter.print(stringBuffer.toString());
            }
            this.setFileStatus("" + stringBuffer.length());
        } else {
            boolean bl = false;
            boolean bl2 = false;
            switch (n2) {
                case 2: {
                    bl = true;
                }
                case 3: {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    XMLStream xMLStream = new XMLStream(iCobolVar, true, this.lineAdv);
                    xMLStream.setPrintWriter(printWriter);
                    TransformerHandler transformerHandler = xMLStream.getTransformerHandler();
                    String string = iCobolVar2.toString();
                    if (bl) {
                        string = "<?" + string + "?>";
                    }
                    string = string + eol;
                    char[] cArray = string.toCharArray();
                    try {
                        if (bl) {
                            transformerHandler.processingInstruction("javax.xml.transform.disable-output-escaping", null);
                            transformerHandler.characters(cArray, 0, cArray.length);
                            transformerHandler.processingInstruction("javax.xml.transform.enable-output-escaping", null);
                        } else {
                            transformerHandler.characters(cArray, 0, cArray.length);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    printWriter.close();
                    String string2 = stringWriter.toString();
                    if (this.varString != null) {
                        try {
                            this.varString.intISub(this.varStringOffset).set(string2);
                        }
                        catch (IscobolRuntimeException iscobolRuntimeException) {
                            // empty catch block
                        }
                        this.varStringOffset += string2.length();
                    } else if (this.filePath != null) {
                        PrintWriter printWriter2 = this.getOutputFile();
                        if (printWriter2 == null) {
                            return;
                        }
                        printWriter2.print(string2);
                    }
                    this.setFileStatus("" + string2);
                    break;
                }
                case 1: {
                    bl2 = true;
                    break;
                }
                default: {
                    if (!this.getStream(iCobolVar)) break;
                    this.xmlStream.writeKey(iCobolVar2, bl2);
                }
            }
        }
    }

    private boolean getStream(ICobolVar iCobolVar) {
        if (this.xmlStream == null) {
            if (iCobolVar == null || iCobolVar.getIXMLAttributes() == null) {
                this.setFileStatus("-2");
                return false;
            }
            XMLStream xMLStream = new XMLStream(iCobolVar, false, this.lineAdv);
            StringBuffer stringBuffer = new StringBuffer();
            xMLStream.writeToStringBuffer(stringBuffer);
            this.xmlStream = new XMLStream(iCobolVar, true, this.lineAdv);
            this.xmlStream.readFromString(stringBuffer.toString());
        }
        return true;
    }

    private PrintWriter getOutputFile() {
        if (this.outputFile == null) {
            try {
                this.outputFile = new PrintWriter(new FileOutputStream(this.filePath, this.getOpenMode() == 6));
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.setFileStatus("-12");
            }
        }
        return this.outputFile;
    }

    public void rewriteXml(ICobolVar iCobolVar, ICobolVar iCobolVar2) {
        if (this.getStream(iCobolVar)) {
            this.xmlStream.rewriteKey(iCobolVar2);
        }
    }

    public void startXml(ICobolVar iCobolVar, int n2) {
        super.start((ICobolVar[])null, 0, 0);
        if (this.xmlStream == null) {
            this.setFileStatus("-2");
        } else if (this.xmlStream.startKey(iCobolVar, n2)) {
            this.setFileStatus("0");
        } else {
            this.setFileStatus("-6");
        }
    }

    public void deleteXml(ICobolVar iCobolVar) {
        if (this.getStream(null)) {
            this.xmlStream.deleteKey(iCobolVar);
        }
    }

    @Override
    public void deleteFile(ICobolVar iCobolVar) {
        super.deleteFile(iCobolVar);
    }

    @Override
    public void rewrite(boolean bl, int n2) {
        throw new IscobolRuntimeException(4, this.getLogicName());
    }

    @Override
    public void delete() {
        throw new IscobolRuntimeException(4, this.getLogicName());
    }

    @Override
    public int readPrev(boolean bl, ICobolVar iCobolVar) {
        throw new IscobolRuntimeException(4, this.getLogicName());
    }

    @Override
    public int readKey(ICobolVar[] iCobolVarArray, boolean bl, ICobolVar iCobolVar) {
        throw new IscobolRuntimeException(4, this.getLogicName());
    }

    @Override
    public void start(ICobolVar[] iCobolVarArray, int n2, int n3) {
        throw new IscobolRuntimeException(4, this.getLogicName());
    }
}

